/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.xmla;

import java.util.Hashtable;
import oracle.dbtools.crest.model.datatype.MDDataTypeNames;
import oracle.dbtools.crest.util.logging.Logger;

public abstract class XMLADataTypesMapping
implements MDDataTypeNames {
    private static final Hashtable DATATYPE_MAP = new Hashtable();
    private static final Hashtable COLUMN_DATATYPE_MAP = new Hashtable();
    private static final Logger LOGGER = new Logger(XMLADataTypesMapping.class);

    public static String getAppropriateDatatype(String string) {
        if (string != null) {
            String string2;
            if (string.indexOf(40) > -1) {
                string = string.substring(0, string.indexOf(40));
            }
            if ((string2 = (String)DATATYPE_MAP.get(string.toUpperCase().trim())) == null) {
                StringBuffer stringBuffer = new StringBuffer("There is no mapping for datatype ");
                stringBuffer.append(string);
                stringBuffer.append(" in XMLADataTypesMapping.getAppropriateDatatype");
                LOGGER.error(stringBuffer.toString());
                return string;
            }
            return string2;
        }
        StringBuffer stringBuffer = new StringBuffer("NULL passed as parameter ");
        stringBuffer.append(" in XMLADataTypesMapping.getAppropriateDatatype");
        LOGGER.error(stringBuffer.toString());
        return "UNKNOWN";
    }

    public static String getAppropriateColumnDatatype(String string) {
        if (string != null) {
            String string2;
            if (string.indexOf(40) > -1) {
                string = string.substring(0, string.indexOf(40));
            }
            if ((string2 = (String)COLUMN_DATATYPE_MAP.get(string.toUpperCase().trim())) == null) {
                StringBuffer stringBuffer = new StringBuffer("There is no mapping for datatype ");
                stringBuffer.append(string);
                stringBuffer.append(" in XMLADataTypesMapping.getAppropriateColumnDatatype");
                LOGGER.error(stringBuffer.toString());
                return string;
            }
            return string2;
        }
        StringBuffer stringBuffer = new StringBuffer("NULL passed as parameter ");
        stringBuffer.append(" in XMLADataTypesMapping.getAppropriateColumnDatatype");
        LOGGER.error(stringBuffer.toString());
        return "UNKNOWN";
    }

    static {
        DATATYPE_MAP.put("INTEGER", "Integer");
        DATATYPE_MAP.put("DOUBLE", "Double");
        DATATYPE_MAP.put("DECIMAL", "Decimal");
        DATATYPE_MAP.put("SMALLINT", "SmallInt");
        DATATYPE_MAP.put("DATETIME", "Date");
        DATATYPE_MAP.put("DATE", "Date");
        DATATYPE_MAP.put("UNIQUEIDENTIFIER", "WChar");
        DATATYPE_MAP.put("BIGINT", "Integer");
        DATATYPE_MAP.put("BIT", "Boolean");
        DATATYPE_MAP.put("NUMERIC", "Currency");
        DATATYPE_MAP.put("BINARY", "WChar");
        DATATYPE_MAP.put("BOOLEAN", "Boolean");
        COLUMN_DATATYPE_MAP.put("INTEGER", "integer");
        COLUMN_DATATYPE_MAP.put("DOUBLE", "double");
        COLUMN_DATATYPE_MAP.put("DECIMAL", "double");
        COLUMN_DATATYPE_MAP.put("SMALLINT", "int");
        COLUMN_DATATYPE_MAP.put("DATETIME", "date");
        COLUMN_DATATYPE_MAP.put("DATE", "date");
        COLUMN_DATATYPE_MAP.put("UNIQUEIDENTIFIER", "string");
        COLUMN_DATATYPE_MAP.put("BIGINT", "integer");
        COLUMN_DATATYPE_MAP.put("BIT", "boolean");
        COLUMN_DATATYPE_MAP.put("NUMERIC", "double");
        COLUMN_DATATYPE_MAP.put("BINARY", "string");
        COLUMN_DATATYPE_MAP.put("WCHAR", "string");
        COLUMN_DATATYPE_MAP.put("CURRENCY", "double");
        COLUMN_DATATYPE_MAP.put("BOOLEAN", "boolean");
    }
}

