/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSComments;
import oracle.dbtools.crest.exports.reports.RSCommentsInRDBMS;
import oracle.dbtools.crest.exports.reports.RSDynamicProperties;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.exports.reports.RSObjectNotes;
import oracle.dbtools.crest.exports.reports.RSViewContainers;
import oracle.dbtools.crest.exports.reports.RSViewDefinition;
import oracle.dbtools.crest.exports.reports.RSViewOrderGroupby;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.util.GUID;

public class RSTableViews
extends RSGeneral {
    public static void export(Design design, Map map, Connection connection) throws Exception {
        ArrayList<TableView> arrayList = new ArrayList<TableView>(1000);
        int n = 0;
        String string = "INSERT INTO DMRS_TABLEVIEWS (TableView_Name, Object_ID, OVID, Import_ID, Model_ID, Model_OVID, Structured_Type_ID, Structured_Type_OVID, Structured_Type_Name, Where_Clause, Having_Clause, User_Defined, Engineer, Allow_Type_Substitution, OID_Columns, Model_Name, Design_OVID, Schema_OVID, Schema_Name) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement preparedStatement = connection.prepareStatement(string);
        Iterator iterator = design.getRelationalDesigns().iterator();
        while (iterator.hasNext()) {
            RelationalDesign relationalDesign = (RelationalDesign)iterator.next();
            String object = (String)map.get(relationalDesign.getObjectID());
            Iterator iterator2 = relationalDesign.getTableViewSet().iterator();
            while (iterator2.hasNext()) {
                TableView tableView2 = (TableView)iterator2.next();
                String string2 = new GUID().toString();
                map.put(tableView2.getObjectID(), string2);
                preparedStatement.setString(1, tableView2.getName());
                preparedStatement.setString(2, tableView2.getObjectID());
                preparedStatement.setString(3, string2);
                preparedStatement.setString(4, tableView2.getImportedId());
                preparedStatement.setString(5, relationalDesign.getObjectID());
                preparedStatement.setString(6, object);
                preparedStatement.setString(7, tableView2.getBasedOnStructuredType() != null ? tableView2.getBasedOnStructuredType().getObjectID() : null);
                preparedStatement.setString(8, tableView2.getBasedOnStructuredType() != null ? (String)map.get(tableView2.getBasedOnStructuredType().getObjectID()) : null);
                preparedStatement.setString(9, tableView2.getBasedOnStructuredType() != null ? tableView2.getBasedOnStructuredType().getName() : null);
                preparedStatement.setString(10, tableView2.getWhere());
                preparedStatement.setString(11, tableView2.getHaving());
                preparedStatement.setString(12, tableView2.getUserDefined() ? "Y" : "N");
                preparedStatement.setString(13, tableView2.getShouldEngineer() ? "Y" : "N");
                preparedStatement.setString(14, tableView2.isAllowTypeSubstitution() ? "Y" : "N");
                preparedStatement.setString(15, tableView2.getOidText());
                preparedStatement.setString(16, relationalDesign.getName());
                preparedStatement.setString(17, (String)map.get(design.getObjectID()));
                preparedStatement.setString(18, tableView2.getSchemaObject() != null ? (String)map.get(tableView2.getSchemaObject().getObjectID()) : null);
                preparedStatement.setString(19, tableView2.getSchemaObject() != null ? tableView2.getSchemaObject().getName() : null);
                preparedStatement.addBatch();
                arrayList.add(tableView2);
                if (++n != 1000) continue;
                n = 0;
                preparedStatement.executeBatch();
                for (TableView tableView2 : arrayList) {
                    RSObjectNotes.export(map, connection, tableView2);
                    RSComments.export(map, connection, tableView2);
                    RSCommentsInRDBMS.export(map, connection, tableView2);
                    RSViewDefinition.export(map, connection, tableView2);
                    RSViewContainers.export(map, connection, tableView2);
                    RSViewOrderGroupby.export(map, connection, tableView2);
                    RSDynamicProperties.export(design, map, connection, tableView2);
                }
                arrayList.clear();
            }
        }
        if (n > 0) {
            n = 0;
            preparedStatement.executeBatch();
            for (TableView tableView : arrayList) {
                RSObjectNotes.export(map, connection, tableView);
                RSComments.export(map, connection, tableView);
                RSCommentsInRDBMS.export(map, connection, tableView);
                RSViewDefinition.export(map, connection, tableView);
                RSViewContainers.export(map, connection, tableView);
                RSViewOrderGroupby.export(map, connection, tableView);
                RSDynamicProperties.export(design, map, connection, tableView);
            }
            arrayList.clear();
        }
        preparedStatement.close();
        preparedStatement = null;
    }
}

