/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.Iterator;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.design.relational.Table;

public class RSTableConstraints
extends RSGeneral {
    public static void export(Map map, Connection connection, Table table) throws Exception {
        int n = 0;
        String string = "INSERT INTO DMRS_TABLE_CONSTRAINTS (Table_ID, Table_OVID, Sequence, Constraint_ID, Constraint_OVID, Constraint_Name, Text, Table_Name, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement preparedStatement = connection.prepareStatement(string);
        Iterator iterator = table.getCheckConstraints().iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            ++n2;
            TableLevelConstraint tableLevelConstraint = (TableLevelConstraint)iterator.next();
            String string2 = tableLevelConstraint.getName();
            if (string2 == null || string2.equals("")) {
                string2 = table.getName() + "_CK" + String.valueOf(n2);
            }
            preparedStatement.setString(1, table.getObjectID());
            preparedStatement.setString(2, (String)map.get(table.getObjectID()));
            preparedStatement.setInt(3, n2);
            preparedStatement.setString(4, tableLevelConstraint.getID());
            preparedStatement.setString(5, RSTableConstraints.getOrCreateOVID(map, tableLevelConstraint.getID()));
            preparedStatement.setString(6, string2);
            preparedStatement.setString(7, tableLevelConstraint.getRule());
            preparedStatement.setString(8, table.getName());
            preparedStatement.setString(9, (String)map.get(table.getDesign().getObjectID()));
            preparedStatement.addBatch();
            if (++n != 1000) continue;
            n = 0;
            preparedStatement.executeBatch();
        }
        if (n > 0) {
            n = 0;
            preparedStatement.executeBatch();
        }
        preparedStatement.close();
        preparedStatement = null;
    }
}

