/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSComments;
import oracle.dbtools.crest.exports.reports.RSDynamicProperties;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.exports.reports.RSObjectNotes;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.datatypes.AbstractDTObject;
import oracle.dbtools.crest.model.design.datatypes.DataTypesDesign;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.util.GUID;

public class RSStructuredTypes
extends RSGeneral {
    public static void export(Design design, Map map, Connection connection, DataTypesDesign dataTypesDesign, String string) throws Exception {
        ArrayList<Object> arrayList = new ArrayList<Object>(1000);
        int n = 0;
        String string2 = (String)map.get(design.getObjectID());
        String string3 = "INSERT INTO DMRS_STRUCTURED_TYPES (Design_ID, Design_OVID, Design_Name, Structured_Type_ID, Structured_Type_OVID, Structured_Type_Name, Super_Type_ID, Super_Type_OVID, Super_Type_Name, Predefined, ST_Final, ST_Instantiable, Model_OVID, Model_Name) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement preparedStatement = connection.prepareStatement(string3);
        Iterator iterator = dataTypesDesign.getStructuredTypeSet().iterator();
        while (iterator.hasNext()) {
            Object object3 = (StructuredType)iterator.next();
            Object object2 = new GUID().toString();
            map.put(((ModelIDObject)object3).getObjectID(), object2);
            preparedStatement.setString(1, design.getObjectID());
            preparedStatement.setString(2, string2);
            preparedStatement.setString(3, design.getName());
            preparedStatement.setString(4, ((ModelIDObject)object3).getObjectID());
            preparedStatement.setString(5, (String)object2);
            preparedStatement.setString(6, ((DesignObject)object3).getName());
            if (((StructuredType)object3).getParentType() != null) {
                preparedStatement.setString(7, ((StructuredType)object3).getParentType().getObjectID());
                preparedStatement.setString(8, (String)map.get(((StructuredType)object3).getParentType().getObjectID()));
                preparedStatement.setString(9, ((StructuredType)object3).getParentType().getName());
            } else {
                preparedStatement.setString(7, null);
                preparedStatement.setString(8, null);
                preparedStatement.setString(9, null);
            }
            preparedStatement.setString(10, ((AbstractDTObject)object3).isPredefined() ? "Y" : "N");
            preparedStatement.setString(11, ((StructuredType)object3).isFinal() ? "Y" : "N");
            preparedStatement.setString(12, ((StructuredType)object3).isInstantiable() ? "Y" : "N");
            preparedStatement.setString(13, string);
            preparedStatement.setString(14, ((DesignObject)object3).getDesignPart().getName());
            preparedStatement.addBatch();
            arrayList.add(object3);
            if (++n != 1000) continue;
            n = 0;
            preparedStatement.executeBatch();
            for (Object object3 : arrayList) {
                RSObjectNotes.export(map, connection, (ModelIDObject)object3);
                RSComments.export(map, connection, (ModelIDObject)object3);
                RSDynamicProperties.export(design, map, connection, (ModelIDObject)object3);
            }
            arrayList.clear();
        }
        if (n > 0) {
            n = 0;
            preparedStatement.executeBatch();
            for (Object object2 : arrayList) {
                RSObjectNotes.export(map, connection, (ModelIDObject)object2);
                RSComments.export(map, connection, (ModelIDObject)object2);
                RSDynamicProperties.export(design, map, connection, (ModelIDObject)object2);
            }
            arrayList.clear();
        }
        preparedStatement.close();
        preparedStatement = null;
    }
}

