/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.Iterator;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.model.design.relational.SpatialColumnDefObject;

public class RSSpatialDimension
extends RSGeneral {
    public static void export(Map map, Connection connection, SpatialColumnDefObject spatialColumnDefObject) throws Exception {
        int n = 0;
        String string = "INSERT INTO DMRS_SPATIAL_DIMENSIONS (Definition_ID, Definition_OVID, Definition_Name, Dimension_Name, Low_Boundary, Upper_Boundary, Tolerance, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement preparedStatement = connection.prepareStatement(string);
        Iterator iterator = spatialColumnDefObject.getTableDimensions().iterator();
        while (iterator.hasNext()) {
            String string2 = String.valueOf(spatialColumnDefObject.getId());
            SpatialColumnDefObject.TableDimension tableDimension = (SpatialColumnDefObject.TableDimension)iterator.next();
            preparedStatement.setString(1, string2);
            preparedStatement.setString(2, (String)map.get(string2));
            preparedStatement.setString(3, spatialColumnDefObject.getName());
            preparedStatement.setString(4, tableDimension.getName());
            preparedStatement.setString(5, tableDimension.getLowBoundary());
            preparedStatement.setString(6, tableDimension.getUpperBoundary());
            preparedStatement.setString(7, tableDimension.getTolerance());
            preparedStatement.setString(8, (String)map.get(spatialColumnDefObject.getParent().getDesign().getObjectID()));
            preparedStatement.addBatch();
            if (++n != 1000) continue;
            n = 0;
            preparedStatement.executeBatch();
        }
        if (n > 0) {
            n = 0;
            preparedStatement.executeBatch();
        }
        preparedStatement.close();
        preparedStatement = null;
    }
}

