/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSComments;
import oracle.dbtools.crest.exports.reports.RSCommentsInRDBMS;
import oracle.dbtools.crest.exports.reports.RSDynamicProperties;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.exports.reports.RSObjectNotes;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.util.GUID;

public class RSSchemaObject
extends RSGeneral {
    public static void export(Design design, Map map, Connection connection) throws Exception {
        ArrayList<SchemaObject> arrayList = new ArrayList<SchemaObject>(1000);
        int n = 0;
        String string = (String)map.get(design.getObjectID());
        String string2 = "INSERT INTO DMRS_SCHEMA_OBJECT (Object_ID, Design_OVID, Schema_OVID, Schema_Name) VALUES (?, ?, ?, ?)";
        PreparedStatement preparedStatement = connection.prepareStatement(string2);
        Iterator iterator = design.getRelationalDesigns().iterator();
        while (iterator.hasNext()) {
            RelationalDesign relationalDesign = (RelationalDesign)iterator.next();
            String object = (String)map.get(relationalDesign.getObjectID());
            Iterator iterator2 = relationalDesign.getSchemaObjectSet().iterator();
            while (iterator2.hasNext()) {
                SchemaObject schemaObject2 = (SchemaObject)iterator2.next();
                String string3 = new GUID().toString();
                map.put(schemaObject2.getObjectID(), string3);
                preparedStatement.setString(1, schemaObject2.getObjectID());
                preparedStatement.setString(2, string);
                preparedStatement.setString(3, string3);
                preparedStatement.setString(4, schemaObject2.getName());
                preparedStatement.addBatch();
                arrayList.add(schemaObject2);
                if (++n != 1000) continue;
                n = 0;
                preparedStatement.executeBatch();
                for (SchemaObject schemaObject2 : arrayList) {
                    RSObjectNotes.export(map, connection, schemaObject2);
                    RSComments.export(map, connection, schemaObject2);
                    RSCommentsInRDBMS.export(map, connection, schemaObject2);
                    RSDynamicProperties.export(design, map, connection, schemaObject2);
                }
                arrayList.clear();
            }
        }
        if (n > 0) {
            n = 0;
            preparedStatement.executeBatch();
            for (SchemaObject schemaObject : arrayList) {
                RSObjectNotes.export(map, connection, schemaObject);
                RSComments.export(map, connection, schemaObject);
                RSCommentsInRDBMS.export(map, connection, schemaObject);
                RSDynamicProperties.export(design, map, connection, schemaObject);
            }
            arrayList.clear();
        }
        preparedStatement.close();
        preparedStatement = null;
    }
}

