/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSComments;
import oracle.dbtools.crest.exports.reports.RSDynamicProperties;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.exports.reports.RSObjectNotes;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.process.Process;
import oracle.dbtools.crest.model.design.process.ProcessModel;
import oracle.dbtools.crest.model.design.process.Role;

public class RSRoles
extends RSGeneral {
    public static void export(Design design, Map map, Connection connection) throws Exception {
        ArrayList<Object> arrayList = new ArrayList<Object>(1000);
        int n = 0;
        ArrayList<Role> arrayList2 = new ArrayList<Role>();
        String string = "INSERT INTO DMRS_ROLES (Role_ID, Role_OVID, Role_Name, Model_ID, Model_OVID, Model_Name, Description, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement preparedStatement = connection.prepareStatement(string);
        ProcessModel processModel = design.getProcessModel();
        Iterator iterator = processModel.getRoleSet().iterator();
        while (iterator.hasNext()) {
            Object object3 = (Role)iterator.next();
            Object object2 = RSRoles.getOrCreateOVID(map, ((ModelIDObject)object3).getObjectID());
            arrayList2.add((Role)object3);
            preparedStatement.setString(1, ((ModelIDObject)object3).getObjectID());
            preparedStatement.setString(2, (String)object2);
            preparedStatement.setString(3, ((DesignObject)object3).getName());
            preparedStatement.setString(4, processModel.getObjectID());
            preparedStatement.setString(5, (String)map.get(processModel.getObjectID()));
            preparedStatement.setString(6, processModel.getName());
            preparedStatement.setString(7, ((Role)object3).getDescription());
            preparedStatement.setString(8, (String)map.get(design.getObjectID()));
            preparedStatement.addBatch();
            arrayList.add(object3);
            if (++n != 1000) continue;
            n = 0;
            preparedStatement.executeBatch();
            for (Object object3 : arrayList) {
                RSObjectNotes.export(map, connection, (ModelIDObject)object3);
                RSComments.export(map, connection, (ModelIDObject)object3);
                RSDynamicProperties.export(design, map, connection, (ModelIDObject)object3);
            }
            arrayList.clear();
        }
        RSRoles.exportProcesses(map, connection, arrayList2, design);
        if (n > 0) {
            n = 0;
            preparedStatement.executeBatch();
            for (Object object2 : arrayList) {
                RSObjectNotes.export(map, connection, (ModelIDObject)object2);
                RSComments.export(map, connection, (ModelIDObject)object2);
                RSDynamicProperties.export(design, map, connection, (ModelIDObject)object2);
            }
            arrayList.clear();
        }
        preparedStatement.close();
        preparedStatement = null;
    }

    private static void exportProcesses(Map map, Connection connection, List list, Design design) throws Exception {
        int n = 0;
        String string = "INSERT INTO DMRS_ROLE_PROCESSES (Role_ID, Role_OVID, Role_Name, Process_ID, Process_OVID, Process_Name, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement preparedStatement = connection.prepareStatement(string);
        for (Role role : list) {
            for (Process process : role.getProcesses()) {
                String string2 = (String)map.get(process.getObjectID());
                preparedStatement.setString(1, role.getObjectID());
                preparedStatement.setString(2, (String)map.get(role.getObjectID()));
                preparedStatement.setString(3, role.getName());
                preparedStatement.setString(4, process.getObjectID());
                preparedStatement.setString(5, string2);
                preparedStatement.setString(6, process.getName());
                preparedStatement.setString(7, (String)map.get(design.getObjectID()));
                preparedStatement.addBatch();
                if (++n != 1000) continue;
                n = 0;
                preparedStatement.executeBatch();
            }
        }
        if (n > 0) {
            n = 0;
            preparedStatement.executeBatch();
        }
        preparedStatement.close();
        preparedStatement = null;
    }
}

