/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSComments;
import oracle.dbtools.crest.exports.reports.RSCommentsInRDBMS;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.exports.reports.RSObjectNotes;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.logical.Relation;

public class RSRelationships
extends RSGeneral {
    public static void export(Design design, Map map, Connection connection, LogicalDesign logicalDesign, String string) throws Exception {
        ArrayList<Object> arrayList = new ArrayList<Object>(1000);
        int n = 0;
        String string2 = "INSERT INTO DMRS_RELATIONSHIPS (Relationship_Name, Model_ID, Model_OVID, Object_ID, OVID, Import_ID, Source_Entity_Name, Target_Entity_Name, Source_Label, Target_Label, SourceTo_Target_Cardinality, TargetTo_Source_Cardinality, Source_Optional, Target_Optional, Dominant_Role, Identifying, Source_ID, Source_OVID, Target_ID, Target_OVID, Number_Of_Attributes, Transferable, In_Arc, Arc_ID, Model_Name, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement preparedStatement = connection.prepareStatement(string2);
        Iterator iterator = logicalDesign.getRelationSet().iterator();
        while (iterator.hasNext()) {
            Object object3 = (Relation)iterator.next();
            Object object2 = RSRelationships.getOrCreateOVID(map, ((ModelIDObject)object3).getObjectID());
            preparedStatement.setString(1, ((DesignObject)object3).getName());
            preparedStatement.setString(2, logicalDesign.getObjectID());
            preparedStatement.setString(3, string);
            preparedStatement.setString(4, ((ModelIDObject)object3).getObjectID());
            preparedStatement.setString(5, (String)object2);
            preparedStatement.setString(6, ((DesignObject)object3).getImportedId());
            preparedStatement.setString(7, ((Relation)object3).getSourceEntity().getName());
            preparedStatement.setString(8, ((Relation)object3).getTargetEntity().getName());
            preparedStatement.setString(9, ((Relation)object3).getNameOnSource());
            preparedStatement.setString(10, ((Relation)object3).getNameOnTarget());
            preparedStatement.setString(11, ((Relation)object3).getTargetCardinality().toString());
            preparedStatement.setString(12, ((Relation)object3).getSourceCardinality().toString());
            preparedStatement.setString(13, ((Relation)object3).isOptionalSource() ? "Y" : "N");
            preparedStatement.setString(14, ((Relation)object3).isOptionalTarget() ? "Y" : "N");
            preparedStatement.setString(15, ((Relation)object3).getDominantRole().getName());
            preparedStatement.setString(16, ((Relation)object3).isIdentifying() ? "Y" : "N");
            preparedStatement.setString(17, ((Relation)object3).getSourceEntity().getObjectID());
            preparedStatement.setString(18, (String)map.get(((Relation)object3).getSourceEntity().getObjectID()));
            preparedStatement.setString(19, ((Relation)object3).getTargetEntity().getObjectID());
            preparedStatement.setString(20, (String)map.get(((Relation)object3).getTargetEntity().getObjectID()));
            int[] nArray = ((Relation)object3).getPKProviderEndPoint();
            if (nArray.length > 0) {
                preparedStatement.setInt(21, ((Relation)object3).getOtherEndPoint(nArray[0]));
            } else {
                preparedStatement.setInt(21, 0);
            }
            preparedStatement.setString(22, ((Relation)object3).isTransferable() ? "Y" : "N");
            preparedStatement.setString(23, ((Relation)object3).inArc() ? "Y" : "N");
            preparedStatement.setString(24, ((Relation)object3).getArc() != null ? ((Relation)object3).getArc().getObjectID() : null);
            preparedStatement.setString(25, logicalDesign.getName());
            preparedStatement.setString(26, (String)map.get(design.getObjectID()));
            preparedStatement.addBatch();
            arrayList.add(object3);
            if (++n != 1000) continue;
            n = 0;
            preparedStatement.executeBatch();
            for (Object object3 : arrayList) {
                RSObjectNotes.export(map, connection, (ModelIDObject)object3);
                RSComments.export(map, connection, (ModelIDObject)object3);
                RSCommentsInRDBMS.export(map, connection, (ModelIDObject)object3);
            }
            arrayList.clear();
        }
        if (n > 0) {
            n = 0;
            preparedStatement.executeBatch();
            for (Object object2 : arrayList) {
                RSObjectNotes.export(map, connection, (ModelIDObject)object2);
                RSComments.export(map, connection, (ModelIDObject)object2);
                RSCommentsInRDBMS.export(map, connection, (ModelIDObject)object2);
            }
            arrayList.clear();
        }
        preparedStatement.close();
        preparedStatement = null;
    }
}

