/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSComments;
import oracle.dbtools.crest.exports.reports.RSDynamicProperties;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.exports.reports.RSObjectNotes;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.process.ExternalData;
import oracle.dbtools.crest.model.design.process.ProcessModel;
import oracle.dbtools.crest.model.design.process.RecordStructure;

public class RSRecordStructures
extends RSGeneral {
    public static void export(Design design, Map map, Connection connection) throws Exception {
        ArrayList<Object> arrayList = new ArrayList<Object>(1000);
        int n = 0;
        ArrayList<RecordStructure> arrayList2 = new ArrayList<RecordStructure>();
        String string = "INSERT INTO DMRS_RECORD_STRUCTURES (Record_Structure_ID, Record_Structure_OVID, Record_Structure_Name, Model_ID, Model_OVID, Model_Name, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement preparedStatement = connection.prepareStatement(string);
        ProcessModel processModel = design.getProcessModel();
        Iterator iterator = processModel.getRecordStructureSet().iterator();
        while (iterator.hasNext()) {
            Object object3 = (RecordStructure)iterator.next();
            Object object2 = RSRecordStructures.getOrCreateOVID(map, ((ModelIDObject)object3).getObjectID());
            arrayList2.add((RecordStructure)object3);
            preparedStatement.setString(1, ((ModelIDObject)object3).getObjectID());
            preparedStatement.setString(2, (String)object2);
            preparedStatement.setString(3, ((DesignObject)object3).getName());
            preparedStatement.setString(4, processModel.getObjectID());
            preparedStatement.setString(5, (String)map.get(processModel.getObjectID()));
            preparedStatement.setString(6, processModel.getName());
            preparedStatement.setString(7, (String)map.get(design.getObjectID()));
            preparedStatement.addBatch();
            arrayList.add(object3);
            if (++n != 1000) continue;
            n = 0;
            preparedStatement.executeBatch();
            for (Object object3 : arrayList) {
                RSObjectNotes.export(map, connection, (ModelIDObject)object3);
                RSComments.export(map, connection, (ModelIDObject)object3);
                RSDynamicProperties.export(design, map, connection, (ModelIDObject)object3);
            }
            arrayList.clear();
        }
        RSRecordStructures.exportRelationships(map, connection, arrayList2, design);
        if (n > 0) {
            n = 0;
            preparedStatement.executeBatch();
            for (Object object2 : arrayList) {
                RSObjectNotes.export(map, connection, (ModelIDObject)object2);
                RSComments.export(map, connection, (ModelIDObject)object2);
                RSDynamicProperties.export(design, map, connection, (ModelIDObject)object2);
            }
            arrayList.clear();
        }
        preparedStatement.close();
        preparedStatement = null;
    }

    private static void exportRelationships(Map map, Connection connection, List list, Design design) throws Exception {
        int n = 0;
        String string = "INSERT INTO DMRS_RECORD_STRUCT_EXT_DATAS (Record_Structure_ID, Record_Structure_OVID, Record_Structure_Name, External_Data_ID, External_Data_OVID, External_Data_Name, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement preparedStatement = connection.prepareStatement(string);
        for (RecordStructure recordStructure : list) {
            for (ExternalData externalData : recordStructure.getExtDatas()) {
                String string2 = (String)map.get(externalData.getObjectID());
                preparedStatement.setString(1, recordStructure.getObjectID());
                preparedStatement.setString(2, (String)map.get(recordStructure.getObjectID()));
                preparedStatement.setString(3, recordStructure.getName());
                preparedStatement.setString(4, externalData.getObjectID());
                preparedStatement.setString(5, string2);
                preparedStatement.setString(6, externalData.getName());
                preparedStatement.setString(7, (String)map.get(design.getObjectID()));
                preparedStatement.addBatch();
                if (++n != 1000) continue;
                n = 0;
                preparedStatement.executeBatch();
            }
        }
        if (n > 0) {
            n = 0;
            preparedStatement.executeBatch();
        }
        preparedStatement.close();
        preparedStatement = null;
    }
}

