/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.Iterator;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.process.DataFlowDesign;
import oracle.dbtools.crest.model.design.process.Process;
import oracle.dbtools.crest.model.design.process.ProcessModel;
import oracle.dbtools.crest.util.GUID;
import oracle.dbtools.crest.util.logging.Logger;

public class RSProcessEntities
extends RSGeneral {
    private static final Logger LOGGER = new Logger(RSProcessEntities.class);

    public static void export(Design design, Map map, Connection connection) throws Exception {
        int n = 0;
        String string = "INSERT INTO DMRS_PROCESS_ENTITIES (Process_ID, Process_OVID, Entity_ID, Entity_OVID, Flow_ID, Flow_OVID, DFD_ID, DFD_OVID, Process_Name, Entity_Name, Flow_Name, DFD_Name, OP_Read, OP_Create, OP_Update, OP_Delete, CRUD_Code, Flow_Direction, Model_ID, Model_OVID, Model_Name, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement preparedStatement = connection.prepareStatement(string);
        ProcessModel processModel = design.getProcessModel();
        Iterator iterator = processModel.getDataFlowDesigns().iterator();
        while (iterator.hasNext()) {
            DataFlowDesign dataFlowDesign = (DataFlowDesign)iterator.next();
            String string2 = RSProcessEntities.getOrCreateOVID(map, dataFlowDesign.getObjectID());
            if (dataFlowDesign.getTopLevelDataFlowDesign() == null) {
                LOGGER.error("RSProcessEntities.export(): DataFlow Diagram (" + dataFlowDesign.getName() + ") has no parent object and must be deleted from the file system." + "\n Delete the file and related directory - " + dataFlowDesign.getSegmentedStorageName());
                continue;
            }
            String string3 = dataFlowDesign.getTopLevelDataFlowDesign().getName();
            Iterator iterator2 = dataFlowDesign.getProcessSet().iterator();
            while (iterator2.hasNext()) {
                Process process = (Process)iterator2.next();
                if (process.getType() != 0) continue;
                String string4 = new GUID().toString();
                map.put(process.getObjectID(), string4);
                for (Process.ProcessedObject processedObject : process.getProcessedEntitiesAndFlows(false)) {
                    preparedStatement.setString(1, process.getObjectID());
                    preparedStatement.setString(2, string4);
                    preparedStatement.setString(3, processedObject.getObject().getObjectID());
                    preparedStatement.setString(4, (String)map.get(processedObject.getObject().getObjectID()));
                    preparedStatement.setString(5, processedObject.getFlow().getObjectID());
                    preparedStatement.setString(6, RSProcessEntities.getOrCreateOVID(map, processedObject.getFlow().getObjectID()));
                    preparedStatement.setString(7, dataFlowDesign.getObjectID());
                    preparedStatement.setString(8, string2);
                    preparedStatement.setString(9, process.getName());
                    preparedStatement.setString(10, processedObject.getObject().getName());
                    preparedStatement.setString(11, processedObject.getFlow().getName());
                    preparedStatement.setString(12, string3);
                    preparedStatement.setString(13, processedObject.isOpRead() ? "Y" : "N");
                    preparedStatement.setString(14, processedObject.isOpCreate() ? "Y" : "N");
                    preparedStatement.setString(15, processedObject.isOpUpdate() ? "Y" : "N");
                    preparedStatement.setString(16, processedObject.isOpDelete() ? "Y" : "N");
                    if (processedObject.isOpRead()) {
                        preparedStatement.setString(17, "R");
                    } else {
                        String string5 = "";
                        if (processedObject.isOpCreate()) {
                            string5 = "C";
                        }
                        if (processedObject.isOpUpdate()) {
                            string5 = string5 + "U";
                        }
                        if (processedObject.isOpDelete()) {
                            string5 = string5 + "D";
                        }
                        preparedStatement.setString(17, string5);
                    }
                    preparedStatement.setString(18, processedObject.isInbound() ? "IN" : "OUT");
                    preparedStatement.setString(19, processModel.getObjectID());
                    preparedStatement.setString(20, (String)map.get(processModel.getObjectID()));
                    preparedStatement.setString(21, processModel.getName());
                    preparedStatement.setString(22, (String)map.get(design.getObjectID()));
                    preparedStatement.addBatch();
                    if (++n != 1000) continue;
                    n = 0;
                    preparedStatement.executeBatch();
                }
            }
        }
        if (n > 0) {
            n = 0;
            preparedStatement.executeBatch();
        }
        preparedStatement.close();
        preparedStatement = null;
    }
}

