/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.util.Iterator;
import java.util.Map;
import oracle.dbtools.crest.exports.Messages;
import oracle.dbtools.crest.exports.reports.RSCubes;
import oracle.dbtools.crest.exports.reports.RSDimensions;
import oracle.dbtools.crest.exports.reports.RSHierarchies;
import oracle.dbtools.crest.exports.reports.RSLevels;
import oracle.dbtools.crest.exports.reports.RSMeasures;
import oracle.dbtools.crest.exports.reports.RSModel;
import oracle.dbtools.crest.exports.reports.RSRaggedHierLinks;
import oracle.dbtools.crest.exports.reports.RSRollupLinks;
import oracle.dbtools.crest.exports.reports.RSSlices;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.multidimensional.MultidimensionalDesign;
import oracle.dbtools.crest.swingui.ProgressDialog;
import oracle.dbtools.crest.util.GUID;

public class RSMultidimensionalModel
extends RSModel {
    public static void export(Design design, Map map, Connection connection, ProgressDialog progressDialog) throws Exception {
        Iterator iterator = design.getMultidimensionalDesigns().iterator();
        while (iterator.hasNext()) {
            MultidimensionalDesign multidimensionalDesign = (MultidimensionalDesign)iterator.next();
            String string = new GUID().toString();
            map.put(multidimensionalDesign.getObjectID(), string);
            RSMultidimensionalModel.export(multidimensionalDesign, map, connection, "Multidimensional", null);
        }
        progressDialog.setNote(Messages.getString("RSMultidimensionalModel.ExportingCubes"));
        RSCubes.export(design, map, connection);
        progressDialog.setNote(Messages.getString("RSMultidimensionalModel.ExportingLevels"));
        RSLevels.export(design, map, connection);
        progressDialog.setNote(Messages.getString("RSMultidimensionalModel.ExportingDimensions"));
        RSDimensions.export(design, map, connection);
        progressDialog.setNote(Messages.getString("RSMultidimensionalModel.ExportingHierarchies"));
        RSHierarchies.export(design, map, connection);
        progressDialog.setNote(Messages.getString("RSMultidimensionalModel.ExportingMeasures"));
        RSMeasures.export(design, map, connection);
        progressDialog.setNote(Messages.getString("RSMultidimensionalModel.ExportingRollupLinks"));
        RSRollupLinks.export(design, map, connection);
        progressDialog.setNote(Messages.getString("RSMultidimensionalModel.ExportingRaggedHierarchyLinks"));
        RSRaggedHierLinks.export(design, map, connection);
        progressDialog.setNote(Messages.getString("RSMultidimensionalModel.ExportingSlices"));
        RSSlices.export(design, map, connection);
    }
}

