/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.model.NamingOptionsHolder;
import oracle.dbtools.crest.model.design.DesignPart;

public class RSModelNamingOptions
extends RSGeneral {
    public static void export(Map map, Connection connection, DesignPart designPart, String string, String string2) throws Exception {
        int n = 0;
        String string3 = "INSERT INTO DMRS_Model_Naming_Options (Object_type, Max_Name_Length, Character_Case, Valid_Characters, Model_ID, Model_OVID, Model_Name, Model_Type, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement preparedStatement = connection.prepareStatement(string3);
        for (NamingOptionsHolder namingOptionsHolder : designPart.getNamingOptionsHolderList()) {
            preparedStatement.setString(1, namingOptionsHolder.getClassName().getSimpleName());
            preparedStatement.setInt(2, namingOptionsHolder.getMaxNameLength());
            switch (namingOptionsHolder.getCaseType()) {
                case 0: {
                    preparedStatement.setString(3, "Upper Case");
                    break;
                }
                case 1: {
                    preparedStatement.setString(3, "Lower Case");
                    break;
                }
                case 2: {
                    preparedStatement.setString(3, "Mixed Case");
                }
            }
            if (namingOptionsHolder.getIsValid() || namingOptionsHolder.getValidChars() == null || "".equalsIgnoreCase(namingOptionsHolder.getValidChars())) {
                preparedStatement.setString(4, "All Valid");
            } else {
                preparedStatement.setString(4, namingOptionsHolder.getValidChars());
            }
            preparedStatement.setString(5, designPart.getObjectID());
            preparedStatement.setString(6, string);
            preparedStatement.setString(7, designPart.getName());
            preparedStatement.setString(8, string2);
            preparedStatement.setString(9, (String)map.get(designPart.getDesign().getObjectID()));
            preparedStatement.addBatch();
            if (++n != 1000) continue;
            n = 0;
            preparedStatement.executeBatch();
        }
        if (n > 0) {
            n = 0;
            preparedStatement.executeBatch();
        }
        preparedStatement.close();
        preparedStatement = null;
    }
}

