/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.logical.Arc;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.CandidateKey;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.EntityView;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKArc;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.xtdmapping.XtdMapping;

public class RSMappings
extends RSGeneral {
    public static void export(Design design, Map map, Connection connection) throws Exception {
        int n = 0;
        String string = "INSERT INTO DMRS_MAPPINGS (Logical_Model_ID, Logical_Model_OVID, Logical_Model_Name, Logical_Object_ID, Logical_Object_OVID, Logical_Object_Name, Logical_Object_Type, Relational_Model_ID, Relational_Model_OVID, Relational_Model_Name, Relational_Object_ID, Relational_Object_OVID, Relational_Object_Name, Relational_Object_Type, Entity_ID, Entity_OVID, Entity_Name, Table_ID, Table_OVID, Table_Name, Design_ID, Design_OVID, Design_Name) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement preparedStatement = connection.prepareStatement(string);
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(design.getExtendedMap().getAllMappings());
        Iterator iterator = design.getRelationalDesigns().iterator();
        while (iterator.hasNext()) {
            RelationalDesign relationalDesign = (RelationalDesign)iterator.next();
            if (!relationalDesign.isLoaded()) continue;
            arrayList.addAll(relationalDesign.getRMExtendedMap().getAllMappings());
        }
        for (XtdMapping xtdMapping : arrayList) {
            DesignObject designObject;
            DesignObject designObject2;
            if (xtdMapping.isDeleted()) continue;
            if (xtdMapping.getOwnerDesignPart() instanceof LogicalDesign) {
                designObject2 = xtdMapping.getOwnerObject();
                designObject = xtdMapping.getTargetObject();
            } else {
                designObject2 = xtdMapping.getTargetObject();
                designObject = xtdMapping.getOwnerObject();
            }
            if (designObject2 == null || (String)map.get(designObject2.getObjectID()) == null || designObject == null || (String)map.get(designObject.getObjectID()) == null) {
                System.out.println(xtdMapping);
                continue;
            }
            preparedStatement.setString(1, designObject2.getDesignPart().getObjectID());
            preparedStatement.setString(2, (String)map.get(designObject2.getDesignPart().getObjectID()));
            preparedStatement.setString(3, designObject2.getDesignPart().getName());
            preparedStatement.setString(4, designObject2.getObjectID());
            preparedStatement.setString(5, (String)map.get(designObject2.getObjectID()));
            preparedStatement.setString(6, designObject2.getName());
            preparedStatement.setString(7, designObject2.getObjectTypeName());
            preparedStatement.setString(8, designObject.getDesignPart().getObjectID());
            preparedStatement.setString(9, (String)map.get(designObject.getDesignPart().getObjectID()));
            preparedStatement.setString(10, designObject.getDesignPart().getName());
            preparedStatement.setString(11, designObject.getObjectID());
            preparedStatement.setString(12, (String)map.get(designObject.getObjectID()));
            preparedStatement.setString(13, designObject.getName());
            preparedStatement.setString(14, designObject.getObjectTypeName());
            if (designObject2 instanceof Entity) {
                preparedStatement.setString(15, designObject2.getObjectID());
                preparedStatement.setString(16, (String)map.get(designObject2.getObjectID()));
                preparedStatement.setString(17, designObject2.getName());
            } else if (designObject2 instanceof EntityView) {
                preparedStatement.setString(15, designObject2.getObjectID());
                preparedStatement.setString(16, (String)map.get(designObject2.getObjectID()));
                preparedStatement.setString(17, null);
            } else if (designObject2 instanceof Attribute) {
                preparedStatement.setString(15, ((Attribute)designObject2).getContainer().getObjectID());
                preparedStatement.setString(16, (String)map.get(((Attribute)designObject2).getContainer().getObjectID()));
                preparedStatement.setString(17, ((Attribute)designObject2).getContainer().getName());
            } else if (designObject2 instanceof CandidateKey) {
                preparedStatement.setString(15, ((CandidateKey)designObject2).getContainerObject().getObjectID());
                preparedStatement.setString(16, (String)map.get(((CandidateKey)designObject2).getContainerObject().getObjectID()));
                preparedStatement.setString(17, ((CandidateKey)designObject2).getContainerObject().getName());
            } else if (designObject2 instanceof Relation) {
                preparedStatement.setString(15, ((Relation)designObject2).getTargetEntity().getObjectID());
                preparedStatement.setString(16, (String)map.get(((Relation)designObject2).getTargetEntity().getObjectID()));
                preparedStatement.setString(17, ((Relation)designObject2).getTargetEntity().getName());
            } else if (designObject2 instanceof Arc && ((Arc)designObject2).getEntity() != null) {
                preparedStatement.setString(15, ((Arc)designObject2).getEntity().getObjectID());
                preparedStatement.setString(16, (String)map.get(((Arc)designObject2).getEntity().getObjectID()));
                preparedStatement.setString(17, ((Arc)designObject2).getEntity().getName());
            } else {
                preparedStatement.setString(15, null);
                preparedStatement.setString(16, null);
                preparedStatement.setString(17, null);
            }
            if (designObject instanceof Table) {
                preparedStatement.setString(18, designObject.getObjectID());
                preparedStatement.setString(19, (String)map.get(designObject.getObjectID()));
                preparedStatement.setString(20, designObject.getName());
            } else if (designObject instanceof TableView) {
                preparedStatement.setString(18, designObject.getObjectID());
                preparedStatement.setString(19, (String)map.get(designObject.getObjectID()));
                preparedStatement.setString(20, null);
            } else if (designObject instanceof Column) {
                preparedStatement.setString(18, ((Column)designObject).getContainer().getObjectID());
                preparedStatement.setString(19, (String)map.get(((Column)designObject).getContainer().getObjectID()));
                preparedStatement.setString(20, ((Column)designObject).getContainer().getName());
            } else if (designObject instanceof Index) {
                preparedStatement.setString(18, ((Index)designObject).getContainerObject().getObjectID());
                preparedStatement.setString(19, (String)map.get(((Index)designObject).getContainerObject().getObjectID()));
                preparedStatement.setString(20, ((Index)designObject).getContainerObject().getName());
            } else if (designObject instanceof FKIndexAssociation) {
                preparedStatement.setString(18, ((FKIndexAssociation)designObject).getTable().getObjectID());
                preparedStatement.setString(19, (String)map.get(((FKIndexAssociation)designObject).getTable().getObjectID()));
                preparedStatement.setString(20, ((FKIndexAssociation)designObject).getTable().getName());
            } else if (designObject instanceof FKArc && ((FKArc)designObject).getTable() != null) {
                preparedStatement.setString(18, ((FKArc)designObject).getTable().getObjectID());
                preparedStatement.setString(19, (String)map.get(((FKArc)designObject).getTable().getObjectID()));
                preparedStatement.setString(20, ((FKArc)designObject).getTable().getName());
            } else {
                preparedStatement.setString(18, null);
                preparedStatement.setString(19, null);
                preparedStatement.setString(20, null);
            }
            preparedStatement.setString(21, design.getObjectID());
            preparedStatement.setString(22, (String)map.get(design.getObjectID()));
            preparedStatement.setString(23, design.getName());
            preparedStatement.addBatch();
            if (++n != 1000) continue;
            n = 0;
            preparedStatement.executeBatch();
        }
        if (n > 0) {
            n = 0;
            preparedStatement.executeBatch();
        }
        preparedStatement.close();
        preparedStatement = null;
    }
}

