/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.util.Map;
import oracle.dbtools.crest.exports.Messages;
import oracle.dbtools.crest.exports.reports.RSAttributes;
import oracle.dbtools.crest.exports.reports.RSEntities;
import oracle.dbtools.crest.exports.reports.RSEntityViews;
import oracle.dbtools.crest.exports.reports.RSKeys;
import oracle.dbtools.crest.exports.reports.RSModel;
import oracle.dbtools.crest.exports.reports.RSRelationships;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.swingui.ProgressDialog;
import oracle.dbtools.crest.util.GUID;

public class RSLogicalModel
extends RSModel {
    public static void export(Design design, Map map, Connection connection, ProgressDialog progressDialog) throws Exception {
        LogicalDesign logicalDesign = design.getLogicalDesign();
        String string = new GUID().toString();
        map.put(logicalDesign.getObjectID(), string);
        RSLogicalModel.export(logicalDesign, map, connection, "Logical", null);
        progressDialog.setNote(Messages.getString("RSLogicalModel.ExportingEntities"));
        RSEntities.export(design, map, connection, logicalDesign, string);
        progressDialog.setNote(Messages.getString("RSLogicalModel.ExportingAttributes"));
        RSAttributes.export(design, map, connection, logicalDesign, string);
        progressDialog.setNote(Messages.getString("RSLogicalModel.ExportingKeys"));
        RSKeys.export(design, map, connection, logicalDesign, string);
        progressDialog.setNote(Messages.getString("RSLogicalModel.ExportingRelationships"));
        RSRelationships.export(design, map, connection, logicalDesign, string);
        progressDialog.setNote(Messages.getString("RSLogicalModel.ExportingEntityViews"));
        RSEntityViews.export(design, map, connection, logicalDesign, string);
    }
}

