/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSComments;
import oracle.dbtools.crest.exports.reports.RSCommentsInRDBMS;
import oracle.dbtools.crest.exports.reports.RSDynamicProperties;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.exports.reports.RSIndexColumns;
import oracle.dbtools.crest.exports.reports.RSObjectNotes;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.util.GUID;

public class RSIndexes
extends RSGeneral {
    public static void export(Design design, Map map, Connection connection) throws Exception {
        ArrayList<Index> arrayList = new ArrayList<Index>(1000);
        int n = 0;
        String string = "INSERT INTO DMRS_INDEXES (Index_Name, Object_ID, OVID, Import_ID, Container_ID, Container_OVID, State, Functional, Expression, Engineer, Table_Name, Spatial_Index, Spatial_Layer_Type, Geodetic_Index, Number_Of_Dimensions, Design_OVID, Schema_OVID, Schema_Name) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement preparedStatement = connection.prepareStatement(string);
        Iterator iterator = design.getRelationalDesigns().iterator();
        while (iterator.hasNext()) {
            RelationalDesign relationalDesign = (RelationalDesign)iterator.next();
            Iterator object = relationalDesign.getGlobalIndexSet().iterator();
            while (object.hasNext()) {
                Index index2 = (Index)object.next();
                String string2 = new GUID().toString();
                map.put(index2.getObjectID(), string2);
                preparedStatement.setString(1, index2.getName());
                preparedStatement.setString(2, index2.getObjectID());
                preparedStatement.setString(3, string2);
                preparedStatement.setString(4, index2.getImportedId());
                preparedStatement.setString(5, index2.getContainerObject().getObjectID());
                preparedStatement.setString(6, (String)map.get(index2.getContainerObject().getObjectID()));
                preparedStatement.setString(7, index2.getIndexState());
                preparedStatement.setString(8, !"".equalsIgnoreCase(index2.getIndexExpression()) ? "Y" : "N");
                preparedStatement.setString(9, index2.getIndexExpression());
                preparedStatement.setString(10, index2.getShouldEngineer() ? "Y" : "N");
                preparedStatement.setString(11, index2.getContainerObject().getName());
                preparedStatement.setString(12, index2.isSpatialIndex() ? "Y" : "N");
                preparedStatement.setString(13, index2.getLayerType());
                preparedStatement.setString(14, "YES".equalsIgnoreCase(index2.getGeodetic()) ? "Y" : "N");
                preparedStatement.setInt(15, index2.getDimensionsNumber());
                preparedStatement.setString(16, (String)map.get(design.getObjectID()));
                preparedStatement.setString(17, index2.getSchemaObject() != null ? (String)map.get(index2.getSchemaObject().getObjectID()) : null);
                preparedStatement.setString(18, index2.getSchemaObject() != null ? index2.getSchemaObject().getName() : null);
                preparedStatement.addBatch();
                arrayList.add(index2);
                if (++n != 1000) continue;
                n = 0;
                preparedStatement.executeBatch();
                for (Index index2 : arrayList) {
                    RSObjectNotes.export(map, connection, index2);
                    RSComments.export(map, connection, index2);
                    RSCommentsInRDBMS.export(map, connection, index2);
                    RSIndexColumns.export(design, map, connection, index2);
                    RSDynamicProperties.export(design, map, connection, index2);
                }
                arrayList.clear();
            }
        }
        if (n > 0) {
            n = 0;
            preparedStatement.executeBatch();
            for (Index index : arrayList) {
                RSObjectNotes.export(map, connection, index);
                RSComments.export(map, connection, index);
                RSCommentsInRDBMS.export(map, connection, index);
                RSIndexColumns.export(design, map, connection, index);
                RSDynamicProperties.export(design, map, connection, index);
            }
            arrayList.clear();
        }
        preparedStatement.close();
        preparedStatement = null;
    }
}

