/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.model.design.glossary.Glossary;
import oracle.dbtools.crest.model.design.glossary.GlossaryWord;
import oracle.dbtools.crest.util.GUID;

public class RSGlossaryTerms
extends RSGeneral {
    public static void export(Glossary glossary, Map map, Connection connection) throws Exception {
        ArrayList arrayList = new ArrayList(1000);
        int n = 0;
        String string = glossary.getId();
        String string2 = (String)map.get(string);
        String string3 = "INSERT INTO DMRS_GLOSSARY_TERMS (Term_ID, Term_OVID, Term_Name, Short_Description, Abbrev, Alt_Abbrev, Prime_Word, Class_Word, Modifier, Qualifier, Glossary_ID, Glossary_OVID, Glossary_Name, Plural) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement preparedStatement = connection.prepareStatement(string3);
        for (GlossaryWord glossaryWord : glossary.getWords()) {
            String string4 = glossaryWord.getId();
            String string5 = new GUID().toString();
            map.put(string4, string5);
            preparedStatement.setString(1, string4);
            preparedStatement.setString(2, string5);
            preparedStatement.setString(3, glossaryWord.getName());
            if (glossaryWord.getShortDescription().length() > 4000) {
                preparedStatement.setString(4, glossaryWord.getShortDescription().substring(0, 4000));
            } else {
                preparedStatement.setString(4, glossaryWord.getShortDescription());
            }
            preparedStatement.setString(5, glossaryWord.getAbbreviation());
            preparedStatement.setString(6, glossaryWord.getAltAbbrevation());
            preparedStatement.setString(7, glossaryWord.isPrimaryWord() ? "Y" : "N");
            preparedStatement.setString(8, glossaryWord.isClassWord() ? "Y" : "N");
            preparedStatement.setString(9, glossaryWord.isModifier() ? "Y" : "N");
            preparedStatement.setString(10, glossaryWord.isQualifier() ? "Y" : "N");
            preparedStatement.setString(11, string);
            preparedStatement.setString(12, string2);
            preparedStatement.setString(13, glossary.getName());
            preparedStatement.setString(14, glossaryWord.getPlural());
            preparedStatement.addBatch();
            if (++n != 1000) continue;
            n = 0;
            preparedStatement.executeBatch();
        }
        if (n > 0) {
            n = 0;
            preparedStatement.executeBatch();
        }
        preparedStatement.close();
        preparedStatement = null;
    }
}

