/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSComments;
import oracle.dbtools.crest.exports.reports.RSDynamicProperties;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.exports.reports.RSIndexColumns;
import oracle.dbtools.crest.exports.reports.RSObjectNotes;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.util.GUID;

public class RSFKeys
extends RSGeneral {
    public static void export(Design design, Map map, Connection connection) throws Exception {
        ArrayList<FKIndexAssociation> arrayList = new ArrayList<FKIndexAssociation>(1000);
        int n = 0;
        String string = "INSERT INTO DMRS_FOREIGNKEYS (FK_Name, Model_ID, Model_OVID, Object_ID, OVID, Import_ID, Child_Table_Name, Referred_Table_Name, Engineer, Delete_Rule, Child_Table_ID, Child_Table_OVID, Referred_Table_ID, Referred_Table_OVID, Referred_Key_ID, Referred_Key_OVID, Number_Of_Columns, Mandatory, Transferable, In_Arc, Arc_ID, Model_Name, Referred_Key_Name, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement preparedStatement = connection.prepareStatement(string);
        Iterator iterator = design.getRelationalDesigns().iterator();
        while (iterator.hasNext()) {
            RelationalDesign relationalDesign = (RelationalDesign)iterator.next();
            Iterator object = relationalDesign.getFKIndexAssociationSet().iterator();
            String string2 = (String)map.get(relationalDesign.getObjectID());
            while (object.hasNext()) {
                FKIndexAssociation fKIndexAssociation2 = (FKIndexAssociation)object.next();
                String string3 = new GUID().toString();
                map.put(fKIndexAssociation2.getObjectID(), string3);
                preparedStatement.setString(1, fKIndexAssociation2.getName());
                preparedStatement.setString(2, relationalDesign.getObjectID());
                preparedStatement.setString(3, string2);
                preparedStatement.setString(4, fKIndexAssociation2.getObjectID());
                preparedStatement.setString(5, string3);
                preparedStatement.setString(6, fKIndexAssociation2.getImportedId());
                preparedStatement.setString(7, fKIndexAssociation2.getContainerWithKeyObject().getName());
                preparedStatement.setString(8, fKIndexAssociation2.getRemoteTable().getName());
                preparedStatement.setString(9, fKIndexAssociation2.getShouldEngineer() ? "Y" : "N");
                preparedStatement.setString(10, fKIndexAssociation2.getDeleteRule());
                preparedStatement.setString(11, fKIndexAssociation2.getContainerWithKeyObject().getObjectID());
                preparedStatement.setString(12, (String)map.get(fKIndexAssociation2.getContainerWithKeyObject().getObjectID()));
                preparedStatement.setString(13, fKIndexAssociation2.getRemoteTable().getObjectID());
                preparedStatement.setString(14, (String)map.get(fKIndexAssociation2.getRemoteTable().getObjectID()));
                preparedStatement.setString(15, fKIndexAssociation2.getRemoteIndex().getObjectID());
                preparedStatement.setString(16, (String)map.get(fKIndexAssociation2.getRemoteIndex().getObjectID()));
                preparedStatement.setInt(17, fKIndexAssociation2.getRemoteIndex().getElements().length);
                preparedStatement.setString(18, fKIndexAssociation2.isMandatory() ? "Y" : "N");
                preparedStatement.setString(19, fKIndexAssociation2.isMandatory() ? "Y" : "N");
                preparedStatement.setString(20, fKIndexAssociation2.getArc() != null ? "Y" : "N");
                preparedStatement.setString(21, fKIndexAssociation2.getArc() != null ? fKIndexAssociation2.getArc().getObjectID() : null);
                preparedStatement.setString(22, relationalDesign.getName());
                preparedStatement.setString(23, fKIndexAssociation2.getRemoteIndex().getName());
                preparedStatement.setString(24, (String)map.get(design.getObjectID()));
                preparedStatement.addBatch();
                arrayList.add(fKIndexAssociation2);
                if (++n != 1000) continue;
                n = 0;
                preparedStatement.executeBatch();
                for (FKIndexAssociation fKIndexAssociation2 : arrayList) {
                    RSObjectNotes.export(map, connection, fKIndexAssociation2);
                    RSComments.export(map, connection, fKIndexAssociation2);
                    RSIndexColumns.export(design, map, connection, fKIndexAssociation2.getRemoteIndex());
                    RSDynamicProperties.export(design, map, connection, fKIndexAssociation2);
                }
                arrayList.clear();
            }
        }
        if (n > 0) {
            n = 0;
            preparedStatement.executeBatch();
            for (FKIndexAssociation fKIndexAssociation : arrayList) {
                RSObjectNotes.export(map, connection, fKIndexAssociation);
                RSComments.export(map, connection, fKIndexAssociation);
                RSIndexColumns.export(design, map, connection, fKIndexAssociation.getRemoteIndex());
                RSDynamicProperties.export(design, map, connection, fKIndexAssociation);
            }
            arrayList.clear();
        }
        preparedStatement.close();
        preparedStatement = null;
    }
}

