/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSComments;
import oracle.dbtools.crest.exports.reports.RSDynamicProperties;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.exports.reports.RSObjectNotes;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.process.Event;
import oracle.dbtools.crest.model.design.process.Flow;
import oracle.dbtools.crest.model.design.process.ProcessModel;

public class RSEvents
extends RSGeneral {
    public static void export(Design design, Map map, Connection connection) throws Exception {
        ArrayList<Object> arrayList = new ArrayList<Object>(1000);
        int n = 0;
        String string = "INSERT INTO DMRS_EVENTS (Event_ID, Event_OVID, Event_Name, Model_ID, Model_OVID, Model_Name, Flow_ID, Flow_OVID, Flow_Name, Event_Type, Times_When_Run, Day_Of_Week, Months, Frequency, Time_Frequency, Minute, Hour, Day_Of_Month, Quarter, Year, On_Day, At_Time, Fiscal, Text, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement preparedStatement = connection.prepareStatement(string);
        ProcessModel processModel = design.getProcessModel();
        Iterator iterator = processModel.getEventSet().iterator();
        while (iterator.hasNext()) {
            Object object3 = (Event)iterator.next();
            Object object2 = RSEvents.getOrCreateOVID(map, ((ModelIDObject)object3).getObjectID());
            Flow flow = ((Event)object3).getFlow();
            preparedStatement.setString(1, ((ModelIDObject)object3).getObjectID());
            preparedStatement.setString(2, (String)object2);
            preparedStatement.setString(3, ((DesignObject)object3).getName());
            preparedStatement.setString(4, processModel.getObjectID());
            preparedStatement.setString(5, (String)map.get(processModel.getObjectID()));
            preparedStatement.setString(6, processModel.getName());
            if (flow != null) {
                preparedStatement.setString(7, flow.getObjectID());
                preparedStatement.setString(8, RSEvents.getOrCreateOVID(map, flow.getObjectID()));
                preparedStatement.setString(9, flow.getName());
            } else {
                preparedStatement.setString(7, null);
                preparedStatement.setString(8, null);
                preparedStatement.setString(9, null);
            }
            int n2 = ((Event)object3).getEventType();
            if (n2 == 0) {
                preparedStatement.setString(10, "Info Flow");
            } else if (n2 == 1) {
                preparedStatement.setString(10, "Clock Calendar");
            } else if (n2 == 2) {
                preparedStatement.setString(10, "Person");
            } else if (n2 == 3) {
                preparedStatement.setString(10, "Storage");
            } else {
                preparedStatement.setString(10, null);
            }
            int n3 = ((Event)object3).getTimesWhenRun();
            if (n3 == 1) {
                preparedStatement.setString(11, "At Open Of Business Day");
            } else if (n3 == 2) {
                preparedStatement.setString(11, "At Close Of Business Day");
            } else if (n3 == 3) {
                preparedStatement.setString(11, "When Convenient During Day");
            } else if (n3 == 4) {
                preparedStatement.setString(11, "At Specified Time");
            } else {
                preparedStatement.setString(11, null);
            }
            preparedStatement.setString(12, ((Event)object3).getDayOfWeek());
            preparedStatement.setString(13, ((Event)object3).getMonths());
            preparedStatement.setInt(14, ((Event)object3).getFrequency());
            preparedStatement.setInt(15, ((Event)object3).getTimeFreq());
            preparedStatement.setInt(16, ((Event)object3).getMinute());
            preparedStatement.setInt(17, ((Event)object3).getHour());
            preparedStatement.setInt(18, ((Event)object3).getDayOfMonth());
            preparedStatement.setInt(19, ((Event)object3).getQuarter());
            preparedStatement.setInt(20, ((Event)object3).getYear());
            preparedStatement.setString(21, ((Event)object3).isOnDay() ? "Y" : "N");
            preparedStatement.setString(22, ((Event)object3).isAtTime() ? "Y" : "N");
            preparedStatement.setString(23, ((Event)object3).isFiscal() ? "Y" : "N");
            preparedStatement.setString(24, ((Event)object3).getText());
            preparedStatement.setString(25, (String)map.get(design.getObjectID()));
            preparedStatement.addBatch();
            arrayList.add(object3);
            if (++n != 1000) continue;
            n = 0;
            preparedStatement.executeBatch();
            for (Object object3 : arrayList) {
                RSObjectNotes.export(map, connection, (ModelIDObject)object3);
                RSComments.export(map, connection, (ModelIDObject)object3);
                RSDynamicProperties.export(design, map, connection, (ModelIDObject)object3);
            }
            arrayList.clear();
        }
        if (n > 0) {
            n = 0;
            preparedStatement.executeBatch();
            for (Object object2 : arrayList) {
                RSObjectNotes.export(map, connection, (ModelIDObject)object2);
                RSComments.export(map, connection, (ModelIDObject)object2);
                RSDynamicProperties.export(design, map, connection, (ModelIDObject)object2);
            }
            arrayList.clear();
        }
        preparedStatement.close();
        preparedStatement = null;
    }
}

