/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSComments;
import oracle.dbtools.crest.exports.reports.RSCommentsInRDBMS;
import oracle.dbtools.crest.exports.reports.RSDynamicProperties;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.exports.reports.RSObjectNotes;
import oracle.dbtools.crest.model.ClassificationType;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.ContainerWithKeyObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.util.GUID;

public class RSEntities
extends RSGeneral {
    public static void export(Design design, Map map, Connection connection, LogicalDesign logicalDesign, String string) throws Exception {
        ArrayList arrayList = new ArrayList(1000);
        int n = 0;
        ctMap.clear();
        String string2 = "INSERT INTO DMRS_CLASSIFICATION_TYPES (Type_ID, Type_OVID, Type_Name, Design_ID, Design_OVID, Design_Name) VALUES (?, ?, ?, ?, ?, ?)";
        PreparedStatement preparedStatement = connection.prepareStatement(string2);
        for (Object object2 : design.getDLSettings().getClassificationTypeList()) {
            String object4 = new GUID().toString();
            ctMap.put(((ClassificationType)object2).getTypeID(), object4);
            preparedStatement.setString(1, ((ClassificationType)object2).getTypeID());
            preparedStatement.setString(2, object4);
            preparedStatement.setString(3, ((ClassificationType)object2).getTypeName());
            preparedStatement.setString(4, design.getObjectID());
            preparedStatement.setString(5, (String)map.get(design.getObjectID()));
            preparedStatement.setString(6, design.getName());
            preparedStatement.addBatch();
            if (++n != 1000) continue;
            n = 0;
            preparedStatement.executeBatch();
        }
        if (n > 0) {
            n = 0;
            preparedStatement.executeBatch();
        }
        preparedStatement.close();
        preparedStatement = null;
        string2 = "INSERT INTO DMRS_ENTITIES (Entity_Name, Object_ID, OVID, Import_ID, Model_ID, Model_OVID, Structured_Type_ID, Structured_Type_OVID, Structured_Type_Name, Number_Data_Elements, Classification_Type_ID, Classification_Type_OVID, Classification_Type_Name, Allow_Type_Substitution, Min_Volume, Expected_Volume, Max_Volume, Growth_Rate_Percents, Growth_Rate_Interval, Normal_Form, Temporary_Object_Scope, Adequately_Normalized, Substitution_Parent, Substitution_Parent_OVID, Synonyms, Synonym_To_Display, Preferred_Abbreviation, SuperTypeEntity_ID, SuperTypeEntity_OVID, Engineering_Strategy, Owner, Entity_Source, Model_Name, Substitution_Parent_Name, SuperTypeEntity_Name, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        preparedStatement = connection.prepareStatement(string2);
        Iterator iterator = logicalDesign.getEntitySet().iterator();
        while (iterator.hasNext()) {
            Object object;
            Object object2;
            object2 = (Entity)iterator.next();
            String string3 = RSEntities.getOrCreateOVID(map, ((ModelIDObject)object2).getObjectID());
            preparedStatement.setString(1, ((DesignObject)object2).getName());
            preparedStatement.setString(2, ((ModelIDObject)object2).getObjectID());
            preparedStatement.setString(3, string3);
            preparedStatement.setString(4, ((DesignObject)object2).getImportedId());
            preparedStatement.setString(5, logicalDesign.getObjectID());
            preparedStatement.setString(6, string);
            preparedStatement.setString(7, ((ContainerObject)object2).getBasedOnStructuredType() != null ? ((ContainerObject)object2).getBasedOnStructuredType().getObjectID() : null);
            preparedStatement.setString(8, ((ContainerObject)object2).getBasedOnStructuredType() != null ? (String)map.get(((ContainerObject)object2).getBasedOnStructuredType().getObjectID()) : null);
            preparedStatement.setString(9, ((ContainerObject)object2).getBasedOnStructuredType() != null ? ((ContainerObject)object2).getBasedOnStructuredType().getName() : null);
            preparedStatement.setInt(10, ((ContainerObject)object2).getElements().length);
            preparedStatement.setString(11, null);
            preparedStatement.setString(12, null);
            preparedStatement.setString(13, null);
            if (!"".equalsIgnoreCase(((ContainerWithKeyObject)object2).getTypeID()) && (object = design.getDLSettings().getClassificationTypeByID(((ContainerWithKeyObject)object2).getTypeID())) != null) {
                String string4 = (String)ctMap.get(((ClassificationType)object).getTypeID());
                preparedStatement.setString(11, ((ContainerWithKeyObject)object2).getTypeID());
                preparedStatement.setString(12, string4);
                preparedStatement.setString(13, ((ClassificationType)object).getTypeName());
            }
            preparedStatement.setString(14, ((ContainerObject)object2).isAllowTypeSubstitution() ? "Y" : "N");
            preparedStatement.setObject(15, ((Entity)object2).getMinVolumes());
            preparedStatement.setObject(16, ((Entity)object2).getExpectedVolumes());
            preparedStatement.setObject(17, ((Entity)object2).getMaxVolumes());
            preparedStatement.setInt(18, ((Entity)object2).getGrowthPercentInt());
            preparedStatement.setString(19, ((Entity)object2).getGrowthType());
            preparedStatement.setString(20, ((Entity)object2).getNormalForm());
            preparedStatement.setString(21, ((Entity)object2).getScope());
            preparedStatement.setString(22, "YES".equalsIgnoreCase(((Entity)object2).getAdequatelyNormalized()) ? "Y" : "N");
            preparedStatement.setString(23, ((ContainerObject)object2).getTypeSubstitution() != null ? ((ContainerObject)object2).getTypeSubstitution().getObjectID() : null);
            preparedStatement.setString(24, ((ContainerObject)object2).getTypeSubstitution() != null ? RSEntities.getOrCreateOVID(map, ((ContainerObject)object2).getTypeSubstitution().getObjectID()) : null);
            preparedStatement.setString(25, ((Entity)object2).getSynonym());
            preparedStatement.setString(26, ((Entity)object2).getSynonymToDisplay());
            preparedStatement.setString(27, ((Entity)object2).getPreferredAbbreviation());
            preparedStatement.setString(28, ((Entity)object2).getHierarchicalParent() != null ? ((Entity)object2).getHierarchicalParent().getObjectID() : null);
            preparedStatement.setString(29, ((Entity)object2).getHierarchicalParent() != null ? RSEntities.getOrCreateOVID(map, ((Entity)object2).getHierarchicalParent().getObjectID()) : null);
            preparedStatement.setString(30, ((Entity)object2).getFwdEngineeringStrategyName());
            preparedStatement.setString(31, ((Entity)object2).getOwner());
            preparedStatement.setString(32, ((Entity)object2).getSource());
            preparedStatement.setString(33, logicalDesign.getName());
            preparedStatement.setString(34, ((ContainerObject)object2).getTypeSubstitution() != null ? ((ContainerObject)object2).getTypeSubstitution().getName() : null);
            preparedStatement.setString(35, ((Entity)object2).getHierarchicalParent() != null ? ((Entity)object2).getHierarchicalParent().getName() : null);
            preparedStatement.setString(36, (String)map.get(design.getObjectID()));
            preparedStatement.addBatch();
            arrayList.add(object2);
            if (++n != 1000) continue;
            n = 0;
            preparedStatement.executeBatch();
            object = arrayList.iterator();
            while (object.hasNext()) {
                object2 = (Entity)object.next();
                RSObjectNotes.export(map, connection, (ModelIDObject)object2);
                RSComments.export(map, connection, (ModelIDObject)object2);
                RSCommentsInRDBMS.export(map, connection, (ModelIDObject)object2);
                RSDynamicProperties.export(design, map, connection, (ModelIDObject)object2);
            }
            arrayList.clear();
        }
        if (n > 0) {
            n = 0;
            preparedStatement.executeBatch();
            for (Entity entity : arrayList) {
                RSObjectNotes.export(map, connection, entity);
                RSComments.export(map, connection, entity);
                RSCommentsInRDBMS.export(map, connection, entity);
                RSDynamicProperties.export(design, map, connection, entity);
            }
            arrayList.clear();
        }
        preparedStatement.close();
        preparedStatement = null;
    }
}

