/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSComments;
import oracle.dbtools.crest.exports.reports.RSCommentsInRDBMS;
import oracle.dbtools.crest.exports.reports.RSDynamicProperties;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.exports.reports.RSObjectNotes;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.datatypes.DataTypesDesign;
import oracle.dbtools.crest.model.design.datatypes.DistinctType;
import oracle.dbtools.crest.util.GUID;

public class RSDistinctTypes
extends RSGeneral {
    public static void export(Design design, Map map, Connection connection, DataTypesDesign dataTypesDesign, String string) throws Exception {
        ArrayList<Object> arrayList = new ArrayList<Object>(1000);
        int n = 0;
        String string2 = (String)map.get(design.getObjectID());
        String string3 = "INSERT INTO DMRS_DISTINCT_TYPES (Design_ID, Design_OVID, Design_Name, Distinct_Type_ID, Distinct_Type_OVID, Distinct_Type_Name, Logical_Type_ID, Logical_Type_OVID, Logical_Type_Name, T_Size, T_Precision, T_Scale, Model_OVID, Model_Name) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement preparedStatement = connection.prepareStatement(string3);
        Iterator iterator = dataTypesDesign.getDistinctTypeSet().iterator();
        while (iterator.hasNext()) {
            Object object3 = (DistinctType)iterator.next();
            Object object2 = new GUID().toString();
            map.put(((ModelIDObject)object3).getObjectID(), object2);
            preparedStatement.setString(1, design.getObjectID());
            preparedStatement.setString(2, string2);
            preparedStatement.setString(3, design.getName());
            preparedStatement.setString(4, ((ModelIDObject)object3).getObjectID());
            preparedStatement.setString(5, (String)object2);
            preparedStatement.setString(6, ((DesignObject)object3).getName());
            if (((DistinctType)object3).getLogicalDataType() != null) {
                preparedStatement.setString(7, ((DistinctType)object3).getLogicalDataType().getObjectID());
                preparedStatement.setString(8, (String)map.get(((DistinctType)object3).getLogicalDataType().getObjectID()));
                preparedStatement.setString(9, ((DistinctType)object3).getLogicalDataType().getName());
            } else {
                preparedStatement.setString(7, null);
                preparedStatement.setString(8, null);
                preparedStatement.setString(9, null);
            }
            preparedStatement.setString(10, ((DistinctType)object3).getSize());
            preparedStatement.setInt(11, ((DistinctType)object3).getPrecision());
            preparedStatement.setInt(12, ((DistinctType)object3).getScale());
            preparedStatement.setString(13, string);
            preparedStatement.setString(14, ((DesignObject)object3).getDesignPart().getName());
            preparedStatement.addBatch();
            arrayList.add(object3);
            if (++n != 1000) continue;
            n = 0;
            preparedStatement.executeBatch();
            for (Object object3 : arrayList) {
                RSObjectNotes.export(map, connection, (ModelIDObject)object3);
                RSComments.export(map, connection, (ModelIDObject)object3);
                RSCommentsInRDBMS.export(map, connection, (ModelIDObject)object3);
                RSDynamicProperties.export(design, map, connection, (ModelIDObject)object3);
            }
            arrayList.clear();
        }
        if (n > 0) {
            n = 0;
            preparedStatement.executeBatch();
            for (Object object2 : arrayList) {
                RSObjectNotes.export(map, connection, (ModelIDObject)object2);
                RSComments.export(map, connection, (ModelIDObject)object2);
                RSCommentsInRDBMS.export(map, connection, (ModelIDObject)object2);
                RSDynamicProperties.export(design, map, connection, (ModelIDObject)object2);
            }
            arrayList.clear();
        }
        preparedStatement.close();
        preparedStatement = null;
    }
}

