/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSComments;
import oracle.dbtools.crest.exports.reports.RSDynamicProperties;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.exports.reports.RSObjectNotes;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.multidimensional.Dimension;
import oracle.dbtools.crest.model.design.multidimensional.Level;
import oracle.dbtools.crest.model.design.multidimensional.MultidimensionalDesign;

public class RSDimensions
extends RSGeneral {
    public static void export(Design design, Map map, Connection connection) throws Exception {
        ArrayList<Dimension> arrayList = new ArrayList<Dimension>(1000);
        int n = 0;
        ArrayList<Dimension> arrayList2 = new ArrayList<Dimension>();
        String string = "INSERT INTO DMRS_DIMENSIONS (Dimension_ID, Dimension_Name, Dimension_OVID, Model_ID, Model_Name, Model_OVID, Base_Entity_ID, Base_Entity_Name, Base_Entity_OVID, Base_Level_ID, Base_Level_Name, Base_Level_OVID, Oracle_Long_Name, Oracle_Plural_Name, Oracle_Short_Name, Description, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement preparedStatement = connection.prepareStatement(string);
        Iterator iterator = design.getMultidimensionalDesigns().iterator();
        while (iterator.hasNext()) {
            MultidimensionalDesign multidimensionalDesign = (MultidimensionalDesign)iterator.next();
            String object = (String)map.get(multidimensionalDesign.getObjectID());
            String string2 = (String)map.get(multidimensionalDesign.getDesign().getObjectID());
            Iterator iterator2 = multidimensionalDesign.getDimensionSet().iterator();
            arrayList2.clear();
            while (iterator2.hasNext()) {
                Dimension dimension2 = (Dimension)iterator2.next();
                String string3 = RSDimensions.getOrCreateOVID(map, dimension2.getObjectID());
                arrayList2.add(dimension2);
                Entity entity = dimension2.getBaseEntity();
                Level level = dimension2.getBaseLevel();
                preparedStatement.setString(1, dimension2.getObjectID());
                preparedStatement.setString(2, dimension2.getName());
                preparedStatement.setString(3, string3);
                preparedStatement.setString(4, multidimensionalDesign.getObjectID());
                preparedStatement.setString(5, multidimensionalDesign.getName());
                preparedStatement.setString(6, object);
                if (entity != null) {
                    preparedStatement.setString(7, entity.getObjectID());
                    preparedStatement.setString(8, entity.getName());
                    preparedStatement.setString(9, RSDimensions.getOrCreateOVID(map, entity.getObjectID()));
                } else {
                    preparedStatement.setString(7, null);
                    preparedStatement.setString(8, null);
                    preparedStatement.setString(9, null);
                }
                if (level != null) {
                    preparedStatement.setString(10, level.getObjectID());
                    preparedStatement.setString(11, level.getName());
                    preparedStatement.setString(12, RSDimensions.getOrCreateOVID(map, level.getObjectID()));
                } else {
                    preparedStatement.setString(10, null);
                    preparedStatement.setString(11, null);
                    preparedStatement.setString(12, null);
                }
                preparedStatement.setString(13, dimension2.getOracleLongName());
                preparedStatement.setString(14, dimension2.getOraclePluralName());
                preparedStatement.setString(15, dimension2.getOracleShortName());
                preparedStatement.setString(16, dimension2.getDescription());
                preparedStatement.setString(17, string2);
                preparedStatement.addBatch();
                arrayList.add(dimension2);
                if (++n != 1000) continue;
                n = 0;
                preparedStatement.executeBatch();
                for (Dimension dimension2 : arrayList) {
                    RSObjectNotes.export(map, connection, dimension2);
                    RSComments.export(map, connection, dimension2);
                    RSDynamicProperties.export(design, map, connection, dimension2);
                }
                arrayList.clear();
            }
            RSDimensions.exportLevels(map, connection, arrayList2, string2);
            RSDimensions.exportCalcMembers(map, connection, arrayList2, string2);
        }
        if (n > 0) {
            n = 0;
            preparedStatement.executeBatch();
            for (Dimension dimension : arrayList) {
                RSObjectNotes.export(map, connection, dimension);
                RSComments.export(map, connection, dimension);
                RSDynamicProperties.export(design, map, connection, dimension);
            }
            arrayList.clear();
        }
        preparedStatement.close();
        preparedStatement = null;
    }

    private static void exportLevels(Map map, Connection connection, List list, String string) throws Exception {
        int n = 0;
        String string2 = "INSERT INTO DMRS_DIMENSION_LEVELS (Dimension_ID, Dimension_Name, Dimension_OVID, Level_ID, Level_Name, Level_OVID, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement preparedStatement = connection.prepareStatement(string2);
        for (Dimension dimension : list) {
            for (Level level : dimension.getAllLevels()) {
                String string3 = RSDimensions.getOrCreateOVID(map, level.getObjectID());
                preparedStatement.setString(1, dimension.getObjectID());
                preparedStatement.setString(2, dimension.getName());
                preparedStatement.setString(3, (String)map.get(dimension.getObjectID()));
                preparedStatement.setString(4, level.getObjectID());
                preparedStatement.setString(5, level.getName());
                preparedStatement.setString(6, string3);
                preparedStatement.setString(7, string);
                preparedStatement.addBatch();
                if (++n != 1000) continue;
                n = 0;
                preparedStatement.executeBatch();
            }
        }
        if (n > 0) {
            n = 0;
            preparedStatement.executeBatch();
        }
        preparedStatement.close();
        preparedStatement = null;
    }

    private static void exportCalcMembers(Map map, Connection connection, List list, String string) throws Exception {
        int n = 0;
        String string2 = "INSERT INTO DMRS_DIMENSION_CALC_ATTRS (Dimension_ID, Dimension_Name, Dimension_OVID, Calc_Attribute_ID, Calc_Attribute_Name, Calc_Attribute_OVID, Calculated_Expr, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement preparedStatement = connection.prepareStatement(string2);
        for (Dimension dimension : list) {
            for (Dimension.PermanentCalcMember permanentCalcMember : dimension.getPermanentCalcMembers()) {
                String string3 = RSDimensions.getOrCreateOVID(map, permanentCalcMember.getId());
                preparedStatement.setString(1, dimension.getObjectID());
                preparedStatement.setString(2, dimension.getName());
                preparedStatement.setString(3, (String)map.get(dimension.getObjectID()));
                preparedStatement.setString(4, permanentCalcMember.getId());
                preparedStatement.setString(5, permanentCalcMember.getName());
                preparedStatement.setString(6, string3);
                preparedStatement.setString(7, permanentCalcMember.getExpression());
                preparedStatement.setString(8, string);
                preparedStatement.addBatch();
                if (++n != 1000) continue;
                n = 0;
                preparedStatement.executeBatch();
            }
        }
        if (n > 0) {
            n = 0;
            preparedStatement.executeBatch();
        }
        preparedStatement.close();
        preparedStatement = null;
    }
}

