/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.Iterator;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSComments;
import oracle.dbtools.crest.exports.reports.RSDynamicProperties;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.exports.reports.RSObjectNotes;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.multidimensional.Cube;
import oracle.dbtools.crest.model.design.multidimensional.Dimension;
import oracle.dbtools.crest.model.design.multidimensional.FactEntitiesJoin;
import oracle.dbtools.crest.model.design.multidimensional.Hierarchy;
import oracle.dbtools.crest.model.design.multidimensional.Level;
import oracle.dbtools.crest.model.design.multidimensional.MultidimensionalDesign;
import oracle.dbtools.crest.model.design.multidimensional.Slice;

public class RSCubes
extends RSGeneral {
    public static void export(Design design, Map map, Connection connection) throws Exception {
        String string = "INSERT INTO DMRS_CUBES (Cube_ID, Cube_Name, Cube_OVID, Model_ID, Model_Name, Model_OVID, Part_Dimension_ID, Part_Dimension_Name, Part_Dimension_OVID, Part_Hierarchy_ID, Part_Hierarchy_Name, Part_Hierarchy_OVID, Part_Level_ID, Part_Level_Name, Part_Level_OVID, Full_Cube_Slice_ID, Full_Cube_Slice_Name, Full_Cube_Slice_OVID, Oracle_Long_Name, Oracle_Plural_Name, Oracle_Short_Name, Is_Compressed_Composites, Is_Global_Composites, Is_Partitioned, Is_Virtual, Part_Description, Description, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement preparedStatement = connection.prepareStatement(string);
        String string2 = "INSERT INTO DMRS_CUBE_DIMENSIONS (Cube_ID, Cube_Name, Cube_OVID, Dimension_ID, Dimension_Name, Dimension_OVID, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement preparedStatement2 = connection.prepareStatement(string2);
        String string3 = "INSERT INTO DMRS_FACT_ENTITIES (Cube_ID, Cube_Name, Cube_OVID, Entity_ID, Entity_Name, Entity_OVID, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement preparedStatement3 = connection.prepareStatement(string3);
        String string4 = "INSERT INTO DMRS_FACT_ENTITIES_JOINS (Join_ID, Join_Name, Join_OVID, Cube_ID, Cube_Name, Cube_OVID, Left_Entity_ID, Left_Entity_Name, Left_Entity_OVID, Right_Entity_ID, Right_Entity_Name, Right_Entity_OVID, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement preparedStatement4 = connection.prepareStatement(string4);
        Iterator iterator = design.getMultidimensionalDesigns().iterator();
        while (iterator.hasNext()) {
            MultidimensionalDesign multidimensionalDesign = (MultidimensionalDesign)iterator.next();
            String string5 = (String)map.get(multidimensionalDesign.getObjectID());
            String string6 = (String)map.get(multidimensionalDesign.getDesign().getObjectID());
            Iterator iterator2 = multidimensionalDesign.getCubeSet().iterator();
            while (iterator2.hasNext()) {
                Object object;
                Object object22;
                Cube cube = (Cube)iterator2.next();
                String string7 = RSCubes.getOrCreateOVID(map, cube.getObjectID());
                Dimension dimension = cube.getPartDimension();
                Hierarchy hierarchy = cube.getPartHierarchy();
                Level level = cube.getPartLevel();
                Slice slice = cube.getFullCubeMaterialization();
                preparedStatement.setString(1, cube.getObjectID());
                preparedStatement.setString(2, cube.getName());
                preparedStatement.setString(3, string7);
                preparedStatement.setString(4, multidimensionalDesign.getObjectID());
                preparedStatement.setString(5, multidimensionalDesign.getName());
                preparedStatement.setString(6, string5);
                if (dimension != null) {
                    preparedStatement.setString(7, dimension.getObjectID());
                    preparedStatement.setString(8, dimension.getName());
                    preparedStatement.setString(9, RSCubes.getOrCreateOVID(map, dimension.getObjectID()));
                } else {
                    preparedStatement.setString(7, null);
                    preparedStatement.setString(8, null);
                    preparedStatement.setString(9, null);
                }
                if (hierarchy != null) {
                    preparedStatement.setString(10, hierarchy.getObjectID());
                    preparedStatement.setString(11, hierarchy.getName());
                    preparedStatement.setString(12, RSCubes.getOrCreateOVID(map, hierarchy.getObjectID()));
                } else {
                    preparedStatement.setString(10, null);
                    preparedStatement.setString(11, null);
                    preparedStatement.setString(12, null);
                }
                if (level != null) {
                    preparedStatement.setString(13, level.getObjectID());
                    preparedStatement.setString(14, level.getName());
                    preparedStatement.setString(15, RSCubes.getOrCreateOVID(map, level.getObjectID()));
                } else {
                    preparedStatement.setString(13, null);
                    preparedStatement.setString(14, null);
                    preparedStatement.setString(15, null);
                }
                if (slice != null) {
                    preparedStatement.setString(16, slice.getObjectID());
                    preparedStatement.setString(17, slice.getName());
                    preparedStatement.setString(18, RSCubes.getOrCreateOVID(map, slice.getObjectID()));
                } else {
                    preparedStatement.setString(16, null);
                    preparedStatement.setString(17, null);
                    preparedStatement.setString(18, null);
                }
                preparedStatement.setString(19, cube.getOracleLongName());
                preparedStatement.setString(20, cube.getOraclePluralName());
                preparedStatement.setString(21, cube.getOracleShortName());
                preparedStatement.setString(22, cube.isCompressedComposites() ? "Y" : "N");
                preparedStatement.setString(23, cube.isUseGlobalComposites() ? "Y" : "N");
                preparedStatement.setString(24, cube.isPartitioned() ? "Y" : "N");
                preparedStatement.setString(25, cube.isVirtual() ? "Y" : "N");
                preparedStatement.setString(26, cube.getPartitioningDescription());
                preparedStatement.setString(27, cube.getDescription());
                preparedStatement.setString(28, string6);
                preparedStatement.executeUpdate();
                RSObjectNotes.export(map, connection, cube);
                RSComments.export(map, connection, cube);
                RSDynamicProperties.export(design, map, connection, cube);
                for (Object object22 : cube.getDimensions()) {
                    object = RSCubes.getOrCreateOVID(map, ((ModelIDObject)object22).getObjectID());
                    preparedStatement2.setString(1, cube.getObjectID());
                    preparedStatement2.setString(2, cube.getName());
                    preparedStatement2.setString(3, string7);
                    preparedStatement2.setString(4, ((ModelIDObject)object22).getObjectID());
                    preparedStatement2.setString(5, ((DesignObject)object22).getName());
                    preparedStatement2.setString(6, (String)object);
                    preparedStatement2.setString(7, string6);
                    preparedStatement2.executeUpdate();
                }
                object22 = cube.getFactEntities().iterator();
                while (object22.hasNext()) {
                    object = (ContainerObject)object22.next();
                    if (!(object instanceof Entity)) continue;
                    Object object3 = (String)map.get(((ModelIDObject)object).getObjectID());
                    preparedStatement3.setString(1, cube.getObjectID());
                    preparedStatement3.setString(2, cube.getName());
                    preparedStatement3.setString(3, string7);
                    preparedStatement3.setString(4, ((ModelIDObject)object).getObjectID());
                    preparedStatement3.setString(5, ((DesignObject)object).getName());
                    preparedStatement3.setString(6, (String)object3);
                    preparedStatement3.setString(7, string6);
                    preparedStatement3.executeUpdate();
                }
                for (Object object3 : cube.getJoins()) {
                    String string8 = RSCubes.getOrCreateOVID(map, ((ModelIDObject)object3).getObjectID());
                    Entity entity = ((FactEntitiesJoin)object3).getLeftEntity();
                    Entity entity2 = ((FactEntitiesJoin)object3).getRightEntity();
                    preparedStatement4.setString(1, ((ModelIDObject)object3).getObjectID());
                    preparedStatement4.setString(2, ((DesignObject)object3).getName());
                    preparedStatement4.setString(3, string8);
                    preparedStatement4.setString(4, cube.getObjectID());
                    preparedStatement4.setString(5, cube.getName());
                    preparedStatement4.setString(6, string7);
                    if (entity != null) {
                        preparedStatement4.setString(7, entity.getObjectID());
                        preparedStatement4.setString(8, entity.getName());
                        preparedStatement4.setString(9, (String)map.get(entity.getObjectID()));
                    } else {
                        preparedStatement4.setString(7, null);
                        preparedStatement4.setString(8, null);
                        preparedStatement4.setString(9, null);
                    }
                    if (entity2 != null) {
                        preparedStatement4.setString(10, entity2.getObjectID());
                        preparedStatement4.setString(11, entity2.getName());
                        preparedStatement4.setString(12, (String)map.get(entity2.getObjectID()));
                    } else {
                        preparedStatement4.setString(10, null);
                        preparedStatement4.setString(11, null);
                        preparedStatement4.setString(12, null);
                    }
                    preparedStatement4.setString(13, string6);
                    preparedStatement4.executeUpdate();
                }
            }
        }
        preparedStatement4.close();
        preparedStatement4 = null;
        preparedStatement3.close();
        preparedStatement3 = null;
        preparedStatement2.close();
        preparedStatement2 = null;
        preparedStatement.close();
        preparedStatement = null;
    }
}

