/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSAVT;
import oracle.dbtools.crest.exports.reports.RSCheckConstraint;
import oracle.dbtools.crest.exports.reports.RSColumnUI;
import oracle.dbtools.crest.exports.reports.RSComments;
import oracle.dbtools.crest.exports.reports.RSCommentsInRDBMS;
import oracle.dbtools.crest.exports.reports.RSDynamicProperties;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.exports.reports.RSObjectNotes;
import oracle.dbtools.crest.exports.reports.RSValueRanges;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;

public class RSColumns
extends RSGeneral {
    public static void export(Design design, Map map, Connection connection) throws Exception {
        ArrayList<Column> arrayList = new ArrayList<Column>(1000);
        int n = 0;
        ArrayList<Column> arrayList2 = new ArrayList<Column>();
        String string = "INSERT INTO DMRS_COLUMNS (Column_Name, Abbreviation, Object_ID, OVID, Import_ID, Container_ID, Container_OVID, Mandatory, DataType_Kind, Value_Type, Formula, ScopeEntity_ID, ScopeEntity_OVID, Domain_ID, Domain_OVID, Logical_Type_ID, Logical_Type_OVID, Distinct_Type_ID, Distinct_Type_OVID, Structured_Type_ID, Structured_Type_OVID, Collection_Type_ID, Collection_Type_OVID, Check_Constraint_Name, Default_Value, Use_Domain_Constraint, Domain_Name, Logical_Type_Name, Structured_Type_Name, Distinct_Type_Name, Collection_Type_Name, Uses_Default, Engineer, Table_Name, PK_Flag, FK_Flag, Native_Type, Sequence, Model_ID, Model_OVID, Model_Name, T_Size, T_Precision, T_Scale, Char_Units, Personally_ID_Information, Sensitive_Information, Mask_For_None_Production, Computed, ScopeEntity_Name, Auto_Increment_Column, Identity_Column, Auto_Increment_Generate_Always, Auto_Increment_Start_With, Auto_Increment_Increment_By, Auto_Increment_Min_Value, Auto_Increment_Max_Value, Auto_Increment_Cycle, Auto_Increment_Disable_Cache, Auto_Increment_Cache, Auto_Increment_Order, Auto_Increment_Sequence_Name, Auto_Increment_Trigger_Name, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement preparedStatement = connection.prepareStatement(string);
        Iterator iterator = design.getRelationalDesigns().iterator();
        while (iterator.hasNext()) {
            RelationalDesign relationalDesign = (RelationalDesign)iterator.next();
            String object = (String)map.get(relationalDesign.getObjectID());
            arrayList2.clear();
            Iterator iterator2 = relationalDesign.getColumnSet().iterator();
            while (iterator2.hasNext()) {
                Column column2 = (Column)iterator2.next();
                String string2 = RSColumns.getOrCreateOVID(map, column2.getObjectID());
                arrayList2.add(column2);
                preparedStatement.setString(1, column2.getName());
                preparedStatement.setString(2, column2.getAbbreviation());
                preparedStatement.setString(3, column2.getObjectID());
                preparedStatement.setString(4, string2);
                preparedStatement.setString(5, column2.getImportedId());
                preparedStatement.setString(6, column2.getContainer().getObjectID());
                preparedStatement.setString(7, (String)map.get(column2.getContainer().getObjectID()));
                preparedStatement.setString(8, column2.getNullsAllowed() ? "N" : "Y");
                switch (column2.getUse()) {
                    case 0: {
                        preparedStatement.setString(9, "Domain");
                        break;
                    }
                    case 1: {
                        preparedStatement.setString(9, "Logical Type");
                        break;
                    }
                    case 2: {
                        preparedStatement.setString(9, "Distinct Type");
                        break;
                    }
                    case 3: {
                        if (column2.isReference()) {
                            preparedStatement.setString(9, "Ref Struct Type");
                            break;
                        }
                        preparedStatement.setString(9, "Structured Type");
                        break;
                    }
                    case 4: {
                        preparedStatement.setString(9, "Collection Type");
                    }
                }
                preparedStatement.setString(10, column2.getSourceType());
                preparedStatement.setString(11, column2.getFormulaDesc());
                preparedStatement.setString(12, column2.getScope() != null ? column2.getScope().getObjectID() : null);
                preparedStatement.setString(13, column2.getScope() != null ? (String)map.get(column2.getScope().getObjectID()) : null);
                preparedStatement.setString(14, column2.getDomain().getObjectID());
                preparedStatement.setString(15, (String)map.get(column2.getDomain().getObjectID()));
                preparedStatement.setString(18, column2.getDistinctType() != null ? column2.getDistinctType().getObjectID() : null);
                preparedStatement.setString(19, column2.getDistinctType() != null ? (String)map.get(column2.getDistinctType().getObjectID()) : null);
                preparedStatement.setString(20, column2.getStructuredType() != null ? column2.getStructuredType().getObjectID() : null);
                preparedStatement.setString(21, column2.getStructuredType() != null ? (String)map.get(column2.getStructuredType().getObjectID()) : null);
                preparedStatement.setString(22, column2.getCollectionType() != null ? column2.getCollectionType().getObjectID() : null);
                preparedStatement.setString(23, column2.getCollectionType() != null ? (String)map.get(column2.getCollectionType().getObjectID()) : null);
                preparedStatement.setString(24, column2.getConstraintName());
                preparedStatement.setString(25, column2.getDefaultValue());
                preparedStatement.setString(26, column2.getUseDomainConstraints() ? "Y" : "N");
                if (column2.getUse() == 0) {
                    preparedStatement.setString(27, column2.getDomain().getName());
                    preparedStatement.setString(28, column2.getDomain().getLogicalDatatype().getName());
                    preparedStatement.setString(16, column2.getDomain().getLogicalDatatype().getObjectID());
                    preparedStatement.setString(17, (String)map.get(column2.getDomain().getLogicalDatatype().getObjectID()));
                } else if (column2.getUse() == 1) {
                    preparedStatement.setString(27, null);
                    preparedStatement.setString(28, column2.getLogicalDatatype().getName());
                    preparedStatement.setString(16, column2.getLogicalDatatype().getObjectID());
                    preparedStatement.setString(17, (String)map.get(column2.getLogicalDatatype().getObjectID()));
                } else if (column2.getUse() == 2) {
                    preparedStatement.setString(27, null);
                    preparedStatement.setString(28, column2.getDistinctType().getLogicalDataType().getName());
                    preparedStatement.setString(16, column2.getDistinctType().getLogicalDataType().getObjectID());
                    preparedStatement.setString(17, (String)map.get(column2.getDistinctType().getLogicalDataType().getObjectID()));
                } else {
                    preparedStatement.setString(27, null);
                    preparedStatement.setString(28, null);
                    preparedStatement.setString(16, null);
                    preparedStatement.setString(17, null);
                }
                preparedStatement.setString(29, column2.getStructuredType() != null ? column2.getStructuredType().getName() : null);
                preparedStatement.setString(30, column2.getDistinctType() != null ? column2.getDistinctType().getName() : null);
                preparedStatement.setString(31, column2.getCollectionType() != null ? column2.getCollectionType().getName() : null);
                preparedStatement.setString(32, column2.getUsesDefaultValue() ? "Y" : "N");
                preparedStatement.setString(33, column2.getShouldEngineer() ? "Y" : "N");
                preparedStatement.setString(34, column2.getContainer().getName());
                preparedStatement.setString(35, column2.isPKElement() ? "P" : null);
                preparedStatement.setString(36, column2.isFKElement() ? "F" : null);
                preparedStatement.setString(37, column2.getDataType().getName());
                preparedStatement.setInt(38, column2.getContainer().getIndexOf(column2) + 1);
                preparedStatement.setString(39, relationalDesign.getObjectID());
                preparedStatement.setString(40, object);
                preparedStatement.setString(41, relationalDesign.getName());
                if (column2.getUse() == 0) {
                    preparedStatement.setString(42, column2.getDomain().getSize());
                    preparedStatement.setInt(43, RSColumns.getIntValue(column2.getDomain().getPrecision()));
                    preparedStatement.setInt(44, RSColumns.getIntValue(column2.getDomain().getScale()));
                } else if (column2.getUse() == 1) {
                    String string3 = column2.getSize();
                    String[] stringArray = string3.split(" ");
                    preparedStatement.setString(42, stringArray[0]);
                    preparedStatement.setInt(43, RSColumns.getIntValue(column2.getPrecision()));
                    preparedStatement.setInt(44, RSColumns.getIntValue(column2.getScale()));
                } else {
                    preparedStatement.setInt(42, 0);
                    preparedStatement.setInt(43, 0);
                    preparedStatement.setInt(44, 0);
                }
                preparedStatement.setString(45, column2.getUnits());
                preparedStatement.setString(46, column2.isContainsPII() == null ? null : (column2.isContainsPII() != false ? "Y" : "N"));
                preparedStatement.setString(47, column2.isContainsSensitiveInformation() == null ? null : (column2.isContainsSensitiveInformation() != false ? "Y" : "N"));
                preparedStatement.setString(48, column2.isMaskData() == null ? null : (column2.isMaskData() != false ? "Y" : "N"));
                preparedStatement.setString(49, column2.isComputed() != false ? "Y" : "N");
                preparedStatement.setString(50, column2.getScope() != null ? column2.getScope().getName() : null);
                preparedStatement.setString(51, column2.isAutoIncrementColumn() ? "Y" : "N");
                preparedStatement.setString(52, column2.isIdentityColumn() ? "Y" : "N");
                preparedStatement.setString(53, column2.isAutoIncrementGenerateAlways() ? "Y" : "N");
                preparedStatement.setString(54, column2.getAutoIncrementStartWith());
                preparedStatement.setInt(55, column2.getAutoIncrementIncrementBy() != null ? column2.getAutoIncrementIncrementBy() : 0);
                preparedStatement.setString(56, column2.getAutoIncrementMinValue());
                preparedStatement.setString(57, column2.getAutoIncrementMaxValue());
                preparedStatement.setString(58, column2.isAutoIncrementCycle() ? "Y" : "N");
                preparedStatement.setString(59, column2.isAutoIncrementDisableCache() ? "Y" : "N");
                preparedStatement.setInt(60, column2.getAutoIncrementCache() != null ? column2.getAutoIncrementCache() : 0);
                preparedStatement.setString(61, column2.isAutoIncrementOrder() ? "Y" : "N");
                preparedStatement.setString(62, column2.getAutoIncrementSequenceName());
                preparedStatement.setString(63, column2.getAutoIncrementTriggerName());
                preparedStatement.setString(64, (String)map.get(design.getObjectID()));
                preparedStatement.addBatch();
                arrayList.add(column2);
                if (++n != 1000) continue;
                n = 0;
                preparedStatement.executeBatch();
                for (Column column2 : arrayList) {
                    RSObjectNotes.export(map, connection, column2);
                    RSComments.export(map, connection, column2);
                    RSCommentsInRDBMS.export(map, connection, column2);
                    RSColumnUI.export(map, connection, column2);
                    RSDynamicProperties.export(design, map, connection, column2);
                }
                arrayList.clear();
            }
            RSAVT.export(connection, arrayList2, map, "Column");
            RSCheckConstraint.export(connection, arrayList2, map, "Column");
            RSValueRanges.export(connection, arrayList2, map, "Column");
        }
        if (n > 0) {
            n = 0;
            preparedStatement.executeBatch();
            for (Column column : arrayList) {
                RSObjectNotes.export(map, connection, column);
                RSComments.export(map, connection, column);
                RSCommentsInRDBMS.export(map, connection, column);
                RSColumnUI.export(map, connection, column);
                RSDynamicProperties.export(design, map, connection, column);
            }
            arrayList.clear();
        }
        preparedStatement.close();
        preparedStatement = null;
    }
}

