/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.Iterator;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.relational.Table;

public class RSColumnGroups
extends RSGeneral {
    public static void export(Map map, Connection connection, Table table) throws Exception {
        int n = 0;
        String string = "INSERT INTO DMRS_COLUMN_GROUPS (Table_ID, Table_OVID, Sequence, ColumnGroup_ID, ColumnGroup_OVID, ColumnGroup_Name, Columns, Notes, Table_Name, Design_OVID) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement preparedStatement = connection.prepareStatement(string);
        Iterator iterator = table.getColumnGroupsSet().iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            Table.ColumnGroup columnGroup = (Table.ColumnGroup)iterator.next();
            preparedStatement.setString(1, table.getObjectID());
            preparedStatement.setString(2, (String)map.get(table.getObjectID()));
            preparedStatement.setInt(3, ++n2);
            preparedStatement.setString(4, columnGroup.getObjectID());
            preparedStatement.setString(5, RSColumnGroups.getOrCreateOVID(map, columnGroup.getObjectID()));
            preparedStatement.setString(6, columnGroup.getName());
            preparedStatement.setString(7, RSColumnGroups.getColumns(columnGroup, table));
            preparedStatement.setString(8, columnGroup.getNote());
            preparedStatement.setString(9, table.getName());
            preparedStatement.setString(10, (String)map.get(table.getDesign().getObjectID()));
            preparedStatement.addBatch();
            if (++n != 1000) continue;
            n = 0;
            preparedStatement.executeBatch();
        }
        if (n > 0) {
            n = 0;
            preparedStatement.executeBatch();
        }
        preparedStatement.close();
        preparedStatement = null;
    }

    private static String getColumns(Table.ColumnGroup columnGroup, Table table) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator<String> iterator = columnGroup.getColumns().iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            String string = iterator.next();
            ContainedObject containedObject = table.getElementByID(string);
            if (containedObject == null) continue;
            if (!bl) {
                stringBuffer.append(", ");
            } else {
                bl = false;
            }
            stringBuffer.append(containedObject.getName());
        }
        return stringBuffer.toString();
    }
}

