/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.awt.Component;
import java.awt.Cursor;
import java.sql.Connection;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JOptionPane;
import oracle.dbtools.crest.exports.Messages;
import oracle.dbtools.crest.exports.reports.DifferentVersionException;
import oracle.dbtools.crest.exports.reports.RSGlossary;
import oracle.dbtools.crest.exports.reports.RSGlossaryTerms;
import oracle.dbtools.crest.exports.reports.SchemaFactory;
import oracle.dbtools.crest.model.design.glossary.Glossary;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ProgressDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.ide.Ide;

public class GlossaryHandler {
    private ApplicationView appView;
    private ProgressDialog monitor;
    private Connection connection = null;
    private String comments;
    private Glossary glossary;
    private Map map;
    private static final Logger LOGGER = new Logger(GlossaryHandler.class);

    public GlossaryHandler(ApplicationView applicationView, Connection connection, String string, Glossary glossary) {
        this.appView = applicationView;
        this.connection = connection;
        this.comments = string;
        this.glossary = glossary;
        this.map = new TreeMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void export() {
        Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(3));
        try {
            this.monitor = new ProgressDialog(this.appView, "", 0, 100);
            try {
                this.monitor.setNote(Messages.getString("GlossaryHandler.ConnectingDatabase"));
                this.monitor.setProgress(1);
                if (this.checkDB()) {
                    this.monitor.setNote(Messages.getString("GlossaryHandler.ExportingGlossary"));
                    this.monitor.setProgress(5);
                    RSGlossary.export(this.glossary, this.map, this.connection, this.comments);
                    this.monitor.setNote(Messages.getString("GlossaryHandler.ExportingGlossaryTerms"));
                    this.monitor.setProgress(10);
                    RSGlossaryTerms.export(this.glossary, this.map, this.connection);
                    this.monitor.setNote(Messages.getString("GlossaryHandler.ExportComplete"));
                    this.monitor.setProgress(100);
                    MessageDialogs.showMessage(Messages.getString("GlossaryHandler.GlossaryExportedSuccessfully"));
                }
                if (this.connection != null) {
                    this.connection.close();
                }
            }
            finally {
                this.monitor.close();
            }
        }
        catch (Exception exception) {
            if (this.connection != null) {
                try {
                    this.connection.rollback();
                    this.connection.close();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
            if (exception.toString().indexOf("ORA-01017") > -1) {
                LOGGER.error("Error Exporting Glossary to Reporting Schema: Error=" + exception.getMessage());
                MessageDialogs.showErrorMessage(Messages.getString("GlossaryHandler.ErrorUserPassword"));
            } else {
                LOGGER.error("Error Exporting Glossary to Reporting Schema: ", exception);
                MessageDialogs.showErrorMessage(Messages.getString("GlossaryHandler.ErrorSeeLogFile"));
            }
        }
        finally {
            Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkDB() throws Exception {
        if (this.connection != null) {
            boolean bl = this.connection.getAutoCommit();
            this.connection.setAutoCommit(false);
            try {
                float f = SchemaFactory.schemaVersion(this.connection);
                if (f == 0.0f) {
                    boolean bl2 = SchemaFactory.createSchema(this.connection);
                    return bl2;
                }
                if (f != 1.6f) {
                    throw new DifferentVersionException();
                }
            }
            catch (DifferentVersionException differentVersionException) {
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), Messages.getString("GlossaryHandler.SchemaVersionOutOfDate"), Messages.getString("GlossaryHandler.Warning"), 2);
                boolean bl3 = false;
                return bl3;
            }
            finally {
                this.connection.setAutoCommit(bl);
            }
            return true;
        }
        return false;
    }
}

