/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.udb.v81;

import oracle.dbtools.crest.exports.ddl.udb.AbstractSSBUDB;
import oracle.dbtools.crest.model.design.storage.Trigger;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.model.design.storage.udb.v81.TriggerUDBv81;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBTriggerUDBv81
extends AbstractSSBUDB {
    private StorageDesignUDB storageDesign;

    @Override
    protected void doAppend(StringBuffer stringBuffer, Object object, boolean bl) {
        TriggerUDBv81 triggerUDBv81 = (TriggerUDBv81)object;
        this.storageDesign = (StorageDesignUDB)this.getStorageDesign(object);
        this.appendComment(stringBuffer, triggerUDBv81);
        this.appendCreate(stringBuffer, triggerUDBv81);
        this.appendTriggeringTime(stringBuffer, triggerUDBv81, bl);
        this.appendAction(stringBuffer, triggerUDBv81);
        this.appendOn(stringBuffer, triggerUDBv81);
        this.appendReferencing(stringBuffer, triggerUDBv81, bl);
        this.appendScope(stringBuffer, triggerUDBv81, bl);
        this.appendCondition(stringBuffer, triggerUDBv81, bl);
        this.appendTriggeredAction(stringBuffer, triggerUDBv81, bl);
        SSBTriggerUDBv81.appendNewLine(stringBuffer, bl, 0);
        this.appendLineFinisher(stringBuffer, bl);
        DDLFileMaker.incrementCreateTrigger();
        if (triggerUDBv81.getDesign().getAppView().getSettings().isGenerateCommentsInRDBMS()) {
            this.appendCommentOn(stringBuffer, triggerUDBv81, bl);
        }
    }

    private void appendCommentOn(StringBuffer stringBuffer, TriggerUDBv81 triggerUDBv81, boolean bl) {
        String string = triggerUDBv81.getCommentInRDBMS().trim();
        if (!"".equals(string)) {
            SSBTriggerUDBv81.appendNewLine(stringBuffer, bl, 0);
            SSBTriggerUDBv81.appendStringWithSpace(stringBuffer, "COMMENT ON");
            SSBTriggerUDBv81.appendStringWithSpace(stringBuffer, "TRIGGER");
            SSBTriggerUDBv81.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(triggerUDBv81.getLongName()));
            SSBTriggerUDBv81.appendStringWithSpace(stringBuffer, "IS");
            SSBTriggerUDBv81.appendString(stringBuffer, '\'');
            SSBTriggerUDBv81.appendString(stringBuffer, string);
            SSBTriggerUDBv81.appendStringWithSpace(stringBuffer, '\'');
            SSBTriggerUDBv81.appendNewLine(stringBuffer, bl, 0);
            this.appendLineFinisher(stringBuffer, bl);
        }
    }

    private void appendCreate(StringBuffer stringBuffer, TriggerUDBv81 triggerUDBv81) {
        this.appendCreate(stringBuffer);
        SSBTriggerUDBv81.appendStringWithSpace(stringBuffer, "TRIGGER");
        if (triggerUDBv81.getSchema() != null) {
            SSBTriggerUDBv81.appendString(stringBuffer, this.storageDesign.getFormatedName(triggerUDBv81.getSchema().getName()));
            SSBTriggerUDBv81.appendString(stringBuffer, ".");
        }
        SSBTriggerUDBv81.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(triggerUDBv81.getName()));
    }

    private void appendTriggeringTime(StringBuffer stringBuffer, TriggerUDBv81 triggerUDBv81, boolean bl) {
        SSBTriggerUDBv81.appendNewLine(stringBuffer, bl, 1);
        SSBTriggerUDBv81.appendStringWithSpace(stringBuffer, triggerUDBv81.getTriggerTime());
    }

    private void appendAction(StringBuffer stringBuffer, TriggerUDBv81 triggerUDBv81) {
        SSBTriggerUDBv81.appendStringWithSpace(stringBuffer, triggerUDBv81.getActions());
        if (triggerUDBv81.getActions().equalsIgnoreCase(Trigger.ACTION_TYPES[1]) && !triggerUDBv81.getColumns().equalsIgnoreCase("")) {
            SSBTriggerUDBv81.appendStringWithSpace(stringBuffer, "OF");
            SSBTriggerUDBv81.appendStringWithSpace(stringBuffer, triggerUDBv81.getColumns());
        }
    }

    private void appendOn(StringBuffer stringBuffer, TriggerUDBv81 triggerUDBv81) {
        SSBTriggerUDBv81.appendStringWithSpace(stringBuffer, "ON");
        if (triggerUDBv81.getTable() != null) {
            SSBTriggerUDBv81.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(triggerUDBv81.getTable().getName()));
        } else {
            SSBTriggerUDBv81.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(triggerUDBv81.getView().getName()));
        }
    }

    private void appendReferencing(StringBuffer stringBuffer, TriggerUDBv81 triggerUDBv81, boolean bl) {
        if (!(triggerUDBv81.getRef_NEW_AS().equalsIgnoreCase("") && triggerUDBv81.getRef_OLD_AS().equalsIgnoreCase("") && triggerUDBv81.getNEW_TABLE_AS().equalsIgnoreCase("") && triggerUDBv81.getOLD_TABLE_AS().equalsIgnoreCase(""))) {
            SSBTriggerUDBv81.appendStringWithSpace(stringBuffer, "REFERENCING");
            if (!triggerUDBv81.getRef_NEW_AS().equalsIgnoreCase("")) {
                SSBTriggerUDBv81.appendNewLine(stringBuffer, bl, 1);
                SSBTriggerUDBv81.appendStringWithSpace(stringBuffer, "NEW");
                SSBTriggerUDBv81.appendStringWithSpace(stringBuffer, "AS");
                SSBTriggerUDBv81.appendStringWithSpace(stringBuffer, triggerUDBv81.getRef_NEW_AS());
            }
            if (!triggerUDBv81.getRef_OLD_AS().equalsIgnoreCase("")) {
                SSBTriggerUDBv81.appendNewLine(stringBuffer, bl, 1);
                SSBTriggerUDBv81.appendStringWithSpace(stringBuffer, "OLD");
                SSBTriggerUDBv81.appendStringWithSpace(stringBuffer, "AS");
                SSBTriggerUDBv81.appendStringWithSpace(stringBuffer, triggerUDBv81.getRef_OLD_AS());
            }
            if (!triggerUDBv81.getOLD_TABLE_AS().equalsIgnoreCase("")) {
                SSBTriggerUDBv81.appendNewLine(stringBuffer, bl, 1);
                SSBTriggerUDBv81.appendStringWithSpace(stringBuffer, "OLD TABLE");
                SSBTriggerUDBv81.appendStringWithSpace(stringBuffer, "AS");
                SSBTriggerUDBv81.appendStringWithSpace(stringBuffer, triggerUDBv81.getOLD_TABLE_AS());
            }
            if (!triggerUDBv81.getNEW_TABLE_AS().equalsIgnoreCase("")) {
                SSBTriggerUDBv81.appendNewLine(stringBuffer, bl, 1);
                SSBTriggerUDBv81.appendStringWithSpace(stringBuffer, "NEW TABLE");
                SSBTriggerUDBv81.appendStringWithSpace(stringBuffer, "AS");
                SSBTriggerUDBv81.appendStringWithSpace(stringBuffer, triggerUDBv81.getNEW_TABLE_AS());
            }
        }
    }

    private void appendScope(StringBuffer stringBuffer, TriggerUDBv81 triggerUDBv81, boolean bl) {
        SSBTriggerUDBv81.appendNewLine(stringBuffer, bl, 1);
        SSBTriggerUDBv81.appendStringWithSpace(stringBuffer, triggerUDBv81.getScope());
        if (triggerUDBv81.isScopeForEachRow()) {
            this.appendMode(stringBuffer);
        }
    }

    private void appendMode(StringBuffer stringBuffer) {
        SSBTriggerUDBv81.appendStringWithSpace(stringBuffer, "MODE DB2SQL");
    }

    private void appendCondition(StringBuffer stringBuffer, TriggerUDBv81 triggerUDBv81, boolean bl) {
        if (!triggerUDBv81.getCondition().equalsIgnoreCase("")) {
            SSBTriggerUDBv81.appendNewLine(stringBuffer, bl, 1);
            SSBTriggerUDBv81.appendStringWithSpace(stringBuffer, "WHEN");
            SSBTriggerUDBv81.appendStringWithSpace(stringBuffer, '(');
            SSBTriggerUDBv81.appendStringWithSpace(stringBuffer, triggerUDBv81.getCondition());
            SSBTriggerUDBv81.appendStringWithSpace(stringBuffer, ')');
        }
    }

    private void appendTriggeredAction(StringBuffer stringBuffer, TriggerUDBv81 triggerUDBv81, boolean bl) {
        SSBTriggerUDBv81.appendNewLine(stringBuffer, bl, 1);
        if (triggerUDBv81.getBody().equalsIgnoreCase("")) {
            SSBTriggerUDBv81.appendStringWithSpace(stringBuffer, "-- Empty body");
        } else {
            SSBTriggerUDBv81.appendStringWithSpace(stringBuffer, triggerUDBv81.getBody());
        }
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof TriggerUDBv81 && ((TriggerUDBv81)object).isMarkedGenerate() && (((TriggerUDBv81)object).getTable() != null || ((TriggerUDBv81)object).getView() != null);
    }
}

