/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.udb.v81;

import java.util.ArrayList;
import oracle.dbtools.crest.exports.ddl.udb.AbstractSSBUDB;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.IndexProxy;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.udb.IndexProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.model.design.storage.udb.v81.IndexProxyUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.StorageDesignUDBv81;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBIndexProxyUDBv81
extends AbstractSSBUDB {
    private static final String PCTFREE = "PCTFREE";
    private static final String MINPCTUSED = "MINPCTUSED";
    private static final String REVERSE_SCAN = "REVERSE SCANS";
    private static final String CLUSTER = "CLUSTER";
    private static final String UNIQUE = "UNIQUE";
    private static final String INCLUDE = "INCLUDE";
    private static final String COLLECT = "COLLECT";
    private static final String BASIC = "BASIC";
    private static final String STATISTICS = "STATISTICS";
    private StorageDesignUDBv81 storageDesign;

    @Override
    public boolean canHandle(Object object) {
        if (object instanceof Index && ((Index)object).isMarkedGenerate()) {
            return true;
        }
        return object instanceof IndexProxyUDBv81 && ((IndexProxyUDBv81)object).isMarkedGenerate();
    }

    @Override
    protected void doAppend(StringBuffer stringBuffer, Object object, boolean bl) {
        Index index = null;
        IndexProxyUDBv81 indexProxyUDBv81 = null;
        if (object instanceof Index) {
            index = (Index)object;
            this.storageDesign = (StorageDesignUDBv81)this.getStorageDesign(object);
            indexProxyUDBv81 = (IndexProxyUDBv81)this.storageDesign.getIndexProxySet().getProxy(index.getObjectID());
        } else if (object instanceof IndexProxyUDBv81) {
            indexProxyUDBv81 = (IndexProxyUDBv81)object;
            index = (Index)indexProxyUDBv81.getObject();
            this.storageDesign = (StorageDesignUDBv81)this.getStorageDesign(object);
        }
        if (indexProxyUDBv81 != null) {
            if (indexProxyUDBv81.isCommentChanged()) {
                this.appendComment(stringBuffer, indexProxyUDBv81);
            } else {
                this.appendComment(stringBuffer, indexProxyUDBv81.getObject());
            }
            this.appendCreate(stringBuffer, indexProxyUDBv81);
            this.appendOnTable(stringBuffer, indexProxyUDBv81, bl);
            this.appendInclude(stringBuffer, indexProxyUDBv81, bl);
            this.appendCluster(stringBuffer, indexProxyUDBv81, bl);
            this.appendPctfree(stringBuffer, indexProxyUDBv81, bl);
            this.appendMinPctfree(stringBuffer, indexProxyUDBv81, bl);
            this.appendReverseScan(stringBuffer, indexProxyUDBv81, bl);
            this.appendCollectStatistics(stringBuffer, indexProxyUDBv81, bl);
            SSBIndexProxyUDBv81.appendNewLine(stringBuffer, bl, 0);
            this.appendLineFinisher(stringBuffer, bl);
            DDLFileMaker.incrementCreateIndex();
            if (index.getDesign().getAppView().getSettings().isGenerateCommentsInRDBMS()) {
                this.appendIndexComment(stringBuffer, index, indexProxyUDBv81, bl);
            }
            this.appendPrivileges(stringBuffer, indexProxyUDBv81, bl);
        } else if (index != null && index.getDesign().getAppView().getSettings().isGenerateCommentsInRDBMS()) {
            this.appendIndexComment(stringBuffer, index, indexProxyUDBv81, bl);
        }
    }

    private void appendIndexComment(StringBuffer stringBuffer, Index index, IndexProxyUDBv81 indexProxyUDBv81, boolean bl) {
        if (indexProxyUDBv81 != null && indexProxyUDBv81.isCommentInRDBMSChanged()) {
            SSBIndexProxyUDBv81.appendNewLine(stringBuffer, bl, 0);
            SSBIndexProxyUDBv81.appendStringWithSpace(stringBuffer, "COMMENT ON");
            SSBIndexProxyUDBv81.appendStringWithSpace(stringBuffer, "INDEX");
            SSBIndexProxyUDBv81.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(indexProxyUDBv81.getLongName()));
            SSBIndexProxyUDBv81.appendStringWithSpace(stringBuffer, "IS");
            SSBIndexProxyUDBv81.appendString(stringBuffer, '\'');
            SSBIndexProxyUDBv81.appendString(stringBuffer, indexProxyUDBv81.getCommentInRDBMS());
            SSBIndexProxyUDBv81.appendStringWithSpace(stringBuffer, '\'');
            SSBIndexProxyUDBv81.appendNewLine(stringBuffer, bl, 0);
            this.appendLineFinisher(stringBuffer, bl);
        } else if (index != null && !"".equalsIgnoreCase(index.getCommentInRDBMS().trim())) {
            SSBIndexProxyUDBv81.appendNewLine(stringBuffer, bl, 0);
            SSBIndexProxyUDBv81.appendStringWithSpace(stringBuffer, "COMMENT ON");
            SSBIndexProxyUDBv81.appendStringWithSpace(stringBuffer, "INDEX");
            SSBIndexProxyUDBv81.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(index.getLongName()));
            SSBIndexProxyUDBv81.appendStringWithSpace(stringBuffer, "IS");
            SSBIndexProxyUDBv81.appendString(stringBuffer, '\'');
            SSBIndexProxyUDBv81.appendString(stringBuffer, index.getCommentInRDBMS());
            SSBIndexProxyUDBv81.appendStringWithSpace(stringBuffer, '\'');
            SSBIndexProxyUDBv81.appendNewLine(stringBuffer, bl, 0);
            this.appendLineFinisher(stringBuffer, bl);
        }
    }

    protected void appendCreate(StringBuffer stringBuffer, IndexProxyUDBv81 indexProxyUDBv81) {
        this.appendCreate(stringBuffer);
        if (indexProxyUDBv81.isUnique()) {
            SSBIndexProxyUDBv81.appendStringWithSpace(stringBuffer, UNIQUE);
        }
        SSBIndexProxyUDBv81.appendStringWithSpace(stringBuffer, "INDEX");
        SSBIndexProxyUDBv81.appendString(stringBuffer, this.storageDesign.getFormatedName(indexProxyUDBv81.getLongName()));
    }

    protected void appendOnTable(StringBuffer stringBuffer, IndexProxyUDBv81 indexProxyUDBv81, boolean bl) {
        ColumnProxy[] columnProxyArray;
        SSBIndexProxyUDBv81.appendNewLine(stringBuffer, bl, 1);
        SSBIndexProxyUDBv81.appendStringWithSpace(stringBuffer, "ON");
        SSBIndexProxyUDBv81.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(indexProxyUDBv81.getTableProxy().getLongName()));
        SSBIndexProxyUDBv81.appendNewLine(stringBuffer, bl, 1);
        SSBIndexProxyUDBv81.appendStringWithSpace(stringBuffer, '(');
        SSBIndexProxyUDBv81.appendNewLine(stringBuffer, bl, 0);
        if (indexProxyUDBv81.getIndex().hasIndexExpression()) {
            SSBIndexProxyUDBv81.appendString(stringBuffer, "     ");
            SSBIndexProxyUDBv81.appendString(stringBuffer, indexProxyUDBv81.getIndex().getIndexExpression());
        }
        if ((columnProxyArray = indexProxyUDBv81.getColumnProxies()) != null) {
            for (int i = 0; i < columnProxyArray.length; ++i) {
                SSBIndexProxyUDBv81.appendString(stringBuffer, "     ");
                SSBIndexProxyUDBv81.appendString(stringBuffer, this.storageDesign.getFormatedName(columnProxyArray[i].getName()));
                SSBIndexProxyUDBv81.appendString(stringBuffer, " ");
                SSBIndexProxyUDBv81.appendString(stringBuffer, indexProxyUDBv81.getIndex().getColumnSortOrder(columnProxyArray[i].getColumn()));
                SSBIndexProxyUDBv81.appendString(stringBuffer, " ");
                if (i >= columnProxyArray.length - 1) continue;
                SSBIndexProxyUDBv81.appendString(stringBuffer, ",\n");
            }
        }
        SSBIndexProxyUDBv81.appendNewLine(stringBuffer, bl, 1);
        SSBIndexProxyUDBv81.appendStringWithSpace(stringBuffer, ')');
    }

    protected void appendInclude(StringBuffer stringBuffer, IndexProxyUDBv81 indexProxyUDBv81, boolean bl) {
        if (indexProxyUDBv81.isUnique() && !indexProxyUDBv81.getColumnList().equalsIgnoreCase("")) {
            SSBIndexProxyUDBv81.appendNewLine(stringBuffer, bl, 1);
            SSBIndexProxyUDBv81.appendStringWithSpace(stringBuffer, INCLUDE);
            SSBIndexProxyUDBv81.appendStringWithSpace(stringBuffer, '(');
            SSBIndexProxyUDBv81.appendStringWithSpace(stringBuffer, indexProxyUDBv81.getColumnList());
            SSBIndexProxyUDBv81.appendStringWithSpace(stringBuffer, ')');
        }
    }

    protected void appendCluster(StringBuffer stringBuffer, IndexProxyUDBv81 indexProxyUDBv81, boolean bl) {
        if (indexProxyUDBv81.getCluster()) {
            SSBIndexProxyUDBv81.appendNewLine(stringBuffer, bl, 1);
            SSBIndexProxyUDBv81.appendStringWithSpace(stringBuffer, CLUSTER);
        }
    }

    protected void appendPctfree(StringBuffer stringBuffer, IndexProxyUDBv81 indexProxyUDBv81, boolean bl) {
        if (indexProxyUDBv81.getPercentageFree() > 0) {
            SSBIndexProxyUDBv81.appendNewLine(stringBuffer, bl, 1);
            SSBIndexProxyUDBv81.appendStringWithSpace(stringBuffer, PCTFREE);
            this.appendStringWithSpace(stringBuffer, indexProxyUDBv81.getPercentageFree());
        }
    }

    protected void appendMinPctfree(StringBuffer stringBuffer, IndexProxyUDBv81 indexProxyUDBv81, boolean bl) {
        if (indexProxyUDBv81.getMinimumPercentageUsed() > 0) {
            SSBIndexProxyUDBv81.appendNewLine(stringBuffer, bl, 1);
            SSBIndexProxyUDBv81.appendStringWithSpace(stringBuffer, MINPCTUSED);
            this.appendStringWithSpace(stringBuffer, indexProxyUDBv81.getMinimumPercentageUsed());
        }
    }

    protected void appendReverseScan(StringBuffer stringBuffer, IndexProxyUDBv81 indexProxyUDBv81, boolean bl) {
        SSBIndexProxyUDBv81.appendNewLine(stringBuffer, bl, 1);
        this.appendAllowDisallowWithSpace(stringBuffer, indexProxyUDBv81.getReverseScanSupport());
        SSBIndexProxyUDBv81.appendStringWithSpace(stringBuffer, REVERSE_SCAN);
    }

    protected void appendCollectStatistics(StringBuffer stringBuffer, IndexProxyUDBv81 indexProxyUDBv81, boolean bl) {
        if (!"NONE".equalsIgnoreCase(indexProxyUDBv81.getCollectStatistics())) {
            SSBIndexProxyUDBv81.appendNewLine(stringBuffer, bl, 1);
            SSBIndexProxyUDBv81.appendStringWithSpace(stringBuffer, COLLECT);
            if (!BASIC.equalsIgnoreCase(indexProxyUDBv81.getCollectStatistics())) {
                SSBIndexProxyUDBv81.appendStringWithSpace(stringBuffer, indexProxyUDBv81.getCollectStatistics());
            }
            SSBIndexProxyUDBv81.appendStringWithSpace(stringBuffer, STATISTICS);
        }
    }

    private void appendPrivileges(StringBuffer stringBuffer, IndexProxyUDB indexProxyUDB, boolean bl) {
        if (!indexProxyUDB.getUsers().equalsIgnoreCase("") || !indexProxyUDB.getGroups().equalsIgnoreCase("")) {
            SSBIndexProxyUDBv81.appendNewLine(stringBuffer, bl, 0);
            SSBIndexProxyUDBv81.appendStringWithSpace(stringBuffer, "GRANT");
            SSBIndexProxyUDBv81.appendStringWithSpace(stringBuffer, "CONTROL");
            SSBIndexProxyUDBv81.appendStringWithSpace(stringBuffer, "ON");
            SSBIndexProxyUDBv81.appendStringWithSpace(stringBuffer, "INDEX");
            SSBIndexProxyUDBv81.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(indexProxyUDB.getLongName()));
            SSBIndexProxyUDBv81.appendNewLine(stringBuffer, bl, 1);
            SSBIndexProxyUDBv81.appendStringWithSpace(stringBuffer, "TO");
            if (!indexProxyUDB.getUsers().equalsIgnoreCase("")) {
                int n;
                for (n = 0; n < indexProxyUDB.getUserSet().size(); ++n) {
                    if (n > 0) {
                        this.appendComma(stringBuffer);
                    }
                    if (!((String)indexProxyUDB.getUserSet().elementAt(n)).trim().equalsIgnoreCase("PUBLIC")) {
                        SSBIndexProxyUDBv81.appendStringWithSpace(stringBuffer, "USER");
                    }
                    this.appendStringWithSpace(stringBuffer, indexProxyUDB.getUserSet().elementAt(n));
                }
                if (!indexProxyUDB.getGroups().equalsIgnoreCase("")) {
                    for (n = 0; n < indexProxyUDB.getUserGroupSet().size(); ++n) {
                        this.appendComma(stringBuffer);
                        SSBIndexProxyUDBv81.appendStringWithSpace(stringBuffer, "GROUP");
                        this.appendStringWithSpace(stringBuffer, indexProxyUDB.getUserGroupSet().elementAt(n));
                    }
                }
            } else {
                for (int i = 0; i < indexProxyUDB.getUserGroupSet().size(); ++i) {
                    if (i > 0) {
                        this.appendComma(stringBuffer);
                    }
                    SSBIndexProxyUDBv81.appendStringWithSpace(stringBuffer, "GROUP");
                    this.appendStringWithSpace(stringBuffer, indexProxyUDB.getUserGroupSet().elementAt(i));
                }
            }
            SSBIndexProxyUDBv81.appendNewLine(stringBuffer, bl, 0);
            this.appendLineFinisher(stringBuffer, bl);
            SSBIndexProxyUDBv81.appendNewLine(stringBuffer, bl, 0);
        }
    }

    public void appendIndexForConstraint(StringBuffer stringBuffer, Index index, TableProxy tableProxy, boolean bl) {
        StringBuffer stringBuffer2 = new StringBuffer();
        String string = "";
        Index index2 = null;
        IndexProxy indexProxy = null;
        index2 = index;
        StorageDesignUDB storageDesignUDB = (StorageDesignUDB)this.getStorageDesign(index);
        if (index2.isFK()) {
            indexProxy = (IndexProxy)storageDesignUDB.getFKProxySet().getProxy(index2.getObjectID());
        }
        if (index2 != null && !index2.isOidKey()) {
            this.storageDesign = (StorageDesignUDBv81)tableProxy.getStorageDesign();
            if (indexProxy != null && indexProxy.isMarkedGenerate() || indexProxy == null && index2.isMarkedGenerate()) {
                if (index2.getElements().length > 0) {
                    String string2;
                    if (indexProxy != null && indexProxy.isCommentChanged()) {
                        this.appendComment(stringBuffer, indexProxy);
                    } else {
                        this.appendComment(stringBuffer, index2);
                    }
                    String string3 = string2 = index2.getName();
                    if (indexProxy != null) {
                        string3 = indexProxy.getLongName();
                    }
                    if (string2.length() < 18) {
                        string2 = string2 + "X";
                        string3 = string3 + "X";
                    }
                    if (string2.length() > 18) {
                        SSBIndexProxyUDBv81.appendNewLine(stringBuffer, bl, 0);
                        SSBIndexProxyUDBv81.appendStringWithSpace(stringBuffer, "--  ERROR: Index name length exceeds maximum allowed length(18)");
                        SSBIndexProxyUDBv81.appendNewLine(stringBuffer, bl, 0);
                        DDLFileMaker.incrementErrors();
                    }
                    SSBIndexProxyUDBv81.appendStringWithSpace(stringBuffer2, "CREATE");
                    if ("Primary Constraint".equals(index2.getIndexState()) || "Unique Constraint".equals(index2.getIndexState())) {
                        SSBIndexProxyUDBv81.appendStringWithSpace(stringBuffer2, UNIQUE);
                    }
                    SSBIndexProxyUDBv81.appendStringWithSpace(stringBuffer2, "INDEX");
                    SSBIndexProxyUDBv81.appendStringWithSpace(stringBuffer2, storageDesignUDB.getFormatedName(string3));
                    string = stringBuffer2.toString();
                    this.appendTable(stringBuffer2, index2, true);
                    this.appendConstraintElementList(stringBuffer2, index2, tableProxy, true);
                    SSBIndexProxyUDBv81.appendNewLine(stringBuffer2, bl, 0);
                    this.appendLineFinisher(stringBuffer2, bl);
                    this.appendToBuffer(stringBuffer, stringBuffer2, string);
                    DDLFileMaker.incrementCreateIndex();
                } else {
                    SSBIndexProxyUDBv81.appendNewLine(stringBuffer, bl, 0);
                    stringBuffer.append("-- Error - Index ");
                    stringBuffer.append(storageDesignUDB.getFormatedName(index2.getName()));
                    stringBuffer.append(" has no columns");
                    SSBIndexProxyUDBv81.appendNewLine(stringBuffer, bl, 0);
                    DDLFileMaker.incrementErrors();
                }
            }
        }
    }

    private void appendConstraintElementList(StringBuffer stringBuffer, Index index, TableProxy tableProxy, boolean bl) {
        Object object2;
        ColumnProxy columnProxy = null;
        ArrayList<ColumnProxy> arrayList = new ArrayList<ColumnProxy>();
        for (Object object2 : index.getElementsCollectionImmutable()) {
            ColumnProxy columnProxy2 = tableProxy.getColumnProxy(((ModelIDObject)object2).getObjectID());
            if (columnProxy2 == null) continue;
            arrayList.add(columnProxy2);
        }
        object2 = arrayList.toArray();
        SSBIndexProxyUDBv81.appendNewLine(stringBuffer, bl, 1);
        if (((Object)object2).length < 1) {
            SSBIndexProxyUDBv81.appendStringWithSpace(stringBuffer, "-- No Columns");
            SSBIndexProxyUDBv81.appendNewLine(stringBuffer, bl, 1);
        }
        SSBIndexProxyUDBv81.appendStringWithSpace(stringBuffer, '(');
        for (int i = 0; i < ((Object)object2).length; ++i) {
            if (i != 0) {
                SSBIndexProxyUDBv81.appendStringWithSpace(stringBuffer, ',');
            }
            columnProxy = (ColumnProxy)object2[i];
            SSBIndexProxyUDBv81.appendNewLine(stringBuffer, bl, 1);
            SSBIndexProxyUDBv81.appendString(stringBuffer, ' ');
            String string = this.storageDesign.getFormatedName(columnProxy.getName());
            SSBIndexProxyUDBv81.appendStringWithSpace(stringBuffer, string);
            SSBIndexProxyUDBv81.appendStringWithSpace(stringBuffer, index.getColumnSortOrder(columnProxy));
        }
        SSBIndexProxyUDBv81.appendNewLine(stringBuffer, bl, 1);
        SSBIndexProxyUDBv81.appendStringWithSpace(stringBuffer, ')');
    }

    protected void appendTable(StringBuffer stringBuffer, Index index, boolean bl) {
        Table table = (Table)index.getTopLevelContainer();
        TableProxy tableProxy = (TableProxy)this.storageDesign.getTableProxySet().getProxy(table.getObjectID());
        SSBIndexProxyUDBv81.appendNewLine(stringBuffer, bl, 1);
        if (tableProxy != null) {
            SSBIndexProxyUDBv81.appendStringWithSpace(stringBuffer, "ON");
            SSBIndexProxyUDBv81.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableProxy.getLongName()));
        }
    }
}

