/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.udb.v81;

import oracle.dbtools.crest.exports.ddl.udb.AbstractSSBUDB;
import oracle.dbtools.crest.exports.ddl.udb.v81.SSBTableSpaceUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.model.design.storage.udb.v81.DataBaseUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.TableSpaceUDBv81;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBDataBaseUDBv81
extends AbstractSSBUDB {
    public static final String USING_CODESET = "USING CODESET";
    public static final String TERRITORY = "TERRITORY";
    public static final String COLLATE_USING = "COLLATE USING";
    public static final String NUMSEGS = "NUMSEGS";
    public static final String DEFAULT_EXTENT_SIZE = "DFT_EXTENT_SZ";
    public static final String CATALOG_TABLESPACE = "CATALOG TABLESPACE";
    public static final String USER_TABLESPACE = "USER TABLESPACE";
    public static final String TEMP_TABLESPACE = "TEMPORARY TABLESPACE";
    public static final String AUTOCONFIGURE = "AUTOCONFIGURE";
    public static final String WITHSTR = "WITH";
    public static final String APPLY = "APPLY";
    private StorageDesignUDB storageDesign;

    @Override
    public boolean canHandle(Object object) {
        return object instanceof DataBaseUDBv81 && ((DataBaseUDBv81)object).isMarkedGenerate();
    }

    @Override
    protected void doAppend(StringBuffer stringBuffer, Object object, boolean bl) {
        DataBaseUDBv81 dataBaseUDBv81 = (DataBaseUDBv81)object;
        this.storageDesign = (StorageDesignUDB)this.getStorageDesign(object);
        this.appendCreate(stringBuffer, dataBaseUDBv81);
        this.appendOnPath(stringBuffer, dataBaseUDBv81, bl);
        this.appendAlias(stringBuffer, dataBaseUDBv81, bl);
        this.appendUsingCodesetTerritory(stringBuffer, dataBaseUDBv81, bl);
        this.appendCollateUsing(stringBuffer, dataBaseUDBv81, bl);
        this.appendNumsegs(stringBuffer, dataBaseUDBv81, bl);
        this.appendDefaultExtentSize(stringBuffer, dataBaseUDBv81, bl);
        this.appendCatalogTableSpace(stringBuffer, dataBaseUDBv81, bl);
        this.appendUserTableSpace(stringBuffer, dataBaseUDBv81, bl);
        this.appendTemporaryTableSpace(stringBuffer, dataBaseUDBv81, bl);
        if (dataBaseUDBv81.getDesign().getAppView().getSettings().isGenerateCommentsInRDBMS()) {
            this.appendWith(stringBuffer, dataBaseUDBv81, bl);
        }
        this.appendAutoConfigure(stringBuffer, dataBaseUDBv81, bl);
        SSBDataBaseUDBv81.appendNewLine(stringBuffer, bl, 0);
        this.appendLineFinisher(stringBuffer, bl);
        DDLFileMaker.incrementCreateDatabase();
    }

    protected void appendCreate(StringBuffer stringBuffer, DataBaseUDBv81 dataBaseUDBv81) {
        this.appendCreate(stringBuffer);
        SSBDataBaseUDBv81.appendStringWithSpace(stringBuffer, "DATABASE");
        SSBDataBaseUDBv81.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(dataBaseUDBv81.getName()));
    }

    protected void appendOnPath(StringBuffer stringBuffer, DataBaseUDBv81 dataBaseUDBv81, boolean bl) {
        if (!dataBaseUDBv81.getOnPath().equalsIgnoreCase("")) {
            SSBDataBaseUDBv81.appendNewLine(stringBuffer, bl, 1);
            SSBDataBaseUDBv81.appendStringWithSpace(stringBuffer, "ON");
            SSBDataBaseUDBv81.appendString(stringBuffer, '\'');
            SSBDataBaseUDBv81.appendString(stringBuffer, dataBaseUDBv81.getOnPath());
            SSBDataBaseUDBv81.appendStringWithSpace(stringBuffer, '\'');
        }
    }

    protected void appendAlias(StringBuffer stringBuffer, DataBaseUDBv81 dataBaseUDBv81, boolean bl) {
        if (!dataBaseUDBv81.getAlias().equalsIgnoreCase("")) {
            SSBDataBaseUDBv81.appendNewLine(stringBuffer, bl, 1);
            SSBDataBaseUDBv81.appendStringWithSpace(stringBuffer, "ALIAS");
            SSBDataBaseUDBv81.appendStringWithSpace(stringBuffer, dataBaseUDBv81.getAlias());
        }
    }

    protected void appendUsingCodesetTerritory(StringBuffer stringBuffer, DataBaseUDBv81 dataBaseUDBv81, boolean bl) {
        if (!dataBaseUDBv81.getCodeSet().equalsIgnoreCase("") && !dataBaseUDBv81.getTerritory().equalsIgnoreCase("")) {
            SSBDataBaseUDBv81.appendNewLine(stringBuffer, bl, 1);
            SSBDataBaseUDBv81.appendStringWithSpace(stringBuffer, USING_CODESET);
            SSBDataBaseUDBv81.appendStringWithSpace(stringBuffer, dataBaseUDBv81.getCodeSet());
            SSBDataBaseUDBv81.appendStringWithSpace(stringBuffer, TERRITORY);
            SSBDataBaseUDBv81.appendStringWithSpace(stringBuffer, dataBaseUDBv81.getTerritory());
        }
    }

    protected void appendCollateUsing(StringBuffer stringBuffer, DataBaseUDBv81 dataBaseUDBv81, boolean bl) {
        if (!dataBaseUDBv81.getCollatingSequence().equalsIgnoreCase("")) {
            SSBDataBaseUDBv81.appendNewLine(stringBuffer, bl, 1);
            SSBDataBaseUDBv81.appendStringWithSpace(stringBuffer, COLLATE_USING);
            SSBDataBaseUDBv81.appendStringWithSpace(stringBuffer, dataBaseUDBv81.getCollatingSequence());
        }
    }

    protected void appendNumsegs(StringBuffer stringBuffer, DataBaseUDBv81 dataBaseUDBv81, boolean bl) {
        if (dataBaseUDBv81.getSegmentNumber() > 0) {
            SSBDataBaseUDBv81.appendNewLine(stringBuffer, bl, 1);
            SSBDataBaseUDBv81.appendStringWithSpace(stringBuffer, NUMSEGS);
            this.appendStringWithSpace(stringBuffer, dataBaseUDBv81.getSegmentNumber());
        }
    }

    protected void appendDefaultExtentSize(StringBuffer stringBuffer, DataBaseUDBv81 dataBaseUDBv81, boolean bl) {
        if (dataBaseUDBv81.getDefaultExtentSize() > 0) {
            SSBDataBaseUDBv81.appendNewLine(stringBuffer, bl, 1);
            SSBDataBaseUDBv81.appendStringWithSpace(stringBuffer, DEFAULT_EXTENT_SIZE);
            this.appendStringWithSpace(stringBuffer, dataBaseUDBv81.getDefaultExtentSize());
        }
    }

    protected void appendCatalogTableSpace(StringBuffer stringBuffer, DataBaseUDBv81 dataBaseUDBv81, boolean bl) {
        if (dataBaseUDBv81.getCatalogTableSpace() != null && !dataBaseUDBv81.getCatalogTableSpace().isNullInstance()) {
            SSBDataBaseUDBv81.appendNewLine(stringBuffer, bl, 1);
            SSBDataBaseUDBv81.appendStringWithSpace(stringBuffer, CATALOG_TABLESPACE);
            this.appendTableSpaceDefinition(stringBuffer, (TableSpaceUDBv81)dataBaseUDBv81.getCatalogTableSpace(), bl);
        }
    }

    protected void appendUserTableSpace(StringBuffer stringBuffer, DataBaseUDBv81 dataBaseUDBv81, boolean bl) {
        if (dataBaseUDBv81.getUserTableSpace() != null && !dataBaseUDBv81.getUserTableSpace().isNullInstance()) {
            SSBDataBaseUDBv81.appendNewLine(stringBuffer, bl, 1);
            SSBDataBaseUDBv81.appendStringWithSpace(stringBuffer, USER_TABLESPACE);
            this.appendTableSpaceDefinition(stringBuffer, (TableSpaceUDBv81)dataBaseUDBv81.getUserTableSpace(), bl);
        }
    }

    protected void appendTemporaryTableSpace(StringBuffer stringBuffer, DataBaseUDBv81 dataBaseUDBv81, boolean bl) {
        if (dataBaseUDBv81.getTemporaryTableSpace() != null && !dataBaseUDBv81.getTemporaryTableSpace().isNullInstance()) {
            SSBDataBaseUDBv81.appendNewLine(stringBuffer, bl, 1);
            SSBDataBaseUDBv81.appendStringWithSpace(stringBuffer, TEMP_TABLESPACE);
            this.appendTableSpaceDefinition(stringBuffer, (TableSpaceUDBv81)dataBaseUDBv81.getTemporaryTableSpace(), bl);
        }
    }

    protected void appendAutoConfigure(StringBuffer stringBuffer, DataBaseUDBv81 dataBaseUDBv81, boolean bl) {
        if (dataBaseUDBv81.getAutoConfigure()) {
            SSBDataBaseUDBv81.appendNewLine(stringBuffer, bl, 1);
            SSBDataBaseUDBv81.appendStringWithSpace(stringBuffer, AUTOCONFIGURE);
            if (dataBaseUDBv81.getUseAdminProperty() || dataBaseUDBv81.getUseBpResizeable() || dataBaseUDBv81.getUseIsolation() || dataBaseUDBv81.getUseMemPercent() || dataBaseUDBv81.getUseNumLocalApps() || dataBaseUDBv81.getUseNumRemoteApps() || dataBaseUDBv81.getUseNumStmts() || dataBaseUDBv81.getUseTpm() || dataBaseUDBv81.getUseWorkloadType()) {
                SSBDataBaseUDBv81.appendStringWithSpace(stringBuffer, "USING");
                if (dataBaseUDBv81.getUseAdminProperty()) {
                    SSBDataBaseUDBv81.appendNewLine(stringBuffer, bl, 2);
                    SSBDataBaseUDBv81.appendStringWithSpace(stringBuffer, "admin_property");
                    SSBDataBaseUDBv81.appendStringWithSpace(stringBuffer, dataBaseUDBv81.getAdminProperty());
                }
                if (dataBaseUDBv81.getUseBpResizeable()) {
                    SSBDataBaseUDBv81.appendNewLine(stringBuffer, bl, 2);
                    SSBDataBaseUDBv81.appendStringWithSpace(stringBuffer, "bp_resizeable");
                    SSBDataBaseUDBv81.appendStringWithSpace(stringBuffer, dataBaseUDBv81.getBpResizeable());
                }
                if (dataBaseUDBv81.getUseIsolation()) {
                    SSBDataBaseUDBv81.appendNewLine(stringBuffer, bl, 2);
                    SSBDataBaseUDBv81.appendStringWithSpace(stringBuffer, "isolation");
                    SSBDataBaseUDBv81.appendStringWithSpace(stringBuffer, dataBaseUDBv81.getIsolation());
                }
                if (dataBaseUDBv81.getUseMemPercent()) {
                    SSBDataBaseUDBv81.appendNewLine(stringBuffer, bl, 2);
                    SSBDataBaseUDBv81.appendStringWithSpace(stringBuffer, "mem_percent");
                    this.appendStringWithSpace(stringBuffer, dataBaseUDBv81.getMemPercent());
                }
                if (dataBaseUDBv81.getUseNumLocalApps()) {
                    SSBDataBaseUDBv81.appendNewLine(stringBuffer, bl, 2);
                    SSBDataBaseUDBv81.appendStringWithSpace(stringBuffer, "num_local_apps");
                    this.appendStringWithSpace(stringBuffer, dataBaseUDBv81.getNumLocalApps());
                }
                if (dataBaseUDBv81.getUseNumRemoteApps()) {
                    SSBDataBaseUDBv81.appendNewLine(stringBuffer, bl, 2);
                    SSBDataBaseUDBv81.appendStringWithSpace(stringBuffer, "num_remote_apps");
                    this.appendStringWithSpace(stringBuffer, dataBaseUDBv81.getNumRemoteApps());
                }
                if (dataBaseUDBv81.getUseNumStmts()) {
                    SSBDataBaseUDBv81.appendNewLine(stringBuffer, bl, 2);
                    SSBDataBaseUDBv81.appendStringWithSpace(stringBuffer, "num_stmts");
                    this.appendStringWithSpace(stringBuffer, dataBaseUDBv81.getNumStmts());
                }
                if (dataBaseUDBv81.getUseTpm()) {
                    SSBDataBaseUDBv81.appendNewLine(stringBuffer, bl, 2);
                    SSBDataBaseUDBv81.appendStringWithSpace(stringBuffer, "tpm");
                    this.appendStringWithSpace(stringBuffer, dataBaseUDBv81.getTpm());
                }
                if (dataBaseUDBv81.getUseWorkloadType()) {
                    SSBDataBaseUDBv81.appendNewLine(stringBuffer, bl, 2);
                    SSBDataBaseUDBv81.appendStringWithSpace(stringBuffer, "workload_type");
                    SSBDataBaseUDBv81.appendStringWithSpace(stringBuffer, dataBaseUDBv81.getWorkloadType());
                }
                if ("".equalsIgnoreCase(dataBaseUDBv81.getApplyChanges().trim())) {
                    SSBDataBaseUDBv81.appendNewLine(stringBuffer, bl, 1);
                    SSBDataBaseUDBv81.appendStringWithSpace(stringBuffer, APPLY);
                    SSBDataBaseUDBv81.appendStringWithSpace(stringBuffer, dataBaseUDBv81.getApplyChanges());
                }
            }
        }
    }

    private void appendTableSpaceDefinition(StringBuffer stringBuffer, TableSpaceUDBv81 tableSpaceUDBv81, boolean bl) {
        SSBTableSpaceUDBv81 sSBTableSpaceUDBv81 = new SSBTableSpaceUDBv81();
        sSBTableSpaceUDBv81.appendManagedBy(stringBuffer, tableSpaceUDBv81);
        sSBTableSpaceUDBv81.appendUsingContainer(stringBuffer, tableSpaceUDBv81, bl);
        sSBTableSpaceUDBv81.appendExtentSize(stringBuffer, tableSpaceUDBv81, bl);
        sSBTableSpaceUDBv81.appendPrefetchSize(stringBuffer, tableSpaceUDBv81, bl);
        sSBTableSpaceUDBv81.appendOverhead(stringBuffer, tableSpaceUDBv81, bl);
        sSBTableSpaceUDBv81.appendTransferRate(stringBuffer, tableSpaceUDBv81, bl);
        sSBTableSpaceUDBv81.appendDroppedTableRecovery(stringBuffer, tableSpaceUDBv81, bl);
    }

    protected void appendWith(StringBuffer stringBuffer, DataBaseUDBv81 dataBaseUDBv81, boolean bl) {
        if (!dataBaseUDBv81.getCommentInRDBMS().equalsIgnoreCase("")) {
            SSBDataBaseUDBv81.appendNewLine(stringBuffer, bl, 1);
            SSBDataBaseUDBv81.appendStringWithSpace(stringBuffer, WITHSTR);
            SSBDataBaseUDBv81.appendString(stringBuffer, '\"');
            SSBDataBaseUDBv81.appendString(stringBuffer, dataBaseUDBv81.getCommentInRDBMS());
            SSBDataBaseUDBv81.appendString(stringBuffer, '\"');
        }
    }
}

