/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.udb.v71;

import oracle.dbtools.crest.exports.ddl.udb.AbstractSSBUDB;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.udb.v71.InstanceUDBv71;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBInstanceUDBv71
extends AbstractSSBUDB {
    public static final String AUTHENTICATION_TYPE = "-a";
    public static final String PORT_NAME = "-p";
    public static final String TYPE = "-s";
    public static final String WORD_WIDTH = "-w";
    public static final String FENCED_ID = "-u";
    public static final String USER_NAME = "-u";
    public static final String PROFILE_PATH = "-p";
    public static final String CLUSTER_NAME = "-c";
    public static final String HOST_NAME = "-h";
    public static final String PORT_RANGE = "-r";
    public static final String CREATE_INSTANCE = "DB2ICRT";
    private StorageDesign storageDesign;

    @Override
    public boolean canHandle(Object object) {
        return object instanceof InstanceUDBv71 && ((InstanceUDBv71)object).isMarkedGenerate();
    }

    @Override
    protected void doAppend(StringBuffer stringBuffer, Object object, boolean bl) {
        InstanceUDBv71 instanceUDBv71 = (InstanceUDBv71)object;
        this.storageDesign = instanceUDBv71.getStorageDesign();
        if (instanceUDBv71.getOperatingSystem().equalsIgnoreCase("Windows Based")) {
            this.appendForWindowsBasedSystems(stringBuffer, instanceUDBv71, bl);
        }
        if (instanceUDBv71.getOperatingSystem().equalsIgnoreCase("OS/2 Based")) {
            this.appendForWindowsBasedSystems(stringBuffer, instanceUDBv71, bl);
        }
        if (instanceUDBv71.getOperatingSystem().equalsIgnoreCase("Unix Based")) {
            this.appendForUnixBasedSystems(stringBuffer, instanceUDBv71, bl);
        }
    }

    protected void appendForWindowsBasedSystems(StringBuffer stringBuffer, InstanceUDBv71 instanceUDBv71, boolean bl) {
        SSBInstanceUDBv71.appendStringWithSpace(stringBuffer, CREATE_INSTANCE);
        this.appendType(stringBuffer, instanceUDBv71, bl);
        this.appendUserName(stringBuffer, instanceUDBv71, bl);
        this.appendProfilePath(stringBuffer, instanceUDBv71, bl);
        this.appendClusterName(stringBuffer, instanceUDBv71, bl);
        this.appendHostName(stringBuffer, instanceUDBv71, bl);
        this.appendPortRange(stringBuffer, instanceUDBv71, bl);
        SSBInstanceUDBv71.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(instanceUDBv71.getName()));
        SSBInstanceUDBv71.appendNewLine(stringBuffer, bl, 0);
        this.appendLineFinisher(stringBuffer, bl);
        DDLFileMaker.incrementCreateInstance();
    }

    protected void appendForUnixBasedSystems(StringBuffer stringBuffer, InstanceUDBv71 instanceUDBv71, boolean bl) {
        SSBInstanceUDBv71.appendStringWithSpace(stringBuffer, CREATE_INSTANCE);
        this.appendAuthenticationType(stringBuffer, instanceUDBv71, bl);
        this.appendPortName(stringBuffer, instanceUDBv71, bl);
        this.appendType(stringBuffer, instanceUDBv71, bl);
        this.appendWordWidth(stringBuffer, instanceUDBv71, bl);
        this.appendFencedId(stringBuffer, instanceUDBv71, bl);
        SSBInstanceUDBv71.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(instanceUDBv71.getName()));
        SSBInstanceUDBv71.appendNewLine(stringBuffer, bl, 0);
        this.appendLineFinisher(stringBuffer, bl);
    }

    protected void appendAuthenticationType(StringBuffer stringBuffer, InstanceUDBv71 instanceUDBv71, boolean bl) {
        if (!instanceUDBv71.getAuthenticationType().equalsIgnoreCase("")) {
            SSBInstanceUDBv71.appendStringWithSpace(stringBuffer, AUTHENTICATION_TYPE);
            SSBInstanceUDBv71.appendStringWithSpace(stringBuffer, instanceUDBv71.getAuthenticationType());
            SSBInstanceUDBv71.appendNewLine(stringBuffer, bl, 1);
        }
    }

    protected void appendPortName(StringBuffer stringBuffer, InstanceUDBv71 instanceUDBv71, boolean bl) {
        if (!instanceUDBv71.getPortName().equalsIgnoreCase("")) {
            SSBInstanceUDBv71.appendStringWithSpace(stringBuffer, "-p");
            SSBInstanceUDBv71.appendStringWithSpace(stringBuffer, instanceUDBv71.getPortName());
            SSBInstanceUDBv71.appendNewLine(stringBuffer, bl, 1);
        }
    }

    protected void appendType(StringBuffer stringBuffer, InstanceUDBv71 instanceUDBv71, boolean bl) {
        if (!instanceUDBv71.getType().equalsIgnoreCase("")) {
            SSBInstanceUDBv71.appendNewLine(stringBuffer, bl, 1);
            SSBInstanceUDBv71.appendStringWithSpace(stringBuffer, TYPE);
            SSBInstanceUDBv71.appendStringWithSpace(stringBuffer, instanceUDBv71.getType());
        }
    }

    protected void appendWordWidth(StringBuffer stringBuffer, InstanceUDBv71 instanceUDBv71, boolean bl) {
        if (instanceUDBv71.getWordWidth() > 0) {
            SSBInstanceUDBv71.appendNewLine(stringBuffer, bl, 1);
            SSBInstanceUDBv71.appendStringWithSpace(stringBuffer, WORD_WIDTH);
            this.appendStringWithSpace(stringBuffer, instanceUDBv71.getWordWidth());
        }
    }

    protected void appendFencedId(StringBuffer stringBuffer, InstanceUDBv71 instanceUDBv71, boolean bl) {
        if (!instanceUDBv71.getFencedId().equalsIgnoreCase("")) {
            SSBInstanceUDBv71.appendNewLine(stringBuffer, bl, 1);
            SSBInstanceUDBv71.appendStringWithSpace(stringBuffer, "-u");
            SSBInstanceUDBv71.appendStringWithSpace(stringBuffer, instanceUDBv71.getFencedId());
        }
    }

    protected void appendUserName(StringBuffer stringBuffer, InstanceUDBv71 instanceUDBv71, boolean bl) {
        if (!instanceUDBv71.getUserName().equalsIgnoreCase("")) {
            SSBInstanceUDBv71.appendNewLine(stringBuffer, bl, 1);
            SSBInstanceUDBv71.appendStringWithSpace(stringBuffer, "-u");
            SSBInstanceUDBv71.appendString(stringBuffer, instanceUDBv71.getUserName());
            this.appendComma(stringBuffer);
            SSBInstanceUDBv71.appendStringWithSpace(stringBuffer, instanceUDBv71.getPassword());
        }
    }

    protected void appendProfilePath(StringBuffer stringBuffer, InstanceUDBv71 instanceUDBv71, boolean bl) {
        if (!instanceUDBv71.getProfilePath().equalsIgnoreCase("")) {
            SSBInstanceUDBv71.appendNewLine(stringBuffer, bl, 1);
            SSBInstanceUDBv71.appendStringWithSpace(stringBuffer, "-p");
            SSBInstanceUDBv71.appendStringWithSpace(stringBuffer, instanceUDBv71.getProfilePath());
        }
    }

    protected void appendClusterName(StringBuffer stringBuffer, InstanceUDBv71 instanceUDBv71, boolean bl) {
        if (!instanceUDBv71.getClusterName().equalsIgnoreCase("")) {
            SSBInstanceUDBv71.appendNewLine(stringBuffer, bl, 1);
            SSBInstanceUDBv71.appendStringWithSpace(stringBuffer, CLUSTER_NAME);
            SSBInstanceUDBv71.appendStringWithSpace(stringBuffer, instanceUDBv71.getClusterName());
        }
    }

    protected void appendHostName(StringBuffer stringBuffer, InstanceUDBv71 instanceUDBv71, boolean bl) {
        if (!instanceUDBv71.getHostName().equalsIgnoreCase("")) {
            SSBInstanceUDBv71.appendNewLine(stringBuffer, bl, 1);
            SSBInstanceUDBv71.appendStringWithSpace(stringBuffer, HOST_NAME);
            SSBInstanceUDBv71.appendStringWithSpace(stringBuffer, instanceUDBv71.getHostName());
        }
    }

    protected void appendPortRange(StringBuffer stringBuffer, InstanceUDBv71 instanceUDBv71, boolean bl) {
        if (!instanceUDBv71.getPortRange().equalsIgnoreCase("")) {
            SSBInstanceUDBv71.appendNewLine(stringBuffer, bl, 1);
            SSBInstanceUDBv71.appendStringWithSpace(stringBuffer, PORT_RANGE);
            SSBInstanceUDBv71.appendStringWithSpace(stringBuffer, instanceUDBv71.getPortRange());
        }
    }
}

