/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.udb.v71;

import oracle.dbtools.crest.exports.ddl.udb.AbstractSSBUDB;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.v71.FKProxyUDBv71;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBFKUDBv71
extends AbstractSSBUDB {
    private StorageDesignUDB storageDesign;

    @Override
    public boolean canHandle(Object object) {
        if (object instanceof RelationalObjectProxy && !((RelationalObjectProxy)object).getStorageDesign().isOpen()) {
            if (object instanceof FKProxyUDBv71) {
                return ((RelationalObjectProxy)object).getObject().isMarkedGenerate();
            }
        } else if (object instanceof FKIndexAssociation) {
            return ((FKIndexAssociation)object).isMarkedGenerate();
        }
        return object instanceof FKProxyUDBv71 && ((FKProxyUDBv71)object).isMarkedGenerate();
    }

    @Override
    protected void doAppend(StringBuffer stringBuffer, Object object, boolean bl) {
        FKProxyUDBv71 fKProxyUDBv71;
        ModelIDObject modelIDObject;
        if (object instanceof FKIndexAssociation) {
            FKIndexAssociation fKIndexAssociation = (FKIndexAssociation)object;
            modelIDObject = (RelationalDesign)fKIndexAssociation.getDesignPart();
            this.storageDesign = (StorageDesignUDB)((RelationalDesign)modelIDObject).getStorageDesign(((RelationalDesign)modelIDObject).getSelectedRDBMSSite());
            fKProxyUDBv71 = (FKProxyUDBv71)this.storageDesign.getFKProxySet().getProxy(fKIndexAssociation.getObjectID());
            if (fKProxyUDBv71 == null && (fKProxyUDBv71 = (FKProxyUDBv71)this.storageDesign.getFKProxySet().getProxy(fKIndexAssociation.getLocalFKIndex().getObjectID())) == null) {
                return;
            }
        } else {
            fKProxyUDBv71 = (FKProxyUDBv71)object;
            this.storageDesign = (StorageDesignUDB)fKProxyUDBv71.getStorageDesign();
        }
        modelIDObject = (TableProxyUDB)fKProxyUDBv71.getStorageDesign().getTableProxySet().getProxy(fKProxyUDBv71.getTable().getObjectID());
        SSBFKUDBv71.appendNewLine(stringBuffer, bl, 0);
        this.appendBeforeAlterScript(stringBuffer, bl, (ContainerObject)((RelationalObjectProxy)modelIDObject).getObject());
        SSBFKUDBv71.appendStringWithSpace(stringBuffer, "ALTER");
        SSBFKUDBv71.appendStringWithSpace(stringBuffer, "TABLE");
        SSBFKUDBv71.appendString(stringBuffer, this.storageDesign.getFormatedName(((TableProxyUDB)modelIDObject).getLongName()));
        SSBFKUDBv71.appendNewLine(stringBuffer, bl, 1);
        SSBFKUDBv71.appendStringWithSpace(stringBuffer, "ADD");
        SSBFKUDBv71.appendStringWithSpace(stringBuffer, "CONSTRAINT");
        SSBFKUDBv71.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(fKProxyUDBv71.getName()));
        SSBFKUDBv71.appendString(stringBuffer, "FOREIGN KEY");
        SSBFKUDBv71.appendNewLine(stringBuffer, bl, 1);
        SSBFKUDBv71.appendStringWithSpace(stringBuffer, '(');
        SSBFKUDBv71.appendNewLine(stringBuffer, bl, 0);
        SSBFKUDBv71.appendString(stringBuffer, fKProxyUDBv71.getColumns(this.storageDesign));
        SSBFKUDBv71.appendNewLine(stringBuffer, bl, 1);
        SSBFKUDBv71.appendStringWithSpace(stringBuffer, ')');
        this.appendReferences(stringBuffer, fKProxyUDBv71, bl);
        this.appendOnDelete(stringBuffer, fKProxyUDBv71, bl);
        this.appendOnUpdate(stringBuffer, fKProxyUDBv71, bl);
        SSBFKUDBv71.appendNewLine(stringBuffer, bl, 0);
        this.appendLineFinisher(stringBuffer, bl);
        SSBFKUDBv71.appendNewLine(stringBuffer, bl, 0);
        SSBFKUDBv71.appendNewLine(stringBuffer, bl, 0);
        DDLFileMaker.incrementAlterTable();
        this.appendAfterAlterScript(stringBuffer, bl, (ContainerObject)((RelationalObjectProxy)modelIDObject).getObject());
    }

    private void appendReferences(StringBuffer stringBuffer, FKProxyUDBv71 fKProxyUDBv71, boolean bl) {
        SSBFKUDBv71.appendNewLine(stringBuffer, bl, 1);
        SSBFKUDBv71.appendStringWithSpace(stringBuffer, "REFERENCES");
        TableProxyUDB tableProxyUDB = (TableProxyUDB)fKProxyUDBv71.getStorageDesign().getTableProxySet().getProxy(fKProxyUDBv71.getFKTable().getObjectID());
        SSBFKUDBv71.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableProxyUDB.getLongName()));
        SSBFKUDBv71.appendNewLine(stringBuffer, bl, 1);
        SSBFKUDBv71.appendStringWithSpace(stringBuffer, '(');
        SSBFKUDBv71.appendNewLine(stringBuffer, bl, 0);
        SSBFKUDBv71.appendString(stringBuffer, fKProxyUDBv71.getReferenceColumns(this.storageDesign));
        SSBFKUDBv71.appendNewLine(stringBuffer, bl, 1);
        SSBFKUDBv71.appendString(stringBuffer, ')');
    }

    private void appendOnDelete(StringBuffer stringBuffer, FKProxyUDBv71 fKProxyUDBv71, boolean bl) {
        FKIndexAssociation fKIndexAssociation = ((Index)fKProxyUDBv71.getObject()).getFKAssociation();
        String string = fKIndexAssociation.getDeleteRule();
        if (string.equalsIgnoreCase("SET DEFAULT")) {
            string = fKIndexAssociation.isMandatory() ? "RESTRICT" : "SET NULL";
        }
        SSBFKUDBv71.appendNewLine(stringBuffer, bl, 1);
        SSBFKUDBv71.appendStringWithSpace(stringBuffer, "ON");
        SSBFKUDBv71.appendStringWithSpace(stringBuffer, "DELETE");
        SSBFKUDBv71.appendString(stringBuffer, string);
    }

    private void appendOnUpdate(StringBuffer stringBuffer, FKProxyUDBv71 fKProxyUDBv71, boolean bl) {
        SSBFKUDBv71.appendNewLine(stringBuffer, bl, 1);
        SSBFKUDBv71.appendStringWithSpace(stringBuffer, "ON");
        SSBFKUDBv71.appendStringWithSpace(stringBuffer, "UPDATE");
        SSBFKUDBv71.appendString(stringBuffer, fKProxyUDBv71.getOnUpdate());
    }
}

