/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.udb.v71;

import oracle.dbtools.crest.exports.ddl.udb.AbstractSSBUDB;
import oracle.dbtools.crest.exports.ddl.udb.v71.SSBTableSpaceUDBv71;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.model.design.storage.udb.v71.DataBaseUDBv71;
import oracle.dbtools.crest.model.design.storage.udb.v71.TableSpaceUDBv71;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBDataBaseUDBv71
extends AbstractSSBUDB {
    public static final String USING_CODESET = "USING CODESET";
    public static final String TERRITORY = "TERRITORY";
    public static final String COLLATE_USING = "COLLATE USING";
    public static final String NUMSEGS = "NUMSEGS";
    public static final String DEFAULT_EXTENT_SIZE = "DFT_EXTENT_SZ";
    public static final String CATALOG_TABLESPACE = "CATALOG TABLESPACE";
    public static final String USER_TABLESPACE = "USER TABLESPACE";
    public static final String TEMP_TABLESPACE = "TEMPORARY TABLESPACE";
    public static final String WITH = "WITH";

    @Override
    public boolean canHandle(Object object) {
        return object instanceof DataBaseUDBv71 && ((DataBaseUDBv71)object).isMarkedGenerate();
    }

    @Override
    protected void doAppend(StringBuffer stringBuffer, Object object, boolean bl) {
        DataBaseUDBv71 dataBaseUDBv71 = (DataBaseUDBv71)object;
        this.appendCreate(stringBuffer, dataBaseUDBv71);
        this.appendOnPath(stringBuffer, dataBaseUDBv71, bl);
        this.appendAlias(stringBuffer, dataBaseUDBv71, bl);
        this.appendUsingCodesetTerritory(stringBuffer, dataBaseUDBv71, bl);
        this.appendCollateUsing(stringBuffer, dataBaseUDBv71, bl);
        this.appendNumsegs(stringBuffer, dataBaseUDBv71, bl);
        this.appendDefaultExtentSize(stringBuffer, dataBaseUDBv71, bl);
        this.appendCatalogTableSpace(stringBuffer, dataBaseUDBv71, bl);
        this.appendUserTableSpace(stringBuffer, dataBaseUDBv71, bl);
        this.appendTemporaryTableSpace(stringBuffer, dataBaseUDBv71, bl);
        if (dataBaseUDBv71.getDesign().getAppView().getSettings().isGenerateCommentsInRDBMS()) {
            this.appendWith(stringBuffer, dataBaseUDBv71, bl);
        }
        SSBDataBaseUDBv71.appendNewLine(stringBuffer, bl, 0);
        this.appendLineFinisher(stringBuffer, bl);
        DDLFileMaker.incrementCreateDatabase();
    }

    protected void appendCreate(StringBuffer stringBuffer, DataBaseUDBv71 dataBaseUDBv71) {
        StorageDesignUDB storageDesignUDB = (StorageDesignUDB)this.getStorageDesign(dataBaseUDBv71);
        this.appendCreate(stringBuffer);
        SSBDataBaseUDBv71.appendStringWithSpace(stringBuffer, "DATABASE");
        SSBDataBaseUDBv71.appendStringWithSpace(stringBuffer, storageDesignUDB.getFormatedName(dataBaseUDBv71.getName()));
    }

    protected void appendOnPath(StringBuffer stringBuffer, DataBaseUDBv71 dataBaseUDBv71, boolean bl) {
        if (!dataBaseUDBv71.getOnPath().equalsIgnoreCase("")) {
            SSBDataBaseUDBv71.appendNewLine(stringBuffer, bl, 1);
            SSBDataBaseUDBv71.appendStringWithSpace(stringBuffer, "ON");
            SSBDataBaseUDBv71.appendString(stringBuffer, '\'');
            SSBDataBaseUDBv71.appendString(stringBuffer, dataBaseUDBv71.getOnPath());
            SSBDataBaseUDBv71.appendStringWithSpace(stringBuffer, '\'');
        }
    }

    protected void appendAlias(StringBuffer stringBuffer, DataBaseUDBv71 dataBaseUDBv71, boolean bl) {
        if (!dataBaseUDBv71.getAlias().equalsIgnoreCase("")) {
            SSBDataBaseUDBv71.appendNewLine(stringBuffer, bl, 1);
            SSBDataBaseUDBv71.appendStringWithSpace(stringBuffer, "ALIAS");
            SSBDataBaseUDBv71.appendStringWithSpace(stringBuffer, dataBaseUDBv71.getAlias());
        }
    }

    protected void appendUsingCodesetTerritory(StringBuffer stringBuffer, DataBaseUDBv71 dataBaseUDBv71, boolean bl) {
        if (!dataBaseUDBv71.getCodeSet().equalsIgnoreCase("") && !dataBaseUDBv71.getTerritory().equalsIgnoreCase("")) {
            SSBDataBaseUDBv71.appendNewLine(stringBuffer, bl, 1);
            SSBDataBaseUDBv71.appendStringWithSpace(stringBuffer, USING_CODESET);
            SSBDataBaseUDBv71.appendStringWithSpace(stringBuffer, dataBaseUDBv71.getCodeSet());
            SSBDataBaseUDBv71.appendStringWithSpace(stringBuffer, TERRITORY);
            SSBDataBaseUDBv71.appendStringWithSpace(stringBuffer, dataBaseUDBv71.getTerritory());
        }
    }

    protected void appendCollateUsing(StringBuffer stringBuffer, DataBaseUDBv71 dataBaseUDBv71, boolean bl) {
        if (!dataBaseUDBv71.getCollatingSequence().equalsIgnoreCase("")) {
            SSBDataBaseUDBv71.appendNewLine(stringBuffer, bl, 1);
            SSBDataBaseUDBv71.appendStringWithSpace(stringBuffer, COLLATE_USING);
            SSBDataBaseUDBv71.appendStringWithSpace(stringBuffer, dataBaseUDBv71.getCollatingSequence());
        }
    }

    protected void appendNumsegs(StringBuffer stringBuffer, DataBaseUDBv71 dataBaseUDBv71, boolean bl) {
        if (dataBaseUDBv71.getSegmentNumber() > 0) {
            SSBDataBaseUDBv71.appendNewLine(stringBuffer, bl, 1);
            SSBDataBaseUDBv71.appendStringWithSpace(stringBuffer, NUMSEGS);
            this.appendStringWithSpace(stringBuffer, dataBaseUDBv71.getSegmentNumber());
        }
    }

    protected void appendDefaultExtentSize(StringBuffer stringBuffer, DataBaseUDBv71 dataBaseUDBv71, boolean bl) {
        if (dataBaseUDBv71.getDefaultExtentSize() > 0) {
            SSBDataBaseUDBv71.appendNewLine(stringBuffer, bl, 1);
            SSBDataBaseUDBv71.appendStringWithSpace(stringBuffer, DEFAULT_EXTENT_SIZE);
            this.appendStringWithSpace(stringBuffer, dataBaseUDBv71.getDefaultExtentSize());
        }
    }

    protected void appendCatalogTableSpace(StringBuffer stringBuffer, DataBaseUDBv71 dataBaseUDBv71, boolean bl) {
        if (dataBaseUDBv71.getCatalogTableSpace() != null && !dataBaseUDBv71.getCatalogTableSpace().isNullInstance()) {
            SSBDataBaseUDBv71.appendNewLine(stringBuffer, bl, 1);
            SSBDataBaseUDBv71.appendStringWithSpace(stringBuffer, CATALOG_TABLESPACE);
            this.appendTableSpaceDefinition(stringBuffer, (TableSpaceUDBv71)dataBaseUDBv71.getCatalogTableSpace(), bl);
        }
    }

    protected void appendUserTableSpace(StringBuffer stringBuffer, DataBaseUDBv71 dataBaseUDBv71, boolean bl) {
        if (dataBaseUDBv71.getUserTableSpace() != null && !dataBaseUDBv71.getUserTableSpace().isNullInstance()) {
            SSBDataBaseUDBv71.appendNewLine(stringBuffer, bl, 1);
            SSBDataBaseUDBv71.appendStringWithSpace(stringBuffer, USER_TABLESPACE);
            this.appendTableSpaceDefinition(stringBuffer, (TableSpaceUDBv71)dataBaseUDBv71.getUserTableSpace(), bl);
        }
    }

    protected void appendTemporaryTableSpace(StringBuffer stringBuffer, DataBaseUDBv71 dataBaseUDBv71, boolean bl) {
        if (dataBaseUDBv71.getTemporaryTableSpace() != null && !dataBaseUDBv71.getTemporaryTableSpace().isNullInstance()) {
            SSBDataBaseUDBv71.appendNewLine(stringBuffer, bl, 1);
            SSBDataBaseUDBv71.appendStringWithSpace(stringBuffer, TEMP_TABLESPACE);
            this.appendTableSpaceDefinition(stringBuffer, (TableSpaceUDBv71)dataBaseUDBv71.getTemporaryTableSpace(), bl);
        }
    }

    private void appendTableSpaceDefinition(StringBuffer stringBuffer, TableSpaceUDBv71 tableSpaceUDBv71, boolean bl) {
        SSBTableSpaceUDBv71 sSBTableSpaceUDBv71 = new SSBTableSpaceUDBv71();
        sSBTableSpaceUDBv71.appendManagedBy(stringBuffer, tableSpaceUDBv71);
        sSBTableSpaceUDBv71.appendUsingContainer(stringBuffer, tableSpaceUDBv71, bl);
        sSBTableSpaceUDBv71.appendExtentSize(stringBuffer, tableSpaceUDBv71, bl);
        sSBTableSpaceUDBv71.appendPrefetchSize(stringBuffer, tableSpaceUDBv71, bl);
        sSBTableSpaceUDBv71.appendOverhead(stringBuffer, tableSpaceUDBv71, bl);
        sSBTableSpaceUDBv71.appendTransferRate(stringBuffer, tableSpaceUDBv71, bl);
        sSBTableSpaceUDBv71.appendDroppedTableRecovery(stringBuffer, tableSpaceUDBv71, bl);
    }

    protected void appendWith(StringBuffer stringBuffer, DataBaseUDBv71 dataBaseUDBv71, boolean bl) {
        if (!dataBaseUDBv71.getCommentInRDBMS().equalsIgnoreCase("")) {
            SSBDataBaseUDBv71.appendNewLine(stringBuffer, bl, 1);
            SSBDataBaseUDBv71.appendStringWithSpace(stringBuffer, WITH);
            SSBDataBaseUDBv71.appendString(stringBuffer, '\"');
            SSBDataBaseUDBv71.appendString(stringBuffer, dataBaseUDBv71.getCommentInRDBMS());
            SSBDataBaseUDBv71.appendString(stringBuffer, '\"');
        }
    }
}

