/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.udb;

import java.util.Iterator;
import oracle.dbtools.crest.exports.ddl.udb.AbstractSSBUDB;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.TypeElementProxy;
import oracle.dbtools.crest.model.design.storage.udb.MethodParamProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.MethodProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.StructuredTypeProxyUDB;

public class SSBStructuredTypeUDB
extends AbstractSSBUDB {
    @Override
    public boolean canHandle(Object object) {
        return object instanceof StructuredTypeProxyUDB || object instanceof StructuredType;
    }

    @Override
    protected void doAppend(StringBuffer stringBuffer, Object object, boolean bl) {
        StructuredTypeProxyUDB structuredTypeProxyUDB;
        StructuredType structuredType;
        if (!(object instanceof StructuredType) && object instanceof StructuredTypeProxyUDB && !(structuredType = (structuredTypeProxyUDB = (StructuredTypeProxyUDB)object).getStructuredType()).isPredefined()) {
            this.appendComment(stringBuffer, structuredTypeProxyUDB);
            this.appendDefinition(stringBuffer, structuredTypeProxyUDB, bl);
        }
    }

    private void appendDefinition(StringBuffer stringBuffer, StructuredTypeProxyUDB structuredTypeProxyUDB, boolean bl) {
        RelationalObjectProxy relationalObjectProxy;
        boolean bl2 = false;
        StructuredType structuredType = structuredTypeProxyUDB.getStructuredType();
        TypeElement[] typeElementArray = structuredType.getElements();
        for (int i = 0; i < typeElementArray.length; ++i) {
            relationalObjectProxy = structuredTypeProxyUDB.getElementByDesignObject(typeElementArray[i]);
            this.appendAttribute(stringBuffer, (TypeElementProxy)relationalObjectProxy, structuredTypeProxyUDB, bl);
            bl2 = true;
        }
        if (bl2) {
            SSBStructuredTypeUDB.appendNewLine(stringBuffer, bl, 0);
        }
        bl2 = false;
        Iterator iterator = structuredTypeProxyUDB.getMethods().iterator();
        while (iterator.hasNext()) {
            relationalObjectProxy = (MethodProxyUDB)iterator.next();
            this.appendMethod(stringBuffer, (MethodProxyUDB)relationalObjectProxy, structuredTypeProxyUDB, bl);
            bl2 = true;
        }
        if (bl2) {
            SSBStructuredTypeUDB.appendNewLine(stringBuffer, bl, 0);
        }
    }

    private void appendAttribute(StringBuffer stringBuffer, TypeElementProxy typeElementProxy, StructuredTypeProxyUDB structuredTypeProxyUDB, boolean bl) {
        SSBStructuredTypeUDB.appendStringWithSpace(stringBuffer, "ALTER");
        SSBStructuredTypeUDB.appendStringWithSpace(stringBuffer, "TYPE");
        if (structuredTypeProxyUDB.getSchema() != null) {
            SSBStructuredTypeUDB.appendString(stringBuffer, structuredTypeProxyUDB.getStorageDesign().getFormatedName(structuredTypeProxyUDB.getSchema().getName()));
            SSBStructuredTypeUDB.appendString(stringBuffer, '.');
        }
        SSBStructuredTypeUDB.appendStringWithSpace(stringBuffer, structuredTypeProxyUDB.getStorageDesign().getFormatedName(structuredTypeProxyUDB.getName()));
        SSBStructuredTypeUDB.appendStringWithSpace(stringBuffer, "ADD");
        SSBStructuredTypeUDB.appendStringWithSpace(stringBuffer, "ATTRIBUTE");
        SSBStructuredTypeUDB.appendStringWithSpace(stringBuffer, typeElementProxy.getName());
        SSBStructuredTypeUDB.appendStringWithSpace(stringBuffer, typeElementProxy.getDatatype("DB2/UDB 7.1"));
        this.appendLineFinisher(stringBuffer, bl);
    }

    private void appendMethod(StringBuffer stringBuffer, MethodProxyUDB methodProxyUDB, StructuredTypeProxyUDB structuredTypeProxyUDB, boolean bl) {
        SSBStructuredTypeUDB.appendStringWithSpace(stringBuffer, "ALTER");
        SSBStructuredTypeUDB.appendStringWithSpace(stringBuffer, "TYPE");
        if (structuredTypeProxyUDB.getSchema() != null) {
            this.appendString(stringBuffer, structuredTypeProxyUDB.getSchema());
            SSBStructuredTypeUDB.appendString(stringBuffer, '.');
        }
        SSBStructuredTypeUDB.appendStringWithSpace(stringBuffer, structuredTypeProxyUDB.getName());
        SSBStructuredTypeUDB.appendStringWithSpace(stringBuffer, "ADD");
        SSBStructuredTypeUDB.appendStringWithSpace(stringBuffer, "METHOD");
        SSBStructuredTypeUDB.appendStringWithSpace(stringBuffer, methodProxyUDB.getName());
        if (methodProxyUDB.getParams().size() > 0) {
            SSBStructuredTypeUDB.appendNewLine(stringBuffer, bl, 1);
            SSBStructuredTypeUDB.appendStringWithSpace(stringBuffer, '(');
            Iterator iterator = methodProxyUDB.getParams().iterator();
            while (iterator.hasNext()) {
                MethodParamProxyUDB methodParamProxyUDB = (MethodParamProxyUDB)iterator.next();
                SSBStructuredTypeUDB.appendNewLine(stringBuffer, bl, 1);
                SSBStructuredTypeUDB.appendString(stringBuffer, ' ');
                SSBStructuredTypeUDB.appendStringWithSpace(stringBuffer, methodParamProxyUDB.getName());
                SSBStructuredTypeUDB.appendStringWithSpace(stringBuffer, methodParamProxyUDB.getMethodParam().getDataType());
                if (methodParamProxyUDB.isAsLocator()) {
                    SSBStructuredTypeUDB.appendStringWithSpace(stringBuffer, "AS LOCATOR");
                }
                if (!iterator.hasNext()) continue;
                SSBStructuredTypeUDB.appendStringWithSpace(stringBuffer, ',');
            }
            SSBStructuredTypeUDB.appendNewLine(stringBuffer, bl, 1);
            SSBStructuredTypeUDB.appendStringWithSpace(stringBuffer, ')');
        }
        if (!"".equalsIgnoreCase(methodProxyUDB.getReturnValue())) {
            SSBStructuredTypeUDB.appendNewLine(stringBuffer, bl, 1);
            SSBStructuredTypeUDB.appendStringWithSpace(stringBuffer, "RETURNS");
            SSBStructuredTypeUDB.appendStringWithSpace(stringBuffer, methodProxyUDB.getReturnValue());
        }
        if (!"".equalsIgnoreCase(methodProxyUDB.getSpecificName())) {
            SSBStructuredTypeUDB.appendNewLine(stringBuffer, bl, 1);
            SSBStructuredTypeUDB.appendStringWithSpace(stringBuffer, "SPECIFIC");
            SSBStructuredTypeUDB.appendStringWithSpace(stringBuffer, methodProxyUDB.getSpecificName());
        }
        if ("YES".equalsIgnoreCase(methodProxyUDB.getReturnSelfAsResult())) {
            SSBStructuredTypeUDB.appendNewLine(stringBuffer, bl, 1);
            SSBStructuredTypeUDB.appendStringWithSpace(stringBuffer, "SELF");
            SSBStructuredTypeUDB.appendStringWithSpace(stringBuffer, "AS");
            SSBStructuredTypeUDB.appendStringWithSpace(stringBuffer, "RESULT");
        }
        if ("SQL".equalsIgnoreCase(methodProxyUDB.getLanguage())) {
            if ("YES".equalsIgnoreCase(methodProxyUDB.getDeterministic())) {
                SSBStructuredTypeUDB.appendNewLine(stringBuffer, bl, 1);
                SSBStructuredTypeUDB.appendStringWithSpace(stringBuffer, "DETERMINISTIC");
            }
            if ("NO".equalsIgnoreCase(methodProxyUDB.getExternalAction())) {
                SSBStructuredTypeUDB.appendNewLine(stringBuffer, bl, 1);
                SSBStructuredTypeUDB.appendStringWithSpace(stringBuffer, "NO");
                SSBStructuredTypeUDB.appendStringWithSpace(stringBuffer, "EXTERNAL");
                SSBStructuredTypeUDB.appendStringWithSpace(stringBuffer, "ACTION");
            }
            if ("CONTAINS SQL".equalsIgnoreCase(methodProxyUDB.getSqlStatementType())) {
                SSBStructuredTypeUDB.appendNewLine(stringBuffer, bl, 1);
                SSBStructuredTypeUDB.appendStringWithSpace(stringBuffer, "CONTAINS");
                SSBStructuredTypeUDB.appendStringWithSpace(stringBuffer, "SQL");
            }
            if ("YES".equalsIgnoreCase(methodProxyUDB.getFederated())) {
                SSBStructuredTypeUDB.appendNewLine(stringBuffer, bl, 1);
                SSBStructuredTypeUDB.appendStringWithSpace(stringBuffer, "FEDERATED");
            } else {
                SSBStructuredTypeUDB.appendNewLine(stringBuffer, bl, 1);
                SSBStructuredTypeUDB.appendStringWithSpace(stringBuffer, "NOT FEDERATED");
            }
        } else {
            SSBStructuredTypeUDB.appendNewLine(stringBuffer, bl, 1);
            SSBStructuredTypeUDB.appendStringWithSpace(stringBuffer, "LANGUAGE");
            SSBStructuredTypeUDB.appendStringWithSpace(stringBuffer, methodProxyUDB.getLanguage());
            SSBStructuredTypeUDB.appendNewLine(stringBuffer, bl, 1);
            SSBStructuredTypeUDB.appendStringWithSpace(stringBuffer, "PARAMETER");
            SSBStructuredTypeUDB.appendStringWithSpace(stringBuffer, "STYLE");
            SSBStructuredTypeUDB.appendStringWithSpace(stringBuffer, methodProxyUDB.getExt_R_ParameterStyle());
            if ("YES".equalsIgnoreCase(methodProxyUDB.getDeterministic())) {
                SSBStructuredTypeUDB.appendNewLine(stringBuffer, bl, 1);
                SSBStructuredTypeUDB.appendStringWithSpace(stringBuffer, "DETERMINISTIC");
            }
            if ("FENCED".equalsIgnoreCase(methodProxyUDB.getExt_R_Safeness())) {
                SSBStructuredTypeUDB.appendNewLine(stringBuffer, bl, 1);
                SSBStructuredTypeUDB.appendStringWithSpace(stringBuffer, "FENCED");
            } else if (methodProxyUDB.getExt_R_Safeness().equalsIgnoreCase("FENCED THREAD SAFE")) {
                SSBStructuredTypeUDB.appendNewLine(stringBuffer, bl, 1);
                SSBStructuredTypeUDB.appendStringWithSpace(stringBuffer, "FENCED THREAD SAFE");
            } else if (methodProxyUDB.getExt_R_Safeness().equalsIgnoreCase("FENCED NOT THREAD SAFE")) {
                SSBStructuredTypeUDB.appendNewLine(stringBuffer, bl, 1);
                SSBStructuredTypeUDB.appendStringWithSpace(stringBuffer, "FENCED NOT THREAD SAFE");
            } else {
                SSBStructuredTypeUDB.appendNewLine(stringBuffer, bl, 1);
                SSBStructuredTypeUDB.appendStringWithSpace(stringBuffer, "NOT FENCED");
            }
            if ("RETURNS NULL ON NULL INPUT".equalsIgnoreCase(methodProxyUDB.getNullParametersTreatment())) {
                SSBStructuredTypeUDB.appendNewLine(stringBuffer, bl, 1);
                SSBStructuredTypeUDB.appendStringWithSpace(stringBuffer, "RETURNS");
                SSBStructuredTypeUDB.appendStringWithSpace(stringBuffer, "NULL");
                SSBStructuredTypeUDB.appendStringWithSpace(stringBuffer, "ON");
                SSBStructuredTypeUDB.appendStringWithSpace(stringBuffer, "NULL");
                SSBStructuredTypeUDB.appendStringWithSpace(stringBuffer, "INPUT");
            }
            SSBStructuredTypeUDB.appendNewLine(stringBuffer, bl, 1);
            SSBStructuredTypeUDB.appendStringWithSpace(stringBuffer, "NO");
            SSBStructuredTypeUDB.appendStringWithSpace(stringBuffer, "SQL");
            if ("NO".equalsIgnoreCase(methodProxyUDB.getExternalAction())) {
                SSBStructuredTypeUDB.appendNewLine(stringBuffer, bl, 1);
                SSBStructuredTypeUDB.appendStringWithSpace(stringBuffer, "NO");
                SSBStructuredTypeUDB.appendStringWithSpace(stringBuffer, "EXTERNAL");
                SSBStructuredTypeUDB.appendStringWithSpace(stringBuffer, "ACTION");
            }
            if (!"".equalsIgnoreCase(methodProxyUDB.getExt_R_Scratchpad())) {
                SSBStructuredTypeUDB.appendNewLine(stringBuffer, bl, 1);
                SSBStructuredTypeUDB.appendStringWithSpace(stringBuffer, "SCRATCHPAD");
                SSBStructuredTypeUDB.appendStringWithSpace(stringBuffer, methodProxyUDB.getExt_R_Scratchpad());
            }
            if ("YES".equalsIgnoreCase(methodProxyUDB.getExt_R_FinalCall())) {
                SSBStructuredTypeUDB.appendNewLine(stringBuffer, bl, 1);
                SSBStructuredTypeUDB.appendStringWithSpace(stringBuffer, "FINAL");
                SSBStructuredTypeUDB.appendStringWithSpace(stringBuffer, "CALL");
            }
            if ("DISALLOW".equalsIgnoreCase(methodProxyUDB.getExt_R_ParallelInvocation())) {
                SSBStructuredTypeUDB.appendNewLine(stringBuffer, bl, 1);
                SSBStructuredTypeUDB.appendStringWithSpace(stringBuffer, "DISALLOW");
                SSBStructuredTypeUDB.appendStringWithSpace(stringBuffer, "PARALLEL");
            }
            if (!"OLE".equalsIgnoreCase(methodProxyUDB.getLanguage()) && "YES".equalsIgnoreCase(methodProxyUDB.getExt_R_DBInfo())) {
                SSBStructuredTypeUDB.appendNewLine(stringBuffer, bl, 1);
                SSBStructuredTypeUDB.appendStringWithSpace(stringBuffer, "DBINFO");
            }
        }
        SSBStructuredTypeUDB.appendNewLine(stringBuffer, bl, 0);
        this.appendLineFinisher(stringBuffer, bl);
    }
}

