/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.udb;

import java.util.HashMap;
import java.util.List;
import oracle.dbtools.crest.exports.ddl.AbstractSSBDB2;
import oracle.dbtools.crest.exports.ddl.oracle.SSBNoneTransferableFKOracle;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.db2.v70.StorageDesignDB2v70;
import oracle.dbtools.crest.model.design.storage.db2.v80.StorageDesignDB2v80;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBNoneTransferableFK_UDB
extends AbstractSSBDB2 {
    private StorageDesign storageDesign;
    int arc_index = 0;

    public SSBNoneTransferableFK_UDB(StorageDesign storageDesign) {
        this.storageDesign = storageDesign;
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof TableProxy;
    }

    @Override
    protected void doAppend(StringBuffer stringBuffer, Object object, boolean bl) {
        TableProxy tableProxy = (TableProxy)object;
        Table table = (Table)tableProxy.getObject();
        if (table.getDesign().getAppView().getSettings().isGenerateFKNoneTransferableTriggers()) {
            StringBuffer stringBuffer2 = new StringBuffer();
            String string = "";
            List list = SSBNoneTransferableFKOracle.getColumnsInOptionalFK(table);
            if (table != null && list.size() > 0) {
                string = "create Arc constraint INSERT trigger for table " + this.storageDesign.getFormatedName(tableProxy.getLongName());
                if (DDLFileMaker.getddlAdvancedGenenerator() == null) {
                    SSBNoneTransferableFK_UDB.appendNewLine(stringBuffer2, bl, 0);
                }
                this.appendFKNoneTransferableOptionalTrigger(stringBuffer2, tableProxy, list, true);
                this.appendToBuffer(stringBuffer, stringBuffer2, string);
                SSBNoneTransferableFK_UDB.appendNewLine(stringBuffer2, bl, 0);
                this.appendToBuffer(stringBuffer, stringBuffer2, string);
            }
            if ((list = SSBNoneTransferableFKOracle.getColumnsInMandatoryFK(table)).size() > 0) {
                stringBuffer2 = new StringBuffer();
                string = "create Non Transferable FK constraint UPDATE trigger for table " + this.storageDesign.getFormatedName(tableProxy.getLongName());
                if (DDLFileMaker.getddlAdvancedGenenerator() == null) {
                    SSBNoneTransferableFK_UDB.appendNewLine(stringBuffer2, bl, 0);
                    SSBNoneTransferableFK_UDB.appendNewLine(stringBuffer2, bl, 0);
                }
                this.appendFKNoneTransferableMandatoryTrigger(stringBuffer2, tableProxy, list, true);
                this.appendToBuffer(stringBuffer, stringBuffer2, string);
                SSBNoneTransferableFK_UDB.appendNewLine(stringBuffer2, bl, 0);
                this.appendToBuffer(stringBuffer, stringBuffer2, string);
            }
        }
    }

    private void appendFKNoneTransferableOptionalTrigger(StringBuffer stringBuffer, TableProxy tableProxy, List list, boolean bl) {
        String string;
        String string2 = this.makeTriggerName(tableProxy, "O");
        String string3 = "";
        boolean bl2 = true;
        for (Column column : list) {
            string = this.storageDesign.getFormatedName(column.getName());
            if (bl2) {
                string3 = string;
                bl2 = false;
                continue;
            }
            string3 = string3 + "," + string;
        }
        SSBNoneTransferableFK_UDB.appendStringWithSpace(stringBuffer, "CREATE TRIGGER " + string2);
        SSBNoneTransferableFK_UDB.appendNewLine(stringBuffer, bl, 0);
        SSBNoneTransferableFK_UDB.appendStringWithSpace(stringBuffer, "NO CASCADE BEFORE UPDATE OF " + string3);
        SSBNoneTransferableFK_UDB.appendNewLine(stringBuffer, bl, 0);
        SSBNoneTransferableFK_UDB.appendStringWithSpace(stringBuffer, "ON " + this.storageDesign.getFormatedName(tableProxy.getLongName()));
        SSBNoneTransferableFK_UDB.appendNewLine(stringBuffer, bl, 0);
        SSBNoneTransferableFK_UDB.appendStringWithSpace(stringBuffer, "REFERENCING OLD AS O");
        SSBNoneTransferableFK_UDB.appendNewLine(stringBuffer, bl, 0);
        SSBNoneTransferableFK_UDB.appendStringWithSpace(stringBuffer, "FOR EACH ROW MODE DB2SQL");
        SSBNoneTransferableFK_UDB.appendNewLine(stringBuffer, bl, 0);
        SSBNoneTransferableFK_UDB.appendStringWithSpace(stringBuffer, "BEGIN ATOMIC");
        SSBNoneTransferableFK_UDB.appendNewLine(stringBuffer, bl, 0);
        for (Column column : list) {
            string = "";
            FKIndexAssociation fKIndexAssociation = column.getFKIndexAssociation();
            if (fKIndexAssociation != null && !fKIndexAssociation.isTransferable() && !fKIndexAssociation.isMandatory()) {
                string = fKIndexAssociation.getName();
            }
            SSBNoneTransferableFK_UDB.appendStringWithSpace(stringBuffer, " IF O." + this.storageDesign.getFormatedName(column.getName()) + " IS NOT NULL THEN");
            SSBNoneTransferableFK_UDB.appendNewLine(stringBuffer, bl, 0);
            SSBNoneTransferableFK_UDB.appendStringWithSpace(stringBuffer, "  signal SQLSTATE '85002' ('Non Transferable FK constraint " + string + " on table " + this.storageDesign.getFormatedName(tableProxy.getLongName()) + " is violated');");
            SSBNoneTransferableFK_UDB.appendNewLine(stringBuffer, bl, 0);
            SSBNoneTransferableFK_UDB.appendStringWithSpace(stringBuffer, " END IF;");
            SSBNoneTransferableFK_UDB.appendNewLine(stringBuffer, bl, 0);
        }
        SSBNoneTransferableFK_UDB.appendStringWithSpace(stringBuffer, "END");
        SSBNoneTransferableFK_UDB.appendNewLine(stringBuffer, bl, 0);
        this.appendLineFinisher(stringBuffer, bl);
    }

    private void appendFKNoneTransferableMandatoryTrigger(StringBuffer stringBuffer, TableProxy tableProxy, List list, boolean bl) {
        String string = this.makeTriggerName(tableProxy, "M");
        String string2 = "";
        boolean bl2 = true;
        HashMap<String, FKIndexAssociation> hashMap = new HashMap<String, FKIndexAssociation>();
        String string3 = "";
        for (Column column : list) {
            Object v;
            FKIndexAssociation fKIndexAssociation;
            String string4 = this.storageDesign.getFormatedName(column.getName());
            if (bl2) {
                string2 = string4;
                bl2 = false;
            } else {
                string2 = string2 + "," + string4;
            }
            if ((fKIndexAssociation = column.getFKIndexAssociation()) == null || fKIndexAssociation.isTransferable() || fKIndexAssociation.isMandatory() || (v = hashMap.get(fKIndexAssociation.getObjectID())) != null) continue;
            hashMap.put(fKIndexAssociation.getObjectID(), fKIndexAssociation);
            if (hashMap.size() > 1) {
                string3 = string3 + " ," + fKIndexAssociation.getName();
                continue;
            }
            string3 = fKIndexAssociation.getName();
        }
        SSBNoneTransferableFK_UDB.appendStringWithSpace(stringBuffer, "CREATE TRIGGER " + this.storageDesign.getFormatedName(string));
        SSBNoneTransferableFK_UDB.appendNewLine(stringBuffer, bl, 0);
        SSBNoneTransferableFK_UDB.appendStringWithSpace(stringBuffer, "NO CASCADE BEFORE UPDATE OF " + string2);
        SSBNoneTransferableFK_UDB.appendNewLine(stringBuffer, bl, 0);
        SSBNoneTransferableFK_UDB.appendStringWithSpace(stringBuffer, "ON " + this.storageDesign.getFormatedName(tableProxy.getLongName()));
        SSBNoneTransferableFK_UDB.appendNewLine(stringBuffer, bl, 0);
        SSBNoneTransferableFK_UDB.appendStringWithSpace(stringBuffer, "FOR EACH ROW MODE DB2SQL");
        SSBNoneTransferableFK_UDB.appendNewLine(stringBuffer, bl, 0);
        SSBNoneTransferableFK_UDB.appendStringWithSpace(stringBuffer, "BEGIN ATOMIC");
        SSBNoneTransferableFK_UDB.appendNewLine(stringBuffer, bl, 0);
        SSBNoneTransferableFK_UDB.appendStringWithSpace(stringBuffer, "  signal SQLSTATE '85003' ('Non Transferable FK constraint " + string3 + " on table " + this.storageDesign.getFormatedName(tableProxy.getLongName()) + " is violated');");
        SSBNoneTransferableFK_UDB.appendNewLine(stringBuffer, bl, 0);
        SSBNoneTransferableFK_UDB.appendStringWithSpace(stringBuffer, "END");
        SSBNoneTransferableFK_UDB.appendNewLine(stringBuffer, bl, 0);
        this.appendLineFinisher(stringBuffer, bl);
    }

    private String makeTriggerName(TableProxy tableProxy, String string) {
        String string2 = "";
        int n = 18;
        if (this.storageDesign instanceof StorageDesignUDB) {
            string2 = "FN" + string + "_";
        } else if (this.storageDesign instanceof StorageDesignDB2v70) {
            string2 = "FN" + string;
            n = 8;
        } else if (this.storageDesign instanceof StorageDesignDB2v80) {
            string2 = "FKNT_" + string + "_";
            n = 128;
        }
        string2 = string2 + this.getStringWithMaxLength(tableProxy.getName(), n - string2.length());
        if (tableProxy.getUserSchema() != null) {
            string2 = this.storageDesign.getFormatedName(tableProxy.getUserSchema().getName()) + "." + this.storageDesign.getFormatedName(string2);
        }
        return string2;
    }
}

