/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.udb;

import oracle.dbtools.crest.exports.ddl.udb.AbstractSSBUDB;
import oracle.dbtools.crest.model.design.datatypes.Method;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.udb.MethodParamProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.MethodProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.StructuredTypeProxyUDB;

public class SSBMethodUDB
extends AbstractSSBUDB {
    @Override
    public boolean canHandle(Object object) {
        return object instanceof MethodProxyUDB || object instanceof Method;
    }

    @Override
    protected void doAppend(StringBuffer stringBuffer, Object object, boolean bl) {
        MethodProxyUDB methodProxyUDB;
        if (!(object instanceof Method) && object instanceof MethodProxyUDB && !(methodProxyUDB = (MethodProxyUDB)object).getStructuredType().isPredefined()) {
            SSBMethodUDB.appendNewLine(stringBuffer, bl, 0);
            this.appendComment(stringBuffer, methodProxyUDB);
            this.appendDefinition(stringBuffer, methodProxyUDB, bl);
            SSBMethodUDB.appendNewLine(stringBuffer, bl, 0);
            this.appendLineFinisher(stringBuffer, bl);
        }
    }

    private void appendDefinition(StringBuffer stringBuffer, MethodProxyUDB methodProxyUDB, boolean bl) {
        SSBMethodUDB.appendNewLine(stringBuffer, bl, 0);
        SSBMethodUDB.appendStringWithSpace(stringBuffer, "CREATE");
        if (!"".equalsIgnoreCase(methodProxyUDB.getSpecificName())) {
            SSBMethodUDB.appendStringWithSpace(stringBuffer, "SPECIFIC");
            SSBMethodUDB.appendStringWithSpace(stringBuffer, "METHOD");
            SSBMethodUDB.appendStringWithSpace(stringBuffer, methodProxyUDB.getStorageDesign().getFormatedName(methodProxyUDB.getSpecificName()));
        } else {
            Object object;
            SSBMethodUDB.appendStringWithSpace(stringBuffer, "METHOD");
            SSBMethodUDB.appendStringWithSpace(stringBuffer, methodProxyUDB.getStorageDesign().getFormatedName(methodProxyUDB.getName()));
            if (methodProxyUDB.getParams().size() > 0) {
                SSBMethodUDB.appendNewLine(stringBuffer, bl, 1);
                SSBMethodUDB.appendStringWithSpace(stringBuffer, '(');
                object = methodProxyUDB.getParams().iterator();
                while (object.hasNext()) {
                    MethodParamProxyUDB methodParamProxyUDB = (MethodParamProxyUDB)object.next();
                    SSBMethodUDB.appendNewLine(stringBuffer, bl, 1);
                    SSBMethodUDB.appendString(stringBuffer, ' ');
                    SSBMethodUDB.appendStringWithSpace(stringBuffer, methodParamProxyUDB.getName());
                    SSBMethodUDB.appendStringWithSpace(stringBuffer, methodParamProxyUDB.getMethodParam().getDataType());
                    if (methodParamProxyUDB.isAsLocator()) {
                        SSBMethodUDB.appendStringWithSpace(stringBuffer, "AS LOCATOR");
                    }
                    if (!object.hasNext()) continue;
                    SSBMethodUDB.appendStringWithSpace(stringBuffer, ',');
                }
                SSBMethodUDB.appendNewLine(stringBuffer, bl, 1);
                SSBMethodUDB.appendStringWithSpace(stringBuffer, ')');
            }
            if (!"".equalsIgnoreCase(methodProxyUDB.getReturnValue())) {
                SSBMethodUDB.appendNewLine(stringBuffer, bl, 1);
                SSBMethodUDB.appendStringWithSpace(stringBuffer, "RETURNS");
                SSBMethodUDB.appendStringWithSpace(stringBuffer, methodProxyUDB.getReturnValue());
            }
            SSBMethodUDB.appendNewLine(stringBuffer, bl, 1);
            SSBMethodUDB.appendStringWithSpace(stringBuffer, "FOR");
            object = (StructuredTypeProxyUDB)methodProxyUDB.getStorageDesign().getProxy(methodProxyUDB.getStructuredType());
            if (((StructuredTypeProxyUDB)object).getSchema() != null) {
                this.appendString(stringBuffer, ((StructuredTypeProxyUDB)object).getSchema());
                SSBMethodUDB.appendString(stringBuffer, '.');
            }
            SSBMethodUDB.appendStringWithSpace(stringBuffer, ((RelationalObjectProxy)object).getName());
        }
        if ("SQL".equalsIgnoreCase(methodProxyUDB.getLanguage())) {
            if (!"".equalsIgnoreCase(methodProxyUDB.getSqlMethodBody())) {
                SSBMethodUDB.appendNewLine(stringBuffer, bl, 1);
                SSBMethodUDB.appendStringWithSpace(stringBuffer, "RETURN");
                SSBMethodUDB.appendStringWithSpace(stringBuffer, methodProxyUDB.getSqlMethodBody());
            }
        } else {
            if (!"".equalsIgnoreCase(methodProxyUDB.getExt_R_Name())) {
                SSBMethodUDB.appendNewLine(stringBuffer, bl, 1);
                SSBMethodUDB.appendStringWithSpace(stringBuffer, "EXTERNAL");
                SSBMethodUDB.appendStringWithSpace(stringBuffer, "NAME");
                SSBMethodUDB.appendStringWithSpace(stringBuffer, methodProxyUDB.getExt_R_Name());
            }
            if (!"".equalsIgnoreCase(methodProxyUDB.getExt_R_TransformGroup())) {
                SSBMethodUDB.appendNewLine(stringBuffer, bl, 1);
                SSBMethodUDB.appendStringWithSpace(stringBuffer, "TRANSFORM");
                SSBMethodUDB.appendStringWithSpace(stringBuffer, "GROUP");
                SSBMethodUDB.appendStringWithSpace(stringBuffer, methodProxyUDB.getExt_R_TransformGroup());
            }
        }
    }
}

