/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.udb;

import oracle.dbtools.crest.exports.ddl.udb.AbstractSSBUDB;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.storage.udb.StructuredTypeProxyUDB;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBIncompleteStructuredTypeUDB
extends AbstractSSBUDB {
    @Override
    public boolean canHandle(Object object) {
        if (object instanceof StructuredTypeProxyUDB && ((StructuredTypeProxyUDB)object).isMarkedGenerate()) {
            return true;
        }
        return object instanceof StructuredType && ((StructuredType)object).isMarkedGenerate();
    }

    @Override
    protected void doAppend(StringBuffer stringBuffer, Object object, boolean bl) {
        if (object instanceof StructuredType) {
            StructuredType structuredType = (StructuredType)object;
            SSBIncompleteStructuredTypeUDB.appendNewLine(stringBuffer, bl, 0);
            this.appendComment(stringBuffer, structuredType);
            this.appendIncompleteDefinition(stringBuffer, structuredType, bl);
            DDLFileMaker.incrementCreateStructuredType();
        } else if (object instanceof StructuredTypeProxyUDB) {
            StructuredTypeProxyUDB structuredTypeProxyUDB = (StructuredTypeProxyUDB)object;
            StructuredType structuredType = structuredTypeProxyUDB.getStructuredType();
            SSBIncompleteStructuredTypeUDB.appendNewLine(stringBuffer, bl, 0);
            this.appendComment(stringBuffer, structuredTypeProxyUDB);
            boolean bl2 = structuredType.getDesign().hasUsageOfStructuredType(structuredType);
            if (!structuredType.isInstantiable() && bl2) {
                SSBIncompleteStructuredTypeUDB.appendNewLine(stringBuffer, true, 0);
                SSBIncompleteStructuredTypeUDB.appendStringWithSpace(stringBuffer, "--  ERROR: Type " + structuredType.getName() + " is defined as not instantiable but it's used");
                SSBIncompleteStructuredTypeUDB.appendNewLine(stringBuffer, true, 0);
                SSBIncompleteStructuredTypeUDB.appendStringWithSpace(stringBuffer, "--  in table/view definition - generated as instantiable");
                SSBIncompleteStructuredTypeUDB.appendNewLine(stringBuffer, true, 0);
                DDLFileMaker.incrementErrors();
            }
            if (!structuredType.isPredefined()) {
                this.appendIncompleteDefinition(stringBuffer, structuredTypeProxyUDB, bl);
                DDLFileMaker.incrementCreateStructuredType();
            }
        }
    }

    private void appendIncompleteDefinition(StringBuffer stringBuffer, StructuredType structuredType, boolean bl) {
        SSBIncompleteStructuredTypeUDB.appendNewLine(stringBuffer, bl, 0);
        SSBIncompleteStructuredTypeUDB.appendStringWithSpace(stringBuffer, "CREATE");
        SSBIncompleteStructuredTypeUDB.appendStringWithSpace(stringBuffer, "TYPE");
        SSBIncompleteStructuredTypeUDB.appendStringWithSpace(stringBuffer, structuredType.getName());
        SSBIncompleteStructuredTypeUDB.appendNewLine(stringBuffer, bl, 0);
        this.appendLineFinisher(stringBuffer, bl);
        SSBIncompleteStructuredTypeUDB.appendNewLine(stringBuffer, bl, 0);
    }

    private void appendIncompleteDefinition(StringBuffer stringBuffer, StructuredTypeProxyUDB structuredTypeProxyUDB, boolean bl) {
        StructuredType structuredType = structuredTypeProxyUDB.getStructuredType();
        SSBIncompleteStructuredTypeUDB.appendNewLine(stringBuffer, bl, 0);
        SSBIncompleteStructuredTypeUDB.appendStringWithSpace(stringBuffer, "CREATE");
        SSBIncompleteStructuredTypeUDB.appendStringWithSpace(stringBuffer, "TYPE");
        if (structuredTypeProxyUDB.getSchema() != null) {
            SSBIncompleteStructuredTypeUDB.appendString(stringBuffer, structuredTypeProxyUDB.getStorageDesign().getFormatedName(structuredTypeProxyUDB.getSchema().getName()));
            SSBIncompleteStructuredTypeUDB.appendString(stringBuffer, '.');
        }
        SSBIncompleteStructuredTypeUDB.appendStringWithSpace(stringBuffer, structuredTypeProxyUDB.getStorageDesign().getFormatedName(structuredTypeProxyUDB.getName()));
        if (structuredTypeProxyUDB.hasParentType()) {
            StructuredTypeProxyUDB structuredTypeProxyUDB2 = (StructuredTypeProxyUDB)structuredTypeProxyUDB.getParentType();
            SSBIncompleteStructuredTypeUDB.appendStringWithSpace(stringBuffer, "UNDER");
            if (structuredTypeProxyUDB.getSchema() != null) {
                this.appendString(stringBuffer, structuredTypeProxyUDB2.getSchema());
                SSBIncompleteStructuredTypeUDB.appendString(stringBuffer, '.');
            }
            SSBIncompleteStructuredTypeUDB.appendStringWithSpace(stringBuffer, structuredTypeProxyUDB2.getName());
        }
        boolean bl2 = structuredType.getDesign().hasUsageOfStructuredType(structuredType);
        SSBIncompleteStructuredTypeUDB.appendNewLine(stringBuffer, bl, 1);
        if (!structuredType.isInstantiable() && !bl2) {
            SSBIncompleteStructuredTypeUDB.appendStringWithSpace(stringBuffer, "NOT");
        }
        SSBIncompleteStructuredTypeUDB.appendStringWithSpace(stringBuffer, "INSTANTIABLE");
        if (!"".equalsIgnoreCase(structuredTypeProxyUDB.getInlineLength())) {
            SSBIncompleteStructuredTypeUDB.appendNewLine(stringBuffer, bl, 1);
            SSBIncompleteStructuredTypeUDB.appendStringWithSpace(stringBuffer, "INLINE");
            SSBIncompleteStructuredTypeUDB.appendStringWithSpace(stringBuffer, "LENGTH");
            SSBIncompleteStructuredTypeUDB.appendStringWithSpace(stringBuffer, structuredTypeProxyUDB.getInlineLength());
        }
        if (!structuredType.isFinal()) {
            SSBIncompleteStructuredTypeUDB.appendNewLine(stringBuffer, bl, 1);
            SSBIncompleteStructuredTypeUDB.appendStringWithSpace(stringBuffer, "NOT");
            SSBIncompleteStructuredTypeUDB.appendStringWithSpace(stringBuffer, "FINAL");
        }
        SSBIncompleteStructuredTypeUDB.appendNewLine(stringBuffer, bl, 1);
        SSBIncompleteStructuredTypeUDB.appendStringWithSpace(stringBuffer, "MODE DB2SQL");
        if ("YES".equalsIgnoreCase(structuredTypeProxyUDB.getWithFunctionAccess())) {
            SSBIncompleteStructuredTypeUDB.appendNewLine(stringBuffer, bl, 1);
            SSBIncompleteStructuredTypeUDB.appendStringWithSpace(stringBuffer, "WITH");
            SSBIncompleteStructuredTypeUDB.appendStringWithSpace(stringBuffer, "FUNCTION");
            SSBIncompleteStructuredTypeUDB.appendStringWithSpace(stringBuffer, "ACCESS");
        }
        if (structuredTypeProxyUDB.getType() != null) {
            SSBIncompleteStructuredTypeUDB.appendNewLine(stringBuffer, bl, 1);
            SSBIncompleteStructuredTypeUDB.appendStringWithSpace(stringBuffer, "REF");
            SSBIncompleteStructuredTypeUDB.appendStringWithSpace(stringBuffer, "USING");
            SSBIncompleteStructuredTypeUDB.appendStringWithSpace(stringBuffer, structuredTypeProxyUDB.getDataType());
        }
        if (!"".equalsIgnoreCase(structuredTypeProxyUDB.getRefType2RefCastFunction())) {
            SSBIncompleteStructuredTypeUDB.appendNewLine(stringBuffer, bl, 1);
            SSBIncompleteStructuredTypeUDB.appendStringWithSpace(stringBuffer, "CAST");
            SSBIncompleteStructuredTypeUDB.appendStringWithSpace(stringBuffer, "(SOURCE AS REF)");
            SSBIncompleteStructuredTypeUDB.appendStringWithSpace(stringBuffer, "WITH");
            SSBIncompleteStructuredTypeUDB.appendStringWithSpace(stringBuffer, structuredTypeProxyUDB.getRefType2RefCastFunction());
        }
        if (!"".equalsIgnoreCase(structuredTypeProxyUDB.getRef2RefTypeCastFunction())) {
            SSBIncompleteStructuredTypeUDB.appendNewLine(stringBuffer, bl, 1);
            SSBIncompleteStructuredTypeUDB.appendStringWithSpace(stringBuffer, "CAST");
            SSBIncompleteStructuredTypeUDB.appendStringWithSpace(stringBuffer, "(REF AS SOURCE)");
            SSBIncompleteStructuredTypeUDB.appendStringWithSpace(stringBuffer, "WITH");
            SSBIncompleteStructuredTypeUDB.appendStringWithSpace(stringBuffer, structuredTypeProxyUDB.getRef2RefTypeCastFunction());
        }
        SSBIncompleteStructuredTypeUDB.appendNewLine(stringBuffer, bl, 0);
        this.appendLineFinisher(stringBuffer, bl);
        SSBIncompleteStructuredTypeUDB.appendNewLine(stringBuffer, bl, 0);
    }
}

