/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.udb;

import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.exports.ddl.AbstractSSBDB2;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKArc;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.db2.v70.StorageDesignDB2v70;
import oracle.dbtools.crest.model.design.storage.db2.v80.StorageDesignDB2v80;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBArcFK_UDB
extends AbstractSSBDB2 {
    private StorageDesign storageDesign;
    int arc_index = 0;

    public SSBArcFK_UDB(StorageDesign storageDesign) {
        this.storageDesign = storageDesign;
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof FKArc;
    }

    @Override
    protected void doAppend(StringBuffer stringBuffer, Object object, boolean bl) {
        FKArc fKArc = (FKArc)object;
        if (fKArc.getDesign().getAppView().getSettings().isGenerateFKArcTriggers()) {
            StringBuffer stringBuffer2 = new StringBuffer();
            String string = "";
            Table table = fKArc.getTable();
            List list = this.getColumnsInArc(table, fKArc);
            if (table != null && fKArc.getFkeys().size() > 1 && list.size() > 0) {
                this.arc_index = table.getArcs().indexOf(fKArc) + 1;
                this.appendComment(stringBuffer, fKArc);
                TableProxy tableProxy = (TableProxy)this.storageDesign.getTableProxySet().getProxy(table.getObjectID());
                string = "create Arc constraint INSERT trigger for table " + tableProxy.getLongName();
                if (DDLFileMaker.getddlAdvancedGenenerator() == null) {
                    SSBArcFK_UDB.appendNewLine(stringBuffer2, bl, 0);
                }
                this.appendArcInsertTrigger(stringBuffer2, fKArc, tableProxy, list, true);
                this.appendToBuffer(stringBuffer, stringBuffer2, string);
                SSBArcFK_UDB.appendNewLine(stringBuffer2, bl, 0);
                this.appendToBuffer(stringBuffer, stringBuffer2, string);
                stringBuffer2 = new StringBuffer();
                string = "create Arc constraint UPDATE trigger for table " + this.storageDesign.getFormatedName(tableProxy.getLongName());
                if (DDLFileMaker.getddlAdvancedGenenerator() == null) {
                    SSBArcFK_UDB.appendNewLine(stringBuffer2, bl, 0);
                    SSBArcFK_UDB.appendNewLine(stringBuffer2, bl, 0);
                }
                this.appendArcUpdateTrigger(stringBuffer2, fKArc, tableProxy, list, true);
                this.appendToBuffer(stringBuffer, stringBuffer2, string);
                SSBArcFK_UDB.appendNewLine(stringBuffer2, bl, 0);
                this.appendToBuffer(stringBuffer, stringBuffer2, string);
            }
        }
    }

    private List getColumnsInArc(Table table, FKArc fKArc) {
        ArrayList<Column> arrayList = new ArrayList<Column>();
        for (FKIndexAssociation fKIndexAssociation : fKArc.getFkeys()) {
            for (Column column : fKIndexAssociation.getLocalFKIndex().getElementsCollection()) {
                arrayList.add(column);
            }
        }
        return arrayList;
    }

    private void appendArcInsertTrigger(StringBuffer stringBuffer, FKArc fKArc, TableProxy tableProxy, List list, boolean bl) {
        String string = this.makeTriggerName(tableProxy, "I");
        SSBArcFK_UDB.appendStringWithSpace(stringBuffer, "CREATE TRIGGER " + this.storageDesign.getFormatedName(string));
        SSBArcFK_UDB.appendNewLine(stringBuffer, bl, 0);
        SSBArcFK_UDB.appendStringWithSpace(stringBuffer, "NO CASCADE BEFORE INSERT ON " + this.storageDesign.getFormatedName(tableProxy.getLongName()));
        SSBArcFK_UDB.appendNewLine(stringBuffer, bl, 0);
        SSBArcFK_UDB.appendStringWithSpace(stringBuffer, "REFERENCING NEW AS N");
        SSBArcFK_UDB.appendNewLine(stringBuffer, bl, 0);
        SSBArcFK_UDB.appendStringWithSpace(stringBuffer, "FOR EACH ROW MODE DB2SQL");
        SSBArcFK_UDB.appendNewLine(stringBuffer, bl, 0);
        SSBArcFK_UDB.appendStringWithSpace(stringBuffer, "BEGIN ATOMIC");
        SSBArcFK_UDB.appendNewLine(stringBuffer, bl, 0);
        SSBArcFK_UDB.appendStringWithSpace(stringBuffer, " DECLARE i SMALLINT DEFAULT 0;");
        SSBArcFK_UDB.appendNewLine(stringBuffer, bl, 0);
        for (Column column : list) {
            SSBArcFK_UDB.appendStringWithSpace(stringBuffer, " IF N." + column.getName() + " IS NOT NULL THEN");
            SSBArcFK_UDB.appendNewLine(stringBuffer, bl, 0);
            SSBArcFK_UDB.appendStringWithSpace(stringBuffer, "  SET i = i+1;");
            SSBArcFK_UDB.appendNewLine(stringBuffer, bl, 0);
            SSBArcFK_UDB.appendStringWithSpace(stringBuffer, " END IF;");
            SSBArcFK_UDB.appendNewLine(stringBuffer, bl, 0);
        }
        SSBArcFK_UDB.appendStringWithSpace(stringBuffer, " IF i>1 THEN");
        SSBArcFK_UDB.appendNewLine(stringBuffer, bl, 0);
        SSBArcFK_UDB.appendStringWithSpace(stringBuffer, "  signal SQLSTATE '85001' ('Arc constraint on " + this.storageDesign.getFormatedName(tableProxy.getLongName()) + "-one value is permitted in FKs');");
        SSBArcFK_UDB.appendNewLine(stringBuffer, bl, 0);
        SSBArcFK_UDB.appendStringWithSpace(stringBuffer, " END IF;");
        SSBArcFK_UDB.appendNewLine(stringBuffer, bl, 0);
        if (fKArc.isMandatory()) {
            SSBArcFK_UDB.appendStringWithSpace(stringBuffer, " IF i=0 THEN");
            SSBArcFK_UDB.appendNewLine(stringBuffer, bl, 0);
            SSBArcFK_UDB.appendStringWithSpace(stringBuffer, "  signal SQLSTATE '85002' ('Mandatory Arc constraint on " + this.storageDesign.getFormatedName(tableProxy.getLongName()) + "-one value should be set in FKs');");
            SSBArcFK_UDB.appendNewLine(stringBuffer, bl, 0);
            SSBArcFK_UDB.appendStringWithSpace(stringBuffer, " END IF;");
            SSBArcFK_UDB.appendNewLine(stringBuffer, bl, 0);
        }
        SSBArcFK_UDB.appendStringWithSpace(stringBuffer, "END");
        SSBArcFK_UDB.appendNewLine(stringBuffer, bl, 0);
        this.appendLineFinisher(stringBuffer, bl);
    }

    private void appendArcUpdateTrigger(StringBuffer stringBuffer, FKArc fKArc, TableProxy tableProxy, List list, boolean bl) {
        String string = this.makeTriggerName(tableProxy, "U");
        String string2 = "";
        boolean bl2 = true;
        for (Column column : list) {
            String string3 = this.storageDesign.getFormatedName(column.getName());
            if (bl2) {
                string2 = string3;
                bl2 = false;
                continue;
            }
            string2 = string2 + "," + string3;
        }
        SSBArcFK_UDB.appendStringWithSpace(stringBuffer, "CREATE TRIGGER " + this.storageDesign.getFormatedName(string));
        SSBArcFK_UDB.appendNewLine(stringBuffer, bl, 0);
        SSBArcFK_UDB.appendStringWithSpace(stringBuffer, "NO CASCADE BEFORE UPDATE OF " + string2);
        SSBArcFK_UDB.appendNewLine(stringBuffer, bl, 0);
        SSBArcFK_UDB.appendStringWithSpace(stringBuffer, "ON " + this.storageDesign.getFormatedName(tableProxy.getLongName()));
        SSBArcFK_UDB.appendNewLine(stringBuffer, bl, 0);
        SSBArcFK_UDB.appendStringWithSpace(stringBuffer, "REFERENCING NEW AS N");
        SSBArcFK_UDB.appendNewLine(stringBuffer, bl, 0);
        SSBArcFK_UDB.appendStringWithSpace(stringBuffer, "FOR EACH ROW MODE DB2SQL");
        SSBArcFK_UDB.appendNewLine(stringBuffer, bl, 0);
        SSBArcFK_UDB.appendStringWithSpace(stringBuffer, "BEGIN ATOMIC");
        SSBArcFK_UDB.appendNewLine(stringBuffer, bl, 0);
        SSBArcFK_UDB.appendStringWithSpace(stringBuffer, " DECLARE i SMALLINT DEFAULT 0;");
        SSBArcFK_UDB.appendNewLine(stringBuffer, bl, 0);
        for (Column column : list) {
            SSBArcFK_UDB.appendStringWithSpace(stringBuffer, " IF N." + column.getName() + " IS NOT NULL THEN");
            SSBArcFK_UDB.appendNewLine(stringBuffer, bl, 0);
            SSBArcFK_UDB.appendStringWithSpace(stringBuffer, "  SET i = i+1;");
            SSBArcFK_UDB.appendNewLine(stringBuffer, bl, 0);
            SSBArcFK_UDB.appendStringWithSpace(stringBuffer, " END IF;");
            SSBArcFK_UDB.appendNewLine(stringBuffer, bl, 0);
        }
        SSBArcFK_UDB.appendStringWithSpace(stringBuffer, " IF i>1 THEN");
        SSBArcFK_UDB.appendNewLine(stringBuffer, bl, 0);
        SSBArcFK_UDB.appendStringWithSpace(stringBuffer, "  signal SQLSTATE '85001' ('Arc constraint on " + this.storageDesign.getFormatedName(tableProxy.getLongName()) + "-one value is permitted in FKs');");
        SSBArcFK_UDB.appendNewLine(stringBuffer, bl, 0);
        SSBArcFK_UDB.appendStringWithSpace(stringBuffer, " END IF;");
        SSBArcFK_UDB.appendNewLine(stringBuffer, bl, 0);
        if (fKArc.isMandatory()) {
            SSBArcFK_UDB.appendStringWithSpace(stringBuffer, " IF i=0 THEN");
            SSBArcFK_UDB.appendNewLine(stringBuffer, bl, 0);
            SSBArcFK_UDB.appendStringWithSpace(stringBuffer, "  signal SQLSTATE '85002' ('Mandatory Arc constraint on " + this.storageDesign.getFormatedName(tableProxy.getLongName()) + "-one value should be set in FKs');");
            SSBArcFK_UDB.appendNewLine(stringBuffer, bl, 0);
            SSBArcFK_UDB.appendStringWithSpace(stringBuffer, " END IF;");
            SSBArcFK_UDB.appendNewLine(stringBuffer, bl, 0);
        }
        SSBArcFK_UDB.appendStringWithSpace(stringBuffer, "END");
        SSBArcFK_UDB.appendNewLine(stringBuffer, bl, 0);
        this.appendLineFinisher(stringBuffer, bl);
    }

    private String makeTriggerName(TableProxy tableProxy, String string) {
        String string2 = "";
        int n = 18;
        if (this.storageDesign instanceof StorageDesignUDB) {
            string2 = "A" + string + this.arc_index + "_";
        } else if (this.storageDesign instanceof StorageDesignDB2v70) {
            string2 = "A" + string + this.arc_index;
            n = 8;
        } else if (this.storageDesign instanceof StorageDesignDB2v80) {
            string2 = "ARCTR_" + string + this.arc_index + "_";
            n = 128;
        }
        string2 = this.storageDesign.getFormatedName(string2 + this.getStringWithMaxLength(tableProxy.getName(), n - string2.length()));
        if (tableProxy.getUserSchema() != null) {
            string2 = this.storageDesign.getFormatedName(tableProxy.getUserSchema().getName()) + "." + string2;
        }
        return string2;
    }
}

