/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.sqlserver.v2k5;

import java.util.Iterator;
import oracle.dbtools.crest.exports.ddl.oracle.SSBArcFK_CheckConstr;
import oracle.dbtools.crest.exports.ddl.sqlserver.AbstractSSBSqlServer;
import oracle.dbtools.crest.exports.ddl.sqlserver.v2k5.SSBIndexSqlServerv2k5;
import oracle.dbtools.crest.exports.ddl.sqlserver.v2k5.SSBXMLIndexSqlServerv2k5;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.DesignObjectPlaceHolder;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.sqlserver.ColumnProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.InstanceDescriptorColumnSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.ColumnProxySqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.PKProxySqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.StorageDesignSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.TableProxySqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.UniqueProxySqlServerv2k5;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBTableSqlServerv2k5
extends AbstractSSBSqlServer {
    private StorageDesignSqlServerv2k5 storageDesign;
    private SSBIndexSqlServerv2k5 ssbIndex = new SSBIndexSqlServerv2k5();
    private SSBXMLIndexSqlServerv2k5 ssbXMLIndex = new SSBXMLIndexSqlServerv2k5();
    boolean canWriteComma = true;
    private SSBArcFK_CheckConstr arcConstrHandler;

    @Override
    protected void doAppend(StringBuffer stringBuffer, Object object, boolean bl) {
        Table table = null;
        TableProxySqlServerv2k5 tableProxySqlServerv2k5 = null;
        if (object == null) {
            return;
        }
        if (object instanceof Table) {
            table = (Table)object;
            this.storageDesign = (StorageDesignSqlServerv2k5)this.getStorageDesign(object);
            tableProxySqlServerv2k5 = (TableProxySqlServerv2k5)this.storageDesign.getTableProxySet().getProxy(table.getObjectID());
        } else if (object instanceof TableProxySqlServerv2k5) {
            tableProxySqlServerv2k5 = (TableProxySqlServerv2k5)object;
            table = (Table)tableProxySqlServerv2k5.getObject();
            this.storageDesign = (StorageDesignSqlServerv2k5)this.getStorageDesign(object);
        }
        if (tableProxySqlServerv2k5 != null && !tableProxySqlServerv2k5.isMarkedGenerate()) {
            this.appendIndexes(stringBuffer, tableProxySqlServerv2k5, bl);
            return;
        }
        if (table != null) {
            SSBTableSqlServerv2k5.appendNewLine(stringBuffer, bl, 0);
            this.appendBeforeCreateScript(stringBuffer, bl, table);
            if (tableProxySqlServerv2k5 != null && tableProxySqlServerv2k5.isCommentChanged()) {
                this.appendComment(stringBuffer, tableProxySqlServerv2k5);
            } else {
                this.appendComment(stringBuffer, table);
            }
            if (tableProxySqlServerv2k5 != null) {
                SSBTableSqlServerv2k5.appendNewLine(stringBuffer, bl, 0);
                this.appendDataBase(stringBuffer, tableProxySqlServerv2k5.getDatabase(), bl);
                SSBTableSqlServerv2k5.appendNewLine(stringBuffer, bl, 0);
                this.appendCreateTable(stringBuffer, tableProxySqlServerv2k5);
                this.appendColumns(stringBuffer, table, tableProxySqlServerv2k5, bl);
                this.appendFilegroup(stringBuffer, tableProxySqlServerv2k5, bl);
                this.appendTextImage(stringBuffer, tableProxySqlServerv2k5, bl);
                SSBTableSqlServerv2k5.appendNewLine(stringBuffer, bl, 0);
                SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, "GO");
                DDLFileMaker.incrementCreateTable();
                SSBTableSqlServerv2k5.appendNewLine(stringBuffer, bl, 0);
                this.appendAfterCreateScript(stringBuffer, bl, table);
                this.appendColumnCheckConstraints(stringBuffer, tableProxySqlServerv2k5, bl);
                if (this.getArcConstrHandler() != null) {
                    this.getArcConstrHandler().appendArcConstraints(stringBuffer, tableProxySqlServerv2k5, bl);
                }
                if (table.getDesign().getAppView().getSettings().isGenerateCommentsInRDBMS()) {
                    this.appendTableCommentOn(stringBuffer, table, tableProxySqlServerv2k5, bl);
                }
                this.appendBindDefault(stringBuffer, table, tableProxySqlServerv2k5, bl);
                this.appendExtProperties(stringBuffer, tableProxySqlServerv2k5, bl);
                this.appendColumnExtProperties(stringBuffer, table, tableProxySqlServerv2k5, bl);
                this.appendIndexes(stringBuffer, tableProxySqlServerv2k5, bl);
            } else {
                this.appendTableCommentOn(stringBuffer, table, tableProxySqlServerv2k5, bl);
            }
        }
    }

    private void appendIndexes(StringBuffer stringBuffer, TableProxySqlServerv2k5 tableProxySqlServerv2k5, boolean bl) {
        Iterator iterator = tableProxySqlServerv2k5.getIndexes().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (this.ssbXMLIndex.canHandle(e)) {
                this.ssbXMLIndex.doAppend(stringBuffer, e, bl);
                continue;
            }
            this.ssbIndex.doAppend(stringBuffer, e, bl);
        }
        this.appendIndexesForConstraints(stringBuffer, (Table)tableProxySqlServerv2k5.getObject(), tableProxySqlServerv2k5);
    }

    private void appendCreateTable(StringBuffer stringBuffer, TableProxySqlServerv2k5 tableProxySqlServerv2k5) {
        if (this.storageDesign.getFormatedName(tableProxySqlServerv2k5.getName()).length() > tableProxySqlServerv2k5.getMaxNameLength()) {
            SSBTableSqlServerv2k5.appendNewLine(stringBuffer, true, 0);
            SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, "--  ERROR: Table name length exceeds maximum allowed length(" + tableProxySqlServerv2k5.getMaxNameLength() + ")");
            SSBTableSqlServerv2k5.appendNewLine(stringBuffer, true, 0);
            DDLFileMaker.incrementErrors();
        }
        SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, "CREATE");
        SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, "TABLE");
        SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableProxySqlServerv2k5.getLongName()));
    }

    private void appendBindDefault(StringBuffer stringBuffer, Table table, TableProxySqlServerv2k5 tableProxySqlServerv2k5, boolean bl) {
        Column[] columnArray = (Column[])table.getElements();
        Column column = null;
        ColumnProxySqlServerv2k5 columnProxySqlServerv2k5 = null;
        SSBTableSqlServerv2k5.appendNewLine(stringBuffer, bl, 1);
        if (columnArray.length > 0) {
            for (int i = 0; i < columnArray.length; ++i) {
                if (tableProxySqlServerv2k5 == null || !(columnProxySqlServerv2k5 = (ColumnProxySqlServerv2k5)tableProxySqlServerv2k5.getColumnProxy((column = columnArray[i]).getObjectID())).getDefineDefault() || columnProxySqlServerv2k5.getDefaultObject() == null) continue;
                SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, "EXEC");
                SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, "sp_bindefault");
                SSBTableSqlServerv2k5.appendString(stringBuffer, '\'');
                SSBTableSqlServerv2k5.appendString(stringBuffer, columnProxySqlServerv2k5.getDefaultObject().getName());
                SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, '\'');
                this.appendComma(stringBuffer);
                SSBTableSqlServerv2k5.appendString(stringBuffer, '\'');
                SSBTableSqlServerv2k5.appendString(stringBuffer, columnProxySqlServerv2k5.getTableProxy().getName());
                SSBTableSqlServerv2k5.appendString(stringBuffer, '.');
                SSBTableSqlServerv2k5.appendString(stringBuffer, columnProxySqlServerv2k5.getName());
                SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, '\'');
                SSBTableSqlServerv2k5.appendNewLine(stringBuffer, bl, 0);
                SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, "GO");
                SSBTableSqlServerv2k5.appendNewLine(stringBuffer, bl, 0);
            }
        }
    }

    protected void appendColumns(StringBuffer stringBuffer, Table table, TableProxySqlServerv2k5 tableProxySqlServerv2k5, boolean bl) {
        Column[] columnArray = (Column[])table.getElements();
        Column column = null;
        ColumnProxySqlServerv2k5 columnProxySqlServerv2k5 = null;
        Object[] objectArray = null;
        if (tableProxySqlServerv2k5 != null) {
            objectArray = tableProxySqlServerv2k5.getInstanceDescriptorCols().toArray();
        }
        SSBTableSqlServerv2k5.appendNewLine(stringBuffer, bl, 1);
        if (columnArray.length == 0 && (objectArray == null || objectArray.length == 0)) {
            SSBTableSqlServerv2k5.appendNewLine(stringBuffer, bl, 1);
            stringBuffer.append("-- No columns");
            SSBTableSqlServerv2k5.appendNewLine(stringBuffer, bl, 1);
        } else {
            for (int i = 0; i < columnArray.length; ++i) {
                if (i == 0) {
                    SSBTableSqlServerv2k5.appendString(stringBuffer, '(');
                } else {
                    stringBuffer.append(", ");
                }
                SSBTableSqlServerv2k5.appendNewLine(stringBuffer, bl, 1);
                if (tableProxySqlServerv2k5 == null) continue;
                column = columnArray[i];
                columnProxySqlServerv2k5 = (ColumnProxySqlServerv2k5)tableProxySqlServerv2k5.getColumnProxy(column.getObjectID());
                if (columnProxySqlServerv2k5.getComputed()) {
                    SSBTableSqlServerv2k5.appendSpace(stringBuffer);
                    SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(columnProxySqlServerv2k5.getName()));
                    SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, "AS");
                    SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, columnProxySqlServerv2k5.getFormula());
                    if (!columnProxySqlServerv2k5.getPersistedProp().equalsIgnoreCase("YES")) continue;
                    SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, "PERSISTED");
                    continue;
                }
                this.appendColumnNameAndDataType(stringBuffer, columnProxySqlServerv2k5, bl);
                this.appendColumnNullsAllowed(stringBuffer, columnProxySqlServerv2k5);
                this.appendColate(stringBuffer, columnProxySqlServerv2k5);
                this.appendDefault(stringBuffer, columnProxySqlServerv2k5);
                this.appendIdentity(stringBuffer, columnProxySqlServerv2k5);
                this.appendRowGuidCow(stringBuffer, columnProxySqlServerv2k5);
                this.appendColumnConstraints(stringBuffer, column, columnProxySqlServerv2k5);
            }
            InstanceDescriptorColumnSqlServer instanceDescriptorColumnSqlServer = null;
            for (int i = 0; i < objectArray.length; ++i) {
                instanceDescriptorColumnSqlServer = (InstanceDescriptorColumnSqlServer)objectArray[i];
                if (columnArray.length == 0 && i == 0) {
                    SSBTableSqlServerv2k5.appendString(stringBuffer, '(');
                } else {
                    stringBuffer.append(", ");
                }
                SSBTableSqlServerv2k5.appendNewLine(stringBuffer, bl, 1);
                SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(instanceDescriptorColumnSqlServer.getName()));
                SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, instanceDescriptorColumnSqlServer.getDataType());
            }
            this.appendConstrants(stringBuffer, tableProxySqlServerv2k5, bl);
            this.appendTableConstraintsDefinition(stringBuffer, table, bl);
            SSBTableSqlServerv2k5.appendNewLine(stringBuffer, bl, 1);
            SSBTableSqlServerv2k5.appendString(stringBuffer, ')');
        }
    }

    private void appendFilegroup(StringBuffer stringBuffer, TableProxySqlServerv2k5 tableProxySqlServerv2k5, boolean bl) {
        SSBTableSqlServerv2k5.appendNewLine(stringBuffer, bl, 1);
        SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, "ON");
        if (tableProxySqlServerv2k5.getPartitionScheme() != null) {
            SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableProxySqlServerv2k5.getPartitionScheme().getName()));
            if (tableProxySqlServerv2k5.getPartitioningColumn() != null) {
                SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, '(');
                SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableProxySqlServerv2k5.getPartitioningColumn().getName()));
                SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, ')');
            }
        } else if (tableProxySqlServerv2k5.getFilegroup() != null) {
            SSBTableSqlServerv2k5.appendString(stringBuffer, this.storageDesign.getFormatedName(tableProxySqlServerv2k5.getFilegroup().getName()));
        } else {
            SSBTableSqlServerv2k5.appendString(stringBuffer, "\"default\"");
        }
    }

    private void appendTextImage(StringBuffer stringBuffer, TableProxySqlServerv2k5 tableProxySqlServerv2k5, boolean bl) {
        if (tableProxySqlServerv2k5.getTextImageFG() != null) {
            SSBTableSqlServerv2k5.appendNewLine(stringBuffer, bl, 1);
            SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, "TEXTIMAGE_ON");
            SSBTableSqlServerv2k5.appendString(stringBuffer, '\'');
            SSBTableSqlServerv2k5.appendString(stringBuffer, tableProxySqlServerv2k5.getTextImageFG().getName());
            SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, '\'');
        }
    }

    private void appendColumnNameAndDataType(StringBuffer stringBuffer, ColumnProxySqlServerv2k5 columnProxySqlServerv2k5, boolean bl) {
        if (this.storageDesign.getFormatedName(columnProxySqlServerv2k5.getName()).length() > columnProxySqlServerv2k5.getMaxNameLength()) {
            SSBTableSqlServerv2k5.appendNewLine(stringBuffer, true, 0);
            SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, "--  ERROR: Column name length exceeds maximum allowed length(" + columnProxySqlServerv2k5.getMaxNameLength() + ")");
            SSBTableSqlServerv2k5.appendNewLine(stringBuffer, true, 0);
            DDLFileMaker.incrementErrors();
        }
        SSBTableSqlServerv2k5.appendString(stringBuffer, ' ');
        SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(columnProxySqlServerv2k5.getName()));
        String string = columnProxySqlServerv2k5.getDatatypeString();
        SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, string);
        if (string.equalsIgnoreCase("unknown")) {
            SSBTableSqlServerv2k5.appendNewLine(stringBuffer, bl, 0);
            SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, "--  ERROR: Datatype UNKNOWN is not allowed");
            SSBTableSqlServerv2k5.appendNewLine(stringBuffer, bl, 5);
            DDLFileMaker.incrementErrors();
        }
    }

    private void appendColumnNullsAllowed(StringBuffer stringBuffer, ColumnProxySqlServerv2k5 columnProxySqlServerv2k5) {
        if (!columnProxySqlServerv2k5.getNullsAllowed()) {
            SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, "NOT NULL");
        }
    }

    private void appendColate(StringBuffer stringBuffer, ColumnProxySqlServerv2k5 columnProxySqlServerv2k5) {
        if (!columnProxySqlServerv2k5.getCollation().trim().equalsIgnoreCase("")) {
            SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, "COLLATE");
            SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, columnProxySqlServerv2k5.getCollation());
        }
    }

    private void appendDefault(StringBuffer stringBuffer, ColumnProxySqlServer columnProxySqlServer) {
        if (!columnProxySqlServer.getDefineDefault() && !columnProxySqlServer.getDefaultValue().trim().equalsIgnoreCase("")) {
            SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, "DEFAULT");
            try {
                String string = columnProxySqlServer.getDefaultValue().trim();
                String string2 = columnProxySqlServer.getColumn().getDatatypeString("SQL Server 2005");
                String string3 = this.addQuotesToDefault(string2, string);
                SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, string3);
            }
            catch (Exception exception) {
                SSBTableSqlServerv2k5.appendString(stringBuffer, '\'');
                SSBTableSqlServerv2k5.appendString(stringBuffer, columnProxySqlServer.getDefaultValue().trim());
                SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, '\'');
            }
        }
    }

    private void appendIdentity(StringBuffer stringBuffer, ColumnProxySqlServerv2k5 columnProxySqlServerv2k5) {
        if (!columnProxySqlServerv2k5.getDefineDefault() && columnProxySqlServerv2k5.getAsIdentity()) {
            SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, "IDENTITY");
            if (!"1".equals(columnProxySqlServerv2k5.getIdentitySeed()) || columnProxySqlServerv2k5.getIdentityIncrement() != 1) {
                SSBTableSqlServerv2k5.appendString(stringBuffer, '(');
                SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, columnProxySqlServerv2k5.getIdentitySeed());
                this.appendComma(stringBuffer);
                this.appendString(stringBuffer, columnProxySqlServerv2k5.getIdentityIncrement());
                SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, ')');
            }
            if (columnProxySqlServerv2k5.getIdentityForReplication().equalsIgnoreCase("NO")) {
                SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, "NOT FOR REPLICATION");
            }
        }
    }

    private void appendRowGuidCow(StringBuffer stringBuffer, ColumnProxySqlServerv2k5 columnProxySqlServerv2k5) {
        if (columnProxySqlServerv2k5.getRowGuidCol().trim().equalsIgnoreCase("YES")) {
            SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, "ROWGUIDCOL");
        }
    }

    private void appendTableConstraintsDefinition(StringBuffer stringBuffer, Table table, boolean bl) {
        for (TableLevelConstraint tableLevelConstraint : table.getCheckConstraints()) {
            this.appendComma(stringBuffer);
            SSBTableSqlServerv2k5.appendNewLine(stringBuffer, bl, 1);
            SSBTableSqlServerv2k5.appendString(stringBuffer, ' ');
            SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, "CONSTRAINT");
            SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableLevelConstraint.getName()));
            SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, "CHECK");
            SSBTableSqlServerv2k5.appendString(stringBuffer, '(');
            SSBTableSqlServerv2k5.appendString(stringBuffer, tableLevelConstraint.getRule());
            SSBTableSqlServerv2k5.appendString(stringBuffer, ')');
        }
    }

    private void appendConstrants(StringBuffer stringBuffer, TableProxySqlServerv2k5 tableProxySqlServerv2k5, boolean bl) {
        this.appendPKey(stringBuffer, tableProxySqlServerv2k5, bl);
        this.appendUniqueKeys(stringBuffer, tableProxySqlServerv2k5, bl);
    }

    private void appendPKey(StringBuffer stringBuffer, TableProxySqlServerv2k5 tableProxySqlServerv2k5, boolean bl) {
        StorageObjectCollection storageObjectCollection = tableProxySqlServerv2k5.getPkeys();
        Iterator iterator = storageObjectCollection.iterator();
        while (iterator.hasNext()) {
            PKProxySqlServerv2k5 pKProxySqlServerv2k5 = (PKProxySqlServerv2k5)iterator.next();
            ColumnProxy[] columnProxyArray = pKProxySqlServerv2k5.getColumnProxies();
            if (columnProxyArray.length <= 0 || !pKProxySqlServerv2k5.isMarkedGenerate()) continue;
            if (!this.isContainXMLColumn(columnProxyArray)) {
                int n;
                this.appendComma(stringBuffer);
                SSBTableSqlServerv2k5.appendNewLine(stringBuffer, bl, 1);
                SSBTableSqlServerv2k5.appendString(stringBuffer, ' ');
                SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, "CONSTRAINT");
                SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(pKProxySqlServerv2k5.getName()));
                SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, "PRIMARY KEY");
                if (pKProxySqlServerv2k5.isClustered()) {
                    SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, "CLUSTERED");
                } else {
                    SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, "NONCLUSTERED");
                }
                for (n = 0; n < columnProxyArray.length; ++n) {
                    if (n == 0) {
                        SSBTableSqlServerv2k5.appendString(stringBuffer, '(');
                    } else {
                        stringBuffer.append(", ");
                    }
                    ColumnProxy columnProxy = columnProxyArray[n];
                    String string = "";
                    if (columnProxy.getObject() != null) {
                        string = ((Index)pKProxySqlServerv2k5.getObject()).getColumnSortOrder(columnProxy.getObject());
                    }
                    if ("DESC".equalsIgnoreCase(string)) {
                        SSBTableSqlServerv2k5.appendString(stringBuffer, this.storageDesign.getFormatedName(columnProxy.getName()) + " " + string);
                        continue;
                    }
                    SSBTableSqlServerv2k5.appendString(stringBuffer, this.storageDesign.getFormatedName(columnProxy.getName()));
                }
                SSBTableSqlServerv2k5.appendString(stringBuffer, ')');
                SSBTableSqlServerv2k5.appendNewLine(stringBuffer, bl, 1);
                SSBTableSqlServerv2k5.appendString(stringBuffer, ' ');
                n = 0;
                SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, "WITH");
                SSBTableSqlServerv2k5.appendString(stringBuffer, '(');
                if (pKProxySqlServerv2k5.getPadIndex().equalsIgnoreCase("YES")) {
                    SSBTableSqlServerv2k5.appendNewLine(stringBuffer, bl, 1);
                    SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, "PAD_INDEX");
                    SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, '=');
                    SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, "ON");
                    n = 1;
                }
                if (pKProxySqlServerv2k5.getFillFactor() > 0 && pKProxySqlServerv2k5.getFillFactor() < 100) {
                    if (n != 0) {
                        this.appendComma(stringBuffer);
                    }
                    SSBTableSqlServerv2k5.appendNewLine(stringBuffer, bl, 1);
                    SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, "FILLFACTOR");
                    SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, '=');
                    this.appendStringWithSpace(stringBuffer, pKProxySqlServerv2k5.getFillFactor());
                    n = 1;
                }
                if (pKProxySqlServerv2k5.getIgnoreDupKey().equalsIgnoreCase("YES")) {
                    if (n != 0) {
                        this.appendComma(stringBuffer);
                    }
                    SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, "IGNORE_DUP_KEY");
                    SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, '=');
                    SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, "ON");
                    n = 1;
                }
                if (pKProxySqlServerv2k5.getRecomputeStatistics().equalsIgnoreCase("NO")) {
                    if (n != 0) {
                        this.appendComma(stringBuffer);
                    }
                    SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, "STATISTICS_NORECOMPUTE");
                    SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, '=');
                    SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, "ON");
                    n = 1;
                }
                if (n != 0) {
                    this.appendComma(stringBuffer);
                }
                SSBTableSqlServerv2k5.appendNewLine(stringBuffer, bl, 1);
                SSBTableSqlServerv2k5.appendString(stringBuffer, ' ');
                SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, "ALLOW_PAGE_LOCKS");
                SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, '=');
                SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, pKProxySqlServerv2k5.getAllowPageLocks());
                this.appendComma(stringBuffer);
                SSBTableSqlServerv2k5.appendNewLine(stringBuffer, bl, 1);
                SSBTableSqlServerv2k5.appendString(stringBuffer, ' ');
                SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, "ALLOW_ROW_LOCKS");
                SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, '=');
                SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, pKProxySqlServerv2k5.getAllowRowLocks());
                SSBTableSqlServerv2k5.appendString(stringBuffer, ')');
                SSBTableSqlServerv2k5.appendNewLine(stringBuffer, bl, 1);
                SSBTableSqlServerv2k5.appendString(stringBuffer, ' ');
                SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, "ON");
                if (pKProxySqlServerv2k5.getPartitionScheme() != null) {
                    this.appendStringWithSpace(stringBuffer, pKProxySqlServerv2k5.getPartitionScheme());
                    if (pKProxySqlServerv2k5.getPartitioningColumn() == null) continue;
                    SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, '(');
                    this.appendStringWithSpace(stringBuffer, pKProxySqlServerv2k5.getPartitioningColumn());
                    SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, ')');
                    continue;
                }
                if (pKProxySqlServerv2k5.getFilegroup() != null) {
                    SSBTableSqlServerv2k5.appendString(stringBuffer, this.storageDesign.getFormatedName(pKProxySqlServerv2k5.getFilegroup().getName()));
                    continue;
                }
                SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, "\"default\"");
                continue;
            }
            SSBTableSqlServerv2k5.appendNewLine(stringBuffer, bl, 0);
            stringBuffer.append("-- Error - Constraint ");
            stringBuffer.append(pKProxySqlServerv2k5.getName());
            stringBuffer.append(" contains a column of XML type.");
            SSBTableSqlServerv2k5.appendNewLine(stringBuffer, bl, 0);
            this.canWriteComma = false;
            DDLFileMaker.incrementErrors();
        }
    }

    private boolean isContainXMLColumn(ColumnProxy[] columnProxyArray) {
        for (int i = 0; i < columnProxyArray.length; ++i) {
            if (!columnProxyArray[i].getDataType().getName().equalsIgnoreCase("XML")) continue;
            return true;
        }
        return false;
    }

    private void appendUniqueKeys(StringBuffer stringBuffer, TableProxySqlServerv2k5 tableProxySqlServerv2k5, boolean bl) {
        StorageObjectCollection storageObjectCollection = tableProxySqlServerv2k5.getUkeys();
        Iterator iterator = storageObjectCollection.iterator();
        while (iterator.hasNext()) {
            UniqueProxySqlServerv2k5 uniqueProxySqlServerv2k5 = (UniqueProxySqlServerv2k5)iterator.next();
            ColumnProxy[] columnProxyArray = uniqueProxySqlServerv2k5.getColumnProxies();
            if (columnProxyArray.length <= 0 || !uniqueProxySqlServerv2k5.isMarkedGenerate()) continue;
            if (!this.isContainXMLColumn(columnProxyArray)) {
                this.appendComma(stringBuffer);
                SSBTableSqlServerv2k5.appendNewLine(stringBuffer, bl, 1);
                SSBTableSqlServerv2k5.appendString(stringBuffer, ' ');
                SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, "CONSTRAINT");
                SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(uniqueProxySqlServerv2k5.getName()));
                SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, "UNIQUE");
                if (uniqueProxySqlServerv2k5.isClustered()) {
                    SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, "CLUSTERED");
                } else {
                    SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, "NONCLUSTERED");
                }
                for (int i = 0; i < columnProxyArray.length; ++i) {
                    if (i == 0) {
                        SSBTableSqlServerv2k5.appendString(stringBuffer, '(');
                    } else {
                        stringBuffer.append(", ");
                    }
                    ColumnProxy columnProxy = columnProxyArray[i];
                    String string = "";
                    if (columnProxy.getObject() != null) {
                        string = ((Index)uniqueProxySqlServerv2k5.getObject()).getColumnSortOrder(columnProxy.getObject());
                    }
                    if ("DESC".equalsIgnoreCase(string)) {
                        SSBTableSqlServerv2k5.appendString(stringBuffer, this.storageDesign.getFormatedName(columnProxy.getName()) + " " + string);
                        continue;
                    }
                    SSBTableSqlServerv2k5.appendString(stringBuffer, this.storageDesign.getFormatedName(columnProxy.getName()));
                }
                SSBTableSqlServerv2k5.appendString(stringBuffer, ')');
                if (uniqueProxySqlServerv2k5.getFillFactor() > 0 && uniqueProxySqlServerv2k5.getFillFactor() < 100) {
                    SSBTableSqlServerv2k5.appendNewLine(stringBuffer, bl, 1);
                    SSBTableSqlServerv2k5.appendString(stringBuffer, ' ');
                    SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, "WITH");
                    SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, "FILLFACTOR");
                    SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, '=');
                    this.appendStringWithSpace(stringBuffer, uniqueProxySqlServerv2k5.getFillFactor());
                }
                SSBTableSqlServerv2k5.appendNewLine(stringBuffer, bl, 1);
                SSBTableSqlServerv2k5.appendString(stringBuffer, ' ');
                SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, "ON");
                if (uniqueProxySqlServerv2k5.getPartitionScheme() != null) {
                    this.appendStringWithSpace(stringBuffer, uniqueProxySqlServerv2k5.getPartitionScheme());
                    if (uniqueProxySqlServerv2k5.getPartitioningColumn() == null) continue;
                    SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, '(');
                    this.appendStringWithSpace(stringBuffer, uniqueProxySqlServerv2k5.getPartitioningColumn());
                    SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, ')');
                    continue;
                }
                if (uniqueProxySqlServerv2k5.getFilegroup() != null) {
                    this.appendStringWithSpace(stringBuffer, uniqueProxySqlServerv2k5.getFilegroup());
                    continue;
                }
                SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, "\"default\"");
                continue;
            }
            SSBTableSqlServerv2k5.appendNewLine(stringBuffer, bl, 0);
            stringBuffer.append("-- Error - Constraint ");
            stringBuffer.append(uniqueProxySqlServerv2k5.getName());
            stringBuffer.append(" contains column of XML type.");
            SSBTableSqlServerv2k5.appendNewLine(stringBuffer, bl, 0);
            this.canWriteComma = false;
            DDLFileMaker.incrementErrors();
        }
    }

    private void appendColumnConstraints(StringBuffer stringBuffer, Column column, ColumnProxySqlServer columnProxySqlServer) {
        String string;
        if (column.hasConstraintsDefined() && !"".equals(string = column.getConstraintsText(this.storageDesign.getFormatedName(columnProxySqlServer.getName())))) {
            String string2 = column.getConstraintName();
            if (!string2.equals("") && string2.length() <= 128 || column.getDesign().getAppView().getSettings().isGenerateInlineColumnCC()) {
                SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, "CONSTRAINT");
                SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(string2));
                SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, "CHECK");
                SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, '(');
                SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, string);
                SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, ')');
            }
            if ("".equals(string2) || !"".equals(string2) && string2.length() > 128 || column.getDesign().getAppView().getSettings().isGenerateInlineColumnCC()) {
                SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, "CHECK");
                SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, '(');
                SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, string);
                SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, ')');
            }
        }
    }

    protected void appendTableCommentOn(StringBuffer stringBuffer, Table table, TableProxySqlServerv2k5 tableProxySqlServerv2k5, boolean bl) {
        block14: {
            block13: {
                String string = null;
                String string2 = null;
                if (tableProxySqlServerv2k5 != null && tableProxySqlServerv2k5.isCommentInRDBMSChanged()) {
                    string = tableProxySqlServerv2k5.getCommentInRDBMS();
                    string2 = tableProxySqlServerv2k5.getName();
                } else if (table != null) {
                    string = table.getCommentInRDBMS();
                    string2 = table.getName();
                }
                if (string != null && !string.trim().equalsIgnoreCase("")) {
                    SSBTableSqlServerv2k5.appendNewLine(stringBuffer, bl, 0);
                    SSBTableSqlServerv2k5.appendNewLine(stringBuffer, bl, 0);
                    SSBTableSqlServerv2k5.appendNewLine(stringBuffer, bl, 0);
                    SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, "EXEC");
                    SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, "sp_addextendedproperty");
                    SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, "'MS_Description'");
                    SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, ',');
                    SSBTableSqlServerv2k5.appendString(stringBuffer, '\'');
                    SSBTableSqlServerv2k5.appendString(stringBuffer, string);
                    SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, '\'');
                    SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, ',');
                    if (tableProxySqlServerv2k5 != null && tableProxySqlServerv2k5.getUser() != null) {
                        SSBTableSqlServerv2k5.appendString(stringBuffer, '\'');
                        SSBTableSqlServerv2k5.appendString(stringBuffer, "USER");
                        SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, '\'');
                        SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, ',');
                        SSBTableSqlServerv2k5.appendString(stringBuffer, '\'');
                        this.appendString(stringBuffer, tableProxySqlServerv2k5.getUser());
                        SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, '\'');
                        SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, ',');
                    }
                    SSBTableSqlServerv2k5.appendString(stringBuffer, '\'');
                    SSBTableSqlServerv2k5.appendString(stringBuffer, "TABLE");
                    SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, '\'');
                    SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, ',');
                    SSBTableSqlServerv2k5.appendString(stringBuffer, '\'');
                    SSBTableSqlServerv2k5.appendString(stringBuffer, string2);
                    SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, '\'');
                    SSBTableSqlServerv2k5.appendNewLine(stringBuffer, bl, 0);
                    SSBTableSqlServerv2k5.appendString(stringBuffer, "GO");
                    SSBTableSqlServerv2k5.appendNewLine(stringBuffer, bl, 0);
                }
                if (tableProxySqlServerv2k5 == null) break block13;
                ColumnProxy[] columnProxyArray = tableProxySqlServerv2k5.getColumnProxies();
                for (int i = 0; i < columnProxyArray.length; ++i) {
                    ColumnProxy columnProxy = columnProxyArray[i];
                    if (columnProxy.getCommentInRDBMS() != null && columnProxy.isCommentInRDBMSChanged()) {
                        this.appendColumnComment(stringBuffer, columnProxy, tableProxySqlServerv2k5, bl);
                        continue;
                    }
                    this.appendColumnComment(stringBuffer, (Column)columnProxy.getObject(), table, bl);
                }
                Iterator iterator = tableProxySqlServerv2k5.getPkeys().iterator();
                PKProxySqlServerv2k5 pKProxySqlServerv2k5 = null;
                while (iterator.hasNext()) {
                    pKProxySqlServerv2k5 = (PKProxySqlServerv2k5)iterator.next();
                    if (pKProxySqlServerv2k5.getCommentInRDBMS() != null && pKProxySqlServerv2k5.isCommentInRDBMSChanged()) {
                        this.appendPKeyComment(stringBuffer, pKProxySqlServerv2k5, tableProxySqlServerv2k5, bl);
                        continue;
                    }
                    this.appendIndexComment(stringBuffer, (Index)pKProxySqlServerv2k5.getObject(), table, bl);
                }
                iterator = tableProxySqlServerv2k5.getUkeys().iterator();
                UniqueProxySqlServerv2k5 uniqueProxySqlServerv2k5 = null;
                while (iterator.hasNext()) {
                    uniqueProxySqlServerv2k5 = (UniqueProxySqlServerv2k5)iterator.next();
                    if (uniqueProxySqlServerv2k5.getCommentInRDBMS() != null && uniqueProxySqlServerv2k5.isCommentInRDBMSChanged()) {
                        this.appendUKeyComment(stringBuffer, uniqueProxySqlServerv2k5, tableProxySqlServerv2k5, bl);
                        continue;
                    }
                    this.appendIndexComment(stringBuffer, (Index)uniqueProxySqlServerv2k5.getObject(), table, bl);
                }
                break block14;
            }
            if (table == null) break block14;
            ContainedObject[] containedObjectArray = table.getElements();
            for (int i = 0; i < containedObjectArray.length; ++i) {
                Column column = (Column)containedObjectArray[i];
                if (column.getCommentInRDBMS() == null) continue;
                this.appendColumnComment(stringBuffer, column, table, bl);
            }
            Iterator iterator = table.getPKeys().iterator();
            Index index = null;
            while (iterator.hasNext()) {
                index = (Index)iterator.next();
                if (index.getCommentInRDBMS() == null) continue;
                this.appendIndexComment(stringBuffer, index, table, bl);
            }
        }
    }

    protected void appendColumnComment(StringBuffer stringBuffer, ColumnProxy columnProxy, TableProxySqlServerv2k5 tableProxySqlServerv2k5, boolean bl) {
        if (tableProxySqlServerv2k5 != null && !columnProxy.getCommentInRDBMS().equalsIgnoreCase("")) {
            SSBTableSqlServerv2k5.appendNewLine(stringBuffer, bl, 0);
            SSBTableSqlServerv2k5.appendNewLine(stringBuffer, bl, 0);
            SSBTableSqlServerv2k5.appendNewLine(stringBuffer, bl, 0);
            SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, "EXEC");
            SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, "sp_addextendedproperty");
            SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, "'MS_Description'");
            SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, ',');
            SSBTableSqlServerv2k5.appendString(stringBuffer, '\'');
            SSBTableSqlServerv2k5.appendString(stringBuffer, columnProxy.getCommentInRDBMS());
            SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, '\'');
            SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, ',');
            if (tableProxySqlServerv2k5.getUser() != null) {
                SSBTableSqlServerv2k5.appendString(stringBuffer, '\'');
                SSBTableSqlServerv2k5.appendString(stringBuffer, "USER");
                SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, '\'');
                SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, ',');
                SSBTableSqlServerv2k5.appendString(stringBuffer, '\'');
                this.appendString(stringBuffer, tableProxySqlServerv2k5.getUser());
                SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, '\'');
                SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, ',');
            }
            SSBTableSqlServerv2k5.appendString(stringBuffer, '\'');
            SSBTableSqlServerv2k5.appendString(stringBuffer, "TABLE");
            SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, '\'');
            SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, ',');
            SSBTableSqlServerv2k5.appendString(stringBuffer, '\'');
            SSBTableSqlServerv2k5.appendString(stringBuffer, tableProxySqlServerv2k5.getName());
            SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, '\'');
            SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, ',');
            SSBTableSqlServerv2k5.appendString(stringBuffer, '\'');
            SSBTableSqlServerv2k5.appendString(stringBuffer, "COLUMN");
            SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, '\'');
            SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, ',');
            SSBTableSqlServerv2k5.appendString(stringBuffer, '\'');
            SSBTableSqlServerv2k5.appendString(stringBuffer, columnProxy.getName());
            SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, '\'');
            SSBTableSqlServerv2k5.appendNewLine(stringBuffer, bl, 0);
            SSBTableSqlServerv2k5.appendString(stringBuffer, "GO");
            SSBTableSqlServerv2k5.appendNewLine(stringBuffer, bl, 0);
        }
    }

    protected void appendColumnComment(StringBuffer stringBuffer, Column column, Table table, boolean bl) {
        if (!column.getCommentInRDBMS().equalsIgnoreCase("")) {
            SSBTableSqlServerv2k5.appendNewLine(stringBuffer, bl, 0);
            SSBTableSqlServerv2k5.appendNewLine(stringBuffer, bl, 0);
            SSBTableSqlServerv2k5.appendNewLine(stringBuffer, bl, 0);
            SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, "EXEC");
            SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, "sp_addextendedproperty");
            SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, "'MS_Description'");
            SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, ',');
            SSBTableSqlServerv2k5.appendString(stringBuffer, '\'');
            SSBTableSqlServerv2k5.appendString(stringBuffer, column.getCommentInRDBMS());
            SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, '\'');
            SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, ',');
            SSBTableSqlServerv2k5.appendString(stringBuffer, '\'');
            SSBTableSqlServerv2k5.appendString(stringBuffer, "TABLE");
            SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, '\'');
            SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, ',');
            SSBTableSqlServerv2k5.appendString(stringBuffer, '\'');
            SSBTableSqlServerv2k5.appendString(stringBuffer, table.getName());
            SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, '\'');
            SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, ',');
            SSBTableSqlServerv2k5.appendString(stringBuffer, '\'');
            SSBTableSqlServerv2k5.appendString(stringBuffer, "COLUMN");
            SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, '\'');
            SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, ',');
            SSBTableSqlServerv2k5.appendString(stringBuffer, '\'');
            SSBTableSqlServerv2k5.appendString(stringBuffer, column.getName());
            SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, '\'');
            SSBTableSqlServerv2k5.appendNewLine(stringBuffer, bl, 0);
            SSBTableSqlServerv2k5.appendString(stringBuffer, "GO");
            SSBTableSqlServerv2k5.appendNewLine(stringBuffer, bl, 0);
        }
    }

    protected void appendPKeyComment(StringBuffer stringBuffer, PKProxySqlServerv2k5 pKProxySqlServerv2k5, TableProxySqlServerv2k5 tableProxySqlServerv2k5, boolean bl) {
        if (tableProxySqlServerv2k5 != null && !pKProxySqlServerv2k5.getCommentInRDBMS().equalsIgnoreCase("")) {
            SSBTableSqlServerv2k5.appendNewLine(stringBuffer, bl, 0);
            SSBTableSqlServerv2k5.appendNewLine(stringBuffer, bl, 0);
            SSBTableSqlServerv2k5.appendNewLine(stringBuffer, bl, 0);
            SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, "EXEC");
            SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, "sp_addextendedproperty");
            SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, "'MS_Description'");
            SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, ',');
            SSBTableSqlServerv2k5.appendString(stringBuffer, '\'');
            SSBTableSqlServerv2k5.appendString(stringBuffer, pKProxySqlServerv2k5.getCommentInRDBMS());
            SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, '\'');
            SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, ',');
            if (tableProxySqlServerv2k5.getUser() != null) {
                SSBTableSqlServerv2k5.appendString(stringBuffer, '\'');
                SSBTableSqlServerv2k5.appendString(stringBuffer, "USER");
                SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, '\'');
                SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, ',');
                SSBTableSqlServerv2k5.appendString(stringBuffer, '\'');
                this.appendString(stringBuffer, tableProxySqlServerv2k5.getUser());
                SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, '\'');
                SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, ',');
            }
            SSBTableSqlServerv2k5.appendString(stringBuffer, '\'');
            SSBTableSqlServerv2k5.appendString(stringBuffer, "TABLE");
            SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, '\'');
            SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, ',');
            SSBTableSqlServerv2k5.appendString(stringBuffer, '\'');
            SSBTableSqlServerv2k5.appendString(stringBuffer, tableProxySqlServerv2k5.getName());
            SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, '\'');
            SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, ',');
            SSBTableSqlServerv2k5.appendString(stringBuffer, '\'');
            SSBTableSqlServerv2k5.appendString(stringBuffer, "CONSTRAINT");
            SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, '\'');
            SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, ',');
            SSBTableSqlServerv2k5.appendString(stringBuffer, '\'');
            SSBTableSqlServerv2k5.appendString(stringBuffer, pKProxySqlServerv2k5.getName());
            SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, '\'');
            SSBTableSqlServerv2k5.appendNewLine(stringBuffer, bl, 0);
            SSBTableSqlServerv2k5.appendString(stringBuffer, "GO");
            SSBTableSqlServerv2k5.appendNewLine(stringBuffer, bl, 0);
        }
    }

    protected void appendUKeyComment(StringBuffer stringBuffer, UniqueProxySqlServerv2k5 uniqueProxySqlServerv2k5, TableProxySqlServerv2k5 tableProxySqlServerv2k5, boolean bl) {
        if (tableProxySqlServerv2k5 != null && !uniqueProxySqlServerv2k5.getCommentInRDBMS().equalsIgnoreCase("")) {
            SSBTableSqlServerv2k5.appendNewLine(stringBuffer, bl, 0);
            SSBTableSqlServerv2k5.appendNewLine(stringBuffer, bl, 0);
            SSBTableSqlServerv2k5.appendNewLine(stringBuffer, bl, 0);
            SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, "EXEC");
            SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, "sp_addextendedproperty");
            SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, "'MS_Description'");
            SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, ',');
            SSBTableSqlServerv2k5.appendString(stringBuffer, '\'');
            SSBTableSqlServerv2k5.appendString(stringBuffer, uniqueProxySqlServerv2k5.getCommentInRDBMS());
            SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, '\'');
            SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, ',');
            if (tableProxySqlServerv2k5.getUser() != null) {
                SSBTableSqlServerv2k5.appendString(stringBuffer, '\'');
                SSBTableSqlServerv2k5.appendString(stringBuffer, "USER");
                SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, '\'');
                SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, ',');
                SSBTableSqlServerv2k5.appendString(stringBuffer, '\'');
                this.appendString(stringBuffer, tableProxySqlServerv2k5.getUser());
                SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, '\'');
                SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, ',');
            }
            SSBTableSqlServerv2k5.appendString(stringBuffer, '\'');
            SSBTableSqlServerv2k5.appendString(stringBuffer, "TABLE");
            SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, '\'');
            SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, ',');
            SSBTableSqlServerv2k5.appendString(stringBuffer, '\'');
            SSBTableSqlServerv2k5.appendString(stringBuffer, tableProxySqlServerv2k5.getName());
            SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, '\'');
            SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, ',');
            SSBTableSqlServerv2k5.appendString(stringBuffer, '\'');
            SSBTableSqlServerv2k5.appendString(stringBuffer, "CONSTRAINT");
            SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, '\'');
            SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, ',');
            SSBTableSqlServerv2k5.appendString(stringBuffer, '\'');
            SSBTableSqlServerv2k5.appendString(stringBuffer, uniqueProxySqlServerv2k5.getName());
            SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, '\'');
            SSBTableSqlServerv2k5.appendNewLine(stringBuffer, bl, 0);
            SSBTableSqlServerv2k5.appendString(stringBuffer, "GO");
            SSBTableSqlServerv2k5.appendNewLine(stringBuffer, bl, 0);
        }
    }

    protected void appendIndexComment(StringBuffer stringBuffer, Index index, Table table, boolean bl) {
        if (!index.getCommentInRDBMS().equalsIgnoreCase("")) {
            SSBTableSqlServerv2k5.appendNewLine(stringBuffer, bl, 0);
            SSBTableSqlServerv2k5.appendNewLine(stringBuffer, bl, 0);
            SSBTableSqlServerv2k5.appendNewLine(stringBuffer, bl, 0);
            SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, "EXEC");
            SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, "sp_addextendedproperty");
            SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, "'MS_Description'");
            SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, ',');
            SSBTableSqlServerv2k5.appendString(stringBuffer, '\'');
            SSBTableSqlServerv2k5.appendString(stringBuffer, index.getCommentInRDBMS());
            SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, '\'');
            SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, ',');
            SSBTableSqlServerv2k5.appendString(stringBuffer, '\'');
            SSBTableSqlServerv2k5.appendString(stringBuffer, "TABLE");
            SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, '\'');
            SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, ',');
            SSBTableSqlServerv2k5.appendString(stringBuffer, '\'');
            SSBTableSqlServerv2k5.appendString(stringBuffer, table.getName());
            SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, '\'');
            SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, ',');
            SSBTableSqlServerv2k5.appendString(stringBuffer, '\'');
            SSBTableSqlServerv2k5.appendString(stringBuffer, "CONSTRAINT");
            SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, '\'');
            SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, ',');
            SSBTableSqlServerv2k5.appendString(stringBuffer, '\'');
            SSBTableSqlServerv2k5.appendString(stringBuffer, index.getName());
            SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, '\'');
            SSBTableSqlServerv2k5.appendNewLine(stringBuffer, bl, 0);
            SSBTableSqlServerv2k5.appendString(stringBuffer, "GO");
            SSBTableSqlServerv2k5.appendNewLine(stringBuffer, bl, 0);
        }
    }

    private void appendColumnCheckConstraints(StringBuffer stringBuffer, TableProxy tableProxy, boolean bl) {
        ColumnProxy[] columnProxyArray = tableProxy.getColumnProxies();
        for (int i = 0; i < columnProxyArray.length; ++i) {
            ColumnProxy columnProxy = columnProxyArray[i];
            Column column = columnProxy.getColumn();
            if (!column.hasConstraintsDefined()) continue;
            String string = column.getConstraintsText(this.storageDesign.getFormatedName(columnProxy.getName()));
            String string2 = this.storageDesign.getFormatedName(column.getConstraintName());
            if ("".equals(string) || "".equals(string2) || string2.length() >= 129) continue;
            SSBTableSqlServerv2k5.appendNewLine(stringBuffer, bl, 0);
            SSBTableSqlServerv2k5.appendNewLine(stringBuffer, bl, 0);
            SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, "ALTER");
            SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, "TABLE");
            SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableProxy.getLongName()));
            SSBTableSqlServerv2k5.appendNewLine(stringBuffer, bl, 1);
            SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, "ADD");
            SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, "CONSTRAINT");
            SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, string2);
            SSBTableSqlServerv2k5.appendNewLine(stringBuffer, bl, 1);
            SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, "CHECK");
            SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, '(');
            SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, string);
            SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, ')');
            SSBTableSqlServerv2k5.appendNewLine(stringBuffer, bl, 0);
            SSBTableSqlServerv2k5.appendString(stringBuffer, "GO");
            SSBTableSqlServerv2k5.appendNewLine(stringBuffer, bl, 0);
        }
    }

    @Override
    public boolean canHandle(Object object) {
        if (object instanceof Table && ((Table)object).isMarkedGenerate()) {
            return true;
        }
        return object instanceof TableProxySqlServerv2k5 && ((TableProxySqlServerv2k5)object).getDatabase() != null && !((TableProxySqlServerv2k5)object).getDatabase().isNullInstance();
    }

    private void appendExtProperties(StringBuffer stringBuffer, Object object, boolean bl) {
        TableProxySqlServerv2k5 tableProxySqlServerv2k5 = (TableProxySqlServerv2k5)object;
        if (!"".equalsIgnoreCase(tableProxySqlServerv2k5.getProps())) {
            if (tableProxySqlServerv2k5.getUser() != null) {
                for (int i = 0; i < tableProxySqlServerv2k5.getExtPropsSet().size() - 1; ++i) {
                    String string = '\'' + (String)tableProxySqlServerv2k5.getExtPropsSet().get(i) + '\'';
                    String string2 = '\'' + (String)tableProxySqlServerv2k5.getExtPropsSet().get(++i) + '\'';
                    SSBTableSqlServerv2k5.appendNewLine(stringBuffer, bl, 1);
                    SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, "EXEC");
                    SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, "sp_addextendedproperty");
                    String string3 = string + ", " + string2;
                    SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, string3);
                    SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, ',');
                    SSBTableSqlServerv2k5.appendNewLine(stringBuffer, bl, 1);
                    SSBTableSqlServerv2k5.appendString(stringBuffer, '\'');
                    SSBTableSqlServerv2k5.appendString(stringBuffer, "USER");
                    SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, '\'');
                    SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, ',');
                    SSBTableSqlServerv2k5.appendString(stringBuffer, this.storageDesign.getFormatedName(tableProxySqlServerv2k5.getUser().getName()));
                    SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, ',');
                    SSBTableSqlServerv2k5.appendString(stringBuffer, '\'');
                    SSBTableSqlServerv2k5.appendString(stringBuffer, "TABLE");
                    SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, '\'');
                    SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, ',');
                    SSBTableSqlServerv2k5.appendString(stringBuffer, this.storageDesign.getFormatedName(tableProxySqlServerv2k5.getName()));
                    SSBTableSqlServerv2k5.appendNewLine(stringBuffer, bl, 0);
                    SSBTableSqlServerv2k5.appendString(stringBuffer, "GO");
                    SSBTableSqlServerv2k5.appendNewLine(stringBuffer, bl, 0);
                }
            }
        }
    }

    private void appendColumnExtProperties(StringBuffer stringBuffer, Table table, TableProxySqlServerv2k5 tableProxySqlServerv2k5, boolean bl) {
        Column[] columnArray = (Column[])table.getElements();
        Column column = null;
        ColumnProxySqlServerv2k5 columnProxySqlServerv2k5 = null;
        SSBTableSqlServerv2k5.appendNewLine(stringBuffer, bl, 0);
        for (int i = 0; i < columnArray.length; ++i) {
            if (tableProxySqlServerv2k5 == null || "".equalsIgnoreCase((columnProxySqlServerv2k5 = (ColumnProxySqlServerv2k5)tableProxySqlServerv2k5.getColumnProxy((column = columnArray[i]).getObjectID())).getProps())) continue;
            int n = 0;
            while (n < columnProxySqlServerv2k5.getExtPropsSet().size() - 1) {
                if (tableProxySqlServerv2k5.getUser() == null) continue;
                String string = '\'' + (String)columnProxySqlServerv2k5.getExtPropsSet().get(n) + '\'';
                String string2 = '\'' + (String)columnProxySqlServerv2k5.getExtPropsSet().get(++n) + '\'';
                ++n;
                SSBTableSqlServerv2k5.appendNewLine(stringBuffer, bl, 0);
                SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, "EXEC");
                SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, "sp_addextendedproperty");
                String string3 = string + ", " + string2;
                SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, string3);
                SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, ',');
                SSBTableSqlServerv2k5.appendNewLine(stringBuffer, bl, 1);
                SSBTableSqlServerv2k5.appendString(stringBuffer, '\'');
                SSBTableSqlServerv2k5.appendString(stringBuffer, "USER");
                SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, '\'');
                SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, ',');
                if (tableProxySqlServerv2k5.getUser() != null) {
                    SSBTableSqlServerv2k5.appendString(stringBuffer, this.storageDesign.getFormatedName(tableProxySqlServerv2k5.getUser().getName()));
                }
                SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, ',');
                SSBTableSqlServerv2k5.appendString(stringBuffer, '\'');
                SSBTableSqlServerv2k5.appendString(stringBuffer, "TABLE");
                SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, '\'');
                SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, ',');
                SSBTableSqlServerv2k5.appendString(stringBuffer, this.storageDesign.getFormatedName(tableProxySqlServerv2k5.getName()));
                SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, ',');
                SSBTableSqlServerv2k5.appendString(stringBuffer, '\'');
                SSBTableSqlServerv2k5.appendString(stringBuffer, "COLUMN");
                SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, '\'');
                SSBTableSqlServerv2k5.appendStringWithSpace(stringBuffer, ',');
                SSBTableSqlServerv2k5.appendString(stringBuffer, this.storageDesign.getFormatedName(columnProxySqlServerv2k5.getName()));
                SSBTableSqlServerv2k5.appendNewLine(stringBuffer, bl, 0);
                SSBTableSqlServerv2k5.appendString(stringBuffer, "GO");
                SSBTableSqlServerv2k5.appendNewLine(stringBuffer, bl, 0);
            }
        }
    }

    private void appendIndexesForConstraints(StringBuffer stringBuffer, Table table, TableProxy tableProxy) {
        KeyObject[] keyObjectArray = table.getKeys();
        boolean bl = table.getDesign().getDLSettings().isAutomaticPKGeneration();
        boolean bl2 = table.getDesign().getDLSettings().isAutomaticUKGeneration();
        boolean bl3 = table.getDesign().getDLSettings().isAutomaticFKGeneration();
        for (int i = 0; i < keyObjectArray.length; ++i) {
            Index index;
            ContainedObject[] containedObjectArray;
            Index index2 = (Index)keyObjectArray[i];
            if (!(bl && "Primary Constraint".equals(index2.getIndexState()) || bl2 && "Unique Constraint".equals(index2.getIndexState())) && (!index2.isFK() || !bl3) || (containedObjectArray = index2.getElements()).length <= 0 || (index = this.getIndexForColumns(table, index2, containedObjectArray, false)) != null) continue;
            this.ssbIndex.appendIndexForConstraint(stringBuffer, index2, true);
        }
    }

    private Index getIndexForColumns(Table table, Index index, ContainedObject[] containedObjectArray, boolean bl) {
        Object[] objectArray = table.getIndexes().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            DesignObjectPlaceHolder designObjectPlaceHolder = (DesignObjectPlaceHolder)objectArray[i];
            Index index2 = (Index)designObjectPlaceHolder.getDesignObject();
            ContainedObject[] containedObjectArray2 = index2.getElements();
            if (containedObjectArray.length != containedObjectArray2.length) continue;
            boolean bl2 = false;
            for (int j = 0; j < containedObjectArray.length; ++j) {
                String string;
                if (containedObjectArray[j] != containedObjectArray2[j]) {
                    bl2 = true;
                    break;
                }
                if (!bl || "ASC".equalsIgnoreCase(string = index2.getColumnSortOrder(containedObjectArray2[j]).trim()) || "".equalsIgnoreCase(string)) continue;
                bl2 = true;
                break;
            }
            if (bl2 || index2 == index) continue;
            return index2;
        }
        return null;
    }

    public SSBArcFK_CheckConstr getArcConstrHandler() {
        if (this.arcConstrHandler == null && this.storageDesign != null) {
            this.arcConstrHandler = new SSBArcFK_CheckConstr(this.storageDesign);
        }
        return this.arcConstrHandler;
    }
}

