/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.sqlserver.v2k5;

import oracle.dbtools.crest.exports.ddl.sqlserver.AbstractSSBSqlServer;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.sqlserver.PartitionSchemeSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.PartitionSchemeSqlServerv2k5;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBPartitionSchemeSqlServerv2k5
extends AbstractSSBSqlServer {
    private StorageDesign storageDesign;

    @Override
    protected void doAppend(StringBuffer stringBuffer, Object object, boolean bl) {
        PartitionSchemeSqlServerv2k5 partitionSchemeSqlServerv2k5 = (PartitionSchemeSqlServerv2k5)object;
        this.storageDesign = partitionSchemeSqlServerv2k5.getStorageDesign();
        this.appendComment(stringBuffer, partitionSchemeSqlServerv2k5);
        this.appendPartitionScheme(stringBuffer, partitionSchemeSqlServerv2k5, bl);
        DDLFileMaker.incrementPartitionSheme();
    }

    private void appendPartitionScheme(StringBuffer stringBuffer, PartitionSchemeSqlServerv2k5 partitionSchemeSqlServerv2k5, boolean bl) {
        SSBPartitionSchemeSqlServerv2k5.appendNewLine(stringBuffer, bl, 0);
        this.appendDataBase(stringBuffer, partitionSchemeSqlServerv2k5.getPartitionFunction().getDatabase(), bl);
        SSBPartitionSchemeSqlServerv2k5.appendStringWithSpace(stringBuffer, "CREATE");
        SSBPartitionSchemeSqlServerv2k5.appendStringWithSpace(stringBuffer, "PARTITION");
        SSBPartitionSchemeSqlServerv2k5.appendStringWithSpace(stringBuffer, "SCHEME");
        SSBPartitionSchemeSqlServerv2k5.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(partitionSchemeSqlServerv2k5.getName()));
        SSBPartitionSchemeSqlServerv2k5.appendNewLine(stringBuffer, bl, 0);
        this.appendPartitionMapping(stringBuffer, partitionSchemeSqlServerv2k5, bl);
        SSBPartitionSchemeSqlServerv2k5.appendNewLine(stringBuffer, bl, 0);
        SSBPartitionSchemeSqlServerv2k5.appendString(stringBuffer, "GO");
        SSBPartitionSchemeSqlServerv2k5.appendNewLine(stringBuffer, bl, 0);
    }

    private void appendPartitionMapping(StringBuffer stringBuffer, PartitionSchemeSqlServerv2k5 partitionSchemeSqlServerv2k5, boolean bl) {
        SSBPartitionSchemeSqlServerv2k5.appendStringWithSpace(stringBuffer, "AS");
        SSBPartitionSchemeSqlServerv2k5.appendStringWithSpace(stringBuffer, "PARTITION");
        SSBPartitionSchemeSqlServerv2k5.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(partitionSchemeSqlServerv2k5.getPartitionFunction().getName()));
        SSBPartitionSchemeSqlServerv2k5.appendNewLine(stringBuffer, bl, 0);
        if (partitionSchemeSqlServerv2k5.isSingleFileGroupSelected()) {
            this.appendSingleFileGroup(stringBuffer, partitionSchemeSqlServerv2k5, bl);
        } else {
            this.appendMultipleFileGroups(stringBuffer, partitionSchemeSqlServerv2k5, bl);
        }
    }

    private void appendSingleFileGroup(StringBuffer stringBuffer, PartitionSchemeSqlServerv2k5 partitionSchemeSqlServerv2k5, boolean bl) {
        SSBPartitionSchemeSqlServerv2k5.appendStringWithSpace(stringBuffer, "ALL");
        SSBPartitionSchemeSqlServerv2k5.appendStringWithSpace(stringBuffer, "TO");
        SSBPartitionSchemeSqlServerv2k5.appendStringWithSpace(stringBuffer, '(');
        if (partitionSchemeSqlServerv2k5.getSingleFileGroup() != null && !partitionSchemeSqlServerv2k5.getSingleFileGroup().getName().equalsIgnoreCase("PRIMARY")) {
            SSBPartitionSchemeSqlServerv2k5.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(partitionSchemeSqlServerv2k5.getSingleFileGroup().getName()));
        } else {
            SSBPartitionSchemeSqlServerv2k5.appendStringWithSpace(stringBuffer, "[PRIMARY]");
        }
        SSBPartitionSchemeSqlServerv2k5.appendStringWithSpace(stringBuffer, ')');
    }

    private void appendMultipleFileGroups(StringBuffer stringBuffer, PartitionSchemeSqlServerv2k5 partitionSchemeSqlServerv2k5, boolean bl) {
        SSBPartitionSchemeSqlServerv2k5.appendStringWithSpace(stringBuffer, "TO");
        SSBPartitionSchemeSqlServerv2k5.appendStringWithSpace(stringBuffer, '(');
        if (partitionSchemeSqlServerv2k5.getMappingTableSet().size() > 0) {
            this.appendFileGroups(stringBuffer, partitionSchemeSqlServerv2k5, bl);
        } else {
            int n = partitionSchemeSqlServerv2k5.getPartitionFunction().getBValuesSet().size();
            for (int i = 0; i < n + 1; i += 2) {
                SSBPartitionSchemeSqlServerv2k5.appendStringWithSpace(stringBuffer, "[PRIMARY]");
                if (i >= n) continue;
                SSBPartitionSchemeSqlServerv2k5.appendString(stringBuffer, ',');
            }
        }
        SSBPartitionSchemeSqlServerv2k5.appendStringWithSpace(stringBuffer, ')');
    }

    private void appendFileGroups(StringBuffer stringBuffer, PartitionSchemeSqlServerv2k5 partitionSchemeSqlServerv2k5, boolean bl) {
        PartitionSchemeSqlServer.MappingTable mappingTable = partitionSchemeSqlServerv2k5.getMappingTableSet();
        for (int i = 1; i < mappingTable.size(); i += 2) {
            String string = (String)mappingTable.get(i);
            if (!this.isNotEmpty(string) || string.trim().equalsIgnoreCase("PRIMARY")) {
                string = "[PRIMARY]";
            }
            SSBPartitionSchemeSqlServerv2k5.appendStringWithSpace(stringBuffer, string.trim());
            if (i >= mappingTable.size() - 2) continue;
            SSBPartitionSchemeSqlServerv2k5.appendString(stringBuffer, ',');
        }
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof PartitionSchemeSqlServerv2k5 && ((PartitionSchemeSqlServerv2k5)object).isMarkedGenerate() && !((PartitionSchemeSqlServerv2k5)object).getPartitionFunction().getInputType().equals("");
    }
}

