/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.sqlserver.v2k5;

import java.util.StringTokenizer;
import oracle.dbtools.crest.exports.ddl.sqlserver.AbstractSSBSqlServer;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.relational.ColumnView;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.IndexOnViewSqlServerv2k5;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBIndexOnViewSqlServerv2k5
extends AbstractSSBSqlServer {
    private StorageDesign storageDesign;

    @Override
    protected void doAppend(StringBuffer stringBuffer, Object object, boolean bl) {
        IndexOnViewSqlServerv2k5 indexOnViewSqlServerv2k5 = (IndexOnViewSqlServerv2k5)object;
        this.storageDesign = indexOnViewSqlServerv2k5.getStorageDesign();
        this.appendComment(stringBuffer, indexOnViewSqlServerv2k5);
        TableView tableView = (TableView)indexOnViewSqlServerv2k5.getView().getObject();
        if (tableView.getColumns().length > 0) {
            SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(stringBuffer, "CREATE");
            this.appendUnique(stringBuffer, indexOnViewSqlServerv2k5);
            this.appendClustered(stringBuffer, indexOnViewSqlServerv2k5);
            SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(stringBuffer, "INDEX");
            SSBIndexOnViewSqlServerv2k5.appendNewLine(stringBuffer, bl, 1);
            SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(indexOnViewSqlServerv2k5.getName()));
            this.appendView(stringBuffer, indexOnViewSqlServerv2k5, bl);
            this.appendOptions(stringBuffer, indexOnViewSqlServerv2k5, bl);
            this.appendFilegroup(stringBuffer, indexOnViewSqlServerv2k5, bl);
            SSBIndexOnViewSqlServerv2k5.appendNewLine(stringBuffer, bl, 0);
            SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(stringBuffer, "GO");
            DDLFileMaker.incrementCreateIndexOnView();
            if (indexOnViewSqlServerv2k5.getDesign().getAppView().getSettings().isGenerateCommentsInRDBMS()) {
                this.appendIndexOnViewComment(stringBuffer, indexOnViewSqlServerv2k5, bl);
            }
            this.appendExtProperties(stringBuffer, indexOnViewSqlServerv2k5, bl);
        } else {
            SSBIndexOnViewSqlServerv2k5.appendNewLine(stringBuffer, bl, 0);
            SSBIndexOnViewSqlServerv2k5.appendNewLine(stringBuffer, bl, 0);
            stringBuffer.append("-- Index ").append(indexOnViewSqlServerv2k5.getName()).append(" on View ").append(indexOnViewSqlServerv2k5.getView().getName()).append(" not created in ddl");
            DDLFileMaker.incrementErrors();
            SSBIndexOnViewSqlServerv2k5.appendNewLine(stringBuffer, bl, 0);
        }
    }

    protected void appendIndexOnViewComment(StringBuffer stringBuffer, IndexOnViewSqlServerv2k5 indexOnViewSqlServerv2k5, boolean bl) {
        String string = indexOnViewSqlServerv2k5.getCommentInRDBMS();
        if (string != null && !string.trim().equalsIgnoreCase("")) {
            SSBIndexOnViewSqlServerv2k5.appendNewLine(stringBuffer, bl, 0);
            SSBIndexOnViewSqlServerv2k5.appendNewLine(stringBuffer, bl, 0);
            SSBIndexOnViewSqlServerv2k5.appendNewLine(stringBuffer, bl, 0);
            SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(stringBuffer, "EXEC");
            SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(stringBuffer, "sp_addextendedproperty");
            SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(stringBuffer, "'MS_Description'");
            SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(stringBuffer, ',');
            SSBIndexOnViewSqlServerv2k5.appendString(stringBuffer, '\'');
            SSBIndexOnViewSqlServerv2k5.appendString(stringBuffer, string);
            SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(stringBuffer, '\'');
            SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(stringBuffer, ',');
            if (indexOnViewSqlServerv2k5 != null && indexOnViewSqlServerv2k5.getView().getUser() != null) {
                SSBIndexOnViewSqlServerv2k5.appendString(stringBuffer, '\'');
                SSBIndexOnViewSqlServerv2k5.appendString(stringBuffer, "USER");
                SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(stringBuffer, '\'');
                SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(stringBuffer, ',');
                SSBIndexOnViewSqlServerv2k5.appendString(stringBuffer, '\'');
                SSBIndexOnViewSqlServerv2k5.appendString(stringBuffer, indexOnViewSqlServerv2k5.getView().getUser().getName());
                SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(stringBuffer, '\'');
                SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(stringBuffer, ',');
            }
            SSBIndexOnViewSqlServerv2k5.appendString(stringBuffer, '\'');
            SSBIndexOnViewSqlServerv2k5.appendString(stringBuffer, "VIEW");
            SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(stringBuffer, '\'');
            SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(stringBuffer, ',');
            SSBIndexOnViewSqlServerv2k5.appendString(stringBuffer, '\'');
            SSBIndexOnViewSqlServerv2k5.appendString(stringBuffer, indexOnViewSqlServerv2k5.getLongName());
            SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(stringBuffer, '\'');
            SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(stringBuffer, ',');
            SSBIndexOnViewSqlServerv2k5.appendString(stringBuffer, '\'');
            SSBIndexOnViewSqlServerv2k5.appendString(stringBuffer, "INDEX");
            SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(stringBuffer, '\'');
            SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(stringBuffer, ',');
            SSBIndexOnViewSqlServerv2k5.appendString(stringBuffer, '\'');
            SSBIndexOnViewSqlServerv2k5.appendString(stringBuffer, indexOnViewSqlServerv2k5.getName());
            SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(stringBuffer, '\'');
            SSBIndexOnViewSqlServerv2k5.appendNewLine(stringBuffer, bl, 0);
            SSBIndexOnViewSqlServerv2k5.appendString(stringBuffer, "GO");
            SSBIndexOnViewSqlServerv2k5.appendNewLine(stringBuffer, bl, 0);
        }
    }

    private void appendUnique(StringBuffer stringBuffer, IndexOnViewSqlServerv2k5 indexOnViewSqlServerv2k5) {
        if (indexOnViewSqlServerv2k5.getUnique().equalsIgnoreCase("YES")) {
            SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(stringBuffer, "UNIQUE");
        }
    }

    private void appendClustered(StringBuffer stringBuffer, IndexOnViewSqlServerv2k5 indexOnViewSqlServerv2k5) {
        if (indexOnViewSqlServerv2k5.getClustered().equalsIgnoreCase("YES")) {
            SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(stringBuffer, "CLUSTERED");
        } else {
            SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(stringBuffer, "NONCLUSTERED");
        }
    }

    private void appendView(StringBuffer stringBuffer, IndexOnViewSqlServerv2k5 indexOnViewSqlServerv2k5, boolean bl) {
        SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(stringBuffer, "ON");
        SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(indexOnViewSqlServerv2k5.getView().getName()));
        SSBIndexOnViewSqlServerv2k5.appendNewLine(stringBuffer, bl, 1);
        SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(stringBuffer, '(');
        SSBIndexOnViewSqlServerv2k5.appendNewLine(stringBuffer, bl, 1);
        TableView tableView = (TableView)indexOnViewSqlServerv2k5.getView().getObject();
        ContainedObject[] containedObjectArray = tableView.getColumns();
        for (int i = 0; i < containedObjectArray.length; ++i) {
            SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(((ColumnView)containedObjectArray[i]).getName()));
            if (i != containedObjectArray.length - 1) {
                this.appendComma(stringBuffer);
            }
            SSBIndexOnViewSqlServerv2k5.appendNewLine(stringBuffer, bl, 1);
        }
        SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(stringBuffer, ')');
    }

    private void appendOptions(StringBuffer stringBuffer, IndexOnViewSqlServerv2k5 indexOnViewSqlServerv2k5, boolean bl) {
        if (indexOnViewSqlServerv2k5.getFillFactor() > 0 || indexOnViewSqlServerv2k5.getIgnoreDupKey().equalsIgnoreCase("YES") || indexOnViewSqlServerv2k5.getRecomputeStatistics().equalsIgnoreCase("NO") || indexOnViewSqlServerv2k5.getSortInTempDB().equalsIgnoreCase("YES")) {
            SSBIndexOnViewSqlServerv2k5.appendNewLine(stringBuffer, bl, 1);
            SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(stringBuffer, "WITH");
            boolean bl2 = false;
            if (indexOnViewSqlServerv2k5.getFillFactor() > 0) {
                if (indexOnViewSqlServerv2k5.getPadIndex().equalsIgnoreCase("YES")) {
                    SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(stringBuffer, "PAD_INDEX");
                    this.appendComma(stringBuffer);
                }
                SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(stringBuffer, "FILLFACTOR");
                SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(stringBuffer, '=');
                this.appendStringWithSpace(stringBuffer, indexOnViewSqlServerv2k5.getFillFactor());
                bl2 = true;
            }
            if (indexOnViewSqlServerv2k5.getIgnoreDupKey().equalsIgnoreCase("YES")) {
                if (bl2) {
                    this.appendComma(stringBuffer);
                }
                SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(stringBuffer, "IGNORE_DUP_KEY");
                bl2 = true;
            }
            if (indexOnViewSqlServerv2k5.getRecomputeStatistics().equalsIgnoreCase("NO")) {
                if (bl2) {
                    this.appendComma(stringBuffer);
                }
                SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(stringBuffer, "STATISTICS_NORECOMPUTE");
                bl2 = true;
            }
            if (indexOnViewSqlServerv2k5.getSortInTempDB().equalsIgnoreCase("YES")) {
                if (bl2) {
                    this.appendComma(stringBuffer);
                }
                SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(stringBuffer, "SORT_IN_TEMPDB");
            }
        }
    }

    private void appendFilegroup(StringBuffer stringBuffer, IndexOnViewSqlServerv2k5 indexOnViewSqlServerv2k5, boolean bl) {
        if (indexOnViewSqlServerv2k5.getFilegroup() != null) {
            SSBIndexOnViewSqlServerv2k5.appendNewLine(stringBuffer, bl, 1);
            SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(stringBuffer, "ON");
            SSBIndexOnViewSqlServerv2k5.appendString(stringBuffer, '\'');
            SSBIndexOnViewSqlServerv2k5.appendString(stringBuffer, indexOnViewSqlServerv2k5.getFilegroup().getName());
            SSBIndexOnViewSqlServerv2k5.appendString(stringBuffer, '\'');
        }
    }

    private void appendExtProperties(StringBuffer stringBuffer, IndexOnViewSqlServerv2k5 indexOnViewSqlServerv2k5, boolean bl) {
        if (!indexOnViewSqlServerv2k5.getProps().trim().equalsIgnoreCase("") && indexOnViewSqlServerv2k5.getView().getUser() != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(indexOnViewSqlServerv2k5.getProps().trim(), ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string = stringTokenizer.nextToken();
                String string2 = stringTokenizer.nextToken();
                SSBIndexOnViewSqlServerv2k5.appendNewLine(stringBuffer, bl, 0);
                SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(stringBuffer, "EXEC");
                SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(stringBuffer, "sp_addextendedproperty");
                SSBIndexOnViewSqlServerv2k5.appendString(stringBuffer, '\'');
                SSBIndexOnViewSqlServerv2k5.appendString(stringBuffer, string.trim());
                SSBIndexOnViewSqlServerv2k5.appendString(stringBuffer, '\'');
                this.appendComma(stringBuffer);
                SSBIndexOnViewSqlServerv2k5.appendString(stringBuffer, '\'');
                SSBIndexOnViewSqlServerv2k5.appendString(stringBuffer, string2.trim());
                SSBIndexOnViewSqlServerv2k5.appendString(stringBuffer, '\'');
                String string3 = "";
                string3 = this.storageDesign.getFormatedName(indexOnViewSqlServerv2k5.getView().getUser().getName());
                this.appendComma(stringBuffer);
                SSBIndexOnViewSqlServerv2k5.appendNewLine(stringBuffer, bl, 1);
                SSBIndexOnViewSqlServerv2k5.appendString(stringBuffer, '\'');
                SSBIndexOnViewSqlServerv2k5.appendString(stringBuffer, "USER");
                SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(stringBuffer, '\'');
                this.appendComma(stringBuffer);
                SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(stringBuffer, string3);
                this.appendComma(stringBuffer);
                SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(stringBuffer, "'Schema-bound View'");
                this.appendComma(stringBuffer);
                SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(indexOnViewSqlServerv2k5.getView().getName()));
                this.appendComma(stringBuffer);
                SSBIndexOnViewSqlServerv2k5.appendString(stringBuffer, '\'');
                SSBIndexOnViewSqlServerv2k5.appendString(stringBuffer, "INDEX");
                SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(stringBuffer, '\'');
                this.appendComma(stringBuffer);
                SSBIndexOnViewSqlServerv2k5.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(indexOnViewSqlServerv2k5.getName()));
                SSBIndexOnViewSqlServerv2k5.appendNewLine(stringBuffer, bl, 0);
                SSBIndexOnViewSqlServerv2k5.appendString(stringBuffer, "GO");
                SSBIndexOnViewSqlServerv2k5.appendNewLine(stringBuffer, bl, 1);
            }
        }
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof IndexOnViewSqlServerv2k5 && ((IndexOnViewSqlServerv2k5)object).getView().getDataBase() != null && !((IndexOnViewSqlServerv2k5)object).getView().getDataBase().isNullInstance() && ((IndexOnViewSqlServerv2k5)object).isMarkedGenerate();
    }
}

