/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.sqlserver.v2k;

import java.util.Iterator;
import oracle.dbtools.crest.exports.ddl.oracle.SSBArcFK_CheckConstr;
import oracle.dbtools.crest.exports.ddl.sqlserver.AbstractSSBSqlServer;
import oracle.dbtools.crest.exports.ddl.sqlserver.v2k.SSBIndexSqlServerv2k;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.DesignObjectPlaceHolder;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.sqlserver.ColumnProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.InstanceDescriptorColumnSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.PKProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UniqueProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.ColumnProxySqlServerv2k;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.StorageDesignSqlServerv2k;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.TableProxySqlServerv2k;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBTableSqlServerv2k
extends AbstractSSBSqlServer {
    private StorageDesignSqlServerv2k storageDesign;
    private SSBIndexSqlServerv2k ssbIndex = new SSBIndexSqlServerv2k();
    private SSBArcFK_CheckConstr arcConstrHandler;

    @Override
    protected void doAppend(StringBuffer stringBuffer, Object object, boolean bl) {
        Table table = null;
        TableProxySqlServerv2k tableProxySqlServerv2k = null;
        if (object == null) {
            return;
        }
        if (object instanceof Table) {
            table = (Table)object;
            this.storageDesign = (StorageDesignSqlServerv2k)this.getStorageDesign(object);
            tableProxySqlServerv2k = (TableProxySqlServerv2k)this.storageDesign.getTableProxySet().getProxy(table.getObjectID());
        } else if (object instanceof TableProxySqlServer) {
            tableProxySqlServerv2k = (TableProxySqlServerv2k)object;
            table = (Table)tableProxySqlServerv2k.getObject();
            this.storageDesign = (StorageDesignSqlServerv2k)this.getStorageDesign(object);
        }
        if (tableProxySqlServerv2k != null && !tableProxySqlServerv2k.isMarkedGenerate()) {
            this.appendIndexes(stringBuffer, tableProxySqlServerv2k, bl);
            return;
        }
        if (table != null) {
            SSBTableSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
            this.appendBeforeCreateScript(stringBuffer, bl, table);
            if (tableProxySqlServerv2k != null && tableProxySqlServerv2k.isCommentChanged()) {
                this.appendComment(stringBuffer, tableProxySqlServerv2k);
            } else {
                this.appendComment(stringBuffer, table);
            }
            if (tableProxySqlServerv2k != null) {
                this.appendCreateTable(stringBuffer, tableProxySqlServerv2k);
                this.appendColumns(stringBuffer, table, tableProxySqlServerv2k, bl);
                this.appendFilegroup(stringBuffer, tableProxySqlServerv2k, bl);
                this.appendTextImage(stringBuffer, tableProxySqlServerv2k, bl);
                SSBTableSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
                SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, "GO");
                DDLFileMaker.incrementCreateTable();
                SSBTableSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
                SSBTableSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
                this.appendAfterCreateScript(stringBuffer, bl, table);
                this.appendColumnCheckConstraints(stringBuffer, tableProxySqlServerv2k, bl);
                if (this.getArcConstrHandler() != null) {
                    this.getArcConstrHandler().appendArcConstraints(stringBuffer, tableProxySqlServerv2k, bl);
                }
                if (table.getDesign().getAppView().getSettings().isGenerateCommentsInRDBMS()) {
                    this.appendTableCommentOn(stringBuffer, table, tableProxySqlServerv2k, bl);
                }
                this.appendBindDefault(stringBuffer, table, tableProxySqlServerv2k, bl);
                this.appendExtProperties(stringBuffer, tableProxySqlServerv2k, bl);
                this.appendColumnExtProperties(stringBuffer, table, tableProxySqlServerv2k, bl);
                this.appendIndexes(stringBuffer, tableProxySqlServerv2k, bl);
            } else {
                this.appendTableCommentOn(stringBuffer, table, tableProxySqlServerv2k, bl);
            }
        }
    }

    private void appendIndexes(StringBuffer stringBuffer, TableProxySqlServer tableProxySqlServer, boolean bl) {
        Iterator iterator = tableProxySqlServer.getIndexes().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            this.ssbIndex.doAppend(stringBuffer, e, bl);
        }
        this.appendIndexesForConstraints(stringBuffer, (Table)tableProxySqlServer.getObject(), tableProxySqlServer);
    }

    private void appendCreateTable(StringBuffer stringBuffer, TableProxySqlServerv2k tableProxySqlServerv2k) {
        if (tableProxySqlServerv2k.getName().length() > tableProxySqlServerv2k.getMaxNameLength()) {
            SSBTableSqlServerv2k.appendNewLine(stringBuffer, true, 0);
            SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, "--  ERROR: Table name length exceeds maximum allowed length(" + tableProxySqlServerv2k.getMaxNameLength() + ")");
            SSBTableSqlServerv2k.appendNewLine(stringBuffer, true, 0);
            DDLFileMaker.incrementErrors();
        }
        SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, "CREATE");
        SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, "TABLE");
        if (tableProxySqlServerv2k.getUser() != null && tableProxySqlServerv2k.getDatabase() != null && !tableProxySqlServerv2k.getDatabase().isNullInstance()) {
            SSBTableSqlServerv2k.appendString(stringBuffer, this.storageDesign.getFormatedName(tableProxySqlServerv2k.getDatabase().getName()));
            SSBTableSqlServerv2k.appendString(stringBuffer, '.');
        }
        SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableProxySqlServerv2k.getLongName()));
    }

    private void appendBindDefault(StringBuffer stringBuffer, Table table, TableProxySqlServerv2k tableProxySqlServerv2k, boolean bl) {
        Column[] columnArray = (Column[])table.getElements();
        Column column = null;
        ColumnProxySqlServerv2k columnProxySqlServerv2k = null;
        SSBTableSqlServerv2k.appendNewLine(stringBuffer, bl, 1);
        if (columnArray.length > 0) {
            for (int i = 0; i < columnArray.length; ++i) {
                if (tableProxySqlServerv2k == null || !(columnProxySqlServerv2k = (ColumnProxySqlServerv2k)tableProxySqlServerv2k.getColumnProxy((column = columnArray[i]).getObjectID())).getDefineDefault() || columnProxySqlServerv2k.getDefaultObject() == null) continue;
                SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, "EXEC");
                SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, "sp_bindefault");
                SSBTableSqlServerv2k.appendString(stringBuffer, '\'');
                SSBTableSqlServerv2k.appendString(stringBuffer, columnProxySqlServerv2k.getDefaultObject().getName());
                SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, '\'');
                this.appendComma(stringBuffer);
                SSBTableSqlServerv2k.appendString(stringBuffer, '\'');
                SSBTableSqlServerv2k.appendString(stringBuffer, columnProxySqlServerv2k.getTableProxy().getName());
                SSBTableSqlServerv2k.appendString(stringBuffer, '.');
                SSBTableSqlServerv2k.appendString(stringBuffer, columnProxySqlServerv2k.getName());
                SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, '\'');
                SSBTableSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
                SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, "GO");
                SSBTableSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
            }
        }
    }

    protected void appendColumns(StringBuffer stringBuffer, Table table, TableProxySqlServerv2k tableProxySqlServerv2k, boolean bl) {
        Column[] columnArray = (Column[])table.getElements();
        Column column = null;
        ColumnProxySqlServerv2k columnProxySqlServerv2k = null;
        Object[] objectArray = null;
        if (tableProxySqlServerv2k != null) {
            objectArray = tableProxySqlServerv2k.getInstanceDescriptorCols().toArray();
        }
        SSBTableSqlServerv2k.appendNewLine(stringBuffer, bl, 1);
        if (columnArray.length == 0 && (objectArray == null || objectArray.length == 0)) {
            SSBTableSqlServerv2k.appendNewLine(stringBuffer, bl, 1);
            stringBuffer.append("-- No columns");
            SSBTableSqlServerv2k.appendNewLine(stringBuffer, bl, 1);
        } else {
            for (int i = 0; i < columnArray.length; ++i) {
                if (i == 0) {
                    SSBTableSqlServerv2k.appendString(stringBuffer, '(');
                } else {
                    stringBuffer.append(", ");
                }
                SSBTableSqlServerv2k.appendNewLine(stringBuffer, bl, 1);
                if (tableProxySqlServerv2k == null) continue;
                column = columnArray[i];
                columnProxySqlServerv2k = (ColumnProxySqlServerv2k)tableProxySqlServerv2k.getColumnProxy(column.getObjectID());
                if (columnProxySqlServerv2k.getComputed()) {
                    SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(columnProxySqlServerv2k.getName()));
                    SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, "AS");
                    SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, columnProxySqlServerv2k.getFormula());
                    continue;
                }
                this.appendColumnNameAndDataType(stringBuffer, columnProxySqlServerv2k, bl);
                this.appendColumnNullsAllowed(stringBuffer, columnProxySqlServerv2k);
                this.appendColate(stringBuffer, columnProxySqlServerv2k);
                this.appendDefault(stringBuffer, columnProxySqlServerv2k);
                this.appendIdentity(stringBuffer, columnProxySqlServerv2k);
                this.appendRowGuidCow(stringBuffer, columnProxySqlServerv2k);
                this.appendColumnConstraints(stringBuffer, column, columnProxySqlServerv2k);
            }
            InstanceDescriptorColumnSqlServer instanceDescriptorColumnSqlServer = null;
            for (int i = 0; i < objectArray.length; ++i) {
                instanceDescriptorColumnSqlServer = (InstanceDescriptorColumnSqlServer)objectArray[i];
                if (columnArray.length == 0 && i == 0) {
                    SSBTableSqlServerv2k.appendString(stringBuffer, '(');
                } else {
                    stringBuffer.append(", ");
                }
                SSBTableSqlServerv2k.appendNewLine(stringBuffer, bl, 1);
                SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(instanceDescriptorColumnSqlServer.getName()));
                SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, instanceDescriptorColumnSqlServer.getDataType());
            }
            this.appendConstrants(stringBuffer, tableProxySqlServerv2k, bl);
            this.appendTableConstraintsDefinition(stringBuffer, table, bl);
            SSBTableSqlServerv2k.appendNewLine(stringBuffer, bl, 1);
            SSBTableSqlServerv2k.appendString(stringBuffer, ')');
        }
    }

    private void appendFilegroup(StringBuffer stringBuffer, TableProxySqlServerv2k tableProxySqlServerv2k, boolean bl) {
        if (tableProxySqlServerv2k.getFilegroup() != null) {
            SSBTableSqlServerv2k.appendNewLine(stringBuffer, bl, 1);
            SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, "ON");
            SSBTableSqlServerv2k.appendString(stringBuffer, '\'');
            SSBTableSqlServerv2k.appendString(stringBuffer, tableProxySqlServerv2k.getFilegroup().getName());
            SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, '\'');
        }
    }

    private void appendTextImage(StringBuffer stringBuffer, TableProxySqlServerv2k tableProxySqlServerv2k, boolean bl) {
        if (tableProxySqlServerv2k.getTextImageFG() != null) {
            SSBTableSqlServerv2k.appendNewLine(stringBuffer, bl, 1);
            SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, "TEXTIMAGE_ON");
            SSBTableSqlServerv2k.appendString(stringBuffer, '\'');
            SSBTableSqlServerv2k.appendString(stringBuffer, tableProxySqlServerv2k.getTextImageFG().getName());
            SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, '\'');
        }
    }

    private void appendColumnNameAndDataType(StringBuffer stringBuffer, ColumnProxySqlServerv2k columnProxySqlServerv2k, boolean bl) {
        if (columnProxySqlServerv2k.getName().length() > columnProxySqlServerv2k.getMaxNameLength()) {
            SSBTableSqlServerv2k.appendNewLine(stringBuffer, true, 0);
            SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, "--  ERROR: Column name length exceeds maximum allowed length(" + columnProxySqlServerv2k.getMaxNameLength() + ")");
            SSBTableSqlServerv2k.appendNewLine(stringBuffer, true, 0);
            DDLFileMaker.incrementErrors();
        }
        SSBTableSqlServerv2k.appendString(stringBuffer, ' ');
        SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(columnProxySqlServerv2k.getName()));
        String string = columnProxySqlServerv2k.getDatatypeString();
        SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, string);
        if (string.equalsIgnoreCase("unknown")) {
            SSBTableSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
            SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, "--  ERROR: Datatype UNKNOWN is not allowed");
            SSBTableSqlServerv2k.appendNewLine(stringBuffer, bl, 5);
            DDLFileMaker.incrementErrors();
        }
    }

    private void appendColumnNullsAllowed(StringBuffer stringBuffer, ColumnProxySqlServerv2k columnProxySqlServerv2k) {
        if (!columnProxySqlServerv2k.getNullsAllowed()) {
            SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, "NOT NULL");
        }
    }

    private void appendColate(StringBuffer stringBuffer, ColumnProxySqlServerv2k columnProxySqlServerv2k) {
        if (!columnProxySqlServerv2k.getCollation().trim().equalsIgnoreCase("")) {
            SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, "COLLATE");
            SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, columnProxySqlServerv2k.getCollation());
        }
    }

    private void appendDefault(StringBuffer stringBuffer, ColumnProxySqlServer columnProxySqlServer) {
        if (!columnProxySqlServer.getDefineDefault() && !columnProxySqlServer.getDefaultValue().trim().equalsIgnoreCase("")) {
            SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, "DEFAULT");
            try {
                String string = columnProxySqlServer.getDefaultValue().trim();
                String string2 = columnProxySqlServer.getColumn().getDatatypeString("SQL Server 2000");
                String string3 = this.addQuotesToDefault(string2, string);
                SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, string3);
            }
            catch (Exception exception) {
                SSBTableSqlServerv2k.appendString(stringBuffer, '\'');
                SSBTableSqlServerv2k.appendString(stringBuffer, columnProxySqlServer.getDefaultValue().trim());
                SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, '\'');
            }
        }
    }

    private void appendIdentity(StringBuffer stringBuffer, ColumnProxySqlServerv2k columnProxySqlServerv2k) {
        if (!columnProxySqlServerv2k.getDefineDefault() && columnProxySqlServerv2k.getAsIdentity()) {
            SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, "IDENTITY");
            if (!"1".equals(columnProxySqlServerv2k.getIdentitySeed()) || columnProxySqlServerv2k.getIdentityIncrement() != 1) {
                SSBTableSqlServerv2k.appendString(stringBuffer, '(');
                SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, columnProxySqlServerv2k.getIdentitySeed());
                this.appendComma(stringBuffer);
                this.appendString(stringBuffer, columnProxySqlServerv2k.getIdentityIncrement());
                SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, ')');
            }
            if (columnProxySqlServerv2k.getIdentityForReplication().equalsIgnoreCase("NO")) {
                SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, "NOT FOR REPLICATION");
            }
        }
    }

    private void appendRowGuidCow(StringBuffer stringBuffer, ColumnProxySqlServerv2k columnProxySqlServerv2k) {
        if (columnProxySqlServerv2k.getRowGuidCol().trim().equalsIgnoreCase("YES")) {
            SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, "ROWGUIDCOL");
        }
    }

    private void appendTableConstraintsDefinition(StringBuffer stringBuffer, Table table, boolean bl) {
        for (TableLevelConstraint tableLevelConstraint : table.getCheckConstraints()) {
            this.appendComma(stringBuffer);
            SSBTableSqlServerv2k.appendNewLine(stringBuffer, bl, 1);
            SSBTableSqlServerv2k.appendString(stringBuffer, ' ');
            SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, "CONSTRAINT");
            SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableLevelConstraint.getName()));
            SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, "CHECK");
            SSBTableSqlServerv2k.appendString(stringBuffer, '(');
            SSBTableSqlServerv2k.appendString(stringBuffer, tableLevelConstraint.getRule());
            SSBTableSqlServerv2k.appendString(stringBuffer, ')');
        }
    }

    private void appendConstrants(StringBuffer stringBuffer, TableProxySqlServerv2k tableProxySqlServerv2k, boolean bl) {
        this.appendPKey(stringBuffer, tableProxySqlServerv2k, bl);
        this.appendUniqueKeys(stringBuffer, tableProxySqlServerv2k, bl);
    }

    private void appendPKey(StringBuffer stringBuffer, TableProxySqlServerv2k tableProxySqlServerv2k, boolean bl) {
        StorageObjectCollection storageObjectCollection = tableProxySqlServerv2k.getPkeys();
        Iterator iterator = storageObjectCollection.iterator();
        while (iterator.hasNext()) {
            PKProxySqlServer pKProxySqlServer = (PKProxySqlServer)iterator.next();
            ColumnProxy[] columnProxyArray = pKProxySqlServer.getColumnProxies();
            if (columnProxyArray.length <= 0 || !pKProxySqlServer.isMarkedGenerate()) continue;
            this.appendComma(stringBuffer);
            SSBTableSqlServerv2k.appendNewLine(stringBuffer, bl, 1);
            SSBTableSqlServerv2k.appendString(stringBuffer, ' ');
            SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, "CONSTRAINT");
            SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(pKProxySqlServer.getName()));
            SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, "PRIMARY KEY");
            if (pKProxySqlServer.isClustered()) {
                SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, "CLUSTERED");
            } else {
                SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, "NONCLUSTERED");
            }
            for (int i = 0; i < columnProxyArray.length; ++i) {
                if (i == 0) {
                    SSBTableSqlServerv2k.appendString(stringBuffer, '(');
                } else {
                    stringBuffer.append(", ");
                }
                ColumnProxy columnProxy = columnProxyArray[i];
                String string = "";
                if (columnProxy.getObject() != null) {
                    string = ((Index)pKProxySqlServer.getObject()).getColumnSortOrder(columnProxy.getObject());
                }
                if ("DESC".equalsIgnoreCase(string)) {
                    SSBTableSqlServerv2k.appendString(stringBuffer, this.storageDesign.getFormatedName(columnProxy.getName()) + " " + string);
                    continue;
                }
                SSBTableSqlServerv2k.appendString(stringBuffer, this.storageDesign.getFormatedName(columnProxy.getName()));
            }
            SSBTableSqlServerv2k.appendString(stringBuffer, ')');
            if (pKProxySqlServer.getFillFactor() > 0 && pKProxySqlServer.getFillFactor() < 100) {
                SSBTableSqlServerv2k.appendNewLine(stringBuffer, bl, 1);
                SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, "WITH");
                SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, "FILLFACTOR");
                SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, '=');
                this.appendStringWithSpace(stringBuffer, pKProxySqlServer.getFillFactor());
            }
            if (pKProxySqlServer.getFilegroup() == null) continue;
            SSBTableSqlServerv2k.appendNewLine(stringBuffer, bl, 1);
            SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, "ON");
            SSBTableSqlServerv2k.appendString(stringBuffer, '\'');
            SSBTableSqlServerv2k.appendString(stringBuffer, pKProxySqlServer.getFilegroup().getName());
            SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, '\'');
        }
    }

    private void appendUniqueKeys(StringBuffer stringBuffer, TableProxySqlServerv2k tableProxySqlServerv2k, boolean bl) {
        StorageObjectCollection storageObjectCollection = tableProxySqlServerv2k.getUkeys();
        Iterator iterator = storageObjectCollection.iterator();
        while (iterator.hasNext()) {
            UniqueProxySqlServer uniqueProxySqlServer = (UniqueProxySqlServer)iterator.next();
            ColumnProxy[] columnProxyArray = uniqueProxySqlServer.getColumnProxies();
            if (columnProxyArray.length <= 0 || !uniqueProxySqlServer.isMarkedGenerate()) continue;
            this.appendComma(stringBuffer);
            SSBTableSqlServerv2k.appendNewLine(stringBuffer, bl, 1);
            SSBTableSqlServerv2k.appendString(stringBuffer, ' ');
            SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, "CONSTRAINT");
            SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(uniqueProxySqlServer.getName()));
            SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, "UNIQUE");
            if (uniqueProxySqlServer.isClustered()) {
                SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, "CLUSTERED");
            } else {
                SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, "NONCLUSTERED");
            }
            for (int i = 0; i < columnProxyArray.length; ++i) {
                if (i == 0) {
                    SSBTableSqlServerv2k.appendString(stringBuffer, '(');
                } else {
                    stringBuffer.append(", ");
                }
                ColumnProxy columnProxy = columnProxyArray[i];
                String string = "";
                if (columnProxy.getObject() != null) {
                    string = ((Index)uniqueProxySqlServer.getObject()).getColumnSortOrder(columnProxy.getObject());
                }
                if ("DESC".equalsIgnoreCase(string)) {
                    SSBTableSqlServerv2k.appendString(stringBuffer, this.storageDesign.getFormatedName(columnProxy.getName()) + " " + string);
                    continue;
                }
                SSBTableSqlServerv2k.appendString(stringBuffer, this.storageDesign.getFormatedName(columnProxy.getName()));
            }
            SSBTableSqlServerv2k.appendString(stringBuffer, ')');
            if (uniqueProxySqlServer.getFillFactor() > 0 && uniqueProxySqlServer.getFillFactor() < 100) {
                SSBTableSqlServerv2k.appendNewLine(stringBuffer, bl, 1);
                SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, "WITH");
                SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, "FILLFACTOR");
                SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, '=');
                this.appendStringWithSpace(stringBuffer, uniqueProxySqlServer.getFillFactor());
            }
            if (uniqueProxySqlServer.getFilegroup() == null) continue;
            SSBTableSqlServerv2k.appendNewLine(stringBuffer, bl, 1);
            SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, "ON");
            SSBTableSqlServerv2k.appendString(stringBuffer, '\'');
            SSBTableSqlServerv2k.appendString(stringBuffer, uniqueProxySqlServer.getFilegroup().getName());
            SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, '\'');
        }
    }

    private void appendColumnConstraints(StringBuffer stringBuffer, Column column, ColumnProxySqlServer columnProxySqlServer) {
        String string;
        if (column.hasConstraintsDefined() && !"".equals(string = column.getConstraintsText(this.storageDesign.getFormatedName(columnProxySqlServer.getName())))) {
            String string2 = column.getConstraintName();
            if (!string2.equals("") && string2.length() <= 128 || column.getDesign().getAppView().getSettings().isGenerateInlineColumnCC()) {
                SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, "CONSTRAINT");
                SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(string2));
                SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, "CHECK");
                SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, '(');
                SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, string);
                SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, ')');
            }
            if ("".equals(string2) || !"".equals(string2) && string2.length() > 128 || column.getDesign().getAppView().getSettings().isGenerateInlineColumnCC()) {
                SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, "CHECK");
                SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, '(');
                SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, string);
                SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, ')');
            }
        }
    }

    protected void appendTableCommentOn(StringBuffer stringBuffer, Table table, TableProxySqlServer tableProxySqlServer, boolean bl) {
        block14: {
            block13: {
                String string = null;
                String string2 = null;
                if (tableProxySqlServer != null && tableProxySqlServer.isCommentInRDBMSChanged()) {
                    string = tableProxySqlServer.getCommentInRDBMS();
                    string2 = tableProxySqlServer.getName();
                } else if (table != null) {
                    string = table.getCommentInRDBMS();
                    string2 = table.getName();
                }
                if (string != null && !string.trim().equalsIgnoreCase("")) {
                    SSBTableSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
                    SSBTableSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
                    SSBTableSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
                    SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, "EXEC");
                    SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, "sp_addextendedproperty");
                    SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, "'MS_Description'");
                    SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, ',');
                    SSBTableSqlServerv2k.appendString(stringBuffer, '\'');
                    SSBTableSqlServerv2k.appendString(stringBuffer, string);
                    SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, '\'');
                    SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, ',');
                    if (tableProxySqlServer != null && tableProxySqlServer.getUser() != null) {
                        SSBTableSqlServerv2k.appendString(stringBuffer, '\'');
                        SSBTableSqlServerv2k.appendString(stringBuffer, "USER");
                        SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, '\'');
                        SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, ',');
                        SSBTableSqlServerv2k.appendString(stringBuffer, '\'');
                        SSBTableSqlServerv2k.appendString(stringBuffer, tableProxySqlServer.getUser().getName());
                        SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, '\'');
                        SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, ',');
                    }
                    SSBTableSqlServerv2k.appendString(stringBuffer, '\'');
                    SSBTableSqlServerv2k.appendString(stringBuffer, "TABLE");
                    SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, '\'');
                    SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, ',');
                    SSBTableSqlServerv2k.appendString(stringBuffer, '\'');
                    SSBTableSqlServerv2k.appendString(stringBuffer, string2);
                    SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, '\'');
                    SSBTableSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
                    SSBTableSqlServerv2k.appendString(stringBuffer, "GO");
                    SSBTableSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
                }
                if (tableProxySqlServer == null) break block13;
                ColumnProxy[] columnProxyArray = tableProxySqlServer.getColumnProxies();
                for (int i = 0; i < columnProxyArray.length; ++i) {
                    ColumnProxy columnProxy = columnProxyArray[i];
                    if (columnProxy.getCommentInRDBMS() != null && columnProxy.isCommentInRDBMSChanged()) {
                        this.appendColumnComment(stringBuffer, columnProxy, tableProxySqlServer, bl);
                        continue;
                    }
                    this.appendColumnComment(stringBuffer, (Column)columnProxy.getObject(), table, bl);
                }
                Iterator iterator = tableProxySqlServer.getPkeys().iterator();
                PKProxySqlServer pKProxySqlServer = null;
                while (iterator.hasNext()) {
                    pKProxySqlServer = (PKProxySqlServer)iterator.next();
                    if (pKProxySqlServer.getCommentInRDBMS() != null && pKProxySqlServer.isCommentInRDBMSChanged()) {
                        this.appendPKeyComment(stringBuffer, pKProxySqlServer, tableProxySqlServer, bl);
                        continue;
                    }
                    this.appendIndexComment(stringBuffer, (Index)pKProxySqlServer.getObject(), table, bl);
                }
                iterator = tableProxySqlServer.getUkeys().iterator();
                UniqueProxySqlServer uniqueProxySqlServer = null;
                while (iterator.hasNext()) {
                    uniqueProxySqlServer = (UniqueProxySqlServer)iterator.next();
                    if (uniqueProxySqlServer.getCommentInRDBMS() != null && uniqueProxySqlServer.isCommentInRDBMSChanged()) {
                        this.appendUKeyComment(stringBuffer, uniqueProxySqlServer, tableProxySqlServer, bl);
                        continue;
                    }
                    this.appendIndexComment(stringBuffer, (Index)uniqueProxySqlServer.getObject(), table, bl);
                }
                break block14;
            }
            if (table == null) break block14;
            ContainedObject[] containedObjectArray = table.getElements();
            for (int i = 0; i < containedObjectArray.length; ++i) {
                Column column = (Column)containedObjectArray[i];
                if (column.getCommentInRDBMS() == null) continue;
                this.appendColumnComment(stringBuffer, column, table, bl);
            }
            Iterator iterator = table.getPKeys().iterator();
            Index index = null;
            while (iterator.hasNext()) {
                index = (Index)iterator.next();
                if (index.getCommentInRDBMS() == null) continue;
                this.appendIndexComment(stringBuffer, index, table, bl);
            }
        }
    }

    protected void appendColumnComment(StringBuffer stringBuffer, ColumnProxy columnProxy, TableProxySqlServer tableProxySqlServer, boolean bl) {
        if (tableProxySqlServer != null && !columnProxy.getCommentInRDBMS().equalsIgnoreCase("")) {
            SSBTableSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
            SSBTableSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
            SSBTableSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
            SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, "EXEC");
            SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, "sp_addextendedproperty");
            SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, "'MS_Description'");
            SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, ',');
            SSBTableSqlServerv2k.appendString(stringBuffer, '\'');
            SSBTableSqlServerv2k.appendString(stringBuffer, columnProxy.getCommentInRDBMS());
            SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, '\'');
            SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, ',');
            if (tableProxySqlServer.getUser() != null) {
                SSBTableSqlServerv2k.appendString(stringBuffer, '\'');
                SSBTableSqlServerv2k.appendString(stringBuffer, "USER");
                SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, '\'');
                SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, ',');
                SSBTableSqlServerv2k.appendString(stringBuffer, '\'');
                SSBTableSqlServerv2k.appendString(stringBuffer, tableProxySqlServer.getUser().getName());
                SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, '\'');
                SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, ',');
            }
            SSBTableSqlServerv2k.appendString(stringBuffer, '\'');
            SSBTableSqlServerv2k.appendString(stringBuffer, "TABLE");
            SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, '\'');
            SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, ',');
            SSBTableSqlServerv2k.appendString(stringBuffer, '\'');
            SSBTableSqlServerv2k.appendString(stringBuffer, tableProxySqlServer.getName());
            SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, '\'');
            SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, ',');
            SSBTableSqlServerv2k.appendString(stringBuffer, '\'');
            SSBTableSqlServerv2k.appendString(stringBuffer, "COLUMN");
            SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, '\'');
            SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, ',');
            SSBTableSqlServerv2k.appendString(stringBuffer, '\'');
            SSBTableSqlServerv2k.appendString(stringBuffer, columnProxy.getName());
            SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, '\'');
            SSBTableSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
            SSBTableSqlServerv2k.appendString(stringBuffer, "GO");
            SSBTableSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
        }
    }

    protected void appendColumnComment(StringBuffer stringBuffer, Column column, Table table, boolean bl) {
        if (!column.getCommentInRDBMS().equalsIgnoreCase("")) {
            SSBTableSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
            SSBTableSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
            SSBTableSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
            SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, "EXEC");
            SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, "sp_addextendedproperty");
            SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, "'MS_Description'");
            SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, ',');
            SSBTableSqlServerv2k.appendString(stringBuffer, '\'');
            SSBTableSqlServerv2k.appendString(stringBuffer, column.getCommentInRDBMS());
            SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, '\'');
            SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, ',');
            SSBTableSqlServerv2k.appendString(stringBuffer, '\'');
            SSBTableSqlServerv2k.appendString(stringBuffer, "TABLE");
            SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, '\'');
            SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, ',');
            SSBTableSqlServerv2k.appendString(stringBuffer, '\'');
            SSBTableSqlServerv2k.appendString(stringBuffer, table.getName());
            SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, '\'');
            SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, ',');
            SSBTableSqlServerv2k.appendString(stringBuffer, '\'');
            SSBTableSqlServerv2k.appendString(stringBuffer, "COLUMN");
            SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, '\'');
            SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, ',');
            SSBTableSqlServerv2k.appendString(stringBuffer, '\'');
            SSBTableSqlServerv2k.appendString(stringBuffer, column.getName());
            SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, '\'');
            SSBTableSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
            SSBTableSqlServerv2k.appendString(stringBuffer, "GO");
            SSBTableSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
        }
    }

    protected void appendPKeyComment(StringBuffer stringBuffer, PKProxySqlServer pKProxySqlServer, TableProxySqlServer tableProxySqlServer, boolean bl) {
        if (tableProxySqlServer != null && !pKProxySqlServer.getCommentInRDBMS().equalsIgnoreCase("")) {
            SSBTableSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
            SSBTableSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
            SSBTableSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
            SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, "EXEC");
            SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, "sp_addextendedproperty");
            SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, "'MS_Description'");
            SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, ',');
            SSBTableSqlServerv2k.appendString(stringBuffer, '\'');
            SSBTableSqlServerv2k.appendString(stringBuffer, pKProxySqlServer.getCommentInRDBMS());
            SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, '\'');
            SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, ',');
            if (tableProxySqlServer.getUser() != null) {
                SSBTableSqlServerv2k.appendString(stringBuffer, '\'');
                SSBTableSqlServerv2k.appendString(stringBuffer, "USER");
                SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, '\'');
                SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, ',');
                SSBTableSqlServerv2k.appendString(stringBuffer, '\'');
                SSBTableSqlServerv2k.appendString(stringBuffer, tableProxySqlServer.getUser().getName());
                SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, '\'');
                SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, ',');
            }
            SSBTableSqlServerv2k.appendString(stringBuffer, '\'');
            SSBTableSqlServerv2k.appendString(stringBuffer, "TABLE");
            SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, '\'');
            SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, ',');
            SSBTableSqlServerv2k.appendString(stringBuffer, '\'');
            SSBTableSqlServerv2k.appendString(stringBuffer, tableProxySqlServer.getName());
            SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, '\'');
            SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, ',');
            SSBTableSqlServerv2k.appendString(stringBuffer, '\'');
            SSBTableSqlServerv2k.appendString(stringBuffer, "CONSTRAINT");
            SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, '\'');
            SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, ',');
            SSBTableSqlServerv2k.appendString(stringBuffer, '\'');
            SSBTableSqlServerv2k.appendString(stringBuffer, pKProxySqlServer.getName());
            SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, '\'');
            SSBTableSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
            SSBTableSqlServerv2k.appendString(stringBuffer, "GO");
            SSBTableSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
        }
    }

    protected void appendUKeyComment(StringBuffer stringBuffer, UniqueProxySqlServer uniqueProxySqlServer, TableProxySqlServer tableProxySqlServer, boolean bl) {
        if (tableProxySqlServer != null && !uniqueProxySqlServer.getCommentInRDBMS().equalsIgnoreCase("")) {
            SSBTableSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
            SSBTableSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
            SSBTableSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
            SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, "EXEC");
            SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, "sp_addextendedproperty");
            SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, "'MS_Description'");
            SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, ',');
            SSBTableSqlServerv2k.appendString(stringBuffer, '\'');
            SSBTableSqlServerv2k.appendString(stringBuffer, uniqueProxySqlServer.getCommentInRDBMS());
            SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, '\'');
            SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, ',');
            if (tableProxySqlServer.getUser() != null) {
                SSBTableSqlServerv2k.appendString(stringBuffer, '\'');
                SSBTableSqlServerv2k.appendString(stringBuffer, "USER");
                SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, '\'');
                SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, ',');
                SSBTableSqlServerv2k.appendString(stringBuffer, '\'');
                SSBTableSqlServerv2k.appendString(stringBuffer, tableProxySqlServer.getUser().getName());
                SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, '\'');
                SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, ',');
            }
            SSBTableSqlServerv2k.appendString(stringBuffer, '\'');
            SSBTableSqlServerv2k.appendString(stringBuffer, "TABLE");
            SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, '\'');
            SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, ',');
            SSBTableSqlServerv2k.appendString(stringBuffer, '\'');
            SSBTableSqlServerv2k.appendString(stringBuffer, tableProxySqlServer.getName());
            SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, '\'');
            SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, ',');
            SSBTableSqlServerv2k.appendString(stringBuffer, '\'');
            SSBTableSqlServerv2k.appendString(stringBuffer, "CONSTRAINT");
            SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, '\'');
            SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, ',');
            SSBTableSqlServerv2k.appendString(stringBuffer, '\'');
            SSBTableSqlServerv2k.appendString(stringBuffer, uniqueProxySqlServer.getName());
            SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, '\'');
            SSBTableSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
            SSBTableSqlServerv2k.appendString(stringBuffer, "GO");
            SSBTableSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
        }
    }

    protected void appendIndexComment(StringBuffer stringBuffer, Index index, Table table, boolean bl) {
        if (!index.getCommentInRDBMS().equalsIgnoreCase("")) {
            SSBTableSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
            SSBTableSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
            SSBTableSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
            SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, "EXEC");
            SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, "sp_addextendedproperty");
            SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, "'MS_Description'");
            SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, ',');
            SSBTableSqlServerv2k.appendString(stringBuffer, '\'');
            SSBTableSqlServerv2k.appendString(stringBuffer, index.getCommentInRDBMS());
            SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, '\'');
            SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, ',');
            SSBTableSqlServerv2k.appendString(stringBuffer, '\'');
            SSBTableSqlServerv2k.appendString(stringBuffer, "TABLE");
            SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, '\'');
            SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, ',');
            SSBTableSqlServerv2k.appendString(stringBuffer, '\'');
            SSBTableSqlServerv2k.appendString(stringBuffer, table.getName());
            SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, '\'');
            SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, ',');
            SSBTableSqlServerv2k.appendString(stringBuffer, '\'');
            SSBTableSqlServerv2k.appendString(stringBuffer, "CONSTRAINT");
            SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, '\'');
            SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, ',');
            SSBTableSqlServerv2k.appendString(stringBuffer, '\'');
            SSBTableSqlServerv2k.appendString(stringBuffer, index.getName());
            SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, '\'');
            SSBTableSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
            SSBTableSqlServerv2k.appendString(stringBuffer, "GO");
            SSBTableSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
        }
    }

    private void appendColumnCheckConstraints(StringBuffer stringBuffer, TableProxy tableProxy, boolean bl) {
        ColumnProxy[] columnProxyArray = tableProxy.getColumnProxies();
        for (int i = 0; i < columnProxyArray.length; ++i) {
            ColumnProxy columnProxy = columnProxyArray[i];
            Column column = columnProxy.getColumn();
            if (!column.hasConstraintsDefined()) continue;
            String string = column.getConstraintsText(this.storageDesign.getFormatedName(columnProxy.getName()));
            String string2 = this.storageDesign.getFormatedName(column.getConstraintName());
            if ("".equals(string) || "".equals(string2) || string2.length() >= 129) continue;
            SSBTableSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
            SSBTableSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
            SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, "ALTER");
            SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, "TABLE");
            SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableProxy.getLongName()));
            SSBTableSqlServerv2k.appendNewLine(stringBuffer, bl, 1);
            SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, "ADD");
            SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, "CONSTRAINT");
            SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, string2);
            SSBTableSqlServerv2k.appendNewLine(stringBuffer, bl, 1);
            SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, "CHECK");
            SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, '(');
            SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, string);
            SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, ')');
            SSBTableSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
            SSBTableSqlServerv2k.appendString(stringBuffer, "GO");
            SSBTableSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
        }
    }

    @Override
    public boolean canHandle(Object object) {
        if (object instanceof Table && ((Table)object).isMarkedGenerate()) {
            return true;
        }
        return object instanceof TableProxySqlServer && ((TableProxySqlServer)object).getDatabase() != null && !((TableProxySqlServer)object).getDatabase().isNullInstance();
    }

    private void appendExtProperties(StringBuffer stringBuffer, Object object, boolean bl) {
        TableProxySqlServerv2k tableProxySqlServerv2k = (TableProxySqlServerv2k)object;
        if (!"".equalsIgnoreCase(tableProxySqlServerv2k.getProps())) {
            if (tableProxySqlServerv2k.getUser() != null) {
                for (int i = 0; i < tableProxySqlServerv2k.getExtPropsSet().size() - 1; ++i) {
                    String string = '\'' + (String)tableProxySqlServerv2k.getExtPropsSet().get(i) + '\'';
                    String string2 = '\'' + (String)tableProxySqlServerv2k.getExtPropsSet().get(++i) + '\'';
                    SSBTableSqlServerv2k.appendNewLine(stringBuffer, bl, 1);
                    SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, "EXEC");
                    SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, "sp_addextendedproperty");
                    String string3 = string + ", " + string2;
                    SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, string3);
                    SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, ',');
                    SSBTableSqlServerv2k.appendNewLine(stringBuffer, bl, 1);
                    SSBTableSqlServerv2k.appendString(stringBuffer, '\'');
                    SSBTableSqlServerv2k.appendString(stringBuffer, "USER");
                    SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, '\'');
                    SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, ',');
                    SSBTableSqlServerv2k.appendString(stringBuffer, this.storageDesign.getFormatedName(tableProxySqlServerv2k.getUser().getName()));
                    SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, ',');
                    SSBTableSqlServerv2k.appendString(stringBuffer, '\'');
                    SSBTableSqlServerv2k.appendString(stringBuffer, "TABLE");
                    SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, '\'');
                    SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, ',');
                    SSBTableSqlServerv2k.appendString(stringBuffer, this.storageDesign.getFormatedName(tableProxySqlServerv2k.getName()));
                    SSBTableSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
                    SSBTableSqlServerv2k.appendString(stringBuffer, "GO");
                    SSBTableSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
                }
            }
        }
    }

    private void appendColumnExtProperties(StringBuffer stringBuffer, Table table, TableProxySqlServerv2k tableProxySqlServerv2k, boolean bl) {
        Column[] columnArray = (Column[])table.getElements();
        Column column = null;
        ColumnProxySqlServerv2k columnProxySqlServerv2k = null;
        SSBTableSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
        for (int i = 0; i < columnArray.length; ++i) {
            if (tableProxySqlServerv2k == null || "".equalsIgnoreCase((columnProxySqlServerv2k = (ColumnProxySqlServerv2k)tableProxySqlServerv2k.getColumnProxy((column = columnArray[i]).getObjectID())).getProps())) continue;
            int n = 0;
            while (n < columnProxySqlServerv2k.getExtPropsSet().size() - 1) {
                if (tableProxySqlServerv2k.getUser() == null) continue;
                String string = '\'' + (String)columnProxySqlServerv2k.getExtPropsSet().get(n) + '\'';
                String string2 = '\'' + (String)columnProxySqlServerv2k.getExtPropsSet().get(++n) + '\'';
                ++n;
                SSBTableSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
                SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, "EXEC");
                SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, "sp_addextendedproperty");
                String string3 = string + ", " + string2;
                SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, string3);
                SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, ',');
                SSBTableSqlServerv2k.appendNewLine(stringBuffer, bl, 1);
                SSBTableSqlServerv2k.appendString(stringBuffer, '\'');
                SSBTableSqlServerv2k.appendString(stringBuffer, "USER");
                SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, '\'');
                SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, ',');
                if (tableProxySqlServerv2k.getUser() != null) {
                    SSBTableSqlServerv2k.appendString(stringBuffer, this.storageDesign.getFormatedName(tableProxySqlServerv2k.getUser().getName()));
                    SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, ',');
                }
                SSBTableSqlServerv2k.appendString(stringBuffer, '\'');
                SSBTableSqlServerv2k.appendString(stringBuffer, "TABLE");
                SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, '\'');
                SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, ',');
                SSBTableSqlServerv2k.appendString(stringBuffer, this.storageDesign.getFormatedName(tableProxySqlServerv2k.getName()));
                SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, ',');
                SSBTableSqlServerv2k.appendString(stringBuffer, '\'');
                SSBTableSqlServerv2k.appendString(stringBuffer, "COLUMN");
                SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, '\'');
                SSBTableSqlServerv2k.appendStringWithSpace(stringBuffer, ',');
                SSBTableSqlServerv2k.appendString(stringBuffer, this.storageDesign.getFormatedName(columnProxySqlServerv2k.getName()));
                SSBTableSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
                SSBTableSqlServerv2k.appendString(stringBuffer, "GO");
                SSBTableSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
            }
        }
    }

    private void appendIndexesForConstraints(StringBuffer stringBuffer, Table table, TableProxy tableProxy) {
        KeyObject[] keyObjectArray = table.getKeys();
        boolean bl = table.getDesign().getDLSettings().isAutomaticPKGeneration();
        boolean bl2 = table.getDesign().getDLSettings().isAutomaticUKGeneration();
        boolean bl3 = table.getDesign().getDLSettings().isAutomaticFKGeneration();
        for (int i = 0; i < keyObjectArray.length; ++i) {
            Index index;
            ContainedObject[] containedObjectArray;
            Index index2 = (Index)keyObjectArray[i];
            if (!(bl && "Primary Constraint".equals(index2.getIndexState()) || bl2 && "Unique Constraint".equals(index2.getIndexState())) && (!index2.isFK() || !bl3) || (containedObjectArray = index2.getElements()).length <= 0 || (index = this.getIndexForColumns(table, index2, containedObjectArray, false)) != null) continue;
            this.ssbIndex.appendIndexForConstraint(stringBuffer, index2, true);
        }
    }

    private Index getIndexForColumns(Table table, Index index, ContainedObject[] containedObjectArray, boolean bl) {
        Object[] objectArray = table.getIndexes().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            DesignObjectPlaceHolder designObjectPlaceHolder = (DesignObjectPlaceHolder)objectArray[i];
            Index index2 = (Index)designObjectPlaceHolder.getDesignObject();
            ContainedObject[] containedObjectArray2 = index2.getElements();
            if (containedObjectArray.length != containedObjectArray2.length) continue;
            boolean bl2 = false;
            for (int j = 0; j < containedObjectArray.length; ++j) {
                String string;
                if (containedObjectArray[j] != containedObjectArray2[j]) {
                    bl2 = true;
                    break;
                }
                if (!bl || "ASC".equalsIgnoreCase(string = index2.getColumnSortOrder(containedObjectArray2[j]).trim()) || "".equalsIgnoreCase(string)) continue;
                bl2 = true;
                break;
            }
            if (bl2 || index2 == index) continue;
            return index2;
        }
        return null;
    }

    public SSBArcFK_CheckConstr getArcConstrHandler() {
        if (this.arcConstrHandler == null && this.storageDesign != null) {
            this.arcConstrHandler = new SSBArcFK_CheckConstr(this.storageDesign);
        }
        return this.arcConstrHandler;
    }
}

