/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.sqlserver.v2k;

import java.util.Iterator;
import oracle.dbtools.crest.exports.ddl.sqlserver.AbstractSSBSqlServer;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.sqlserver.ColumnProxySetSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.ColumnProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.RuleSqlServerv2k;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBRuleSqlServerv2k
extends AbstractSSBSqlServer {
    private StorageDesign storageDesign;

    @Override
    protected void doAppend(StringBuffer stringBuffer, Object object, boolean bl) {
        RuleSqlServerv2k ruleSqlServerv2k = (RuleSqlServerv2k)object;
        this.storageDesign = ruleSqlServerv2k.getStorageDesign();
        this.appendComment(stringBuffer, ruleSqlServerv2k);
        this.appendRule(stringBuffer, ruleSqlServerv2k, bl);
        this.appendBindRule(stringBuffer, ruleSqlServerv2k, bl);
    }

    private void appendRule(StringBuffer stringBuffer, RuleSqlServerv2k ruleSqlServerv2k, boolean bl) {
        if (!ruleSqlServerv2k.getExpression().trim().equalsIgnoreCase("")) {
            this.appendDataBase(stringBuffer, ruleSqlServerv2k.getDatabase(), bl);
            SSBRuleSqlServerv2k.appendStringWithSpace(stringBuffer, "CREATE");
            SSBRuleSqlServerv2k.appendStringWithSpace(stringBuffer, "RULE");
            if (ruleSqlServerv2k.getOwner() != null) {
                SSBRuleSqlServerv2k.appendString(stringBuffer, this.storageDesign.getFormatedName(ruleSqlServerv2k.getOwner().getName()));
                SSBRuleSqlServerv2k.appendString(stringBuffer, '.');
            }
            SSBRuleSqlServerv2k.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(ruleSqlServerv2k.getName()));
            SSBRuleSqlServerv2k.appendNewLine(stringBuffer, bl, 1);
            SSBRuleSqlServerv2k.appendStringWithSpace(stringBuffer, "AS");
            SSBRuleSqlServerv2k.appendNewLine(stringBuffer, bl, 1);
            SSBRuleSqlServerv2k.appendStringWithSpace(stringBuffer, ruleSqlServerv2k.getExpression());
            SSBRuleSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
            SSBRuleSqlServerv2k.appendStringWithSpace(stringBuffer, "GO");
            SSBRuleSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
            DDLFileMaker.incrementCreateRule();
            if (ruleSqlServerv2k.getDesign().getAppView().getSettings().isGenerateCommentsInRDBMS()) {
                this.appendRuleComment(stringBuffer, ruleSqlServerv2k, bl);
            }
        } else {
            SSBRuleSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
            stringBuffer.append("-- Error - Empty expression in rule ");
            stringBuffer.append(this.storageDesign.getFormatedName(ruleSqlServerv2k.getName()));
            SSBRuleSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
            DDLFileMaker.incrementErrors();
        }
    }

    private void appendRuleComment(StringBuffer stringBuffer, RuleSqlServerv2k ruleSqlServerv2k, boolean bl) {
        String string = ruleSqlServerv2k.getCommentInRDBMS();
        if (string != null && !string.trim().equalsIgnoreCase("")) {
            SSBRuleSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
            SSBRuleSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
            SSBRuleSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
            SSBRuleSqlServerv2k.appendStringWithSpace(stringBuffer, "EXEC");
            SSBRuleSqlServerv2k.appendStringWithSpace(stringBuffer, "sp_addextendedproperty");
            SSBRuleSqlServerv2k.appendStringWithSpace(stringBuffer, "'MS_Description'");
            SSBRuleSqlServerv2k.appendStringWithSpace(stringBuffer, ',');
            SSBRuleSqlServerv2k.appendString(stringBuffer, '\'');
            SSBRuleSqlServerv2k.appendString(stringBuffer, string);
            SSBRuleSqlServerv2k.appendStringWithSpace(stringBuffer, '\'');
            SSBRuleSqlServerv2k.appendStringWithSpace(stringBuffer, ',');
            if (ruleSqlServerv2k != null && ruleSqlServerv2k.getOwner() != null) {
                SSBRuleSqlServerv2k.appendString(stringBuffer, '\'');
                SSBRuleSqlServerv2k.appendString(stringBuffer, "USER");
                SSBRuleSqlServerv2k.appendStringWithSpace(stringBuffer, '\'');
                SSBRuleSqlServerv2k.appendStringWithSpace(stringBuffer, ',');
                SSBRuleSqlServerv2k.appendString(stringBuffer, '\'');
                this.appendString(stringBuffer, ruleSqlServerv2k.getOwner());
                SSBRuleSqlServerv2k.appendStringWithSpace(stringBuffer, '\'');
                SSBRuleSqlServerv2k.appendStringWithSpace(stringBuffer, ',');
            }
            SSBRuleSqlServerv2k.appendString(stringBuffer, '\'');
            SSBRuleSqlServerv2k.appendString(stringBuffer, "RULE");
            SSBRuleSqlServerv2k.appendStringWithSpace(stringBuffer, '\'');
            SSBRuleSqlServerv2k.appendStringWithSpace(stringBuffer, ',');
            SSBRuleSqlServerv2k.appendString(stringBuffer, '\'');
            SSBRuleSqlServerv2k.appendString(stringBuffer, this.storageDesign.getFormatedName(ruleSqlServerv2k.getLongName()));
            SSBRuleSqlServerv2k.appendStringWithSpace(stringBuffer, '\'');
            SSBRuleSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
            SSBRuleSqlServerv2k.appendString(stringBuffer, "GO");
            SSBRuleSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
        }
    }

    private void appendBindRule(StringBuffer stringBuffer, RuleSqlServerv2k ruleSqlServerv2k, boolean bl) {
        Iterator iterator = ruleSqlServerv2k.getColumnSet().iterator();
        ColumnProxySetSqlServer columnProxySetSqlServer = (ColumnProxySetSqlServer)ruleSqlServerv2k.getStorageDesign().getColumnProxySet();
        ColumnProxySqlServer columnProxySqlServer = null;
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            SSBRuleSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
            SSBRuleSqlServerv2k.appendStringWithSpace(stringBuffer, "EXEC");
            SSBRuleSqlServerv2k.appendStringWithSpace(stringBuffer, "sp_bindrule");
            SSBRuleSqlServerv2k.appendString(stringBuffer, '\'');
            if (ruleSqlServerv2k.getOwner() != null) {
                SSBRuleSqlServerv2k.appendString(stringBuffer, ruleSqlServerv2k.getOwner().getName());
                SSBRuleSqlServerv2k.appendString(stringBuffer, '.');
            }
            SSBRuleSqlServerv2k.appendString(stringBuffer, ruleSqlServerv2k.getName());
            SSBRuleSqlServerv2k.appendStringWithSpace(stringBuffer, '\'');
            this.appendComma(stringBuffer);
            SSBRuleSqlServerv2k.appendString(stringBuffer, '\'');
            columnProxySqlServer = columnProxySetSqlServer.getByName(string);
            SSBRuleSqlServerv2k.appendString(stringBuffer, this.storageDesign.getFormatedName(columnProxySqlServer.getTableProxy().getName()));
            SSBRuleSqlServerv2k.appendString(stringBuffer, '.');
            SSBRuleSqlServerv2k.appendString(stringBuffer, string);
            SSBRuleSqlServerv2k.appendString(stringBuffer, '\'');
            SSBRuleSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
            SSBRuleSqlServerv2k.appendStringWithSpace(stringBuffer, "GO");
            SSBRuleSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
        }
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof RuleSqlServerv2k && ((RuleSqlServerv2k)object).getDatabase() != null && !((RuleSqlServerv2k)object).getDatabase().isNullInstance() && ((RuleSqlServerv2k)object).isMarkedGenerate();
    }
}

