/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.sqlserver.v2k;

import oracle.dbtools.crest.exports.ddl.sqlserver.AbstractSSBSqlServer;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.RoleSqlServerv2k;

public class SSBRoleSqlServerv2k
extends AbstractSSBSqlServer {
    private StorageDesign storageDesign;

    @Override
    protected void doAppend(StringBuffer stringBuffer, Object object, boolean bl) {
        RoleSqlServerv2k roleSqlServerv2k = (RoleSqlServerv2k)object;
        this.storageDesign = roleSqlServerv2k.getStorageDesign();
        this.appendComment(stringBuffer, roleSqlServerv2k);
        this.appendUse(stringBuffer, roleSqlServerv2k, bl);
        if (!roleSqlServerv2k.getIsApplicationRole()) {
            this.appendAddRole(stringBuffer, roleSqlServerv2k, bl);
            this.appendAddRoleMember(stringBuffer, roleSqlServerv2k, bl);
        } else {
            this.appendAddApplRole(stringBuffer, roleSqlServerv2k, bl);
        }
        this.appendPrivileges(stringBuffer, roleSqlServerv2k, bl);
    }

    protected void appendUse(StringBuffer stringBuffer, RoleSqlServerv2k roleSqlServerv2k, boolean bl) {
        if (roleSqlServerv2k.getDatabase() != null && !roleSqlServerv2k.getDatabase().isNullInstance()) {
            SSBRoleSqlServerv2k.appendStringWithSpace(stringBuffer, "USE");
            SSBRoleSqlServerv2k.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(roleSqlServerv2k.getDatabase().getName()));
            SSBRoleSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
            SSBRoleSqlServerv2k.appendStringWithSpace(stringBuffer, "GO");
            SSBRoleSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
        }
    }

    protected void appendAddRole(StringBuffer stringBuffer, RoleSqlServerv2k roleSqlServerv2k, boolean bl) {
        SSBRoleSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
        SSBRoleSqlServerv2k.appendStringWithSpace(stringBuffer, "EXEC");
        SSBRoleSqlServerv2k.appendStringWithSpace(stringBuffer, "sp_addrole");
        SSBRoleSqlServerv2k.appendString(stringBuffer, '\'');
        SSBRoleSqlServerv2k.appendString(stringBuffer, roleSqlServerv2k.getName());
        SSBRoleSqlServerv2k.appendString(stringBuffer, '\'');
        if (roleSqlServerv2k.getOwner() != null) {
            this.appendComma(stringBuffer);
            SSBRoleSqlServerv2k.appendString(stringBuffer, '\'');
            this.appendString(stringBuffer, roleSqlServerv2k.getOwner());
            SSBRoleSqlServerv2k.appendString(stringBuffer, '\'');
        }
        SSBRoleSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
        SSBRoleSqlServerv2k.appendStringWithSpace(stringBuffer, "GO");
        SSBRoleSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
    }

    protected void appendAddRoleMember(StringBuffer stringBuffer, RoleSqlServerv2k roleSqlServerv2k, boolean bl) {
        for (String string : roleSqlServerv2k.getUserSet()) {
            SSBRoleSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
            SSBRoleSqlServerv2k.appendStringWithSpace(stringBuffer, "EXEC");
            SSBRoleSqlServerv2k.appendStringWithSpace(stringBuffer, "sp_addrolemember");
            SSBRoleSqlServerv2k.appendString(stringBuffer, '\'');
            SSBRoleSqlServerv2k.appendString(stringBuffer, roleSqlServerv2k.getName());
            SSBRoleSqlServerv2k.appendString(stringBuffer, '\'');
            this.appendComma(stringBuffer);
            SSBRoleSqlServerv2k.appendString(stringBuffer, '\'');
            SSBRoleSqlServerv2k.appendString(stringBuffer, this.storageDesign.getFormatedName(string));
            SSBRoleSqlServerv2k.appendString(stringBuffer, '\'');
            SSBRoleSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
            SSBRoleSqlServerv2k.appendStringWithSpace(stringBuffer, "GO");
            SSBRoleSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
        }
    }

    protected void appendAddApplRole(StringBuffer stringBuffer, RoleSqlServerv2k roleSqlServerv2k, boolean bl) {
        SSBRoleSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
        SSBRoleSqlServerv2k.appendStringWithSpace(stringBuffer, "EXEC");
        SSBRoleSqlServerv2k.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName("sp_addapprole"));
        SSBRoleSqlServerv2k.appendString(stringBuffer, '\'');
        SSBRoleSqlServerv2k.appendString(stringBuffer, roleSqlServerv2k.getName());
        SSBRoleSqlServerv2k.appendString(stringBuffer, '\'');
        this.appendComma(stringBuffer);
        SSBRoleSqlServerv2k.appendString(stringBuffer, '\'');
        SSBRoleSqlServerv2k.appendString(stringBuffer, roleSqlServerv2k.decodePassword());
        SSBRoleSqlServerv2k.appendString(stringBuffer, '\'');
        SSBRoleSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
        SSBRoleSqlServerv2k.appendStringWithSpace(stringBuffer, "GO");
        SSBRoleSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
    }

    private void appendPrivileges(StringBuffer stringBuffer, RoleSqlServerv2k roleSqlServerv2k, boolean bl) {
        if (!"".equalsIgnoreCase(roleSqlServerv2k.getSystemPrivileges())) {
            SSBRoleSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
            if (roleSqlServerv2k.getDatabase() != null && !roleSqlServerv2k.getDatabase().isNullInstance()) {
                SSBRoleSqlServerv2k.appendStringWithSpace(stringBuffer, "USE");
                this.appendStringWithSpace(stringBuffer, roleSqlServerv2k.getDatabase());
                SSBRoleSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
                SSBRoleSqlServerv2k.appendString(stringBuffer, "GO");
                SSBRoleSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
            }
            SSBRoleSqlServerv2k.appendStringWithSpace(stringBuffer, "GRANT");
            if (roleSqlServerv2k.getPrivilegesSet().contains("ALL")) {
                SSBRoleSqlServerv2k.appendString(stringBuffer, "ALL");
            } else {
                SSBRoleSqlServerv2k.appendString(stringBuffer, roleSqlServerv2k.getSystemPrivileges());
            }
            SSBRoleSqlServerv2k.appendNewLine(stringBuffer, bl, 1);
            SSBRoleSqlServerv2k.appendStringWithSpace(stringBuffer, "TO");
            this.appendString(stringBuffer, roleSqlServerv2k);
            SSBRoleSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
            SSBRoleSqlServerv2k.appendString(stringBuffer, "GO");
            SSBRoleSqlServerv2k.appendNewLine(stringBuffer, bl, 1);
        }
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof RoleSqlServerv2k && ((RoleSqlServerv2k)object).getDatabase() != null && !((RoleSqlServerv2k)object).getDatabase().isNullInstance() && ((RoleSqlServerv2k)object).isMarkedGenerate();
    }
}

