/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.sqlserver.v2k;

import java.util.StringTokenizer;
import oracle.dbtools.crest.exports.ddl.sqlserver.AbstractSSBSqlServer;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.IndexProxy;
import oracle.dbtools.crest.model.design.storage.sqlserver.IndexProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.IndexProxySqlServerv2k;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.StorageDesignSqlServerv2k;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBIndexSqlServerv2k
extends AbstractSSBSqlServer {
    StorageDesignSqlServerv2k storageDesign;

    @Override
    protected void doAppend(StringBuffer stringBuffer, Object object, boolean bl) {
        Index index = null;
        IndexProxySqlServerv2k indexProxySqlServerv2k = null;
        if (object instanceof Index) {
            index = (Index)object;
            this.storageDesign = (StorageDesignSqlServerv2k)this.getStorageDesign(object);
            indexProxySqlServerv2k = (IndexProxySqlServerv2k)this.storageDesign.getIndexProxySet().getProxy(index.getObjectID());
        } else if (object instanceof IndexProxySqlServer) {
            indexProxySqlServerv2k = (IndexProxySqlServerv2k)object;
            index = (Index)indexProxySqlServerv2k.getObject();
            this.storageDesign = (StorageDesignSqlServerv2k)this.getStorageDesign(object);
        }
        if (indexProxySqlServerv2k != null && indexProxySqlServerv2k.isCommentChanged()) {
            this.appendComment(stringBuffer, indexProxySqlServerv2k);
        } else {
            this.appendComment(stringBuffer, index);
        }
        if (indexProxySqlServerv2k != null) {
            if (indexProxySqlServerv2k.isMarkedGenerate()) {
                SSBIndexSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
                SSBIndexSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
                SSBIndexSqlServerv2k.appendStringWithSpace(stringBuffer, "CREATE");
                this.appendUnique(stringBuffer, indexProxySqlServerv2k);
                this.appendClustered(stringBuffer, indexProxySqlServerv2k);
                SSBIndexSqlServerv2k.appendStringWithSpace(stringBuffer, "INDEX");
                SSBIndexSqlServerv2k.appendNewLine(stringBuffer, bl, 1);
                SSBIndexSqlServerv2k.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(indexProxySqlServerv2k.getLongName()));
                this.appendTable(stringBuffer, indexProxySqlServerv2k, bl);
                this.appendOptions(stringBuffer, indexProxySqlServerv2k);
                this.appendFilegroup(stringBuffer, indexProxySqlServerv2k, bl);
                SSBIndexSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
                SSBIndexSqlServerv2k.appendStringWithSpace(stringBuffer, "GO");
                DDLFileMaker.incrementCreateIndex();
                SSBIndexSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
                if (index.getDesign().getAppView().getSettings().isGenerateCommentsInRDBMS()) {
                    this.appendIndexComment(stringBuffer, index, indexProxySqlServerv2k, bl);
                }
                this.appendExtProperties(stringBuffer, indexProxySqlServerv2k, bl);
            } else if (index.hasIndexExpression()) {
                SSBIndexSqlServerv2k.appendStringWithSpace(stringBuffer, index.getIndexExpression());
            } else {
                stringBuffer.append("-- Index ").append(index.getName()).append(" on Table ").append(indexProxySqlServerv2k.getTableName()).append(" not created in ddl");
                SSBIndexSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
            }
        } else if (index.getDesign().getAppView().getSettings().isGenerateCommentsInRDBMS()) {
            this.appendIndexComment(stringBuffer, index, indexProxySqlServerv2k, bl);
        }
    }

    protected void appendIndexComment(StringBuffer stringBuffer, Index index, IndexProxySqlServer indexProxySqlServer, boolean bl) {
        String string = null;
        String string2 = null;
        if (indexProxySqlServer != null && indexProxySqlServer.isCommentInRDBMSChanged()) {
            string = indexProxySqlServer.getCommentInRDBMS();
            string2 = indexProxySqlServer.getTableProxy().getName();
        } else if (index != null) {
            string = index.getCommentInRDBMS();
            string2 = index.getContainerObject().getName();
        }
        if (string != null && !string.trim().equalsIgnoreCase("")) {
            SSBIndexSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
            SSBIndexSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
            SSBIndexSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
            SSBIndexSqlServerv2k.appendStringWithSpace(stringBuffer, "EXEC");
            SSBIndexSqlServerv2k.appendStringWithSpace(stringBuffer, "sp_addextendedproperty");
            SSBIndexSqlServerv2k.appendStringWithSpace(stringBuffer, "'MS_Description'");
            SSBIndexSqlServerv2k.appendStringWithSpace(stringBuffer, ',');
            SSBIndexSqlServerv2k.appendString(stringBuffer, '\'');
            SSBIndexSqlServerv2k.appendString(stringBuffer, string);
            SSBIndexSqlServerv2k.appendStringWithSpace(stringBuffer, '\'');
            SSBIndexSqlServerv2k.appendStringWithSpace(stringBuffer, ',');
            if (indexProxySqlServer != null && ((TableProxySqlServer)indexProxySqlServer.getTableProxy()).getUser() != null) {
                SSBIndexSqlServerv2k.appendString(stringBuffer, "'user'");
                SSBIndexSqlServerv2k.appendStringWithSpace(stringBuffer, ',');
                SSBIndexSqlServerv2k.appendString(stringBuffer, '\'');
                SSBIndexSqlServerv2k.appendString(stringBuffer, this.storageDesign.getFormatedName(((TableProxySqlServer)indexProxySqlServer.getTableProxy()).getUser().getName()));
                SSBIndexSqlServerv2k.appendStringWithSpace(stringBuffer, '\'');
                SSBIndexSqlServerv2k.appendStringWithSpace(stringBuffer, ',');
            }
            SSBIndexSqlServerv2k.appendString(stringBuffer, "'table'");
            SSBIndexSqlServerv2k.appendStringWithSpace(stringBuffer, ',');
            SSBIndexSqlServerv2k.appendString(stringBuffer, '\'');
            SSBIndexSqlServerv2k.appendString(stringBuffer, this.storageDesign.getFormatedName(string2));
            SSBIndexSqlServerv2k.appendStringWithSpace(stringBuffer, '\'');
            SSBIndexSqlServerv2k.appendStringWithSpace(stringBuffer, ',');
            SSBIndexSqlServerv2k.appendString(stringBuffer, "'index'");
            SSBIndexSqlServerv2k.appendStringWithSpace(stringBuffer, ',');
            SSBIndexSqlServerv2k.appendString(stringBuffer, '\'');
            SSBIndexSqlServerv2k.appendString(stringBuffer, this.storageDesign.getFormatedName(index.getName()));
            SSBIndexSqlServerv2k.appendStringWithSpace(stringBuffer, '\'');
            SSBIndexSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
            SSBIndexSqlServerv2k.appendString(stringBuffer, "GO");
            SSBIndexSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
        }
    }

    private void appendUnique(StringBuffer stringBuffer, IndexProxySqlServerv2k indexProxySqlServerv2k) {
        if (indexProxySqlServerv2k.getUnique().equalsIgnoreCase("YES")) {
            SSBIndexSqlServerv2k.appendStringWithSpace(stringBuffer, "UNIQUE");
        }
    }

    private void appendClustered(StringBuffer stringBuffer, IndexProxySqlServerv2k indexProxySqlServerv2k) {
        if (indexProxySqlServerv2k.isClustered()) {
            SSBIndexSqlServerv2k.appendStringWithSpace(stringBuffer, "CLUSTERED");
        } else {
            SSBIndexSqlServerv2k.appendStringWithSpace(stringBuffer, "NONCLUSTERED");
        }
    }

    private void appendTable(StringBuffer stringBuffer, IndexProxySqlServerv2k indexProxySqlServerv2k, boolean bl) {
        SSBIndexSqlServerv2k.appendStringWithSpace(stringBuffer, "ON");
        SSBIndexSqlServerv2k.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(indexProxySqlServerv2k.getTableProxy().getName()));
        SSBIndexSqlServerv2k.appendNewLine(stringBuffer, bl, 1);
        SSBIndexSqlServerv2k.appendStringWithSpace(stringBuffer, '(');
        SSBIndexSqlServerv2k.appendNewLine(stringBuffer, bl, 1);
        if (indexProxySqlServerv2k.getIndex().hasIndexExpression()) {
            SSBIndexSqlServerv2k.appendString(stringBuffer, ' ');
            SSBIndexSqlServerv2k.appendString(stringBuffer, indexProxySqlServerv2k.getIndex().getIndexExpression());
            SSBIndexSqlServerv2k.appendNewLine(stringBuffer, bl, 1);
        }
        ColumnProxy[] columnProxyArray = indexProxySqlServerv2k.getColumnProxies();
        for (int i = 0; i < columnProxyArray.length; ++i) {
            String string = "";
            if (columnProxyArray[i].getObject() != null) {
                string = ((Index)indexProxySqlServerv2k.getObject()).getColumnSortOrder(columnProxyArray[i].getObject());
            }
            SSBIndexSqlServerv2k.appendString(stringBuffer, ' ');
            if ("DESC".equalsIgnoreCase(string)) {
                SSBIndexSqlServerv2k.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(columnProxyArray[i].getName()) + " " + string);
            } else {
                SSBIndexSqlServerv2k.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(columnProxyArray[i].getName()));
            }
            if (i != columnProxyArray.length - 1) {
                this.appendComma(stringBuffer);
            }
            SSBIndexSqlServerv2k.appendNewLine(stringBuffer, bl, 1);
        }
        SSBIndexSqlServerv2k.appendStringWithSpace(stringBuffer, ')');
    }

    private void appendOptions(StringBuffer stringBuffer, IndexProxySqlServerv2k indexProxySqlServerv2k) {
        if (indexProxySqlServerv2k.getFillFactor() > 0 || indexProxySqlServerv2k.getIgnoreDupKey().equalsIgnoreCase("YES") || indexProxySqlServerv2k.getRecomputeStatistics().equalsIgnoreCase("NO") || indexProxySqlServerv2k.getSortInTempDB().equalsIgnoreCase("YES")) {
            SSBIndexSqlServerv2k.appendStringWithSpace(stringBuffer, "WITH");
            boolean bl = false;
            if (indexProxySqlServerv2k.getFillFactor() > 0) {
                if (indexProxySqlServerv2k.getPadIndex().equalsIgnoreCase("YES")) {
                    SSBIndexSqlServerv2k.appendStringWithSpace(stringBuffer, "PAD_INDEX");
                    this.appendComma(stringBuffer);
                }
                SSBIndexSqlServerv2k.appendStringWithSpace(stringBuffer, "FILLFACTOR");
                SSBIndexSqlServerv2k.appendStringWithSpace(stringBuffer, '=');
                this.appendStringWithSpace(stringBuffer, indexProxySqlServerv2k.getFillFactor());
                bl = true;
            }
            if (indexProxySqlServerv2k.getIgnoreDupKey().equalsIgnoreCase("YES")) {
                if (bl) {
                    this.appendComma(stringBuffer);
                }
                SSBIndexSqlServerv2k.appendStringWithSpace(stringBuffer, "IGNORE_DUP_KEY");
                bl = true;
            }
            if (indexProxySqlServerv2k.getRecomputeStatistics().equalsIgnoreCase("NO")) {
                if (bl) {
                    this.appendComma(stringBuffer);
                }
                SSBIndexSqlServerv2k.appendStringWithSpace(stringBuffer, "STATISTICS_NORECOMPUTE");
                bl = true;
            }
            if (indexProxySqlServerv2k.getSortInTempDB().equalsIgnoreCase("YES")) {
                if (bl) {
                    this.appendComma(stringBuffer);
                }
                SSBIndexSqlServerv2k.appendStringWithSpace(stringBuffer, "SORT_IN_TEMPDB");
            }
        }
    }

    private void appendFilegroup(StringBuffer stringBuffer, IndexProxySqlServerv2k indexProxySqlServerv2k, boolean bl) {
        if (indexProxySqlServerv2k.getFilegroup() != null) {
            SSBIndexSqlServerv2k.appendNewLine(stringBuffer, bl, 1);
            SSBIndexSqlServerv2k.appendStringWithSpace(stringBuffer, "ON");
            SSBIndexSqlServerv2k.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(indexProxySqlServerv2k.getFilegroup().getName()));
        }
    }

    private void appendExtProperties(StringBuffer stringBuffer, IndexProxySqlServerv2k indexProxySqlServerv2k, boolean bl) {
        if (!indexProxySqlServerv2k.getProps().trim().equalsIgnoreCase("") && ((TableProxySqlServer)indexProxySqlServerv2k.getTableProxy()).getUser() != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(indexProxySqlServerv2k.getProps().trim(), ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string = stringTokenizer.nextToken();
                String string2 = stringTokenizer.nextToken();
                SSBIndexSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
                SSBIndexSqlServerv2k.appendStringWithSpace(stringBuffer, "EXEC");
                SSBIndexSqlServerv2k.appendStringWithSpace(stringBuffer, "sp_addextendedproperty");
                SSBIndexSqlServerv2k.appendStringWithSpace(stringBuffer, string);
                this.appendComma(stringBuffer);
                SSBIndexSqlServerv2k.appendStringWithSpace(stringBuffer, string2);
                String string3 = "";
                string3 = ((TableProxySqlServer)indexProxySqlServerv2k.getTableProxy()).getUser().getName();
                this.appendComma(stringBuffer);
                SSBIndexSqlServerv2k.appendNewLine(stringBuffer, bl, 1);
                SSBIndexSqlServerv2k.appendStringWithSpace(stringBuffer, "'user'");
                this.appendComma(stringBuffer);
                SSBIndexSqlServerv2k.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(string3));
                this.appendComma(stringBuffer);
                SSBIndexSqlServerv2k.appendStringWithSpace(stringBuffer, "'table'");
                this.appendComma(stringBuffer);
                SSBIndexSqlServerv2k.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(indexProxySqlServerv2k.getTableProxy().getName()));
                this.appendComma(stringBuffer);
                SSBIndexSqlServerv2k.appendStringWithSpace(stringBuffer, "'index'");
                this.appendComma(stringBuffer);
                SSBIndexSqlServerv2k.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(indexProxySqlServerv2k.getName()));
                SSBIndexSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
                SSBIndexSqlServerv2k.appendString(stringBuffer, "GO");
                SSBIndexSqlServerv2k.appendNewLine(stringBuffer, bl, 1);
            }
        }
    }

    @Override
    public boolean canHandle(Object object) {
        if (object instanceof Index && ((Index)object).isMarkedGenerate()) {
            return true;
        }
        return object instanceof IndexProxy && ((TableProxySqlServer)((IndexProxy)object).getTableProxy()).getDatabase() != null && !((TableProxySqlServer)((IndexProxy)object).getTableProxy()).getDatabase().isNullInstance() && ((IndexProxy)object).isMarkedGenerate();
    }

    public void appendIndexForConstraint(StringBuffer stringBuffer, Index index, boolean bl) {
        StringBuffer stringBuffer2 = new StringBuffer();
        String string = "";
        Index index2 = null;
        IndexProxy indexProxy = null;
        index2 = index;
        StorageDesignSqlServerv2k storageDesignSqlServerv2k = (StorageDesignSqlServerv2k)this.getStorageDesign(index);
        if ("Primary Constraint".equals(index2.getIndexState())) {
            indexProxy = (IndexProxy)storageDesignSqlServerv2k.getPKProxySet().getProxy(index2.getObjectID());
        } else if ("Unique Constraint".equals(index2.getIndexState())) {
            indexProxy = (IndexProxy)storageDesignSqlServerv2k.getUniqueProxySet().getProxy(index2.getObjectID());
        } else if (index2.isFK()) {
            indexProxy = (IndexProxy)storageDesignSqlServerv2k.getFKProxySet().getProxy(index2.getObjectID());
        }
        if (index2 != null && !index2.isOidKey() && indexProxy != null) {
            this.storageDesign = (StorageDesignSqlServerv2k)indexProxy.getStorageDesign();
            if (indexProxy.isMarkedGenerate()) {
                if (index2.getElements().length > 0) {
                    if (indexProxy.isCommentChanged()) {
                        this.appendComment(stringBuffer, indexProxy);
                    } else {
                        this.appendComment(stringBuffer, index2);
                    }
                    String string2 = indexProxy.getName();
                    String string3 = indexProxy.getLongName();
                    if (string2.length() < indexProxy.getMaxNameLength()) {
                        string2 = string2 + "X";
                        string3 = string3 + "X";
                    }
                    if (string2.length() > indexProxy.getMaxNameLength()) {
                        SSBIndexSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
                        SSBIndexSqlServerv2k.appendStringWithSpace(stringBuffer, "--  ERROR: Index name length exceeds maximum allowed length(" + indexProxy.getMaxNameLength() + ")");
                        SSBIndexSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
                        DDLFileMaker.incrementErrors();
                    }
                    SSBIndexSqlServerv2k.appendStringWithSpace(stringBuffer2, "CREATE");
                    if ("Primary Constraint".equals(index2.getIndexState()) || "Unique Constraint".equals(index2.getIndexState())) {
                        SSBIndexSqlServerv2k.appendStringWithSpace(stringBuffer2, "UNIQUE");
                    }
                    SSBIndexSqlServerv2k.appendStringWithSpace(stringBuffer2, "INDEX");
                    SSBIndexSqlServerv2k.appendStringWithSpace(stringBuffer2, storageDesignSqlServerv2k.getFormatedName(string3));
                    string = stringBuffer2.toString();
                    SSBIndexSqlServerv2k.appendStringWithSpace(stringBuffer2, "ON");
                    SSBIndexSqlServerv2k.appendStringWithSpace(stringBuffer2, storageDesignSqlServerv2k.getFormatedName(indexProxy.getTableProxy().getLongName()));
                    this.appendConstraintElementList(stringBuffer2, index2, indexProxy, true);
                    SSBIndexSqlServerv2k.appendNewLine(stringBuffer2, bl, 0);
                    this.appendLineFinisher(stringBuffer2, bl);
                    this.appendToBuffer(stringBuffer, stringBuffer2, string);
                    DDLFileMaker.incrementCreateIndex();
                } else {
                    SSBIndexSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
                    stringBuffer.append("-- Error - Index ");
                    stringBuffer.append(storageDesignSqlServerv2k.getFormatedName(index2.getName()));
                    stringBuffer.append(" has no columns");
                    SSBIndexSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
                    DDLFileMaker.incrementErrors();
                }
            }
        }
    }

    private void appendConstraintElementList(StringBuffer stringBuffer, Index index, IndexProxy indexProxy, boolean bl) {
        ColumnProxy columnProxy = null;
        ColumnProxy[] columnProxyArray = indexProxy.getColumnProxies();
        SSBIndexSqlServerv2k.appendNewLine(stringBuffer, bl, 1);
        if (columnProxyArray.length < 1) {
            SSBIndexSqlServerv2k.appendStringWithSpace(stringBuffer, "-- No Columns");
            SSBIndexSqlServerv2k.appendNewLine(stringBuffer, bl, 1);
        }
        SSBIndexSqlServerv2k.appendStringWithSpace(stringBuffer, '(');
        for (int i = 0; i < columnProxyArray.length; ++i) {
            if (i != 0) {
                SSBIndexSqlServerv2k.appendStringWithSpace(stringBuffer, ',');
            }
            columnProxy = columnProxyArray[i];
            SSBIndexSqlServerv2k.appendNewLine(stringBuffer, bl, 1);
            SSBIndexSqlServerv2k.appendString(stringBuffer, ' ');
            String string = this.storageDesign.getFormatedName(columnProxy.getName());
            SSBIndexSqlServerv2k.appendStringWithSpace(stringBuffer, string);
            SSBIndexSqlServerv2k.appendStringWithSpace(stringBuffer, index.getColumnSortOrder(columnProxy));
        }
        SSBIndexSqlServerv2k.appendNewLine(stringBuffer, bl, 1);
        SSBIndexSqlServerv2k.appendStringWithSpace(stringBuffer, ')');
    }
}

