/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.sqlserver.v2k;

import java.util.StringTokenizer;
import oracle.dbtools.crest.exports.ddl.sqlserver.AbstractSSBSqlServer;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.relational.ColumnView;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.IndexOnViewSqlServerv2k;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBIndexOnViewSqlServerv2k
extends AbstractSSBSqlServer {
    private StorageDesign storageDesign;

    @Override
    protected void doAppend(StringBuffer stringBuffer, Object object, boolean bl) {
        IndexOnViewSqlServerv2k indexOnViewSqlServerv2k = (IndexOnViewSqlServerv2k)object;
        this.storageDesign = indexOnViewSqlServerv2k.getStorageDesign();
        this.appendComment(stringBuffer, indexOnViewSqlServerv2k);
        TableView tableView = (TableView)indexOnViewSqlServerv2k.getView().getObject();
        if (tableView.getColumns().length > 0) {
            SSBIndexOnViewSqlServerv2k.appendStringWithSpace(stringBuffer, "CREATE");
            this.appendUnique(stringBuffer, indexOnViewSqlServerv2k);
            this.appendClustered(stringBuffer, indexOnViewSqlServerv2k);
            SSBIndexOnViewSqlServerv2k.appendStringWithSpace(stringBuffer, "INDEX");
            SSBIndexOnViewSqlServerv2k.appendNewLine(stringBuffer, bl, 1);
            SSBIndexOnViewSqlServerv2k.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(indexOnViewSqlServerv2k.getName()));
            this.appendView(stringBuffer, indexOnViewSqlServerv2k, bl);
            this.appendOptions(stringBuffer, indexOnViewSqlServerv2k, bl);
            this.appendFilegroup(stringBuffer, indexOnViewSqlServerv2k, bl);
            SSBIndexOnViewSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
            SSBIndexOnViewSqlServerv2k.appendStringWithSpace(stringBuffer, "GO");
            DDLFileMaker.incrementCreateIndexOnView();
            if (indexOnViewSqlServerv2k.getDesign().getAppView().getSettings().isGenerateCommentsInRDBMS()) {
                this.appendIndexOnViewComment(stringBuffer, indexOnViewSqlServerv2k, bl);
            }
            this.appendExtProperties(stringBuffer, indexOnViewSqlServerv2k, bl);
        } else {
            SSBIndexOnViewSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
            SSBIndexOnViewSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
            stringBuffer.append("-- Index ").append(indexOnViewSqlServerv2k.getName()).append(" on View ").append(indexOnViewSqlServerv2k.getView().getName()).append(" not created in ddl");
            DDLFileMaker.incrementErrors();
            SSBIndexOnViewSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
        }
    }

    protected void appendIndexOnViewComment(StringBuffer stringBuffer, IndexOnViewSqlServerv2k indexOnViewSqlServerv2k, boolean bl) {
        String string = indexOnViewSqlServerv2k.getCommentInRDBMS();
        if (string != null && !string.trim().equalsIgnoreCase("")) {
            SSBIndexOnViewSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
            SSBIndexOnViewSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
            SSBIndexOnViewSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
            SSBIndexOnViewSqlServerv2k.appendStringWithSpace(stringBuffer, "EXEC");
            SSBIndexOnViewSqlServerv2k.appendStringWithSpace(stringBuffer, "sp_addextendedproperty");
            SSBIndexOnViewSqlServerv2k.appendStringWithSpace(stringBuffer, "'MS_Description'");
            SSBIndexOnViewSqlServerv2k.appendStringWithSpace(stringBuffer, ',');
            SSBIndexOnViewSqlServerv2k.appendString(stringBuffer, '\'');
            SSBIndexOnViewSqlServerv2k.appendString(stringBuffer, string);
            SSBIndexOnViewSqlServerv2k.appendStringWithSpace(stringBuffer, '\'');
            SSBIndexOnViewSqlServerv2k.appendStringWithSpace(stringBuffer, ',');
            if (indexOnViewSqlServerv2k != null && indexOnViewSqlServerv2k.getView().getUser() != null) {
                SSBIndexOnViewSqlServerv2k.appendString(stringBuffer, '\'');
                SSBIndexOnViewSqlServerv2k.appendString(stringBuffer, "USER");
                SSBIndexOnViewSqlServerv2k.appendStringWithSpace(stringBuffer, '\'');
                SSBIndexOnViewSqlServerv2k.appendStringWithSpace(stringBuffer, ',');
                SSBIndexOnViewSqlServerv2k.appendString(stringBuffer, '\'');
                SSBIndexOnViewSqlServerv2k.appendString(stringBuffer, this.storageDesign.getFormatedName(indexOnViewSqlServerv2k.getView().getUser().getName()));
                SSBIndexOnViewSqlServerv2k.appendStringWithSpace(stringBuffer, '\'');
                SSBIndexOnViewSqlServerv2k.appendStringWithSpace(stringBuffer, ',');
            }
            SSBIndexOnViewSqlServerv2k.appendString(stringBuffer, '\'');
            SSBIndexOnViewSqlServerv2k.appendString(stringBuffer, "VIEW");
            SSBIndexOnViewSqlServerv2k.appendStringWithSpace(stringBuffer, '\'');
            SSBIndexOnViewSqlServerv2k.appendStringWithSpace(stringBuffer, ',');
            SSBIndexOnViewSqlServerv2k.appendString(stringBuffer, '\'');
            SSBIndexOnViewSqlServerv2k.appendString(stringBuffer, this.storageDesign.getFormatedName(indexOnViewSqlServerv2k.getLongName()));
            SSBIndexOnViewSqlServerv2k.appendStringWithSpace(stringBuffer, '\'');
            SSBIndexOnViewSqlServerv2k.appendStringWithSpace(stringBuffer, ',');
            SSBIndexOnViewSqlServerv2k.appendString(stringBuffer, '\'');
            SSBIndexOnViewSqlServerv2k.appendString(stringBuffer, "INDEX");
            SSBIndexOnViewSqlServerv2k.appendStringWithSpace(stringBuffer, '\'');
            SSBIndexOnViewSqlServerv2k.appendStringWithSpace(stringBuffer, ',');
            SSBIndexOnViewSqlServerv2k.appendString(stringBuffer, '\'');
            SSBIndexOnViewSqlServerv2k.appendString(stringBuffer, this.storageDesign.getFormatedName(indexOnViewSqlServerv2k.getName()));
            SSBIndexOnViewSqlServerv2k.appendStringWithSpace(stringBuffer, '\'');
            SSBIndexOnViewSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
            SSBIndexOnViewSqlServerv2k.appendString(stringBuffer, "GO");
            SSBIndexOnViewSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
        }
    }

    private void appendUnique(StringBuffer stringBuffer, IndexOnViewSqlServerv2k indexOnViewSqlServerv2k) {
        if (indexOnViewSqlServerv2k.getUnique().equalsIgnoreCase("YES")) {
            SSBIndexOnViewSqlServerv2k.appendStringWithSpace(stringBuffer, "UNIQUE");
        }
    }

    private void appendClustered(StringBuffer stringBuffer, IndexOnViewSqlServerv2k indexOnViewSqlServerv2k) {
        if (indexOnViewSqlServerv2k.getClustered().equalsIgnoreCase("YES")) {
            SSBIndexOnViewSqlServerv2k.appendStringWithSpace(stringBuffer, "CLUSTERED");
        } else {
            SSBIndexOnViewSqlServerv2k.appendStringWithSpace(stringBuffer, "NONCLUSTERED");
        }
    }

    private void appendView(StringBuffer stringBuffer, IndexOnViewSqlServerv2k indexOnViewSqlServerv2k, boolean bl) {
        SSBIndexOnViewSqlServerv2k.appendStringWithSpace(stringBuffer, "ON");
        SSBIndexOnViewSqlServerv2k.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(indexOnViewSqlServerv2k.getView().getName()));
        SSBIndexOnViewSqlServerv2k.appendNewLine(stringBuffer, bl, 1);
        SSBIndexOnViewSqlServerv2k.appendStringWithSpace(stringBuffer, '(');
        SSBIndexOnViewSqlServerv2k.appendNewLine(stringBuffer, bl, 1);
        TableView tableView = (TableView)indexOnViewSqlServerv2k.getView().getObject();
        ContainedObject[] containedObjectArray = tableView.getColumns();
        for (int i = 0; i < containedObjectArray.length; ++i) {
            SSBIndexOnViewSqlServerv2k.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(((ColumnView)containedObjectArray[i]).getName()));
            if (i != containedObjectArray.length - 1) {
                this.appendComma(stringBuffer);
            }
            SSBIndexOnViewSqlServerv2k.appendNewLine(stringBuffer, bl, 1);
        }
        SSBIndexOnViewSqlServerv2k.appendStringWithSpace(stringBuffer, ')');
    }

    private void appendOptions(StringBuffer stringBuffer, IndexOnViewSqlServerv2k indexOnViewSqlServerv2k, boolean bl) {
        if (indexOnViewSqlServerv2k.getFillFactor() > 0 || indexOnViewSqlServerv2k.getIgnoreDupKey().equalsIgnoreCase("YES") || indexOnViewSqlServerv2k.getRecomputeStatistics().equalsIgnoreCase("NO") || indexOnViewSqlServerv2k.getSortInTempDB().equalsIgnoreCase("YES")) {
            SSBIndexOnViewSqlServerv2k.appendNewLine(stringBuffer, bl, 1);
            SSBIndexOnViewSqlServerv2k.appendStringWithSpace(stringBuffer, "WITH");
            boolean bl2 = false;
            if (indexOnViewSqlServerv2k.getFillFactor() > 0) {
                if (indexOnViewSqlServerv2k.getPadIndex().equalsIgnoreCase("YES")) {
                    SSBIndexOnViewSqlServerv2k.appendStringWithSpace(stringBuffer, "PAD_INDEX");
                    this.appendComma(stringBuffer);
                }
                SSBIndexOnViewSqlServerv2k.appendStringWithSpace(stringBuffer, "FILLFACTOR");
                SSBIndexOnViewSqlServerv2k.appendStringWithSpace(stringBuffer, '=');
                this.appendStringWithSpace(stringBuffer, indexOnViewSqlServerv2k.getFillFactor());
                bl2 = true;
            }
            if (indexOnViewSqlServerv2k.getIgnoreDupKey().equalsIgnoreCase("YES")) {
                if (bl2) {
                    this.appendComma(stringBuffer);
                }
                SSBIndexOnViewSqlServerv2k.appendStringWithSpace(stringBuffer, "IGNORE_DUP_KEY");
                bl2 = true;
            }
            if (indexOnViewSqlServerv2k.getRecomputeStatistics().equalsIgnoreCase("NO")) {
                if (bl2) {
                    this.appendComma(stringBuffer);
                }
                SSBIndexOnViewSqlServerv2k.appendStringWithSpace(stringBuffer, "STATISTICS_NORECOMPUTE");
                bl2 = true;
            }
            if (indexOnViewSqlServerv2k.getSortInTempDB().equalsIgnoreCase("YES")) {
                if (bl2) {
                    this.appendComma(stringBuffer);
                }
                SSBIndexOnViewSqlServerv2k.appendStringWithSpace(stringBuffer, "SORT_IN_TEMPDB");
            }
        }
    }

    private void appendFilegroup(StringBuffer stringBuffer, IndexOnViewSqlServerv2k indexOnViewSqlServerv2k, boolean bl) {
        if (indexOnViewSqlServerv2k.getFilegroup() != null) {
            SSBIndexOnViewSqlServerv2k.appendNewLine(stringBuffer, bl, 1);
            SSBIndexOnViewSqlServerv2k.appendStringWithSpace(stringBuffer, "ON");
            SSBIndexOnViewSqlServerv2k.appendString(stringBuffer, '\'');
            SSBIndexOnViewSqlServerv2k.appendString(stringBuffer, indexOnViewSqlServerv2k.getFilegroup().getName());
            SSBIndexOnViewSqlServerv2k.appendString(stringBuffer, '\'');
        }
    }

    private void appendExtProperties(StringBuffer stringBuffer, IndexOnViewSqlServerv2k indexOnViewSqlServerv2k, boolean bl) {
        if (!indexOnViewSqlServerv2k.getProps().trim().equalsIgnoreCase("") && indexOnViewSqlServerv2k.getView().getUser() != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(indexOnViewSqlServerv2k.getProps().trim(), ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string = stringTokenizer.nextToken();
                String string2 = stringTokenizer.nextToken();
                SSBIndexOnViewSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
                SSBIndexOnViewSqlServerv2k.appendStringWithSpace(stringBuffer, "EXEC");
                SSBIndexOnViewSqlServerv2k.appendStringWithSpace(stringBuffer, "sp_addextendedproperty");
                SSBIndexOnViewSqlServerv2k.appendString(stringBuffer, '\'');
                SSBIndexOnViewSqlServerv2k.appendString(stringBuffer, string.trim());
                SSBIndexOnViewSqlServerv2k.appendString(stringBuffer, '\'');
                this.appendComma(stringBuffer);
                SSBIndexOnViewSqlServerv2k.appendString(stringBuffer, '\'');
                SSBIndexOnViewSqlServerv2k.appendString(stringBuffer, string2.trim());
                SSBIndexOnViewSqlServerv2k.appendString(stringBuffer, '\'');
                String string3 = "";
                string3 = this.storageDesign.getFormatedName(indexOnViewSqlServerv2k.getView().getUser().getName());
                this.appendComma(stringBuffer);
                SSBIndexOnViewSqlServerv2k.appendNewLine(stringBuffer, bl, 1);
                SSBIndexOnViewSqlServerv2k.appendString(stringBuffer, '\'');
                SSBIndexOnViewSqlServerv2k.appendString(stringBuffer, "USER");
                SSBIndexOnViewSqlServerv2k.appendStringWithSpace(stringBuffer, '\'');
                this.appendComma(stringBuffer);
                SSBIndexOnViewSqlServerv2k.appendStringWithSpace(stringBuffer, string3);
                this.appendComma(stringBuffer);
                SSBIndexOnViewSqlServerv2k.appendStringWithSpace(stringBuffer, "'Schema-bound View'");
                this.appendComma(stringBuffer);
                SSBIndexOnViewSqlServerv2k.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(indexOnViewSqlServerv2k.getView().getName()));
                this.appendComma(stringBuffer);
                SSBIndexOnViewSqlServerv2k.appendString(stringBuffer, '\'');
                SSBIndexOnViewSqlServerv2k.appendString(stringBuffer, "INDEX");
                SSBIndexOnViewSqlServerv2k.appendStringWithSpace(stringBuffer, '\'');
                this.appendComma(stringBuffer);
                SSBIndexOnViewSqlServerv2k.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(indexOnViewSqlServerv2k.getName()));
                SSBIndexOnViewSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
                SSBIndexOnViewSqlServerv2k.appendString(stringBuffer, "GO");
                SSBIndexOnViewSqlServerv2k.appendNewLine(stringBuffer, bl, 1);
            }
        }
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof IndexOnViewSqlServerv2k && ((IndexOnViewSqlServerv2k)object).getView().getDataBase() != null && !((IndexOnViewSqlServerv2k)object).getView().getDataBase().isNullInstance() && ((IndexOnViewSqlServerv2k)object).isMarkedGenerate();
    }
}

