/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.sqlserver.v2k;

import java.util.Iterator;
import oracle.dbtools.crest.exports.ddl.sqlserver.AbstractSSBSqlServer;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataFileSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.FileGroupSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.StorageDesignSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.DataBaseSqlServerv2k;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBDataBaseSqlServerv2k
extends AbstractSSBSqlServer {
    private StorageDesignSqlServer storageDesign;
    boolean existsPrimary = false;

    @Override
    protected void doAppend(StringBuffer stringBuffer, Object object, boolean bl) {
        DataBaseSqlServerv2k dataBaseSqlServerv2k = (DataBaseSqlServerv2k)object;
        this.storageDesign = (StorageDesignSqlServer)this.getStorageDesign(object);
        this.appendComment(stringBuffer, dataBaseSqlServerv2k);
        SSBDataBaseSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
        this.appendCreate(stringBuffer, dataBaseSqlServerv2k, bl);
        this.appendFileSpec(stringBuffer, dataBaseSqlServerv2k, bl);
        this.appendFileGroup(stringBuffer, dataBaseSqlServerv2k, bl);
        this.appendLogOn(stringBuffer, dataBaseSqlServerv2k, bl);
        this.appendCollate(stringBuffer, dataBaseSqlServerv2k, bl);
        SSBDataBaseSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
        SSBDataBaseSqlServerv2k.appendStringWithSpace(stringBuffer, "GO");
        SSBDataBaseSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
        SSBDataBaseSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
        DDLFileMaker.incrementCreateDatabase();
        this.appendAlterDatabase(stringBuffer, dataBaseSqlServerv2k, bl);
    }

    protected void appendCreate(StringBuffer stringBuffer, DataBaseSqlServerv2k dataBaseSqlServerv2k, boolean bl) {
        this.appendCreate(stringBuffer);
        SSBDataBaseSqlServerv2k.appendStringWithSpace(stringBuffer, "DATABASE");
        SSBDataBaseSqlServerv2k.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(dataBaseSqlServerv2k.getName()));
        SSBDataBaseSqlServerv2k.appendNewLine(stringBuffer, bl, 1);
    }

    protected void appendFileSpec(StringBuffer stringBuffer, DataBaseSqlServerv2k dataBaseSqlServerv2k, boolean bl) {
        StorageObjectCollection storageObjectCollection = dataBaseSqlServerv2k.getFilegroups();
        if (storageObjectCollection.containsName("PRIMARY")) {
            FileGroupSqlServer fileGroupSqlServer = (FileGroupSqlServer)storageObjectCollection.getByName("PRIMARY");
            if (fileGroupSqlServer != null && fileGroupSqlServer.getDatafiles() != null) {
                if (this.checkFileGroupValidity(fileGroupSqlServer)) {
                    StorageObjectCollection storageObjectCollection2 = fileGroupSqlServer.getDatafiles();
                    if (storageObjectCollection2.size() > 0) {
                        this.existsPrimary = true;
                        SSBDataBaseSqlServerv2k.appendStringWithSpace(stringBuffer, "ON");
                        SSBDataBaseSqlServerv2k.appendStringWithSpace(stringBuffer, "PRIMARY");
                        SSBDataBaseSqlServerv2k.appendNewLine(stringBuffer, bl, 1);
                        this.appendDataFiles(stringBuffer, storageObjectCollection2, bl);
                    }
                } else {
                    SSBDataBaseSqlServerv2k.appendNewLine(stringBuffer, bl, 1);
                    SSBDataBaseSqlServerv2k.appendStringWithSpace(stringBuffer, "-- Invalid filegroup");
                    SSBDataBaseSqlServerv2k.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(fileGroupSqlServer.getName()));
                }
            }
        } else {
            this.existsPrimary = false;
        }
    }

    protected void appendFileGroup(StringBuffer stringBuffer, DataBaseSqlServerv2k dataBaseSqlServerv2k, boolean bl) {
        if (this.existsPrimary) {
            StorageObjectCollection storageObjectCollection = dataBaseSqlServerv2k.getFilegroups();
            Iterator iterator = storageObjectCollection.iterator();
            while (iterator.hasNext()) {
                FileGroupSqlServer fileGroupSqlServer = (FileGroupSqlServer)iterator.next();
                if (fileGroupSqlServer.getName().equalsIgnoreCase("PRIMARY")) continue;
                if (this.checkFileGroupValidity(fileGroupSqlServer)) {
                    this.appendComma(stringBuffer);
                    SSBDataBaseSqlServerv2k.appendNewLine(stringBuffer, bl, 1);
                    this.appendGroup(stringBuffer, fileGroupSqlServer, bl);
                    continue;
                }
                SSBDataBaseSqlServerv2k.appendNewLine(stringBuffer, bl, 1);
                SSBDataBaseSqlServerv2k.appendStringWithSpace(stringBuffer, "-- Invalid filegroup");
                SSBDataBaseSqlServerv2k.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(fileGroupSqlServer.getName()));
            }
        }
    }

    protected void appendCollate(StringBuffer stringBuffer, DataBaseSqlServerv2k dataBaseSqlServerv2k, boolean bl) {
        String string = dataBaseSqlServerv2k.getCollationName();
        if (string != null && !string.trim().equalsIgnoreCase("")) {
            SSBDataBaseSqlServerv2k.appendNewLine(stringBuffer, bl, 1);
            SSBDataBaseSqlServerv2k.appendStringWithSpace(stringBuffer, "COLLATE");
            SSBDataBaseSqlServerv2k.appendStringWithSpace(stringBuffer, string);
        }
    }

    protected void appendLogOn(StringBuffer stringBuffer, DataBaseSqlServerv2k dataBaseSqlServerv2k, boolean bl) {
        if (this.existsPrimary) {
            StorageObjectCollection storageObjectCollection = dataBaseSqlServerv2k.getTransactionLogs();
            Iterator iterator = storageObjectCollection.iterator();
            boolean bl2 = false;
            while (iterator.hasNext()) {
                DataFileSqlServer dataFileSqlServer = (DataFileSqlServer)iterator.next();
                if (dataFileSqlServer.getDataBase() != null && this.checkDataFileValidity(dataFileSqlServer)) {
                    if (!bl2) {
                        SSBDataBaseSqlServerv2k.appendNewLine(stringBuffer, bl, 1);
                        SSBDataBaseSqlServerv2k.appendStringWithSpace(stringBuffer, "LOG ON");
                        SSBDataBaseSqlServerv2k.appendNewLine(stringBuffer, bl, 1);
                    }
                    bl2 = true;
                    this.appendDataFile(stringBuffer, dataFileSqlServer, bl);
                    continue;
                }
                if (dataFileSqlServer.getDataBase() == null || this.checkDataFileValidity(dataFileSqlServer)) continue;
                SSBDataBaseSqlServerv2k.appendNewLine(stringBuffer, bl, 1);
                SSBDataBaseSqlServerv2k.appendStringWithSpace(stringBuffer, "-- Invalid datafile name");
                SSBDataBaseSqlServerv2k.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(dataFileSqlServer.getName()));
            }
            this.deleteLastComma(stringBuffer, bl, bl2);
        }
    }

    protected void appendAlterDatabase(StringBuffer stringBuffer, DataBaseSqlServerv2k dataBaseSqlServerv2k, boolean bl) {
        SSBDataBaseSqlServerv2k.appendStringWithSpace(stringBuffer, "ALTER");
        SSBDataBaseSqlServerv2k.appendStringWithSpace(stringBuffer, "DATABASE");
        SSBDataBaseSqlServerv2k.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(dataBaseSqlServerv2k.getLongName()));
        SSBDataBaseSqlServerv2k.appendNewLine(stringBuffer, bl, 1);
        SSBDataBaseSqlServerv2k.appendStringWithSpace(stringBuffer, "SET");
        this.appendStateOption(stringBuffer, dataBaseSqlServerv2k, bl);
        this.appendCursorOption(stringBuffer, dataBaseSqlServerv2k, bl);
        this.appendAutoOption(stringBuffer, dataBaseSqlServerv2k, bl);
        this.appendSqlOption(stringBuffer, dataBaseSqlServerv2k, bl);
        this.appendRecoveryOption(stringBuffer, dataBaseSqlServerv2k, bl);
        SSBDataBaseSqlServerv2k.appendStringWithSpace(stringBuffer, "GO");
        SSBDataBaseSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
    }

    protected void appendStateOption(StringBuffer stringBuffer, DataBaseSqlServerv2k dataBaseSqlServerv2k, boolean bl) {
        SSBDataBaseSqlServerv2k.appendStringWithSpace(stringBuffer, dataBaseSqlServerv2k.getUserState());
        this.appendComma(stringBuffer);
        SSBDataBaseSqlServerv2k.appendNewLine(stringBuffer, bl, 1);
    }

    protected void appendCursorOption(StringBuffer stringBuffer, DataBaseSqlServerv2k dataBaseSqlServerv2k, boolean bl) {
        SSBDataBaseSqlServerv2k.appendStringWithSpace(stringBuffer, "CURSOR_CLOSE_ON_COMMIT");
        SSBDataBaseSqlServerv2k.appendStringWithSpace(stringBuffer, dataBaseSqlServerv2k.getCursorCloseOnCommit());
        this.appendComma(stringBuffer);
        SSBDataBaseSqlServerv2k.appendNewLine(stringBuffer, bl, 1);
        SSBDataBaseSqlServerv2k.appendStringWithSpace(stringBuffer, "CURSOR_DEFAULT");
        SSBDataBaseSqlServerv2k.appendStringWithSpace(stringBuffer, dataBaseSqlServerv2k.getCursorDefault());
        this.appendComma(stringBuffer);
        SSBDataBaseSqlServerv2k.appendNewLine(stringBuffer, bl, 1);
    }

    protected void appendAutoOption(StringBuffer stringBuffer, DataBaseSqlServerv2k dataBaseSqlServerv2k, boolean bl) {
        SSBDataBaseSqlServerv2k.appendStringWithSpace(stringBuffer, "AUTO_CLOSE");
        SSBDataBaseSqlServerv2k.appendStringWithSpace(stringBuffer, dataBaseSqlServerv2k.getAutoClose());
        this.appendComma(stringBuffer);
        SSBDataBaseSqlServerv2k.appendNewLine(stringBuffer, bl, 1);
        SSBDataBaseSqlServerv2k.appendStringWithSpace(stringBuffer, "AUTO_CREATE_STATISTICS");
        SSBDataBaseSqlServerv2k.appendStringWithSpace(stringBuffer, dataBaseSqlServerv2k.getAutoCreateStatistics());
        this.appendComma(stringBuffer);
        SSBDataBaseSqlServerv2k.appendNewLine(stringBuffer, bl, 1);
        SSBDataBaseSqlServerv2k.appendStringWithSpace(stringBuffer, "AUTO_SHRINK");
        SSBDataBaseSqlServerv2k.appendStringWithSpace(stringBuffer, dataBaseSqlServerv2k.getAutoShrink());
        this.appendComma(stringBuffer);
        SSBDataBaseSqlServerv2k.appendNewLine(stringBuffer, bl, 1);
        SSBDataBaseSqlServerv2k.appendStringWithSpace(stringBuffer, "AUTO_UPDATE_STATISTICS");
        SSBDataBaseSqlServerv2k.appendStringWithSpace(stringBuffer, dataBaseSqlServerv2k.getAutoUpdateStatistics());
        this.appendComma(stringBuffer);
        SSBDataBaseSqlServerv2k.appendNewLine(stringBuffer, bl, 1);
    }

    protected void appendSqlOption(StringBuffer stringBuffer, DataBaseSqlServerv2k dataBaseSqlServerv2k, boolean bl) {
        SSBDataBaseSqlServerv2k.appendStringWithSpace(stringBuffer, "ANSI_NULLS");
        SSBDataBaseSqlServerv2k.appendStringWithSpace(stringBuffer, dataBaseSqlServerv2k.getAnsiNulls());
        this.appendComma(stringBuffer);
        SSBDataBaseSqlServerv2k.appendNewLine(stringBuffer, bl, 1);
        if (!dataBaseSqlServerv2k.getAnsiPadding().equalsIgnoreCase("")) {
            SSBDataBaseSqlServerv2k.appendStringWithSpace(stringBuffer, "ANSI_PADDING");
            SSBDataBaseSqlServerv2k.appendStringWithSpace(stringBuffer, dataBaseSqlServerv2k.getAnsiPadding());
            this.appendComma(stringBuffer);
            SSBDataBaseSqlServerv2k.appendNewLine(stringBuffer, bl, 1);
        }
        if (!dataBaseSqlServerv2k.getAnsiWarnings().equalsIgnoreCase("")) {
            SSBDataBaseSqlServerv2k.appendStringWithSpace(stringBuffer, "ANSI_WARNINGS");
            SSBDataBaseSqlServerv2k.appendStringWithSpace(stringBuffer, dataBaseSqlServerv2k.getAnsiWarnings());
            this.appendComma(stringBuffer);
            SSBDataBaseSqlServerv2k.appendNewLine(stringBuffer, bl, 1);
        }
        if (!dataBaseSqlServerv2k.getArithabort().equalsIgnoreCase("")) {
            SSBDataBaseSqlServerv2k.appendStringWithSpace(stringBuffer, "ARITHABORT");
            SSBDataBaseSqlServerv2k.appendStringWithSpace(stringBuffer, dataBaseSqlServerv2k.getArithabort());
            this.appendComma(stringBuffer);
            SSBDataBaseSqlServerv2k.appendNewLine(stringBuffer, bl, 1);
        }
        if (!dataBaseSqlServerv2k.getConcatNullYieldsNull().equalsIgnoreCase("")) {
            SSBDataBaseSqlServerv2k.appendStringWithSpace(stringBuffer, "CONCAT_NULL_YIELDS_NULL");
            SSBDataBaseSqlServerv2k.appendStringWithSpace(stringBuffer, dataBaseSqlServerv2k.getConcatNullYieldsNull());
            this.appendComma(stringBuffer);
            SSBDataBaseSqlServerv2k.appendNewLine(stringBuffer, bl, 1);
        }
        if (!dataBaseSqlServerv2k.getNumericRoundabort().equalsIgnoreCase("")) {
            SSBDataBaseSqlServerv2k.appendStringWithSpace(stringBuffer, "NUMERIC_ROUNDABORT");
            SSBDataBaseSqlServerv2k.appendStringWithSpace(stringBuffer, dataBaseSqlServerv2k.getNumericRoundabort());
            this.appendComma(stringBuffer);
            SSBDataBaseSqlServerv2k.appendNewLine(stringBuffer, bl, 1);
        }
        SSBDataBaseSqlServerv2k.appendStringWithSpace(stringBuffer, "QUOTED_IDENTIFIER");
        SSBDataBaseSqlServerv2k.appendStringWithSpace(stringBuffer, dataBaseSqlServerv2k.getQuotedIdentifier());
        this.appendComma(stringBuffer);
        SSBDataBaseSqlServerv2k.appendNewLine(stringBuffer, bl, 1);
        if (!dataBaseSqlServerv2k.getRecursiveTriggers().equalsIgnoreCase("")) {
            SSBDataBaseSqlServerv2k.appendStringWithSpace(stringBuffer, "RECURSIVE_TRIGGERS");
            SSBDataBaseSqlServerv2k.appendStringWithSpace(stringBuffer, dataBaseSqlServerv2k.getRecursiveTriggers());
            this.appendComma(stringBuffer);
            SSBDataBaseSqlServerv2k.appendNewLine(stringBuffer, bl, 1);
        }
    }

    protected void appendRecoveryOption(StringBuffer stringBuffer, DataBaseSqlServerv2k dataBaseSqlServerv2k, boolean bl) {
        SSBDataBaseSqlServerv2k.appendStringWithSpace(stringBuffer, "RECOVERY");
        SSBDataBaseSqlServerv2k.appendStringWithSpace(stringBuffer, dataBaseSqlServerv2k.getRecovery());
        this.appendComma(stringBuffer);
        SSBDataBaseSqlServerv2k.appendNewLine(stringBuffer, bl, 1);
        SSBDataBaseSqlServerv2k.appendStringWithSpace(stringBuffer, "TORN_PAGE_DETECTION");
        SSBDataBaseSqlServerv2k.appendStringWithSpace(stringBuffer, dataBaseSqlServerv2k.getTornPageDetection());
        SSBDataBaseSqlServerv2k.appendNewLine(stringBuffer, bl, 0);
    }

    private boolean checkFileGroupValidity(FileGroupSqlServer fileGroupSqlServer) {
        StorageObjectCollection storageObjectCollection = fileGroupSqlServer.getDatafiles();
        if (storageObjectCollection == null || storageObjectCollection.size() == 0) {
            return false;
        }
        Iterator iterator = storageObjectCollection.iterator();
        while (iterator.hasNext()) {
            DataFileSqlServer dataFileSqlServer = (DataFileSqlServer)iterator.next();
            if (dataFileSqlServer.getFileName() != null && !dataFileSqlServer.getFileName().trim().equalsIgnoreCase("")) continue;
            return false;
        }
        return true;
    }

    private boolean checkDataFileValidity(DataFileSqlServer dataFileSqlServer) {
        return dataFileSqlServer.getFileName() != null && !dataFileSqlServer.getFileName().trim().equalsIgnoreCase("");
    }

    protected void appendGroup(StringBuffer stringBuffer, FileGroupSqlServer fileGroupSqlServer, boolean bl) {
        StorageObjectCollection storageObjectCollection = fileGroupSqlServer.getDatafiles();
        SSBDataBaseSqlServerv2k.appendStringWithSpace(stringBuffer, "FILEGROUP");
        SSBDataBaseSqlServerv2k.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(fileGroupSqlServer.getName()));
        SSBDataBaseSqlServerv2k.appendNewLine(stringBuffer, bl, 1);
        this.appendDataFiles(stringBuffer, storageObjectCollection, bl);
    }

    protected void appendDataFiles(StringBuffer stringBuffer, StorageObjectCollection storageObjectCollection, boolean bl) {
        Iterator iterator = storageObjectCollection.iterator();
        boolean bl2 = false;
        while (iterator.hasNext()) {
            bl2 = true;
            DataFileSqlServer dataFileSqlServer = (DataFileSqlServer)iterator.next();
            this.appendDataFile(stringBuffer, dataFileSqlServer, bl);
        }
        if (bl2) {
            int n = bl ? NEWLINE.length() + "    ".length() : 1;
            stringBuffer = stringBuffer.delete(stringBuffer.length() - n - 2, stringBuffer.length() - 1);
        }
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof DataBaseSqlServerv2k && ((DataBaseSqlServerv2k)object).isMarkedGenerate();
    }

    protected void appendDataFile(StringBuffer stringBuffer, DataFileSqlServer dataFileSqlServer, boolean bl) {
        SSBDataBaseSqlServerv2k.appendStringWithSpace(stringBuffer, '(');
        SSBDataBaseSqlServerv2k.appendNewLine(stringBuffer, bl, 1);
        this.appendNameWithQuotes(stringBuffer, bl, dataFileSqlServer);
        this.appendFilename(stringBuffer, bl, dataFileSqlServer);
        this.appendInitialSize(stringBuffer, bl, dataFileSqlServer);
        this.appendMaxSize(stringBuffer, dataFileSqlServer);
        this.appendGrowthValue(stringBuffer, bl, dataFileSqlServer);
        SSBDataBaseSqlServerv2k.appendNewLine(stringBuffer, bl, 1);
        SSBDataBaseSqlServerv2k.appendString(stringBuffer, ')');
        this.appendComma(stringBuffer);
        SSBDataBaseSqlServerv2k.appendNewLine(stringBuffer, bl, 1);
    }

    private void deleteLastComma(StringBuffer stringBuffer, boolean bl, boolean bl2) {
        int n = bl ? NEWLINE.length() + "    ".length() : 1;
        if (bl2) {
            stringBuffer = stringBuffer.delete(stringBuffer.length() - n - 2, stringBuffer.length());
        }
    }

    private void appendNameWithQuotes(StringBuffer stringBuffer, boolean bl, DataFileSqlServer dataFileSqlServer) {
        if (!dataFileSqlServer.getName().trim().equalsIgnoreCase("")) {
            SSBDataBaseSqlServerv2k.appendStringWithSpace(stringBuffer, "NAME");
            SSBDataBaseSqlServerv2k.appendStringWithSpace(stringBuffer, '=');
            SSBDataBaseSqlServerv2k.appendString(stringBuffer, '\'');
            this.appendString(stringBuffer, dataFileSqlServer);
            SSBDataBaseSqlServerv2k.appendString(stringBuffer, '\'');
            this.appendComma(stringBuffer);
            SSBDataBaseSqlServerv2k.appendNewLine(stringBuffer, bl, 1);
        }
    }

    private void appendFilename(StringBuffer stringBuffer, boolean bl, DataFileSqlServer dataFileSqlServer) {
        SSBDataBaseSqlServerv2k.appendStringWithSpace(stringBuffer, "FILENAME");
        SSBDataBaseSqlServerv2k.appendStringWithSpace(stringBuffer, '=');
        SSBDataBaseSqlServerv2k.appendString(stringBuffer, '\'');
        SSBDataBaseSqlServerv2k.appendString(stringBuffer, dataFileSqlServer.getFileName());
        SSBDataBaseSqlServerv2k.appendString(stringBuffer, '\'');
        this.appendComma(stringBuffer);
        SSBDataBaseSqlServerv2k.appendNewLine(stringBuffer, bl, 1);
    }

    private void appendInitialSize(StringBuffer stringBuffer, boolean bl, DataFileSqlServer dataFileSqlServer) {
        if (dataFileSqlServer.getInitialSize() != 0) {
            SSBDataBaseSqlServerv2k.appendStringWithSpace(stringBuffer, "SIZE");
            SSBDataBaseSqlServerv2k.appendStringWithSpace(stringBuffer, '=');
            this.appendString(stringBuffer, dataFileSqlServer.getInitialSize());
            this.appendComma(stringBuffer);
            SSBDataBaseSqlServerv2k.appendNewLine(stringBuffer, bl, 1);
        }
    }

    private void appendMaxSize(StringBuffer stringBuffer, DataFileSqlServer dataFileSqlServer) {
        SSBDataBaseSqlServerv2k.appendStringWithSpace(stringBuffer, "MAXSIZE");
        SSBDataBaseSqlServerv2k.appendStringWithSpace(stringBuffer, '=');
        if (dataFileSqlServer.getIsUnlimited()) {
            SSBDataBaseSqlServerv2k.appendString(stringBuffer, "UNLIMITED");
        } else {
            this.appendString(stringBuffer, dataFileSqlServer.getMaxSize());
        }
    }

    private void appendGrowthValue(StringBuffer stringBuffer, boolean bl, DataFileSqlServer dataFileSqlServer) {
        if (dataFileSqlServer.getGrowthValue() != 0) {
            this.appendComma(stringBuffer);
            SSBDataBaseSqlServerv2k.appendNewLine(stringBuffer, bl, 1);
            SSBDataBaseSqlServerv2k.appendStringWithSpace(stringBuffer, "FILEGROWTH");
            SSBDataBaseSqlServerv2k.appendStringWithSpace(stringBuffer, '=');
            this.appendString(stringBuffer, dataFileSqlServer.getGrowthValue());
            if (dataFileSqlServer.getGrowthMethod().equalsIgnoreCase("By Percent")) {
                SSBDataBaseSqlServerv2k.appendStringWithSpace(stringBuffer, '%');
            }
        }
    }
}

