/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.oracle.v9i;

import java.util.List;
import oracle.dbtools.crest.exports.ddl.oracle.AbstractSSBOracle;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.QuotaItemOracle;
import oracle.dbtools.crest.model.design.storage.oracle.QuotaItemSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.UserOraclev9i;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBUserOraclev9i
extends AbstractSSBOracle {
    private StorageDesign storageDesign;

    @Override
    protected void doAppend(StringBuffer stringBuffer, Object object, boolean bl) {
        StringBuffer stringBuffer2 = new StringBuffer();
        String string = "";
        UserOraclev9i userOraclev9i = (UserOraclev9i)object;
        this.storageDesign = userOraclev9i.getStorageDesign();
        this.appendComment(stringBuffer, userOraclev9i);
        SSBUserOraclev9i.appendStringWithSpace(stringBuffer2, "CREATE");
        SSBUserOraclev9i.appendStringWithSpace(stringBuffer2, "USER");
        SSBUserOraclev9i.appendStringWithSpace(stringBuffer2, this.storageDesign.getFormatedName(userOraclev9i.getName()));
        string = stringBuffer2.toString();
        this.appendAuthenticationType(stringBuffer2, userOraclev9i, bl);
        this.appendDefaultTableSpace(stringBuffer2, userOraclev9i, bl);
        this.appendTempTableSpace(stringBuffer2, userOraclev9i, bl);
        this.appendQuotaItems(stringBuffer2, userOraclev9i, bl);
        this.appendProfile(stringBuffer2, userOraclev9i, bl);
        this.appendPasswordExpire(stringBuffer2, userOraclev9i, bl);
        this.appendAccountLock(stringBuffer2, userOraclev9i, bl);
        this.appendToBuffer(stringBuffer, stringBuffer2, string);
        SSBUserOraclev9i.appendNewLine(stringBuffer2, bl, 0);
        this.appendLineFinisher(stringBuffer2, bl);
        SSBUserOraclev9i.appendNewLine(stringBuffer2, bl, 0);
        this.appendToBuffer(stringBuffer, stringBuffer2, string);
        DDLFileMaker.incrementCreateUser();
        this.appendRolesAndPrivileges(stringBuffer, userOraclev9i, bl);
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof UserOraclev9i && ((UserOraclev9i)object).isMarkedGenerate();
    }

    private void appendAuthenticationType(StringBuffer stringBuffer, UserOraclev9i userOraclev9i, boolean bl) {
        String string = userOraclev9i.getAuthType();
        SSBUserOraclev9i.appendNewLine(stringBuffer, bl, 1);
        SSBUserOraclev9i.appendStringWithSpace(stringBuffer, "IDENTIFIED");
        if (string.equalsIgnoreCase("BY_PASSWORD")) {
            SSBUserOraclev9i.appendStringWithSpace(stringBuffer, "BY");
            SSBUserOraclev9i.appendStringWithSpace(stringBuffer, userOraclev9i.decodeIdentifier());
        } else if (string.equalsIgnoreCase("EXTERNALLY")) {
            SSBUserOraclev9i.appendStringWithSpace(stringBuffer, "EXTERNALLY");
        } else {
            SSBUserOraclev9i.appendStringWithSpace(stringBuffer, "GLOBALLY AS");
            SSBUserOraclev9i.appendStringWithSpace(stringBuffer, userOraclev9i.decodeIdentifier());
        }
    }

    private void appendDefaultTableSpace(StringBuffer stringBuffer, UserOraclev9i userOraclev9i, boolean bl) {
        if (userOraclev9i.getDefTableSpace() != null) {
            String string = userOraclev9i.getStorageDesign().getFormatedName(userOraclev9i.getDefTableSpace().getName());
            SSBUserOraclev9i.appendNewLine(stringBuffer, bl, 1);
            SSBUserOraclev9i.appendStringWithSpace(stringBuffer, "DEFAULT");
            SSBUserOraclev9i.appendStringWithSpace(stringBuffer, "TABLESPACE");
            SSBUserOraclev9i.appendStringWithSpace(stringBuffer, string);
        }
    }

    private void appendTempTableSpace(StringBuffer stringBuffer, UserOraclev9i userOraclev9i, boolean bl) {
        if (userOraclev9i.getTempTableSpace() != null) {
            SSBUserOraclev9i.appendNewLine(stringBuffer, bl, 2);
            SSBUserOraclev9i.appendStringWithSpace(stringBuffer, "TEMPORARY");
            SSBUserOraclev9i.appendStringWithSpace(stringBuffer, "TABLESPACE");
            SSBUserOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(userOraclev9i.getTempTableSpace().getName()));
        }
    }

    private void appendQuotaItems(StringBuffer stringBuffer, UserOraclev9i userOraclev9i, boolean bl) {
        QuotaItemSetOracle quotaItemSetOracle = ((StorageDesignOracle)userOraclev9i.getStorageDesign()).getQuotaItemSet();
        List list = quotaItemSetOracle.getElementsList();
        for (QuotaItemOracle quotaItemOracle : list) {
            if (quotaItemOracle.getUser() == null || quotaItemOracle.getTableSpace() == null || !quotaItemOracle.getUser().toString().equalsIgnoreCase(userOraclev9i.toString())) continue;
            SSBUserOraclev9i.appendNewLine(stringBuffer, bl, 1);
            SSBUserOraclev9i.appendStringWithSpace(stringBuffer, "QUOTA");
            SSBUserOraclev9i.appendStringWithSpace(stringBuffer, quotaItemOracle.getSize());
            if (!quotaItemOracle.getSize().equalsIgnoreCase("UNLIMITED")) {
                SSBUserOraclev9i.appendStringWithSpace(stringBuffer, "K");
            }
            SSBUserOraclev9i.appendStringWithSpace(stringBuffer, "ON");
            SSBUserOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(quotaItemOracle.getTableSpace().getName()));
        }
    }

    private void appendProfile(StringBuffer stringBuffer, UserOraclev9i userOraclev9i, boolean bl) {
        String string = userOraclev9i.getProfile();
        if (!"".equalsIgnoreCase(string)) {
            SSBUserOraclev9i.appendNewLine(stringBuffer, bl, 1);
            SSBUserOraclev9i.appendStringWithSpace(stringBuffer, "PROFILE");
            SSBUserOraclev9i.appendStringWithSpace(stringBuffer, string);
        }
    }

    private void appendPasswordExpire(StringBuffer stringBuffer, UserOraclev9i userOraclev9i, boolean bl) {
        String string = userOraclev9i.getPasswordExpire();
        if (string.equalsIgnoreCase("YES")) {
            SSBUserOraclev9i.appendNewLine(stringBuffer, bl, 1);
            SSBUserOraclev9i.appendStringWithSpace(stringBuffer, "PASSWORD EXPIRE");
        }
    }

    private void appendAccountLock(StringBuffer stringBuffer, UserOraclev9i userOraclev9i, boolean bl) {
        String string = userOraclev9i.getAccountLock();
        SSBUserOraclev9i.appendNewLine(stringBuffer, bl, 1);
        if (string.equalsIgnoreCase("YES")) {
            SSBUserOraclev9i.appendStringWithSpace(stringBuffer, "ACCOUNT LOCK");
        } else {
            SSBUserOraclev9i.appendStringWithSpace(stringBuffer, "ACCOUNT UNLOCK");
        }
    }

    private void appendRolesAndPrivileges(StringBuffer stringBuffer, UserOraclev9i userOraclev9i, boolean bl) {
        StringBuffer stringBuffer2 = new StringBuffer();
        String string = "";
        String string2 = userOraclev9i.getRolesNames();
        String string3 = userOraclev9i.getRolesWithAdminOptionNames();
        String string4 = userOraclev9i.getPrivileges();
        String string5 = userOraclev9i.getPrivilegesWithAdminOption();
        if (!"".equalsIgnoreCase(string2)) {
            SSBUserOraclev9i.appendStringWithSpace(stringBuffer2, "GRANT");
            SSBUserOraclev9i.appendStringWithSpace(stringBuffer2, string2);
            SSBUserOraclev9i.appendStringWithSpace(stringBuffer2, "TO");
            SSBUserOraclev9i.appendStringWithSpace(stringBuffer2, this.storageDesign.getFormatedName(userOraclev9i.getName()));
            this.appendToBuffer(stringBuffer, stringBuffer2, string);
            SSBUserOraclev9i.appendNewLine(stringBuffer2, bl, 0);
            this.appendLineFinisher(stringBuffer2, bl);
            SSBUserOraclev9i.appendNewLine(stringBuffer2, bl, 0);
            this.appendToBuffer(stringBuffer, stringBuffer2, string);
        }
        if (!"".equalsIgnoreCase(string3)) {
            SSBUserOraclev9i.appendStringWithSpace(stringBuffer2, "GRANT");
            SSBUserOraclev9i.appendStringWithSpace(stringBuffer2, string3);
            SSBUserOraclev9i.appendStringWithSpace(stringBuffer2, "TO");
            SSBUserOraclev9i.appendStringWithSpace(stringBuffer2, this.storageDesign.getFormatedName(userOraclev9i.getName()));
            stringBuffer2.append(" WITH ADMIN OPTION");
            this.appendToBuffer(stringBuffer, stringBuffer2, string);
            SSBUserOraclev9i.appendNewLine(stringBuffer2, bl, 0);
            this.appendLineFinisher(stringBuffer2, bl);
            SSBUserOraclev9i.appendNewLine(stringBuffer2, bl, 0);
            this.appendToBuffer(stringBuffer, stringBuffer2, string);
        }
        if (!"".equalsIgnoreCase(string4)) {
            SSBUserOraclev9i.appendStringWithSpace(stringBuffer2, "GRANT");
            SSBUserOraclev9i.appendStringWithSpace(stringBuffer2, string4);
            SSBUserOraclev9i.appendStringWithSpace(stringBuffer2, "TO");
            SSBUserOraclev9i.appendStringWithSpace(stringBuffer2, this.storageDesign.getFormatedName(userOraclev9i.getName()));
            this.appendToBuffer(stringBuffer, stringBuffer2, string);
            SSBUserOraclev9i.appendNewLine(stringBuffer2, bl, 0);
            this.appendLineFinisher(stringBuffer2, bl);
            SSBUserOraclev9i.appendNewLine(stringBuffer2, bl, 0);
            this.appendToBuffer(stringBuffer, stringBuffer2, string);
        }
        if (!"".equalsIgnoreCase(string5)) {
            SSBUserOraclev9i.appendStringWithSpace(stringBuffer2, "GRANT");
            SSBUserOraclev9i.appendStringWithSpace(stringBuffer2, string5);
            SSBUserOraclev9i.appendStringWithSpace(stringBuffer2, "TO");
            SSBUserOraclev9i.appendStringWithSpace(stringBuffer2, this.storageDesign.getFormatedName(userOraclev9i.getName()));
            stringBuffer2.append(" WITH ADMIN OPTION");
            this.appendToBuffer(stringBuffer, stringBuffer2, string);
            SSBUserOraclev9i.appendNewLine(stringBuffer2, bl, 0);
            this.appendLineFinisher(stringBuffer2, bl);
            SSBUserOraclev9i.appendNewLine(stringBuffer2, bl, 0);
            this.appendToBuffer(stringBuffer, stringBuffer2, string);
        }
    }
}

