/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.oracle.v9i;

import java.util.Iterator;
import oracle.dbtools.crest.exports.ddl.oracle.AbstractSSBOracle;
import oracle.dbtools.crest.exports.ddl.oracle.v9i.SSBIndexOraclev9i;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.datatypes.Datatype;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.SpatialColumnDefObject;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;

public class SSBSpatialTableOraclev9i
extends AbstractSSBOracle {
    private SSBIndexOraclev9i ssbIndex = null;
    private Object sType;
    private StorageDesign storageDesign;

    @Override
    protected void doAppend(StringBuffer stringBuffer, Object object, boolean bl) {
        if (((ModelIDObject)object).isMarkedGenerate()) {
            Table table = null;
            TableProxyOracle tableProxyOracle = null;
            if (object instanceof TableProxyOracle) {
                tableProxyOracle = (TableProxyOracle)object;
                table = (Table)tableProxyOracle.getObject();
                this.storageDesign = tableProxyOracle.getStorageDesign();
            } else if (object instanceof Table) {
                table = (Table)object;
                Design design = table.getDesign();
                Object object2 = table.getSelectedRDBMSSite();
                this.storageDesign = design.getStorageDesign((RDBMSSite)object2, table);
                tableProxyOracle = (TableProxyOracle)this.storageDesign.getTableProxySet().getProxy(table.getObjectID());
            }
            if (table != null && table.isSpatialTable() && !table.getSpatialDefinitions().isEmpty()) {
                for (Object object2 : table.getSpatialDefinitions()) {
                    if (((SpatialColumnDefObject)object2).getSpatialColumn() == null && !((SpatialColumnDefObject)object2).isFunction()) continue;
                    this.appendRegisterSpatialTable(stringBuffer, table, tableProxyOracle, (SpatialColumnDefObject)object2, bl);
                    this.appendSpatialIndex(stringBuffer, (SpatialColumnDefObject)object2, bl);
                }
            }
        }
    }

    private void appendRegisterSpatialTable(StringBuffer stringBuffer, Table table, TableProxyOracle tableProxyOracle, SpatialColumnDefObject spatialColumnDefObject, boolean bl) {
        StringBuffer stringBuffer2 = new StringBuffer();
        SSBSpatialTableOraclev9i.appendNewLine(stringBuffer, bl, 0);
        SSBSpatialTableOraclev9i.appendStringWithSpace(stringBuffer2, "INSERT");
        SSBSpatialTableOraclev9i.appendStringWithSpace(stringBuffer2, "INTO");
        SSBSpatialTableOraclev9i.appendStringWithSpace(stringBuffer2, "USER_SDO_GEOM_METADATA");
        String string = stringBuffer2.toString();
        this.appendSpatialColumnDefinition(stringBuffer2, table, tableProxyOracle, spatialColumnDefObject, bl);
        this.appendFunctionDefinition(stringBuffer2, table, tableProxyOracle, spatialColumnDefObject, bl);
        this.appendToBuffer(stringBuffer, stringBuffer2, string);
        SSBSpatialTableOraclev9i.appendNewLine(stringBuffer2, bl, 0);
        this.appendLineFinisher(stringBuffer2, bl);
        SSBSpatialTableOraclev9i.appendNewLine(stringBuffer2, bl, 0);
        this.appendToBuffer(stringBuffer, stringBuffer2, string);
    }

    private void appendFunctionDefinition(StringBuffer stringBuffer, Table table, TableProxyOracle tableProxyOracle, SpatialColumnDefObject spatialColumnDefObject, boolean bl) {
        if (spatialColumnDefObject.isFunction()) {
            SSBSpatialTableOraclev9i.appendNewLine(stringBuffer, bl, 1);
            SSBSpatialTableOraclev9i.appendString(stringBuffer, "VALUES");
            SSBSpatialTableOraclev9i.appendNewLine(stringBuffer, bl, 1);
            SSBSpatialTableOraclev9i.appendStringWithSpace(stringBuffer, '(');
            SSBSpatialTableOraclev9i.appendNewLine(stringBuffer, bl, 2);
            SSBSpatialTableOraclev9i.appendString(stringBuffer, '\'');
            if (tableProxyOracle != null) {
                SSBSpatialTableOraclev9i.appendString(stringBuffer, this.storageDesign.getFormatedName(tableProxyOracle.getName()));
            } else {
                SSBSpatialTableOraclev9i.appendString(stringBuffer, this.storageDesign.getFormatedName(table.getName()));
            }
            SSBSpatialTableOraclev9i.appendString(stringBuffer, '\'');
            SSBSpatialTableOraclev9i.appendString(stringBuffer, ',');
            SSBSpatialTableOraclev9i.appendNewLine(stringBuffer, bl, 2);
            SSBSpatialTableOraclev9i.appendString(stringBuffer, '\'');
            SSBSpatialTableOraclev9i.appendString(stringBuffer, spatialColumnDefObject.getFuncExpression());
            SSBSpatialTableOraclev9i.appendString(stringBuffer, '\'');
            SSBSpatialTableOraclev9i.appendString(stringBuffer, ',');
            SSBSpatialTableOraclev9i.appendSpace(stringBuffer);
            this.appendTableDimensional(stringBuffer, spatialColumnDefObject, bl);
            SSBSpatialTableOraclev9i.appendStringWithSpace(stringBuffer, ',');
            SSBSpatialTableOraclev9i.appendNewLine(stringBuffer, bl, 2);
            if (spatialColumnDefObject.getSystemID() == null || spatialColumnDefObject.getSystemID().trim().equals("")) {
                SSBSpatialTableOraclev9i.appendStringWithSpace(stringBuffer, "NULL");
            } else {
                SSBSpatialTableOraclev9i.appendStringWithSpace(stringBuffer, spatialColumnDefObject.getSystemID());
            }
            SSBSpatialTableOraclev9i.appendNewLine(stringBuffer, bl, 1);
            SSBSpatialTableOraclev9i.appendString(stringBuffer, ')');
        }
    }

    private void appendSpatialColumnDefinition(StringBuffer stringBuffer, Table table, TableProxyOracle tableProxyOracle, SpatialColumnDefObject spatialColumnDefObject, boolean bl) {
        if (spatialColumnDefObject.getSpatialColumn() != null) {
            SSBSpatialTableOraclev9i.appendStringWithSpace(stringBuffer, '(');
            SSBSpatialTableOraclev9i.appendStringWithSpace(stringBuffer, "TABLE_NAME");
            SSBSpatialTableOraclev9i.appendStringWithSpace(stringBuffer, ',');
            SSBSpatialTableOraclev9i.appendStringWithSpace(stringBuffer, "COLUMN_NAME");
            SSBSpatialTableOraclev9i.appendStringWithSpace(stringBuffer, ',');
            SSBSpatialTableOraclev9i.appendStringWithSpace(stringBuffer, "DIMINFO");
            SSBSpatialTableOraclev9i.appendStringWithSpace(stringBuffer, ',');
            SSBSpatialTableOraclev9i.appendStringWithSpace(stringBuffer, "SRID");
            SSBSpatialTableOraclev9i.appendStringWithSpace(stringBuffer, ')');
            SSBSpatialTableOraclev9i.appendNewLine(stringBuffer, bl, 1);
            SSBSpatialTableOraclev9i.appendStringWithSpace(stringBuffer, "VALUES");
            SSBSpatialTableOraclev9i.appendStringWithSpace(stringBuffer, '(');
            SSBSpatialTableOraclev9i.appendString(stringBuffer, '\'');
            if (tableProxyOracle != null) {
                SSBSpatialTableOraclev9i.appendString(stringBuffer, this.storageDesign.getFormatedName(tableProxyOracle.getName()));
            } else {
                SSBSpatialTableOraclev9i.appendString(stringBuffer, this.storageDesign.getFormatedName(table.getName()));
            }
            SSBSpatialTableOraclev9i.appendString(stringBuffer, '\'');
            SSBSpatialTableOraclev9i.appendStringWithSpace(stringBuffer, ',');
            SSBSpatialTableOraclev9i.appendString(stringBuffer, '\'');
            Datatype datatype = spatialColumnDefObject.getSpatialColumn().getDataType();
            String string = this.storageDesign.getFormatedName(spatialColumnDefObject.getSpatialColumn().getName());
            if (this.sType == null) {
                this.sType = this.storageDesign.getDesign().getDataTypesDesign().getStructuredTypeSet().getByName("SDO_GEOMETRY");
            }
            if (datatype instanceof StructuredType) {
                StructuredType structuredType = (StructuredType)datatype;
                for (TypeElement typeElement : structuredType.getAllElements()) {
                    if (typeElement.getType() != this.sType) continue;
                    string = string.concat(".").concat(this.storageDesign.getFormatedName(typeElement.getName()));
                    break;
                }
            }
            SSBSpatialTableOraclev9i.appendString(stringBuffer, string);
            SSBSpatialTableOraclev9i.appendStringWithSpace(stringBuffer, '\'');
            SSBSpatialTableOraclev9i.appendStringWithSpace(stringBuffer, ',');
            this.appendTableDimensional(stringBuffer, spatialColumnDefObject, bl);
            SSBSpatialTableOraclev9i.appendStringWithSpace(stringBuffer, ',');
            SSBSpatialTableOraclev9i.appendNewLine(stringBuffer, bl, 2);
            if (spatialColumnDefObject.getSystemID() == null || spatialColumnDefObject.getSystemID().trim().equals("")) {
                SSBSpatialTableOraclev9i.appendStringWithSpace(stringBuffer, "NULL");
            } else {
                SSBSpatialTableOraclev9i.appendStringWithSpace(stringBuffer, spatialColumnDefObject.getSystemID());
            }
            SSBSpatialTableOraclev9i.appendNewLine(stringBuffer, bl, 1);
            SSBSpatialTableOraclev9i.appendStringWithSpace(stringBuffer, ')');
        }
    }

    private void appendTableDimensional(StringBuffer stringBuffer, SpatialColumnDefObject spatialColumnDefObject, boolean bl) {
        SSBSpatialTableOraclev9i.appendNewLine(stringBuffer, bl, 2);
        SSBSpatialTableOraclev9i.appendStringWithSpace(stringBuffer, "MDSYS.SDO_DIM_ARRAY");
        SSBSpatialTableOraclev9i.appendStringWithSpace(stringBuffer, '(');
        Iterator iterator = spatialColumnDefObject.getTableDimensions().iterator();
        while (iterator.hasNext()) {
            SpatialColumnDefObject.TableDimension tableDimension = (SpatialColumnDefObject.TableDimension)iterator.next();
            SSBSpatialTableOraclev9i.appendNewLine(stringBuffer, bl, 3);
            SSBSpatialTableOraclev9i.appendStringWithSpace(stringBuffer, "MDSYS.SDO_DIM_ELEMENT");
            SSBSpatialTableOraclev9i.appendString(stringBuffer, '(');
            SSBSpatialTableOraclev9i.appendString(stringBuffer, '\'');
            SSBSpatialTableOraclev9i.appendString(stringBuffer, this.storageDesign.getFormatedName(tableDimension.getName()));
            SSBSpatialTableOraclev9i.appendString(stringBuffer, '\'');
            SSBSpatialTableOraclev9i.appendString(stringBuffer, ',');
            SSBSpatialTableOraclev9i.appendString(stringBuffer, tableDimension.getLowBoundary());
            SSBSpatialTableOraclev9i.appendString(stringBuffer, ',');
            SSBSpatialTableOraclev9i.appendString(stringBuffer, tableDimension.getUpperBoundary());
            SSBSpatialTableOraclev9i.appendString(stringBuffer, ',');
            SSBSpatialTableOraclev9i.appendString(stringBuffer, tableDimension.getTolerance());
            SSBSpatialTableOraclev9i.appendString(stringBuffer, ')');
            if (!iterator.hasNext()) continue;
            SSBSpatialTableOraclev9i.appendString(stringBuffer, ',');
        }
        SSBSpatialTableOraclev9i.appendNewLine(stringBuffer, bl, 2);
        SSBSpatialTableOraclev9i.appendString(stringBuffer, ')');
    }

    protected void appendSpatialIndex(StringBuffer stringBuffer, SpatialColumnDefObject spatialColumnDefObject, boolean bl) {
        Index index = spatialColumnDefObject.getSpatialIndex();
        if (this.ssbIndex == null) {
            this.ssbIndex = new SSBIndexOraclev9i();
        }
        if (this.ssbIndex.canHandle(index)) {
            this.ssbIndex.doAppend(stringBuffer, index, bl);
        }
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof TableProxyOracle || object instanceof Table;
    }
}

