/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.oracle.v9i;

import java.util.Iterator;
import oracle.dbtools.crest.exports.ddl.oracle.AbstractSSBOracle;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.DataFileOracle;
import oracle.dbtools.crest.model.design.storage.oracle.DataFileSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.RedoLogGroupOracle;
import oracle.dbtools.crest.model.design.storage.oracle.RedoLogGroupSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.DataBaseOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.TemporaryTablespaceOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.UndoTablespaceOraclev9i;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBDataBaseOraclev9i
extends AbstractSSBOracle {
    private StorageDesign storageDesign;

    @Override
    public boolean canHandle(Object object) {
        return object instanceof DataBaseOraclev9i && ((DataBaseOraclev9i)object).isMarkedGenerate();
    }

    @Override
    protected void doAppend(StringBuffer stringBuffer, Object object, boolean bl) {
        DataBaseOraclev9i dataBaseOraclev9i = (DataBaseOraclev9i)object;
        this.storageDesign = dataBaseOraclev9i.getStorageDesign();
        this.appendComment(stringBuffer, dataBaseOraclev9i);
        stringBuffer.append(" -- CREATE DATABASE ").append(dataBaseOraclev9i.getStorageDesign().getFormatedName(dataBaseOraclev9i.getName())).append(' ');
        this.appendSysPass(stringBuffer, dataBaseOraclev9i, bl);
        this.appendSystemPass(stringBuffer, dataBaseOraclev9i, bl);
        this.appendControlFileReuse(stringBuffer, dataBaseOraclev9i);
        this.appendLogFiles(stringBuffer, dataBaseOraclev9i);
        this.appendMaxLogFiles(stringBuffer, dataBaseOraclev9i);
        this.appendMaxLogMembers(stringBuffer, dataBaseOraclev9i);
        this.appendMaxLogHistory(stringBuffer, dataBaseOraclev9i);
        this.appendMaxDataFiles(stringBuffer, dataBaseOraclev9i);
        this.appendMaxInstances(stringBuffer, dataBaseOraclev9i);
        this.appendArchiveLog(stringBuffer, dataBaseOraclev9i);
        this.appendForceLogging(stringBuffer, dataBaseOraclev9i, bl);
        this.appendCharacterSet(stringBuffer, dataBaseOraclev9i);
        this.appendNationalCharacterSet(stringBuffer, dataBaseOraclev9i);
        this.appendDataFiles(stringBuffer, dataBaseOraclev9i);
        this.appendExtentManagement(stringBuffer, dataBaseOraclev9i, bl);
        this.appendTempTablespace(stringBuffer, dataBaseOraclev9i, bl);
        this.appendUndoTablespace(stringBuffer, dataBaseOraclev9i, bl);
        this.appendTimeZone(stringBuffer, dataBaseOraclev9i, bl);
        SSBDataBaseOraclev9i.appendNewLine(stringBuffer, bl, 0);
        DDLFileMaker.incrementCreateDatabase();
    }

    private void appendSysPass(StringBuffer stringBuffer, DataBaseOraclev9i dataBaseOraclev9i, boolean bl) {
        if (!"".equalsIgnoreCase(dataBaseOraclev9i.getPassForSYS())) {
            SSBDataBaseOraclev9i.appendNewLine(stringBuffer, bl, 0);
            SSBDataBaseOraclev9i.appendStringWithSpace(stringBuffer, " --  ");
            SSBDataBaseOraclev9i.appendStringWithSpace(stringBuffer, "USER");
            SSBDataBaseOraclev9i.appendStringWithSpace(stringBuffer, "SYS");
            SSBDataBaseOraclev9i.appendStringWithSpace(stringBuffer, "IDENTIFIED");
            SSBDataBaseOraclev9i.appendStringWithSpace(stringBuffer, "BY");
            SSBDataBaseOraclev9i.appendStringWithSpace(stringBuffer, dataBaseOraclev9i.getPassForSYS());
        }
    }

    private void appendSystemPass(StringBuffer stringBuffer, DataBaseOraclev9i dataBaseOraclev9i, boolean bl) {
        if (!"".equalsIgnoreCase(dataBaseOraclev9i.getPassForSYSTEM())) {
            SSBDataBaseOraclev9i.appendNewLine(stringBuffer, bl, 0);
            SSBDataBaseOraclev9i.appendStringWithSpace(stringBuffer, " --  ");
            SSBDataBaseOraclev9i.appendStringWithSpace(stringBuffer, "USER");
            SSBDataBaseOraclev9i.appendStringWithSpace(stringBuffer, "SYSTEM");
            SSBDataBaseOraclev9i.appendStringWithSpace(stringBuffer, "IDENTIFIED");
            SSBDataBaseOraclev9i.appendStringWithSpace(stringBuffer, "BY");
            SSBDataBaseOraclev9i.appendStringWithSpace(stringBuffer, dataBaseOraclev9i.getPassForSYSTEM());
        }
    }

    private void appendControlFileReuse(StringBuffer stringBuffer, DataBaseOraclev9i dataBaseOraclev9i) {
        String string = dataBaseOraclev9i.getControlFileReuse();
        if (string.equalsIgnoreCase("YES")) {
            stringBuffer.append(NEWLINE);
            stringBuffer.append(" --  ").append("    ").append("CONTROLFILE REUSE");
        }
    }

    private void appendLogFiles(StringBuffer stringBuffer, DataBaseOraclev9i dataBaseOraclev9i) {
        RedoLogGroupSetOracle redoLogGroupSetOracle = ((StorageDesignOracle)dataBaseOraclev9i.getStorageDesign()).getRedoLogGroupSet();
        Iterator iterator = redoLogGroupSetOracle.iterator();
        int n = 0;
        boolean bl = false;
        while (iterator.hasNext()) {
            RedoLogGroupOracle redoLogGroupOracle = (RedoLogGroupOracle)iterator.next();
            if (redoLogGroupOracle.getDataBase() == null || !redoLogGroupOracle.getDataBase().toString().equalsIgnoreCase(dataBaseOraclev9i.toString())) continue;
            ++n;
            if (!bl) {
                stringBuffer.append(NEWLINE);
                stringBuffer.append(" --  ").append("    ");
                SSBDataBaseOraclev9i.appendStringWithSpace(stringBuffer, "LOGFILE");
                bl = true;
            } else {
                SSBDataBaseOraclev9i.appendStringWithSpace(stringBuffer, ',');
            }
            stringBuffer.append(NEWLINE).append(" --  ").append("    ").append("    ");
            SSBDataBaseOraclev9i.appendStringWithSpace(stringBuffer, "GROUP");
            this.appendStringWithSpace(stringBuffer, n);
            if (!"".equalsIgnoreCase(redoLogGroupOracle.getFileName())) {
                SSBDataBaseOraclev9i.appendStringWithSpace(stringBuffer, '(');
                SSBDataBaseOraclev9i.appendString(stringBuffer, '\'');
                SSBDataBaseOraclev9i.appendString(stringBuffer, redoLogGroupOracle.getFileName());
                SSBDataBaseOraclev9i.appendStringWithSpace(stringBuffer, '\'');
                SSBDataBaseOraclev9i.appendStringWithSpace(stringBuffer, ')');
            }
            SSBDataBaseOraclev9i.appendStringWithSpace(stringBuffer, "SIZE");
            this.appendStringWithSpace(stringBuffer, redoLogGroupOracle.getSize());
            SSBDataBaseOraclev9i.appendStringWithSpace(stringBuffer, redoLogGroupOracle.getMeasureUnit());
            if (!redoLogGroupOracle.getReuse().equalsIgnoreCase("YES")) continue;
            SSBDataBaseOraclev9i.appendStringWithSpace(stringBuffer, "REUSE");
        }
    }

    private void appendMaxLogFiles(StringBuffer stringBuffer, DataBaseOraclev9i dataBaseOraclev9i) {
        int n = dataBaseOraclev9i.getMaxLogFiles();
        stringBuffer.append(NEWLINE);
        stringBuffer.append(" --  ").append("    ");
        SSBDataBaseOraclev9i.appendStringWithSpace(stringBuffer, "MAXLOGFILES");
        this.appendStringWithSpace(stringBuffer, n);
    }

    private void appendMaxLogMembers(StringBuffer stringBuffer, DataBaseOraclev9i dataBaseOraclev9i) {
        int n = dataBaseOraclev9i.getMaxLogMembers();
        stringBuffer.append(NEWLINE);
        stringBuffer.append(" --  ").append("    ");
        SSBDataBaseOraclev9i.appendStringWithSpace(stringBuffer, "MAXLOGMEMBERS");
        this.appendStringWithSpace(stringBuffer, n);
    }

    private void appendMaxLogHistory(StringBuffer stringBuffer, DataBaseOraclev9i dataBaseOraclev9i) {
        int n = dataBaseOraclev9i.getMaxLogHistory();
        stringBuffer.append(NEWLINE);
        stringBuffer.append(" --  ").append("    ");
        SSBDataBaseOraclev9i.appendStringWithSpace(stringBuffer, "MAXLOGHISTORY");
        this.appendStringWithSpace(stringBuffer, n);
    }

    private void appendMaxDataFiles(StringBuffer stringBuffer, DataBaseOraclev9i dataBaseOraclev9i) {
        int n = dataBaseOraclev9i.getMaxDataFiles();
        stringBuffer.append(NEWLINE);
        stringBuffer.append(" --  ").append("    ");
        SSBDataBaseOraclev9i.appendStringWithSpace(stringBuffer, "MAXDATAFILES");
        this.appendStringWithSpace(stringBuffer, n);
    }

    private void appendMaxInstances(StringBuffer stringBuffer, DataBaseOraclev9i dataBaseOraclev9i) {
        int n = dataBaseOraclev9i.getMaxInstances();
        stringBuffer.append(NEWLINE);
        stringBuffer.append(" --  ").append("    ");
        SSBDataBaseOraclev9i.appendStringWithSpace(stringBuffer, "MAXINSTANCES");
        this.appendStringWithSpace(stringBuffer, n);
    }

    private void appendArchiveLog(StringBuffer stringBuffer, DataBaseOraclev9i dataBaseOraclev9i) {
        String string = dataBaseOraclev9i.getArchiveLog();
        if (string != null && string.equalsIgnoreCase("YES")) {
            stringBuffer.append(NEWLINE);
            stringBuffer.append(" --  ").append("    ");
            SSBDataBaseOraclev9i.appendStringWithSpace(stringBuffer, "ARCHIVELOG");
        }
    }

    private void appendForceLogging(StringBuffer stringBuffer, DataBaseOraclev9i dataBaseOraclev9i, boolean bl) {
        if ("NO".equalsIgnoreCase(dataBaseOraclev9i.getForceLogging())) {
            SSBDataBaseOraclev9i.appendNewLine(stringBuffer, bl, 0);
            SSBDataBaseOraclev9i.appendStringWithSpace(stringBuffer, " --  ");
            SSBDataBaseOraclev9i.appendStringWithSpace(stringBuffer, "FORCE");
            SSBDataBaseOraclev9i.appendStringWithSpace(stringBuffer, "LOGGING");
        }
    }

    private void appendCharacterSet(StringBuffer stringBuffer, DataBaseOraclev9i dataBaseOraclev9i) {
        String string = dataBaseOraclev9i.getCharacterSet();
        if (!"".equalsIgnoreCase(string)) {
            stringBuffer.append(NEWLINE);
            stringBuffer.append(" --  ").append("    ").append("CHARACTER SET ").append(string);
        }
    }

    private void appendNationalCharacterSet(StringBuffer stringBuffer, DataBaseOraclev9i dataBaseOraclev9i) {
        String string = dataBaseOraclev9i.getNationalCharacterSet();
        if (!"".equalsIgnoreCase(string)) {
            stringBuffer.append(NEWLINE);
            stringBuffer.append(" --  ").append("    ");
            SSBDataBaseOraclev9i.appendStringWithSpace(stringBuffer, "NATIONAL CHARACTER SET");
            SSBDataBaseOraclev9i.appendStringWithSpace(stringBuffer, string);
        }
    }

    private void appendDataFiles(StringBuffer stringBuffer, DataBaseOraclev9i dataBaseOraclev9i) {
        DataFileSetOracle dataFileSetOracle = ((StorageDesignOracle)dataBaseOraclev9i.getStorageDesign()).getDataFileSet();
        Iterator iterator = dataFileSetOracle.iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            DataFileOracle dataFileOracle = (DataFileOracle)iterator.next();
            if (dataFileOracle.getDataBase() == null || !dataFileOracle.getDataBase().toString().equalsIgnoreCase(dataBaseOraclev9i.toString())) continue;
            if (!bl) {
                stringBuffer.append(NEWLINE);
                stringBuffer.append(" --  ").append("    ").append("DATAFILE");
                bl = true;
            } else {
                SSBDataBaseOraclev9i.appendStringWithSpace(stringBuffer, ',');
            }
            stringBuffer.append(NEWLINE);
            stringBuffer.append(" --  ").append("    ").append("    ");
            SSBDataBaseOraclev9i.appendString(stringBuffer, '\'');
            SSBDataBaseOraclev9i.appendString(stringBuffer, dataFileOracle.getFileName());
            SSBDataBaseOraclev9i.appendStringWithSpace(stringBuffer, '\'');
            SSBDataBaseOraclev9i.appendStringWithSpace(stringBuffer, "SIZE");
            this.appendStringWithSpace(stringBuffer, dataFileOracle.getSize());
            SSBDataBaseOraclev9i.appendStringWithSpace(stringBuffer, dataFileOracle.getMeasureUnit());
            if (dataFileOracle.getReuse().equalsIgnoreCase("YES")) {
                SSBDataBaseOraclev9i.appendStringWithSpace(stringBuffer, "REUSE");
            }
            if (!"ON".equalsIgnoreCase(dataFileOracle.getAutoextend()) && !"OFF".equalsIgnoreCase(dataFileOracle.getAutoextend())) continue;
            SSBDataBaseOraclev9i.appendStringWithSpace(stringBuffer, "AUTOEXTEND");
            SSBDataBaseOraclev9i.appendStringWithSpace(stringBuffer, dataFileOracle.getAutoextend());
            if (!dataFileOracle.getAutoextend().equalsIgnoreCase("ON")) continue;
            SSBDataBaseOraclev9i.appendStringWithSpace(stringBuffer, "NEXT");
            this.appendStringWithSpace(stringBuffer, dataFileOracle.getNextBlockSize());
            SSBDataBaseOraclev9i.appendStringWithSpace(stringBuffer, "K");
            SSBDataBaseOraclev9i.appendStringWithSpace(stringBuffer, "MAXSIZE");
            if (dataFileOracle.getMaxSize().equalsIgnoreCase("UNLIMITED")) {
                SSBDataBaseOraclev9i.appendStringWithSpace(stringBuffer, "UNLIMITED");
                continue;
            }
            SSBDataBaseOraclev9i.appendStringWithSpace(stringBuffer, dataFileOracle.getMaxSize());
            SSBDataBaseOraclev9i.appendStringWithSpace(stringBuffer, "K");
        }
    }

    private void appendDataFiles(StringBuffer stringBuffer, UndoTablespaceOraclev9i undoTablespaceOraclev9i, boolean bl) {
        Iterator iterator = undoTablespaceOraclev9i.getDfiles().iterator();
        boolean bl2 = false;
        while (iterator.hasNext()) {
            DataFileOracle dataFileOracle = (DataFileOracle)iterator.next();
            if (!bl2) {
                SSBDataBaseOraclev9i.appendNewLine(stringBuffer, bl, 0);
                SSBDataBaseOraclev9i.appendStringWithSpace(stringBuffer, " --  ");
                SSBDataBaseOraclev9i.appendStringWithSpace(stringBuffer, "DATAFILE");
                bl2 = true;
            } else {
                SSBDataBaseOraclev9i.appendStringWithSpace(stringBuffer, ',');
            }
            SSBDataBaseOraclev9i.appendNewLine(stringBuffer, bl, 0);
            SSBDataBaseOraclev9i.appendStringWithSpace(stringBuffer, " --  ");
            stringBuffer.append("    ").append(this.addQuotes(dataFileOracle.getFileName(), true));
            SSBDataBaseOraclev9i.appendStringWithSpace(stringBuffer, "SIZE");
            this.appendStringWithSpace(stringBuffer, dataFileOracle.getSize());
            SSBDataBaseOraclev9i.appendStringWithSpace(stringBuffer, dataFileOracle.getMeasureUnit());
            if (dataFileOracle.getReuse().equalsIgnoreCase("YES")) {
                SSBDataBaseOraclev9i.appendStringWithSpace(stringBuffer, "REUSE");
            }
            if (!"ON".equalsIgnoreCase(dataFileOracle.getAutoextend()) && !"OFF".equalsIgnoreCase(dataFileOracle.getAutoextend())) continue;
            SSBDataBaseOraclev9i.appendStringWithSpace(stringBuffer, "AUTOEXTEND");
            SSBDataBaseOraclev9i.appendStringWithSpace(stringBuffer, dataFileOracle.getAutoextend());
            if (!dataFileOracle.getAutoextend().equalsIgnoreCase("ON")) continue;
            SSBDataBaseOraclev9i.appendStringWithSpace(stringBuffer, "NEXT");
            this.appendStringWithSpace(stringBuffer, dataFileOracle.getNextBlockSize());
            SSBDataBaseOraclev9i.appendStringWithSpace(stringBuffer, "K");
            SSBDataBaseOraclev9i.appendStringWithSpace(stringBuffer, "MAXSIZE");
            if (dataFileOracle.getMaxSize().equalsIgnoreCase("UNLIMITED")) {
                SSBDataBaseOraclev9i.appendStringWithSpace(stringBuffer, "UNLIMITED");
                continue;
            }
            SSBDataBaseOraclev9i.appendStringWithSpace(stringBuffer, dataFileOracle.getMaxSize());
            SSBDataBaseOraclev9i.appendStringWithSpace(stringBuffer, "K");
        }
    }

    private void appendExtentManagement(StringBuffer stringBuffer, DataBaseOraclev9i dataBaseOraclev9i, boolean bl) {
        if (dataBaseOraclev9i.getExtentManagement().equalsIgnoreCase("LOCAL")) {
            SSBDataBaseOraclev9i.appendNewLine(stringBuffer, bl, 0);
            SSBDataBaseOraclev9i.appendStringWithSpace(stringBuffer, " --  ");
            SSBDataBaseOraclev9i.appendStringWithSpace(stringBuffer, "EXTENT");
            SSBDataBaseOraclev9i.appendStringWithSpace(stringBuffer, "MANAGEMENT");
            SSBDataBaseOraclev9i.appendStringWithSpace(stringBuffer, "LOCAL");
        }
    }

    private void appendTempTablespace(StringBuffer stringBuffer, DataBaseOraclev9i dataBaseOraclev9i, boolean bl) {
        if (dataBaseOraclev9i.getTempTablespace() != null) {
            TemporaryTablespaceOraclev9i temporaryTablespaceOraclev9i = dataBaseOraclev9i.getTempTablespace();
            SSBDataBaseOraclev9i.appendNewLine(stringBuffer, bl, 0);
            SSBDataBaseOraclev9i.appendStringWithSpace(stringBuffer, " --  ");
            SSBDataBaseOraclev9i.appendStringWithSpace(stringBuffer, "DEFAULT");
            SSBDataBaseOraclev9i.appendStringWithSpace(stringBuffer, "TEMPORARY");
            SSBDataBaseOraclev9i.appendStringWithSpace(stringBuffer, "TABLESPACE");
            SSBDataBaseOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(temporaryTablespaceOraclev9i.getName()));
            this.appendTempFile(stringBuffer, temporaryTablespaceOraclev9i, bl);
            this.appendExtent(stringBuffer, temporaryTablespaceOraclev9i, bl);
        }
    }

    private void appendTempFile(StringBuffer stringBuffer, TemporaryTablespaceOraclev9i temporaryTablespaceOraclev9i, boolean bl) {
        if (!"".equalsIgnoreCase(temporaryTablespaceOraclev9i.getFilename().trim())) {
            SSBDataBaseOraclev9i.appendNewLine(stringBuffer, bl, 0);
            SSBDataBaseOraclev9i.appendStringWithSpace(stringBuffer, " --  ");
            SSBDataBaseOraclev9i.appendStringWithSpace(stringBuffer, "TEMPFILE");
            SSBDataBaseOraclev9i.appendString(stringBuffer, '\'');
            SSBDataBaseOraclev9i.appendString(stringBuffer, temporaryTablespaceOraclev9i.getFilename());
            SSBDataBaseOraclev9i.appendStringWithSpace(stringBuffer, '\'');
            if (temporaryTablespaceOraclev9i.getSize() != 0L) {
                SSBDataBaseOraclev9i.appendStringWithSpace(stringBuffer, "SIZE");
                this.appendStringWithSpace(stringBuffer, temporaryTablespaceOraclev9i.getSize());
                SSBDataBaseOraclev9i.appendStringWithSpace(stringBuffer, temporaryTablespaceOraclev9i.getMeasureUnitSize());
            }
            if ("YES".equalsIgnoreCase(temporaryTablespaceOraclev9i.getReuse())) {
                SSBDataBaseOraclev9i.appendStringWithSpace(stringBuffer, "REUSE");
            }
            SSBDataBaseOraclev9i.appendStringWithSpace(stringBuffer, "AUTOEXTEND");
            SSBDataBaseOraclev9i.appendStringWithSpace(stringBuffer, temporaryTablespaceOraclev9i.getAutoextend());
            if (temporaryTablespaceOraclev9i.getAutoextend().equalsIgnoreCase("ON")) {
                SSBDataBaseOraclev9i.appendStringWithSpace(stringBuffer, "NEXT");
                this.appendStringWithSpace(stringBuffer, temporaryTablespaceOraclev9i.getNextBlockSize());
                SSBDataBaseOraclev9i.appendStringWithSpace(stringBuffer, "K");
                SSBDataBaseOraclev9i.appendStringWithSpace(stringBuffer, "MAXSIZE");
                if (temporaryTablespaceOraclev9i.getMaxSize().equalsIgnoreCase("UNLIMITED")) {
                    SSBDataBaseOraclev9i.appendStringWithSpace(stringBuffer, "UNLIMITED");
                } else {
                    SSBDataBaseOraclev9i.appendStringWithSpace(stringBuffer, temporaryTablespaceOraclev9i.getMaxSize());
                    SSBDataBaseOraclev9i.appendStringWithSpace(stringBuffer, "K");
                }
            }
        }
    }

    private void appendExtent(StringBuffer stringBuffer, TemporaryTablespaceOraclev9i temporaryTablespaceOraclev9i, boolean bl) {
        if (temporaryTablespaceOraclev9i.getUniformSize() != 0L) {
            SSBDataBaseOraclev9i.appendNewLine(stringBuffer, bl, 0);
            SSBDataBaseOraclev9i.appendStringWithSpace(stringBuffer, " --  ");
            SSBDataBaseOraclev9i.appendStringWithSpace(stringBuffer, "EXTENT");
            SSBDataBaseOraclev9i.appendStringWithSpace(stringBuffer, "MANAGEMENT");
            SSBDataBaseOraclev9i.appendStringWithSpace(stringBuffer, "LOCAL");
            SSBDataBaseOraclev9i.appendStringWithSpace(stringBuffer, "UNIFORM");
            SSBDataBaseOraclev9i.appendStringWithSpace(stringBuffer, "SIZE");
            this.appendStringWithSpace(stringBuffer, temporaryTablespaceOraclev9i.getUniformSize());
            SSBDataBaseOraclev9i.appendStringWithSpace(stringBuffer, temporaryTablespaceOraclev9i.getMeasureUnitUniformSize());
        }
    }

    private void appendUndoTablespace(StringBuffer stringBuffer, DataBaseOraclev9i dataBaseOraclev9i, boolean bl) {
        if (dataBaseOraclev9i.getUndoTablespace() != null) {
            UndoTablespaceOraclev9i undoTablespaceOraclev9i = dataBaseOraclev9i.getUndoTablespace();
            SSBDataBaseOraclev9i.appendNewLine(stringBuffer, bl, 0);
            SSBDataBaseOraclev9i.appendStringWithSpace(stringBuffer, " --  ");
            SSBDataBaseOraclev9i.appendStringWithSpace(stringBuffer, "UNDO");
            SSBDataBaseOraclev9i.appendStringWithSpace(stringBuffer, "TABLESPACE");
            SSBDataBaseOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(undoTablespaceOraclev9i.getName()));
            this.appendDataFiles(stringBuffer, undoTablespaceOraclev9i, bl);
        }
    }

    private void appendTimeZone(StringBuffer stringBuffer, DataBaseOraclev9i dataBaseOraclev9i, boolean bl) {
        if (!"".equalsIgnoreCase(dataBaseOraclev9i.getTimeZone())) {
            SSBDataBaseOraclev9i.appendNewLine(stringBuffer, bl, 0);
            SSBDataBaseOraclev9i.appendStringWithSpace(stringBuffer, " --  ");
            SSBDataBaseOraclev9i.appendStringWithSpace(stringBuffer, "SET");
            SSBDataBaseOraclev9i.appendStringWithSpace(stringBuffer, "TIME_ZONE");
            SSBDataBaseOraclev9i.appendStringWithSpace(stringBuffer, '=');
            SSBDataBaseOraclev9i.appendString(stringBuffer, '\'');
            SSBDataBaseOraclev9i.appendString(stringBuffer, dataBaseOraclev9i.getTimeZone());
            SSBDataBaseOraclev9i.appendStringWithSpace(stringBuffer, '\'');
        }
    }
}

