/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.oracle.v9i;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import oracle.dbtools.crest.exports.ddl.oracle.AbstractSSBOracle;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.ClusterColumnOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ClusterColumnSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.ClusterOraclev9i;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBClusterOraclev9i
extends AbstractSSBOracle {
    private StorageDesign storageDesign;

    @Override
    protected void doAppend(StringBuffer stringBuffer, Object object, boolean bl) {
        StringBuffer stringBuffer2 = new StringBuffer();
        String string = "";
        ClusterOraclev9i clusterOraclev9i = (ClusterOraclev9i)object;
        this.storageDesign = clusterOraclev9i.getStorageDesign();
        this.appendComment(stringBuffer, clusterOraclev9i);
        SSBClusterOraclev9i.appendStringWithSpace(stringBuffer2, "CREATE");
        SSBClusterOraclev9i.appendStringWithSpace(stringBuffer2, "CLUSTER");
        SSBClusterOraclev9i.appendStringWithSpace(stringBuffer2, clusterOraclev9i.getStorageDesign().getFormatedName(clusterOraclev9i.getLongName()));
        string = stringBuffer2.toString();
        this.appendColumns(stringBuffer2, clusterOraclev9i, bl);
        this.appendAttributes(stringBuffer2, clusterOraclev9i.getSegment(), bl);
        this.appendSize(stringBuffer2, clusterOraclev9i, bl);
        this.appendTableSpace(stringBuffer2, clusterOraclev9i, bl);
        this.appendIndex(stringBuffer2, clusterOraclev9i, bl);
        this.appendParallel(stringBuffer2, clusterOraclev9i, bl);
        this.appendRowDependencies(stringBuffer2, clusterOraclev9i, bl);
        this.appendCache(stringBuffer2, clusterOraclev9i, bl);
        this.appendToBuffer(stringBuffer, stringBuffer2, string);
        SSBClusterOraclev9i.appendNewLine(stringBuffer2, bl, 0);
        this.appendLineFinisher(stringBuffer2, bl);
        this.appendToBuffer(stringBuffer, stringBuffer2, string);
        DDLFileMaker.incrementCreateCluster();
    }

    private void appendRowDependencies(StringBuffer stringBuffer, ClusterOraclev9i clusterOraclev9i, boolean bl) {
        SSBClusterOraclev9i.appendNewLine(stringBuffer, bl, 1);
        if ("YES".equalsIgnoreCase(clusterOraclev9i.getRowDependency())) {
            SSBClusterOraclev9i.appendStringWithSpace(stringBuffer, "ROWDEPENDENCIES");
        } else {
            SSBClusterOraclev9i.appendStringWithSpace(stringBuffer, "NOROWDEPENDENCIES");
        }
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof ClusterOraclev9i && ((ClusterOraclev9i)object).isMarkedGenerate();
    }

    private void appendColumns(StringBuffer stringBuffer, ClusterOraclev9i clusterOraclev9i, boolean bl) {
        ClusterColumnSetOracle clusterColumnSetOracle = ((StorageDesignOracle)clusterOraclev9i.getStorageDesign()).getClusterColumnSet();
        Object[] objectArray = clusterColumnSetOracle.toArray();
        Arrays.sort(objectArray, new ColumnComparator());
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < objectArray.length; ++i) {
            arrayList.add(objectArray[i]);
        }
        Iterator iterator = arrayList.iterator();
        boolean bl2 = true;
        while (iterator.hasNext()) {
            ClusterColumnOracle clusterColumnOracle = (ClusterColumnOracle)iterator.next();
            if (clusterColumnOracle.getCluster() == null || !clusterColumnOracle.getCluster().equals(clusterOraclev9i)) continue;
            if (bl2) {
                SSBClusterOraclev9i.appendNewLine(stringBuffer, bl, 1);
                SSBClusterOraclev9i.appendStringWithSpace(stringBuffer, '(');
                bl2 = false;
            } else {
                SSBClusterOraclev9i.appendString(stringBuffer, ',');
                SSBClusterOraclev9i.appendNewLine(stringBuffer, bl, 1);
                SSBClusterOraclev9i.appendStringWithSpace(stringBuffer, ' ');
            }
            SSBClusterOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(clusterColumnOracle.getName()));
            String string = clusterColumnOracle.getDataType();
            if (string.startsWith("TIMESTAMP")) {
                SSBClusterOraclev9i.appendStringWithSpace(stringBuffer, "TIMESTAMP");
                if (!clusterColumnOracle.getLengthPrecision().trim().equalsIgnoreCase("")) {
                    stringBuffer.append('(').append(clusterColumnOracle.getLengthPrecision());
                    SSBClusterOraclev9i.appendStringWithSpace(stringBuffer, ')');
                }
                if (string.indexOf("WITH") <= -1) continue;
                SSBClusterOraclev9i.appendStringWithSpace(stringBuffer, string.substring(10));
                continue;
            }
            if (string.equalsIgnoreCase("INTERVAL YEAR TO MONTH")) {
                SSBClusterOraclev9i.appendStringWithSpace(stringBuffer, "INTERVAL YEAR");
                if (!clusterColumnOracle.getLengthPrecision().trim().equalsIgnoreCase("")) {
                    stringBuffer.append('(').append(clusterColumnOracle.getLengthPrecision());
                    SSBClusterOraclev9i.appendStringWithSpace(stringBuffer, ')');
                }
                SSBClusterOraclev9i.appendStringWithSpace(stringBuffer, "TO MONTH");
                continue;
            }
            if (string.equalsIgnoreCase("INTERVAL DAY TO SECOND")) {
                SSBClusterOraclev9i.appendStringWithSpace(stringBuffer, "INTERVAL DAY");
                if (!clusterColumnOracle.getLengthPrecision().trim().equalsIgnoreCase("")) {
                    stringBuffer.append('(').append(clusterColumnOracle.getLengthPrecision());
                    SSBClusterOraclev9i.appendStringWithSpace(stringBuffer, ')');
                }
                SSBClusterOraclev9i.appendStringWithSpace(stringBuffer, "TO SECOND");
                if (clusterColumnOracle.getScale() <= 0) continue;
                stringBuffer.append('(').append(clusterColumnOracle.getScale());
                SSBClusterOraclev9i.appendStringWithSpace(stringBuffer, ')');
                continue;
            }
            SSBClusterOraclev9i.appendStringWithSpace(stringBuffer, string);
            if (string.indexOf("CHAR") > -1) {
                if (clusterColumnOracle.getLengthPrecision().trim().equalsIgnoreCase("")) continue;
                stringBuffer.append('(').append(clusterColumnOracle.getLengthPrecision());
                SSBClusterOraclev9i.appendStringWithSpace(stringBuffer, ')');
                continue;
            }
            if (clusterColumnOracle.getLengthPrecision().trim().equalsIgnoreCase("")) continue;
            stringBuffer.append('(').append(clusterColumnOracle.getLengthPrecision());
            if (clusterColumnOracle.getScale() != 0) {
                SSBClusterOraclev9i.appendStringWithSpace(stringBuffer, ',');
                stringBuffer.append(clusterColumnOracle.getScale());
            }
            SSBClusterOraclev9i.appendStringWithSpace(stringBuffer, ')');
        }
        if (!bl2) {
            SSBClusterOraclev9i.appendStringWithSpace(stringBuffer, ')');
        }
    }

    private void appendAttributes(StringBuffer stringBuffer, SegmentOracle segmentOracle, boolean bl) {
        if (segmentOracle != null) {
            SSBClusterOraclev9i.appendNewLine(stringBuffer, bl, 2);
            SSBClusterOraclev9i.appendStringWithSpace(stringBuffer, "PCTFREE");
            this.appendStringWithSpace(stringBuffer, segmentOracle.getPCTFree());
            SSBClusterOraclev9i.appendNewLine(stringBuffer, bl, 2);
            SSBClusterOraclev9i.appendStringWithSpace(stringBuffer, "PCTUSED");
            this.appendStringWithSpace(stringBuffer, segmentOracle.getPCTUsed());
            if (segmentOracle.getInitrans() > 1) {
                SSBClusterOraclev9i.appendNewLine(stringBuffer, bl, 2);
                SSBClusterOraclev9i.appendStringWithSpace(stringBuffer, "INITRANS");
                this.appendStringWithSpace(stringBuffer, segmentOracle.getInitrans());
            }
            if (segmentOracle.getMaxTrans() > 1) {
                SSBClusterOraclev9i.appendNewLine(stringBuffer, bl, 2);
                SSBClusterOraclev9i.appendStringWithSpace(stringBuffer, "MAXTRANS");
                this.appendStringWithSpace(stringBuffer, segmentOracle.getMaxTrans());
            }
            SSBClusterOraclev9i.appendNewLine(stringBuffer, bl, 1);
            SSBClusterOraclev9i.appendStringWithSpace(stringBuffer, "STORAGE");
            SSBClusterOraclev9i.appendStringWithSpace(stringBuffer, '(');
            SSBClusterOraclev9i.appendNewLine(stringBuffer, bl, 2);
            if (segmentOracle.getSCInitialExtent() > 0L) {
                SSBClusterOraclev9i.appendStringWithSpace(stringBuffer, "INITIAL");
                this.appendStringWithSpace(stringBuffer, segmentOracle.getSCInitialExtent());
                SSBClusterOraclev9i.appendNewLine(stringBuffer, bl, 2);
            }
            if (segmentOracle.getSCNextExtent() > 0L) {
                SSBClusterOraclev9i.appendStringWithSpace(stringBuffer, "NEXT");
                this.appendStringWithSpace(stringBuffer, segmentOracle.getSCNextExtent());
                SSBClusterOraclev9i.appendNewLine(stringBuffer, bl, 2);
            }
            SSBClusterOraclev9i.appendStringWithSpace(stringBuffer, "PCTINCREASE");
            this.appendStringWithSpace(stringBuffer, segmentOracle.getSCPctIncrease());
            SSBClusterOraclev9i.appendNewLine(stringBuffer, bl, 2);
            SSBClusterOraclev9i.appendStringWithSpace(stringBuffer, "MINEXTENTS");
            this.appendStringWithSpace(stringBuffer, segmentOracle.getSCMinExtents());
            SSBClusterOraclev9i.appendNewLine(stringBuffer, bl, 2);
            SSBClusterOraclev9i.appendStringWithSpace(stringBuffer, "MAXEXTENTS");
            SSBClusterOraclev9i.appendStringWithSpace(stringBuffer, segmentOracle.getSCMaxExtents());
            SSBClusterOraclev9i.appendNewLine(stringBuffer, bl, 2);
            SSBClusterOraclev9i.appendStringWithSpace(stringBuffer, "FREELISTS");
            this.appendStringWithSpace(stringBuffer, segmentOracle.getSCFreeLists());
            SSBClusterOraclev9i.appendNewLine(stringBuffer, bl, 2);
            SSBClusterOraclev9i.appendStringWithSpace(stringBuffer, "FREELIST");
            SSBClusterOraclev9i.appendStringWithSpace(stringBuffer, "GROUPS");
            this.appendStringWithSpace(stringBuffer, segmentOracle.getSCFreelistGroups());
            SSBClusterOraclev9i.appendNewLine(stringBuffer, bl, 2);
            SSBClusterOraclev9i.appendStringWithSpace(stringBuffer, "BUFFER_POOL");
            SSBClusterOraclev9i.appendStringWithSpace(stringBuffer, segmentOracle.getSCBufferPool());
            SSBClusterOraclev9i.appendNewLine(stringBuffer, bl, 1);
            SSBClusterOraclev9i.appendStringWithSpace(stringBuffer, ')');
        }
    }

    private void appendSize(StringBuffer stringBuffer, ClusterOraclev9i clusterOraclev9i, boolean bl) {
        int n = clusterOraclev9i.getSize();
        if (n > 0) {
            SSBClusterOraclev9i.appendNewLine(stringBuffer, bl, 1);
            SSBClusterOraclev9i.appendStringWithSpace(stringBuffer, "SIZE");
            this.appendStringWithSpace(stringBuffer, n);
            SSBClusterOraclev9i.appendStringWithSpace(stringBuffer, clusterOraclev9i.getMeasureUnit());
        }
    }

    private void appendTableSpace(StringBuffer stringBuffer, ClusterOraclev9i clusterOraclev9i, boolean bl) {
        SegmentOracle segmentOracle;
        TableSpaceOracle tableSpaceOracle = clusterOraclev9i.getTableSpace();
        if (tableSpaceOracle == null && (segmentOracle = clusterOraclev9i.getSegment()) != null) {
            tableSpaceOracle = segmentOracle.getTableSpace();
        }
        if (tableSpaceOracle != null) {
            SSBClusterOraclev9i.appendNewLine(stringBuffer, bl, 1);
            SSBClusterOraclev9i.appendStringWithSpace(stringBuffer, "TABLESPACE");
            SSBClusterOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableSpaceOracle.getName()));
        }
    }

    private void appendIndex(StringBuffer stringBuffer, ClusterOraclev9i clusterOraclev9i, boolean bl) {
        if ("YES".equalsIgnoreCase(clusterOraclev9i.getIndexed())) {
            SSBClusterOraclev9i.appendNewLine(stringBuffer, bl, 1);
            SSBClusterOraclev9i.appendStringWithSpace(stringBuffer, "INDEX");
        } else if (clusterOraclev9i.getHashKeys() >= 2) {
            SSBClusterOraclev9i.appendNewLine(stringBuffer, bl, 1);
            if ("YES".equalsIgnoreCase(clusterOraclev9i.getSingleTable())) {
                SSBClusterOraclev9i.appendStringWithSpace(stringBuffer, "SINGLE");
                SSBClusterOraclev9i.appendStringWithSpace(stringBuffer, "TABLE");
            }
            SSBClusterOraclev9i.appendStringWithSpace(stringBuffer, "HASHKEYS");
            this.appendStringWithSpace(stringBuffer, clusterOraclev9i.getHashKeys());
            if (!"".equalsIgnoreCase(clusterOraclev9i.getHashExpression())) {
                SSBClusterOraclev9i.appendStringWithSpace(stringBuffer, "HASH");
                SSBClusterOraclev9i.appendStringWithSpace(stringBuffer, "IS");
                SSBClusterOraclev9i.appendStringWithSpace(stringBuffer, clusterOraclev9i.getHashExpression());
            }
        }
    }

    private void appendParallel(StringBuffer stringBuffer, ClusterOraclev9i clusterOraclev9i, boolean bl) {
        SSBClusterOraclev9i.appendNewLine(stringBuffer, bl, 1);
        if ("YES".equalsIgnoreCase(clusterOraclev9i.getParallel())) {
            SSBClusterOraclev9i.appendStringWithSpace(stringBuffer, "PARALLEL");
        } else {
            SSBClusterOraclev9i.appendStringWithSpace(stringBuffer, "NOPARALLEL");
        }
    }

    private void appendCache(StringBuffer stringBuffer, ClusterOraclev9i clusterOraclev9i, boolean bl) {
        SSBClusterOraclev9i.appendNewLine(stringBuffer, bl, 1);
        if ("YES".equalsIgnoreCase(clusterOraclev9i.getCache())) {
            SSBClusterOraclev9i.appendStringWithSpace(stringBuffer, "CACHE");
        } else {
            SSBClusterOraclev9i.appendStringWithSpace(stringBuffer, "NOCACHE");
        }
    }

    static class ColumnComparator
    implements Comparator {
        ColumnComparator() {
        }

        public int compare(Object object, Object object2) {
            if (((ClusterColumnOracle)object).getPosition() > ((ClusterColumnOracle)object2).getPosition()) {
                return 1;
            }
            if (((ClusterColumnOracle)object).getPosition() < ((ClusterColumnOracle)object2).getPosition()) {
                return -1;
            }
            return 0;
        }
    }
}

