/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.oracle.v11g;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import oracle.dbtools.crest.exports.Messages;
import oracle.dbtools.crest.exports.ddl.oracle.v10g.SSBIndexOraclev10g;
import oracle.dbtools.crest.exports.ddl.oracle.v10g.SSBTableOraclev10g;
import oracle.dbtools.crest.exports.ddl.oracle.v11g.SSBIndexOraclev11g;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.FKProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionListOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.ColumnProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.PartitionListOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.ColumnProxyOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.ListPartitionOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.PartitionListOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.PartitionOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.StorageDesignOraclev11g;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class SSBTableOraclev11g
extends SSBTableOraclev10g {
    private SSBIndexOraclev11g ssbIndex = null;

    @Override
    protected void appendDatatype(StringBuffer stringBuffer, String string, ColumnProxyOraclev10g columnProxyOraclev10g, boolean bl) {
        if (string.equalsIgnoreCase("unknown") && columnProxyOraclev10g.isVirtual()) {
            return;
        }
        super.appendDatatype(stringBuffer, string, columnProxyOraclev10g, bl);
    }

    @Override
    protected void appendColumnOptions(StringBuffer stringBuffer, TableProxyOraclev10g tableProxyOraclev10g, Column column, ColumnProxyOraclev10g columnProxyOraclev10g, boolean bl) {
        if (columnProxyOraclev10g.isVirtual()) {
            this.appendVirtualColumnDefinition(stringBuffer, tableProxyOraclev10g, (ColumnProxyOraclev11g)columnProxyOraclev10g, bl);
        } else {
            this.appendWithDefaultDefinition(stringBuffer, columnProxyOraclev10g);
        }
        if (!column.getNullsAllowed()) {
            this.appendNotNullDefinition(stringBuffer, columnProxyOraclev10g, bl);
        }
    }

    private void appendVirtualColumnDefinition(StringBuffer stringBuffer, TableProxyOraclev10g tableProxyOraclev10g, ColumnProxyOraclev11g columnProxyOraclev11g, boolean bl) {
        SSBTableOraclev11g.appendStringWithSpace(stringBuffer, "AS");
        SSBTableOraclev11g.appendStringWithSpace(stringBuffer, '(');
        SSBTableOraclev11g.appendStringWithSpace(stringBuffer, columnProxyOraclev11g.getColumnExpression());
        SSBTableOraclev11g.appendStringWithSpace(stringBuffer, ')');
        SSBTableOraclev11g.appendStringWithSpace(stringBuffer, "VIRTUAL");
        if (tableProxyOraclev10g.getOrganization().equalsIgnoreCase("INDEX")) {
            this.appendError(stringBuffer, Messages.getString("SSBTableOraclev11g.ErrorVirtualColumnOrgIndex"), bl);
        }
        if (tableProxyOraclev10g.getCluster() != null) {
            this.appendError(stringBuffer, Messages.getString("SSBTableOraclev11g.ErrorVirtualColumnCluster"), bl);
        }
        if ("YES".equalsIgnoreCase(tableProxyOraclev10g.getTemporary())) {
            this.appendError(stringBuffer, Messages.getString("SSBTableOraclev11g.ErrorVirtualColumnTempTable"), bl);
        }
    }

    @Override
    protected void appendRefPartitionFK(StringBuffer stringBuffer, TableProxyOraclev10g tableProxyOraclev10g, boolean bl) {
        FKProxyOracle fKProxyOracle;
        PartitionListOracle partitionListOracle = tableProxyOraclev10g.getPartitionList();
        if (partitionListOracle != null && partitionListOracle.getPartitionType().equals("REFERENCE") && (fKProxyOracle = ((PartitionListOraclev11g)partitionListOracle).getRefConstraint()) != null) {
            this.appendComma(stringBuffer);
            SSBTableOraclev11g.appendNewLine(stringBuffer, bl, 1);
            SSBTableOraclev11g.appendStringWithSpace(stringBuffer, "CONSTRAINT");
            String string = fKProxyOracle.getName();
            SSBTableOraclev11g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(string));
            if (string.length() > tableProxyOraclev10g.getMaxNameLength()) {
                this.appendError(stringBuffer, Messages.getString("SSBTableOraclev11g.ErrorNameTooLong"), bl);
            }
            SSBTableOraclev11g.appendStringWithSpace(stringBuffer, "FOREIGN KEY");
            SSBTableOraclev11g.appendNewLine(stringBuffer, bl, 1);
            SSBTableOraclev11g.appendStringWithSpace(stringBuffer, '(');
            SSBTableOraclev11g.appendNewLine(stringBuffer, bl, 0);
            String string2 = fKProxyOracle.getColumns(this.storageDesign);
            if (string2.length() > 0) {
                SSBTableOraclev11g.appendString(stringBuffer, string2);
            } else {
                this.appendError(stringBuffer, Messages.getString("SSBTableOraclev11g.ErrorFKNoCols"), bl);
            }
            SSBTableOraclev11g.appendNewLine(stringBuffer, bl, 1);
            SSBTableOraclev11g.appendStringWithSpace(stringBuffer, ')');
            this.appendReferences(stringBuffer, fKProxyOracle);
            this.appendOnDelete(stringBuffer, fKProxyOracle, bl);
            this.appendConstraintState(stringBuffer, fKProxyOracle);
        }
    }

    private void appendReferences(StringBuffer stringBuffer, FKProxyOracle fKProxyOracle) {
        SSBTableOraclev11g.appendNewLine(stringBuffer, true, 1);
        SSBTableOraclev11g.appendStringWithSpace(stringBuffer, "REFERENCES");
        SSBTableOraclev11g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(fKProxyOracle.getReferenceTable()));
        if (!fKProxyOracle.getFKTable().isBST()) {
            SSBTableOraclev11g.appendNewLine(stringBuffer, true, 1);
            SSBTableOraclev11g.appendStringWithSpace(stringBuffer, '(');
            SSBTableOraclev11g.appendNewLine(stringBuffer, true, 0);
            SSBTableOraclev11g.appendString(stringBuffer, fKProxyOracle.getReferenceColumns(this.storageDesign));
            SSBTableOraclev11g.appendNewLine(stringBuffer, true, 1);
            SSBTableOraclev11g.appendStringWithSpace(stringBuffer, ')');
        }
    }

    private void appendOnDelete(StringBuffer stringBuffer, FKProxyOracle fKProxyOracle, boolean bl) {
        FKIndexAssociation fKIndexAssociation = ((Index)fKProxyOracle.getObject()).getFKAssociation();
        String string = fKIndexAssociation.getDeleteRule();
        if (string.equalsIgnoreCase("SET DEFAULT")) {
            string = fKIndexAssociation.isMandatory() ? "RESTRICT" : "SET NULL";
        }
        if (!string.equalsIgnoreCase("RESTRICT") && !string.equalsIgnoreCase("NO ACTION")) {
            SSBTableOraclev11g.appendNewLine(stringBuffer, true, 1);
            SSBTableOraclev11g.appendStringWithSpace(stringBuffer, "ON");
            SSBTableOraclev11g.appendStringWithSpace(stringBuffer, "DELETE");
            SSBTableOraclev11g.appendStringWithSpace(stringBuffer, string);
            if (string.equalsIgnoreCase("SET NULL")) {
                this.appendError(stringBuffer, Messages.getString("SSBTableOraclev11g.ErrorRefFKOnDeleteSetNull"), bl);
            }
        }
    }

    private void appendConstraintState(StringBuffer stringBuffer, FKProxyOracle fKProxyOracle) {
        if (this.storageDesign.isOpen()) {
            SSBTableOraclev11g.appendNewLine(stringBuffer, true, 1);
            if ("NO".equalsIgnoreCase(fKProxyOracle.getDeferrable())) {
                SSBTableOraclev11g.appendStringWithSpace(stringBuffer, "NOT");
                SSBTableOraclev11g.appendStringWithSpace(stringBuffer, "DEFERRABLE");
            } else {
                SSBTableOraclev11g.appendStringWithSpace(stringBuffer, "DEFERRABLE");
                if ("DEFERRED".equalsIgnoreCase(fKProxyOracle.getInitially())) {
                    SSBTableOraclev11g.appendStringWithSpace(stringBuffer, "INITIALLY");
                    SSBTableOraclev11g.appendStringWithSpace(stringBuffer, "DEFERRED");
                }
            }
            if (!"YES".equalsIgnoreCase(fKProxyOracle.getEnable())) {
                SSBTableOraclev11g.appendStringWithSpace(stringBuffer, "DISABLE");
                if ("YES".equalsIgnoreCase(fKProxyOracle.getValidate())) {
                    SSBTableOraclev11g.appendStringWithSpace(stringBuffer, "VALIDATE");
                }
            }
            if (!"YES".equalsIgnoreCase(fKProxyOracle.getValidate())) {
                SSBTableOraclev11g.appendStringWithSpace(stringBuffer, "NOVALIDATE");
            }
            if (fKProxyOracle.getExceptionsTable() != null) {
                SSBTableOraclev11g.appendNewLine(stringBuffer, true, 1);
                stringBuffer.append("EXCEPTIONS INTO ").append(this.storageDesign.getFormatedName(fKProxyOracle.getExceptionsTable().getLongName()));
            }
        }
    }

    @Override
    public void appendPartitionList(StringBuffer stringBuffer, TableProxyOraclev10g tableProxyOraclev10g, boolean bl) {
        PartitionListOraclev11g partitionListOraclev11g = (PartitionListOraclev11g)tableProxyOraclev10g.getPartitionList();
        if (partitionListOraclev11g != null) {
            this.tableProxy = tableProxyOraclev10g;
            this.table = (Table)tableProxyOraclev10g.getObject();
            if (this.storageDesign == null) {
                this.storageDesign = (StorageDesignOraclev11g)tableProxyOraclev10g.getStorageDesign();
            }
            String string = partitionListOraclev11g.getPartitionType();
            String string2 = partitionListOraclev11g.getSubpartitionType();
            SSBTableOraclev11g.appendNewLine(stringBuffer, bl, 1);
            if ("RANGE".equalsIgnoreCase(string)) {
                SSBTableOraclev11g.appendStringWithSpace(stringBuffer, "PARTITION");
                SSBTableOraclev11g.appendStringWithSpace(stringBuffer, "BY");
                SSBTableOraclev11g.appendStringWithSpace(stringBuffer, "RANGE");
                SSBTableOraclev11g.appendStringWithSpace(stringBuffer, '(');
                SSBTableOraclev11g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(partitionListOraclev11g.getColumnList()));
                SSBTableOraclev11g.appendStringWithSpace(stringBuffer, ')');
                String string3 = partitionListOraclev11g.getIntervalExpression().trim();
                if (string3.length() > 0) {
                    SSBTableOraclev11g.appendNewLine(stringBuffer, bl, 2);
                    SSBTableOraclev11g.appendStringWithSpace(stringBuffer, "INTERVAL");
                    SSBTableOraclev11g.appendStringWithSpace(stringBuffer, '(');
                    SSBTableOraclev11g.appendStringWithSpace(stringBuffer, string3);
                    SSBTableOraclev11g.appendStringWithSpace(stringBuffer, ')');
                    if (partitionListOraclev11g.getIntervalTablespaces().length() > 0) {
                        SSBTableOraclev11g.appendNewLine(stringBuffer, bl, 2);
                        SSBTableOraclev11g.appendStringWithSpace(stringBuffer, "STORE IN");
                        SSBTableOraclev11g.appendStringWithSpace(stringBuffer, '(');
                        SSBTableOraclev11g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(partitionListOraclev11g.getAllIntervalTablespaces()));
                        SSBTableOraclev11g.appendStringWithSpace(stringBuffer, ')');
                    }
                }
                this.appendSubPartitionDefinition(stringBuffer, tableProxyOraclev10g, partitionListOraclev11g, bl);
                boolean bl2 = !string2.equalsIgnoreCase("");
                this.appendPartitions(stringBuffer, partitionListOraclev11g, true, bl2, bl);
            } else if ("HASH BY QUANTITY".equalsIgnoreCase(string)) {
                SSBTableOraclev11g.appendStringWithSpace(stringBuffer, "PARTITION");
                SSBTableOraclev11g.appendStringWithSpace(stringBuffer, "BY");
                SSBTableOraclev11g.appendStringWithSpace(stringBuffer, "HASH");
                SSBTableOraclev11g.appendStringWithSpace(stringBuffer, '(');
                SSBTableOraclev11g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(partitionListOraclev11g.getColumnList()));
                SSBTableOraclev11g.appendStringWithSpace(stringBuffer, ')');
                SSBTableOraclev11g.appendNewLine(stringBuffer, bl, 1);
                SSBTableOraclev11g.appendStringWithSpace(stringBuffer, "PARTITIONS");
                this.appendStringWithSpace(stringBuffer, partitionListOraclev11g.getHashPQuantity());
                if (!"".equals(partitionListOraclev11g.getHashPTableSpaces())) {
                    SSBTableOraclev11g.appendNewLine(stringBuffer, bl, 1);
                    SSBTableOraclev11g.appendStringWithSpace(stringBuffer, "STORE IN");
                    SSBTableOraclev11g.appendStringWithSpace(stringBuffer, '(');
                    SSBTableOraclev11g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(partitionListOraclev11g.getAllHashPTableSpaces()));
                    SSBTableOraclev11g.appendStringWithSpace(stringBuffer, ')');
                }
                if (!"".equals(partitionListOraclev11g.getIOTOverflowHashPTS())) {
                    SSBTableOraclev11g.appendNewLine(stringBuffer, bl, 1);
                    SSBTableOraclev11g.appendStringWithSpace(stringBuffer, "OVERFLOW");
                    SSBTableOraclev11g.appendStringWithSpace(stringBuffer, "STORE IN");
                    SSBTableOraclev11g.appendStringWithSpace(stringBuffer, '(');
                    SSBTableOraclev11g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(partitionListOraclev11g.getAllIOTOverflowHashPTS()));
                    SSBTableOraclev11g.appendStringWithSpace(stringBuffer, ')');
                }
            } else if ("HASH BY LIST OF PARTITIONS".equalsIgnoreCase(string)) {
                SSBTableOraclev11g.appendStringWithSpace(stringBuffer, "PARTITION");
                SSBTableOraclev11g.appendStringWithSpace(stringBuffer, "BY");
                SSBTableOraclev11g.appendStringWithSpace(stringBuffer, "HASH");
                SSBTableOraclev11g.appendStringWithSpace(stringBuffer, '(');
                SSBTableOraclev11g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(partitionListOraclev11g.getColumnList()));
                SSBTableOraclev11g.appendStringWithSpace(stringBuffer, ')');
                this.appendHashPartitions(stringBuffer, partitionListOraclev11g, bl);
            } else if ("LIST".equalsIgnoreCase(string)) {
                SSBTableOraclev11g.appendStringWithSpace(stringBuffer, "PARTITION");
                SSBTableOraclev11g.appendStringWithSpace(stringBuffer, "BY");
                SSBTableOraclev11g.appendStringWithSpace(stringBuffer, "LIST");
                SSBTableOraclev11g.appendStringWithSpace(stringBuffer, '(');
                SSBTableOraclev11g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(partitionListOraclev11g.getColumnList()));
                SSBTableOraclev11g.appendStringWithSpace(stringBuffer, ')');
                this.appendSubPartitionDefinition(stringBuffer, tableProxyOraclev10g, partitionListOraclev11g, bl);
                this.appendListPartitions(stringBuffer, partitionListOraclev11g, bl);
            } else if ("REFERENCE".equalsIgnoreCase(string)) {
                FKProxyOracle fKProxyOracle = partitionListOraclev11g.getRefConstraint();
                SSBTableOraclev11g.appendStringWithSpace(stringBuffer, "PARTITION");
                SSBTableOraclev11g.appendStringWithSpace(stringBuffer, "BY");
                SSBTableOraclev11g.appendStringWithSpace(stringBuffer, "REFERENCE");
                if (tableProxyOraclev10g.getOrganization().equalsIgnoreCase("INDEX")) {
                    this.appendError(stringBuffer, Messages.getString("SSBTableOraclev11g.ErrorRefPartOrgIndex"), bl);
                }
                SSBTableOraclev11g.appendStringWithSpace(stringBuffer, '(');
                if (fKProxyOracle == null) {
                    this.appendError(stringBuffer, Messages.getString("SSBTableOraclev11g.ErrorRefConstraintMissing"), bl);
                } else {
                    SSBTableOraclev11g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(fKProxyOracle.getName()));
                    if (fKProxyOracle.getFKTable() == tableProxyOraclev10g.getObject()) {
                        this.appendError(stringBuffer, Messages.getString("SSBTableOraclev11g.ErrorSelfRefFK"), bl);
                    }
                    if (fKProxyOracle.getEnable().equalsIgnoreCase("NO") || fKProxyOracle.getValidate().equalsIgnoreCase("NO") || fKProxyOracle.getDeferrable().equalsIgnoreCase("YES")) {
                        this.appendError(stringBuffer, Messages.getString("SSBTableOraclev11g.ErrorRefFKStateInvalid"), bl);
                    }
                    ColumnProxy[] columnProxyArray = fKProxyOracle.getColumnProxies();
                    for (int i = 0; i < columnProxyArray.length; ++i) {
                        Column column = columnProxyArray[i].getColumn();
                        if (column == null || !column.getNullsAllowed()) continue;
                        this.appendError(stringBuffer, Messages.getString("SSBTableOraclev11g.ErrorRefFKColsNull"), bl);
                        break;
                    }
                }
                SSBTableOraclev11g.appendStringWithSpace(stringBuffer, ')');
                this.appendPartitions(stringBuffer, partitionListOraclev11g, false, false, bl);
            } else if ("SYSTEM".equalsIgnoreCase(string)) {
                int n;
                SSBTableOraclev11g.appendStringWithSpace(stringBuffer, "PARTITION");
                SSBTableOraclev11g.appendStringWithSpace(stringBuffer, "BY");
                SSBTableOraclev11g.appendStringWithSpace(stringBuffer, "SYSTEM");
                if (tableProxyOraclev10g.getOrganization().equalsIgnoreCase("INDEX")) {
                    this.appendError(stringBuffer, Messages.getString("SSBTableOraclev11g.ErrorSysPartIndexOrg"), bl);
                }
                if ((n = partitionListOraclev11g.getSystemPartitions()) > 1) {
                    SSBTableOraclev11g.appendNewLine(stringBuffer, bl, 2);
                    SSBTableOraclev11g.appendStringWithSpace(stringBuffer, "PARTITIONS");
                    this.appendStringWithSpace(stringBuffer, n);
                } else {
                    this.appendPartitions(stringBuffer, partitionListOraclev11g, false, false, bl);
                }
            }
        }
    }

    private void appendSubPartitionDefinition(StringBuffer stringBuffer, TableProxyOraclev10g tableProxyOraclev10g, PartitionListOraclev11g partitionListOraclev11g, boolean bl) {
        String string = partitionListOraclev11g.getSubpartitionType();
        if (string.equalsIgnoreCase("HASH")) {
            SSBTableOraclev11g.appendNewLine(stringBuffer, bl, 1);
            SSBTableOraclev11g.appendStringWithSpace(stringBuffer, "SUBPARTITION");
            SSBTableOraclev11g.appendStringWithSpace(stringBuffer, "BY");
            SSBTableOraclev11g.appendStringWithSpace(stringBuffer, "HASH");
            SSBTableOraclev11g.appendStringWithSpace(stringBuffer, '(');
            SSBTableOraclev11g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(partitionListOraclev11g.getSubPartitionsColumnList()));
            SSBTableOraclev11g.appendStringWithSpace(stringBuffer, ')');
            if (partitionListOraclev11g.getUseSubpartStorageTemplate().equalsIgnoreCase("NO")) {
                if (partitionListOraclev11g.getSubPartitionsQuantity() > 1 || !"".equals(partitionListOraclev11g.getSubPartitionsTableSpaces())) {
                    SSBTableOraclev11g.appendNewLine(stringBuffer, bl, 1);
                    SSBTableOraclev11g.appendStringWithSpace(stringBuffer, "SUBPARTITIONS");
                    this.appendStringWithSpace(stringBuffer, partitionListOraclev11g.getSubPartitionsQuantity());
                    if (!"".equals(partitionListOraclev11g.getSubPartitionsTableSpaces())) {
                        SSBTableOraclev11g.appendNewLine(stringBuffer, bl, 1);
                        SSBTableOraclev11g.appendStringWithSpace(stringBuffer, "STORE IN");
                        SSBTableOraclev11g.appendStringWithSpace(stringBuffer, '(');
                        SSBTableOraclev11g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(partitionListOraclev11g.getAllSubPartitionsTableSpaces()));
                        SSBTableOraclev11g.appendStringWithSpace(stringBuffer, ')');
                    }
                }
            } else {
                this.appendHashSubPartitionTemplates(stringBuffer, tableProxyOraclev10g, bl);
            }
        } else if (string.equalsIgnoreCase("LIST")) {
            SSBTableOraclev11g.appendNewLine(stringBuffer, bl, 1);
            SSBTableOraclev11g.appendStringWithSpace(stringBuffer, "SUBPARTITION");
            SSBTableOraclev11g.appendStringWithSpace(stringBuffer, "BY");
            SSBTableOraclev11g.appendStringWithSpace(stringBuffer, "LIST");
            SSBTableOraclev11g.appendStringWithSpace(stringBuffer, '(');
            SSBTableOraclev11g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(partitionListOraclev11g.getSubPartitionsColumnList()));
            SSBTableOraclev11g.appendStringWithSpace(stringBuffer, ')');
            this.appendListSubPartitionTemplates(stringBuffer, tableProxyOraclev10g, bl);
        } else if (string.equalsIgnoreCase("RANGE")) {
            SSBTableOraclev11g.appendNewLine(stringBuffer, bl, 1);
            SSBTableOraclev11g.appendStringWithSpace(stringBuffer, "SUBPARTITION");
            SSBTableOraclev11g.appendStringWithSpace(stringBuffer, "BY");
            SSBTableOraclev11g.appendStringWithSpace(stringBuffer, "RANGE");
            SSBTableOraclev11g.appendStringWithSpace(stringBuffer, '(');
            SSBTableOraclev11g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(partitionListOraclev11g.getSubPartitionsColumnList()));
            SSBTableOraclev11g.appendStringWithSpace(stringBuffer, ')');
            this.appendRangeSubPartitionTemplates(stringBuffer, tableProxyOraclev10g, bl);
        }
    }

    private void appendRangeSubPartitionTemplates(StringBuffer stringBuffer, TableProxyOraclev10g tableProxyOraclev10g, boolean bl) {
        StorageObjectCollection storageObjectCollection = tableProxyOraclev10g.getListStorageTemplates();
        if (storageObjectCollection.size() > 0) {
            SSBTableOraclev11g.appendNewLine(stringBuffer, bl, 1);
            SSBTableOraclev11g.appendStringWithSpace(stringBuffer, "SUBPARTITION");
            SSBTableOraclev11g.appendStringWithSpace(stringBuffer, "TEMPLATE");
            SSBTableOraclev11g.appendNewLine(stringBuffer, bl, 1);
            SSBTableOraclev11g.appendStringWithSpace(stringBuffer, '(');
            for (int i = 0; i < storageObjectCollection.size(); ++i) {
                PartitionOraclev11g partitionOraclev11g = (PartitionOraclev11g)storageObjectCollection.getElement(i);
                if (i > 0) {
                    SSBTableOraclev11g.appendStringWithSpace(stringBuffer, ',');
                }
                SSBTableOraclev11g.appendNewLine(stringBuffer, bl, 2);
                SSBTableOraclev11g.appendStringWithSpace(stringBuffer, "SUBPARTITION");
                SSBTableOraclev11g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(partitionOraclev11g.getName()));
                SSBTableOraclev11g.appendStringWithSpace(stringBuffer, "VALUES LESS THAN");
                SSBTableOraclev11g.appendStringWithSpace(stringBuffer, '(');
                SSBTableOraclev11g.appendStringWithSpace(stringBuffer, partitionOraclev11g.getValueList());
                SSBTableOraclev11g.appendStringWithSpace(stringBuffer, ')');
                this.appendPartStorage(stringBuffer, partitionOraclev11g, bl);
            }
            SSBTableOraclev11g.appendNewLine(stringBuffer, bl, 1);
            SSBTableOraclev11g.appendStringWithSpace(stringBuffer, ')');
        }
    }

    @Override
    protected void appendSubPartitions(StringBuffer stringBuffer, AbstractStorageObjectOracle abstractStorageObjectOracle, PartitionListOraclev10g partitionListOraclev10g, boolean bl) {
        if (partitionListOraclev10g.getSubpartitionType().equalsIgnoreCase("HASH")) {
            StorageObjectCollection storageObjectCollection = null;
            int n = 0;
            String string = "";
            if (abstractStorageObjectOracle instanceof PartitionOraclev11g) {
                PartitionOraclev11g partitionOraclev11g = (PartitionOraclev11g)abstractStorageObjectOracle;
                storageObjectCollection = partitionOraclev11g.getPartitions();
                n = partitionOraclev11g.getSubPartitionsQuantity();
                string = partitionOraclev11g.getAllSubPartitionsTableSpaces();
            } else if (abstractStorageObjectOracle instanceof ListPartitionOraclev11g) {
                ListPartitionOraclev11g listPartitionOraclev11g = (ListPartitionOraclev11g)abstractStorageObjectOracle;
                storageObjectCollection = listPartitionOraclev11g.getHashSubpartitions();
                n = listPartitionOraclev11g.getSubPartitionsQuantity();
                string = listPartitionOraclev11g.getAllSubPartitionsTableSpaces();
            }
            if (!this.appendHashSubPartitions(stringBuffer, storageObjectCollection, partitionListOraclev10g, bl) && n > 0) {
                SSBTableOraclev11g.appendNewLine(stringBuffer, bl, 1);
                SSBTableOraclev11g.appendStringWithSpace(stringBuffer, "SUBPARTITIONS");
                this.appendStringWithSpace(stringBuffer, n);
                if (!"".equalsIgnoreCase(string)) {
                    SSBTableOraclev11g.appendNewLine(stringBuffer, bl, 1);
                    SSBTableOraclev11g.appendStringWithSpace(stringBuffer, "STORE IN");
                    SSBTableOraclev11g.appendStringWithSpace(stringBuffer, '(');
                    SSBTableOraclev11g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(string));
                    SSBTableOraclev11g.appendStringWithSpace(stringBuffer, ')');
                }
            }
        } else if (partitionListOraclev10g.getSubpartitionType().equalsIgnoreCase("LIST")) {
            if (abstractStorageObjectOracle instanceof PartitionOraclev11g) {
                this.appendListSubPartitions(stringBuffer, ((PartitionOraclev11g)abstractStorageObjectOracle).getListPartitions(), bl);
            } else if (abstractStorageObjectOracle instanceof ListPartitionOraclev11g) {
                this.appendListSubPartitions(stringBuffer, ((ListPartitionOraclev11g)abstractStorageObjectOracle).getListSubpartitions(), bl);
            }
        } else if (partitionListOraclev10g.getSubpartitionType().equalsIgnoreCase("RANGE")) {
            if (abstractStorageObjectOracle instanceof PartitionOraclev11g) {
                this.appendRangeSubPartitions(stringBuffer, ((PartitionOraclev11g)abstractStorageObjectOracle).getRangeSubpartitions(), bl);
            } else if (abstractStorageObjectOracle instanceof ListPartitionOraclev11g) {
                this.appendRangeSubPartitions(stringBuffer, ((ListPartitionOraclev11g)abstractStorageObjectOracle).getRangeSubpartitions(), bl);
            }
        }
    }

    private void appendRangeSubPartitions(StringBuffer stringBuffer, StorageObjectCollection storageObjectCollection, boolean bl) {
        if (storageObjectCollection.size() > 0) {
            Object[] objectArray = storageObjectCollection.toArray();
            Arrays.sort(objectArray, new PositionComparator());
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (int i = 0; i < objectArray.length; ++i) {
                arrayList.add(objectArray[i]);
            }
            Iterator iterator = arrayList.iterator();
            boolean bl2 = true;
            SSBTableOraclev11g.appendNewLine(stringBuffer, bl, 1);
            SSBTableOraclev11g.appendStringWithSpace(stringBuffer, '(');
            while (iterator.hasNext()) {
                PartitionOraclev11g partitionOraclev11g = (PartitionOraclev11g)iterator.next();
                if (!bl2) {
                    SSBTableOraclev11g.appendStringWithSpace(stringBuffer, ',');
                } else {
                    bl2 = false;
                }
                SSBTableOraclev11g.appendNewLine(stringBuffer, bl, 2);
                SSBTableOraclev11g.appendStringWithSpace(stringBuffer, "SUBPARTITION");
                SSBTableOraclev11g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(partitionOraclev11g.getName()));
                SSBTableOraclev11g.appendStringWithSpace(stringBuffer, "VALUES LESS THAN");
                SSBTableOraclev11g.appendStringWithSpace(stringBuffer, '(');
                SSBTableOraclev11g.appendStringWithSpace(stringBuffer, partitionOraclev11g.getValueList());
                SSBTableOraclev11g.appendStringWithSpace(stringBuffer, ')');
                this.appendPartStorage(stringBuffer, partitionOraclev11g, bl);
            }
            SSBTableOraclev11g.appendNewLine(stringBuffer, bl, 1);
            SSBTableOraclev11g.appendStringWithSpace(stringBuffer, ')');
        }
    }

    @Override
    protected SSBIndexOraclev10g getSSBIndex() {
        if (this.ssbIndex == null) {
            this.ssbIndex = new SSBIndexOraclev11g();
            this.ssbIndex.setStorageDesign(this.storageDesign);
        }
        return this.ssbIndex;
    }

    private void appendError(StringBuffer stringBuffer, String string, boolean bl) {
        SSBTableOraclev11g.appendNewLine(stringBuffer, bl, 0);
        SSBTableOraclev11g.appendStringWithSpace(stringBuffer, "--  " + string);
        SSBTableOraclev11g.appendNewLine(stringBuffer, bl, 5);
        DDLFileMaker.incrementErrors();
    }

    static class PositionComparator
    implements Comparator {
        PositionComparator() {
        }

        public int compare(Object object, Object object2) {
            if (((PartitionOracle)object).getPosition() > ((PartitionOracle)object2).getPosition()) {
                return 1;
            }
            if (((PartitionOracle)object).getPosition() < ((PartitionOracle)object2).getPosition()) {
                return -1;
            }
            return 0;
        }
    }
}

